<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WEBCentralizedShoppingCartAccreditationGet StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class WEBCentralizedShoppingCartAccreditationGet extends AbstractStructBase
{
    /**
     * The AccreditationKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $AccreditationKey;
    /**
     * Constructor method for WEBCentralizedShoppingCartAccreditationGet
     * @uses WEBCentralizedShoppingCartAccreditationGet::setAccreditationKey()
     * @param string $accreditationKey
     */
    public function __construct(string $accreditationKey)
    {
        $this
            ->setAccreditationKey($accreditationKey);
    }
    /**
     * Get AccreditationKey value
     * @return string
     */
    public function getAccreditationKey(): string
    {
        return $this->AccreditationKey;
    }
    /**
     * Set AccreditationKey value
     * @param string $accreditationKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartAccreditationGet
     */
    public function setAccreditationKey(string $accreditationKey): self
    {
        // validation for constraint: string
        if (!is_null($accreditationKey) && !is_string($accreditationKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accreditationKey, true), gettype($accreditationKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($accreditationKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $accreditationKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($accreditationKey, true)), __LINE__);
        }
        $this->AccreditationKey = $accreditationKey;
        
        return $this;
    }
}
