<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * WEBCentralizedShoppingCartEventRegistrantSetLineItemsWithCart StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class WEBCentralizedShoppingCartEventRegistrantSetLineItemsWithCart extends AbstractStructBase
{
    /**
     * The RegistrationKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $RegistrationKey;
    /**
     * The oCentralizedOrderEntry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntryType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntryType $oCentralizedOrderEntry = null;
    /**
     * The oFeeCollection
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Drupal\netforum\xWeb\Generated\StructType\Fee[]
     */
    protected ?array $oFeeCollection = null;
    /**
     * Constructor method for
     * WEBCentralizedShoppingCartEventRegistrantSetLineItemsWithCart
     * @uses WEBCentralizedShoppingCartEventRegistrantSetLineItemsWithCart::setRegistrationKey()
     * @uses WEBCentralizedShoppingCartEventRegistrantSetLineItemsWithCart::setOCentralizedOrderEntry()
     * @uses WEBCentralizedShoppingCartEventRegistrantSetLineItemsWithCart::setOFeeCollection()
     * @param string $registrationKey
     * @param \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntryType $oCentralizedOrderEntry
     * @param \Drupal\netforum\xWeb\Generated\StructType\Fee[] $oFeeCollection
     */
    public function __construct(string $registrationKey, ?\Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntryType $oCentralizedOrderEntry = null, ?array $oFeeCollection = null)
    {
        $this
            ->setRegistrationKey($registrationKey)
            ->setOCentralizedOrderEntry($oCentralizedOrderEntry)
            ->setOFeeCollection($oFeeCollection);
    }
    /**
     * Get RegistrationKey value
     * @return string
     */
    public function getRegistrationKey(): string
    {
        return $this->RegistrationKey;
    }
    /**
     * Set RegistrationKey value
     * @param string $registrationKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantSetLineItemsWithCart
     */
    public function setRegistrationKey(string $registrationKey): self
    {
        // validation for constraint: string
        if (!is_null($registrationKey) && !is_string($registrationKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registrationKey, true), gettype($registrationKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($registrationKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $registrationKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($registrationKey, true)), __LINE__);
        }
        $this->RegistrationKey = $registrationKey;
        
        return $this;
    }
    /**
     * Get oCentralizedOrderEntry value
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntryType|null
     */
    public function getOCentralizedOrderEntry(): ?\Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntryType
    {
        return $this->oCentralizedOrderEntry;
    }
    /**
     * Set oCentralizedOrderEntry value
     * @param \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntryType $oCentralizedOrderEntry
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantSetLineItemsWithCart
     */
    public function setOCentralizedOrderEntry(?\Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntryType $oCentralizedOrderEntry = null): self
    {
        $this->oCentralizedOrderEntry = $oCentralizedOrderEntry;
        
        return $this;
    }
    /**
     * Get oFeeCollection value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Fee[]
     */
    public function getOFeeCollection(): ?array
    {
        return $this->oFeeCollection;
    }
    /**
     * This method is responsible for validating the value(s) passed to the setOFeeCollection method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOFeeCollection method
     * This has to validate that each item contained by the array match the itemType constraint
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOFeeCollectionForArrayConstraintFromSetOFeeCollection(?array $values = []): string
    {
        if (!is_array($values)) {
            return '';
        }
        $message = '';
        $invalidValues = [];
        foreach ($values as $wEBCentralizedShoppingCartEventRegistrantSetLineItemsWithCartOFeeCollectionItem) {
            // validation for constraint: itemType
            if (!$wEBCentralizedShoppingCartEventRegistrantSetLineItemsWithCartOFeeCollectionItem instanceof \Drupal\netforum\xWeb\Generated\StructType\Fee) {
                $invalidValues[] = is_object($wEBCentralizedShoppingCartEventRegistrantSetLineItemsWithCartOFeeCollectionItem) ? get_class($wEBCentralizedShoppingCartEventRegistrantSetLineItemsWithCartOFeeCollectionItem) : sprintf('%s(%s)', gettype($wEBCentralizedShoppingCartEventRegistrantSetLineItemsWithCartOFeeCollectionItem), var_export($wEBCentralizedShoppingCartEventRegistrantSetLineItemsWithCartOFeeCollectionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The oFeeCollection property can only contain items of type \Drupal\netforum\xWeb\Generated\StructType\Fee, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        
        return $message;
    }
    /**
     * Set oFeeCollection value
     * @throws InvalidArgumentException
     * @param \Drupal\netforum\xWeb\Generated\StructType\Fee[] $oFeeCollection
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantSetLineItemsWithCart
     */
    public function setOFeeCollection(?array $oFeeCollection = null): self
    {
        // validation for constraint: array
        if ('' !== ($oFeeCollectionArrayErrorMessage = self::validateOFeeCollectionForArrayConstraintFromSetOFeeCollection($oFeeCollection))) {
            throw new InvalidArgumentException($oFeeCollectionArrayErrorMessage, __LINE__);
        }
        $this->oFeeCollection = $oFeeCollection;
        
        return $this;
    }
    /**
     * Add item to oFeeCollection value
     * @throws InvalidArgumentException
     * @param \Drupal\netforum\xWeb\Generated\StructType\Fee $item
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantSetLineItemsWithCart
     */
    public function addToOFeeCollection(\Drupal\netforum\xWeb\Generated\StructType\Fee $item): self
    {
        // validation for constraint: itemType
        if (!$item instanceof \Drupal\netforum\xWeb\Generated\StructType\Fee) {
            throw new InvalidArgumentException(sprintf('The oFeeCollection property can only contain items of type \Drupal\netforum\xWeb\Generated\StructType\Fee, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->oFeeCollection[] = $item;
        
        return $this;
    }
}
