<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WEBCentralizedShoppingCartExhibitorGetBoothTypeList
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class WEBCentralizedShoppingCartExhibitorGetBoothTypeList extends AbstractStructBase
{
    /**
     * The ExhibitKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $ExhibitKey;
    /**
     * Constructor method for WEBCentralizedShoppingCartExhibitorGetBoothTypeList
     * @uses WEBCentralizedShoppingCartExhibitorGetBoothTypeList::setExhibitKey()
     * @param string $exhibitKey
     */
    public function __construct(string $exhibitKey)
    {
        $this
            ->setExhibitKey($exhibitKey);
    }
    /**
     * Get ExhibitKey value
     * @return string
     */
    public function getExhibitKey(): string
    {
        return $this->ExhibitKey;
    }
    /**
     * Set ExhibitKey value
     * @param string $exhibitKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartExhibitorGetBoothTypeList
     */
    public function setExhibitKey(string $exhibitKey): self
    {
        // validation for constraint: string
        if (!is_null($exhibitKey) && !is_string($exhibitKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exhibitKey, true), gettype($exhibitKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($exhibitKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $exhibitKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($exhibitKey, true)), __LINE__);
        }
        $this->ExhibitKey = $exhibitKey;
        
        return $this;
    }
}
