<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WEBCentralizedShoppingCartGetAccreditationListByCustomer
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class WEBCentralizedShoppingCartGetAccreditationListByCustomer extends AbstractStructBase
{
    /**
     * The OrganizationCustomerKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $OrganizationCustomerKey;
    /**
     * Constructor method for WEBCentralizedShoppingCartGetAccreditationListByCustomer
     * @uses WEBCentralizedShoppingCartGetAccreditationListByCustomer::setOrganizationCustomerKey()
     * @param string $organizationCustomerKey
     */
    public function __construct(string $organizationCustomerKey)
    {
        $this
            ->setOrganizationCustomerKey($organizationCustomerKey);
    }
    /**
     * Get OrganizationCustomerKey value
     * @return string
     */
    public function getOrganizationCustomerKey(): string
    {
        return $this->OrganizationCustomerKey;
    }
    /**
     * Set OrganizationCustomerKey value
     * @param string $organizationCustomerKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetAccreditationListByCustomer
     */
    public function setOrganizationCustomerKey(string $organizationCustomerKey): self
    {
        // validation for constraint: string
        if (!is_null($organizationCustomerKey) && !is_string($organizationCustomerKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationCustomerKey, true), gettype($organizationCustomerKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($organizationCustomerKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $organizationCustomerKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($organizationCustomerKey, true)), __LINE__);
        }
        $this->OrganizationCustomerKey = $organizationCustomerKey;
        
        return $this;
    }
}
