<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WEBCentralizedShoppingCartGetAccreditationTypeStatusList
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class WEBCentralizedShoppingCartGetAccreditationTypeStatusList extends AbstractStructBase
{
    /**
     * The AccreditationTypeKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $AccreditationTypeKey;
    /**
     * Constructor method for WEBCentralizedShoppingCartGetAccreditationTypeStatusList
     * @uses WEBCentralizedShoppingCartGetAccreditationTypeStatusList::setAccreditationTypeKey()
     * @param string $accreditationTypeKey
     */
    public function __construct(string $accreditationTypeKey)
    {
        $this
            ->setAccreditationTypeKey($accreditationTypeKey);
    }
    /**
     * Get AccreditationTypeKey value
     * @return string
     */
    public function getAccreditationTypeKey(): string
    {
        return $this->AccreditationTypeKey;
    }
    /**
     * Set AccreditationTypeKey value
     * @param string $accreditationTypeKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetAccreditationTypeStatusList
     */
    public function setAccreditationTypeKey(string $accreditationTypeKey): self
    {
        // validation for constraint: string
        if (!is_null($accreditationTypeKey) && !is_string($accreditationTypeKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accreditationTypeKey, true), gettype($accreditationTypeKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($accreditationTypeKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $accreditationTypeKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($accreditationTypeKey, true)), __LINE__);
        }
        $this->AccreditationTypeKey = $accreditationTypeKey;
        
        return $this;
    }
}
