<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WEBCentralizedShoppingCartGetBoothList StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class WEBCentralizedShoppingCartGetBoothList extends AbstractStructBase
{
    /**
     * The oExhibitor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNewType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNewType $oExhibitor = null;
    /**
     * The BoothType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string|null
     */
    protected ?string $BoothType;
    /**
     * The BoothCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string|null
     */
    protected ?string $BoothCategory;
    /**
     * The ProductName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string|null
     */
    protected ?string $ProductName;
    /**
     * Constructor method for WEBCentralizedShoppingCartGetBoothList
     * @uses WEBCentralizedShoppingCartGetBoothList::setOExhibitor()
     * @uses WEBCentralizedShoppingCartGetBoothList::setBoothType()
     * @uses WEBCentralizedShoppingCartGetBoothList::setBoothCategory()
     * @uses WEBCentralizedShoppingCartGetBoothList::setProductName()
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNewType $oExhibitor
     * @param string $boothType
     * @param string $boothCategory
     * @param string $productName
     */
    public function __construct(?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNewType $oExhibitor = null, ?string $boothType, ?string $boothCategory, ?string $productName)
    {
        $this
            ->setOExhibitor($oExhibitor)
            ->setBoothType($boothType)
            ->setBoothCategory($boothCategory)
            ->setProductName($productName);
    }
    /**
     * Get oExhibitor value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNewType|null
     */
    public function getOExhibitor(): ?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNewType
    {
        return $this->oExhibitor;
    }
    /**
     * Set oExhibitor value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExhibitorNewType $oExhibitor
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetBoothList
     */
    public function setOExhibitor(?\Drupal\netforum\xWeb\Generated\StructType\ExhibitorNewType $oExhibitor = null): self
    {
        $this->oExhibitor = $oExhibitor;
        
        return $this;
    }
    /**
     * Get BoothType value
     * @return string|null
     */
    public function getBoothType(): ?string
    {
        return $this->BoothType;
    }
    /**
     * Set BoothType value
     * @param string $boothType
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetBoothList
     */
    public function setBoothType(?string $boothType): self
    {
        // validation for constraint: string
        if (!is_null($boothType) && !is_string($boothType)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($boothType, true), gettype($boothType)), __LINE__);
        }
        $this->BoothType = $boothType;
        
        return $this;
    }
    /**
     * Get BoothCategory value
     * @return string|null
     */
    public function getBoothCategory(): ?string
    {
        return $this->BoothCategory;
    }
    /**
     * Set BoothCategory value
     * @param string $boothCategory
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetBoothList
     */
    public function setBoothCategory(?string $boothCategory): self
    {
        // validation for constraint: string
        if (!is_null($boothCategory) && !is_string($boothCategory)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($boothCategory, true), gettype($boothCategory)), __LINE__);
        }
        $this->BoothCategory = $boothCategory;
        
        return $this;
    }
    /**
     * Get ProductName value
     * @return string|null
     */
    public function getProductName(): ?string
    {
        return $this->ProductName;
    }
    /**
     * Set ProductName value
     * @param string $productName
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetBoothList
     */
    public function setProductName(?string $productName): self
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productName, true), gettype($productName)), __LINE__);
        }
        $this->ProductName = $productName;
        
        return $this;
    }
}
