<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WEBCentralizedShoppingCartGetProductLineItem StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class WEBCentralizedShoppingCartGetProductLineItem extends AbstractStructBase
{
    /**
     * The ProductKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $ProductKey;
    /**
     * The CustomerKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $CustomerKey;
    /**
     * The Customer_X_Address_Key
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $Customer_X_Address_Key;
    /**
     * Constructor method for WEBCentralizedShoppingCartGetProductLineItem
     * @uses WEBCentralizedShoppingCartGetProductLineItem::setProductKey()
     * @uses WEBCentralizedShoppingCartGetProductLineItem::setCustomerKey()
     * @uses WEBCentralizedShoppingCartGetProductLineItem::setCustomer_X_Address_Key()
     * @param string $productKey
     * @param string $customerKey
     * @param string $customer_X_Address_Key
     */
    public function __construct(string $productKey, string $customerKey, string $customer_X_Address_Key)
    {
        $this
            ->setProductKey($productKey)
            ->setCustomerKey($customerKey)
            ->setCustomer_X_Address_Key($customer_X_Address_Key);
    }
    /**
     * Get ProductKey value
     * @return string
     */
    public function getProductKey(): string
    {
        return $this->ProductKey;
    }
    /**
     * Set ProductKey value
     * @param string $productKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductLineItem
     */
    public function setProductKey(string $productKey): self
    {
        // validation for constraint: string
        if (!is_null($productKey) && !is_string($productKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productKey, true), gettype($productKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($productKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $productKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($productKey, true)), __LINE__);
        }
        $this->ProductKey = $productKey;
        
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string
     */
    public function getCustomerKey(): string
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductLineItem
     */
    public function setCustomerKey(string $customerKey): self
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerKey, true), gettype($customerKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($customerKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $customerKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($customerKey, true)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        
        return $this;
    }
    /**
     * Get Customer_X_Address_Key value
     * @return string
     */
    public function getCustomer_X_Address_Key(): string
    {
        return $this->Customer_X_Address_Key;
    }
    /**
     * Set Customer_X_Address_Key value
     * @param string $customer_X_Address_Key
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductLineItem
     */
    public function setCustomer_X_Address_Key(string $customer_X_Address_Key): self
    {
        // validation for constraint: string
        if (!is_null($customer_X_Address_Key) && !is_string($customer_X_Address_Key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customer_X_Address_Key, true), gettype($customer_X_Address_Key)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($customer_X_Address_Key) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $customer_X_Address_Key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($customer_X_Address_Key, true)), __LINE__);
        }
        $this->Customer_X_Address_Key = $customer_X_Address_Key;
        
        return $this;
    }
}
