<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WEBCentralizedShoppingCartGetSessionListByTrackKey
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class WEBCentralizedShoppingCartGetSessionListByTrackKey extends AbstractStructBase
{
    /**
     * The TrackKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $TrackKey;
    /**
     * Constructor method for WEBCentralizedShoppingCartGetSessionListByTrackKey
     * @uses WEBCentralizedShoppingCartGetSessionListByTrackKey::setTrackKey()
     * @param string $trackKey
     */
    public function __construct(string $trackKey)
    {
        $this
            ->setTrackKey($trackKey);
    }
    /**
     * Get TrackKey value
     * @return string
     */
    public function getTrackKey(): string
    {
        return $this->TrackKey;
    }
    /**
     * Set TrackKey value
     * @param string $trackKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetSessionListByTrackKey
     */
    public function setTrackKey(string $trackKey): self
    {
        // validation for constraint: string
        if (!is_null($trackKey) && !is_string($trackKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackKey, true), gettype($trackKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($trackKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $trackKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($trackKey, true)), __LINE__);
        }
        $this->TrackKey = $trackKey;
        
        return $this;
    }
}
