<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WEBCentralizedShoppingCartGetSponsorListByEventKey
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class WEBCentralizedShoppingCartGetSponsorListByEventKey extends AbstractStructBase
{
    /**
     * The EventKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $EventKey;
    /**
     * Constructor method for WEBCentralizedShoppingCartGetSponsorListByEventKey
     * @uses WEBCentralizedShoppingCartGetSponsorListByEventKey::setEventKey()
     * @param string $eventKey
     */
    public function __construct(string $eventKey)
    {
        $this
            ->setEventKey($eventKey);
    }
    /**
     * Get EventKey value
     * @return string
     */
    public function getEventKey(): string
    {
        return $this->EventKey;
    }
    /**
     * Set EventKey value
     * @param string $eventKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetSponsorListByEventKey
     */
    public function setEventKey(string $eventKey): self
    {
        // validation for constraint: string
        if (!is_null($eventKey) && !is_string($eventKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventKey, true), gettype($eventKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($eventKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $eventKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($eventKey, true)), __LINE__);
        }
        $this->EventKey = $eventKey;
        
        return $this;
    }
}
