<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WEBCentralizedShoppingCartRemoveEventRegistrantFromGroup
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class WEBCentralizedShoppingCartRemoveEventRegistrantFromGroup extends AbstractStructBase
{
    /**
     * The RegistrationKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $RegistrationKey;
    /**
     * The oGroupRegistration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroupType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroupType $oGroupRegistration = null;
    /**
     * Constructor method for WEBCentralizedShoppingCartRemoveEventRegistrantFromGroup
     * @uses WEBCentralizedShoppingCartRemoveEventRegistrantFromGroup::setRegistrationKey()
     * @uses WEBCentralizedShoppingCartRemoveEventRegistrantFromGroup::setOGroupRegistration()
     * @param string $registrationKey
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroupType $oGroupRegistration
     */
    public function __construct(string $registrationKey, ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroupType $oGroupRegistration = null)
    {
        $this
            ->setRegistrationKey($registrationKey)
            ->setOGroupRegistration($oGroupRegistration);
    }
    /**
     * Get RegistrationKey value
     * @return string
     */
    public function getRegistrationKey(): string
    {
        return $this->RegistrationKey;
    }
    /**
     * Set RegistrationKey value
     * @param string $registrationKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartRemoveEventRegistrantFromGroup
     */
    public function setRegistrationKey(string $registrationKey): self
    {
        // validation for constraint: string
        if (!is_null($registrationKey) && !is_string($registrationKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registrationKey, true), gettype($registrationKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($registrationKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $registrationKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($registrationKey, true)), __LINE__);
        }
        $this->RegistrationKey = $registrationKey;
        
        return $this;
    }
    /**
     * Get oGroupRegistration value
     * @return \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroupType|null
     */
    public function getOGroupRegistration(): ?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroupType
    {
        return $this->oGroupRegistration;
    }
    /**
     * Set oGroupRegistration value
     * @param \Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroupType $oGroupRegistration
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartRemoveEventRegistrantFromGroup
     */
    public function setOGroupRegistration(?\Drupal\netforum\xWeb\Generated\StructType\EventsRegistrantGroupType $oGroupRegistration = null): self
    {
        $this->oGroupRegistration = $oGroupRegistration;
        
        return $this;
    }
}
