<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WEBChaptersGetChapterMembershipRoster StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class WEBChaptersGetChapterMembershipRoster extends AbstractStructBase
{
    /**
     * The ChapterKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $ChapterKey;
    /**
     * Constructor method for WEBChaptersGetChapterMembershipRoster
     * @uses WEBChaptersGetChapterMembershipRoster::setChapterKey()
     * @param string $chapterKey
     */
    public function __construct(string $chapterKey)
    {
        $this
            ->setChapterKey($chapterKey);
    }
    /**
     * Get ChapterKey value
     * @return string
     */
    public function getChapterKey(): string
    {
        return $this->ChapterKey;
    }
    /**
     * Set ChapterKey value
     * @param string $chapterKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBChaptersGetChapterMembershipRoster
     */
    public function setChapterKey(string $chapterKey): self
    {
        // validation for constraint: string
        if (!is_null($chapterKey) && !is_string($chapterKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chapterKey, true), gettype($chapterKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($chapterKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $chapterKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($chapterKey, true)), __LINE__);
        }
        $this->ChapterKey = $chapterKey;
        
        return $this;
    }
}
