<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WEBCommitteeGetMembers StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class WEBCommitteeGetMembers extends AbstractStructBase
{
    /**
     * The CommitteeKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    protected string $CommitteeKey;
    /**
     * Constructor method for WEBCommitteeGetMembers
     * @uses WEBCommitteeGetMembers::setCommitteeKey()
     * @param string $committeeKey
     */
    public function __construct(string $committeeKey)
    {
        $this
            ->setCommitteeKey($committeeKey);
    }
    /**
     * Get CommitteeKey value
     * @return string
     */
    public function getCommitteeKey(): string
    {
        return $this->CommitteeKey;
    }
    /**
     * Set CommitteeKey value
     * @param string $committeeKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeGetMembers
     */
    public function setCommitteeKey(string $committeeKey): self
    {
        // validation for constraint: string
        if (!is_null($committeeKey) && !is_string($committeeKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($committeeKey, true), gettype($committeeKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($committeeKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $committeeKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($committeeKey, true)), __LINE__);
        }
        $this->CommitteeKey = $committeeKey;
        
        return $this;
    }
}
