<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WEBFindUsersInRole StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class WEBFindUsersInRole extends AbstractStructBase
{
    /**
     * The roleName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $roleName = null;
    /**
     * The usernameToMatch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $usernameToMatch = null;
    /**
     * Constructor method for WEBFindUsersInRole
     * @uses WEBFindUsersInRole::setRoleName()
     * @uses WEBFindUsersInRole::setUsernameToMatch()
     * @param string $roleName
     * @param string $usernameToMatch
     */
    public function __construct(?string $roleName = null, ?string $usernameToMatch = null)
    {
        $this
            ->setRoleName($roleName)
            ->setUsernameToMatch($usernameToMatch);
    }
    /**
     * Get roleName value
     * @return string|null
     */
    public function getRoleName(): ?string
    {
        return $this->roleName;
    }
    /**
     * Set roleName value
     * @param string $roleName
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBFindUsersInRole
     */
    public function setRoleName(?string $roleName = null): self
    {
        // validation for constraint: string
        if (!is_null($roleName) && !is_string($roleName)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roleName, true), gettype($roleName)), __LINE__);
        }
        $this->roleName = $roleName;
        
        return $this;
    }
    /**
     * Get usernameToMatch value
     * @return string|null
     */
    public function getUsernameToMatch(): ?string
    {
        return $this->usernameToMatch;
    }
    /**
     * Set usernameToMatch value
     * @param string $usernameToMatch
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBFindUsersInRole
     */
    public function setUsernameToMatch(?string $usernameToMatch = null): self
    {
        // validation for constraint: string
        if (!is_null($usernameToMatch) && !is_string($usernameToMatch)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usernameToMatch, true), gettype($usernameToMatch)), __LINE__);
        }
        $this->usernameToMatch = $usernameToMatch;
        
        return $this;
    }
}
