<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WEBMemberDirectoryOrganizationSearch StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class WEBMemberDirectoryOrganizationSearch extends AbstractStructBase
{
    /**
     * The OrganizationAcronym
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $OrganizationAcronym = null;
    /**
     * The OrganizationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $OrganizationName = null;
    /**
     * The OrganizationType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $OrganizationType = null;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $City = null;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $State = null;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $Country = null;
    /**
     * Constructor method for WEBMemberDirectoryOrganizationSearch
     * @uses WEBMemberDirectoryOrganizationSearch::setOrganizationAcronym()
     * @uses WEBMemberDirectoryOrganizationSearch::setOrganizationName()
     * @uses WEBMemberDirectoryOrganizationSearch::setOrganizationType()
     * @uses WEBMemberDirectoryOrganizationSearch::setCity()
     * @uses WEBMemberDirectoryOrganizationSearch::setState()
     * @uses WEBMemberDirectoryOrganizationSearch::setCountry()
     * @param string $organizationAcronym
     * @param string $organizationName
     * @param string $organizationType
     * @param string $city
     * @param string $state
     * @param string $country
     */
    public function __construct(?string $organizationAcronym = null, ?string $organizationName = null, ?string $organizationType = null, ?string $city = null, ?string $state = null, ?string $country = null)
    {
        $this
            ->setOrganizationAcronym($organizationAcronym)
            ->setOrganizationName($organizationName)
            ->setOrganizationType($organizationType)
            ->setCity($city)
            ->setState($state)
            ->setCountry($country);
    }
    /**
     * Get OrganizationAcronym value
     * @return string|null
     */
    public function getOrganizationAcronym(): ?string
    {
        return $this->OrganizationAcronym;
    }
    /**
     * Set OrganizationAcronym value
     * @param string $organizationAcronym
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBMemberDirectoryOrganizationSearch
     */
    public function setOrganizationAcronym(?string $organizationAcronym = null): self
    {
        // validation for constraint: string
        if (!is_null($organizationAcronym) && !is_string($organizationAcronym)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationAcronym, true), gettype($organizationAcronym)), __LINE__);
        }
        $this->OrganizationAcronym = $organizationAcronym;
        
        return $this;
    }
    /**
     * Get OrganizationName value
     * @return string|null
     */
    public function getOrganizationName(): ?string
    {
        return $this->OrganizationName;
    }
    /**
     * Set OrganizationName value
     * @param string $organizationName
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBMemberDirectoryOrganizationSearch
     */
    public function setOrganizationName(?string $organizationName = null): self
    {
        // validation for constraint: string
        if (!is_null($organizationName) && !is_string($organizationName)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationName, true), gettype($organizationName)), __LINE__);
        }
        $this->OrganizationName = $organizationName;
        
        return $this;
    }
    /**
     * Get OrganizationType value
     * @return string|null
     */
    public function getOrganizationType(): ?string
    {
        return $this->OrganizationType;
    }
    /**
     * Set OrganizationType value
     * @param string $organizationType
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBMemberDirectoryOrganizationSearch
     */
    public function setOrganizationType(?string $organizationType = null): self
    {
        // validation for constraint: string
        if (!is_null($organizationType) && !is_string($organizationType)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationType, true), gettype($organizationType)), __LINE__);
        }
        $this->OrganizationType = $organizationType;
        
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity(): ?string
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBMemberDirectoryOrganizationSearch
     */
    public function setCity(?string $city = null): self
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState(): ?string
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBMemberDirectoryOrganizationSearch
     */
    public function setState(?string $state = null): self
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        $this->State = $state;
        
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry(): ?string
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBMemberDirectoryOrganizationSearch
     */
    public function setCountry(?string $country = null): self
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->Country = $country;
        
        return $this;
    }
}
