<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebLogin StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class WebLogin extends AbstractStructBase
{
    /**
     * The keyOverride
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $keyOverride = null;
    /**
     * The userLoginPlain
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string|null
     */
    protected ?string $userLoginPlain;
    /**
     * The passwordPlain
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string|null
     */
    protected ?string $passwordPlain;
    /**
     * Constructor method for WebLogin
     * @uses WebLogin::setKeyOverride()
     * @uses WebLogin::setUserLoginPlain()
     * @uses WebLogin::setPasswordPlain()
     * @param string $keyOverride
     * @param string $userLoginPlain
     * @param string $passwordPlain
     */
    public function __construct(?string $keyOverride = null, ?string $userLoginPlain, ?string $passwordPlain)
    {
        $this
            ->setKeyOverride($keyOverride)
            ->setUserLoginPlain($userLoginPlain)
            ->setPasswordPlain($passwordPlain);
    }
    /**
     * Get keyOverride value
     * @return string|null
     */
    public function getKeyOverride(): ?string
    {
        return $this->keyOverride;
    }
    /**
     * Set keyOverride value
     * @param string $keyOverride
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebLogin
     */
    public function setKeyOverride(?string $keyOverride = null): self
    {
        // validation for constraint: string
        if (!is_null($keyOverride) && !is_string($keyOverride)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keyOverride, true), gettype($keyOverride)), __LINE__);
        }
        $this->keyOverride = $keyOverride;
        
        return $this;
    }
    /**
     * Get userLoginPlain value
     * @return string|null
     */
    public function getUserLoginPlain(): ?string
    {
        return $this->userLoginPlain;
    }
    /**
     * Set userLoginPlain value
     * @param string $userLoginPlain
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebLogin
     */
    public function setUserLoginPlain(?string $userLoginPlain): self
    {
        // validation for constraint: string
        if (!is_null($userLoginPlain) && !is_string($userLoginPlain)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userLoginPlain, true), gettype($userLoginPlain)), __LINE__);
        }
        $this->userLoginPlain = $userLoginPlain;
        
        return $this;
    }
    /**
     * Get passwordPlain value
     * @return string|null
     */
    public function getPasswordPlain(): ?string
    {
        return $this->passwordPlain;
    }
    /**
     * Set passwordPlain value
     * @param string $passwordPlain
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebLogin
     */
    public function setPasswordPlain(?string $passwordPlain): self
    {
        // validation for constraint: string
        if (!is_null($passwordPlain) && !is_string($passwordPlain)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passwordPlain, true), gettype($passwordPlain)), __LINE__);
        }
        $this->passwordPlain = $passwordPlain;
        
        return $this;
    }
}
