<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebUserType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:WebUserType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class WebUserType extends AbstractStructBase
{
    /**
     * The Individual
     * @var \Drupal\netforum\xWeb\Generated\StructType\WebUser_Individual_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\WebUser_Individual_DataObjectType $Individual = null;
    /**
     * The Customer
     * @var \Drupal\netforum\xWeb\Generated\StructType\WebUser_Customer_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\WebUser_Customer_DataObjectType $Customer = null;
    /**
     * The Email
     * @var \Drupal\netforum\xWeb\Generated\StructType\WebUser_Email_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\WebUser_Email_DataObjectType $Email = null;
    /**
     * The Business_Address
     * @var \Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Address_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Address_DataObjectType $Business_Address = null;
    /**
     * The Business_Phone_XRef
     * @var \Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Phone_XRef_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Phone_XRef_DataObjectType $Business_Phone_XRef = null;
    /**
     * The Business_Phone
     * @var \Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Phone_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Phone_DataObjectType $Business_Phone = null;
    /**
     * The Business_Fax_XRef
     * @var \Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Fax_XRef_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Fax_XRef_DataObjectType $Business_Fax_XRef = null;
    /**
     * The Business_Fax
     * @var \Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Fax_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Fax_DataObjectType $Business_Fax = null;
    /**
     * The CurrentKey
     * Meta information extracted from the WSDL
     * - documentation: Primary Key.The current key is the record key for the object. This field must be set whenever updating an existing database record. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $CurrentKey = null;
    /**
     * Constructor method for WebUserType
     * @uses WebUserType::setIndividual()
     * @uses WebUserType::setCustomer()
     * @uses WebUserType::setEmail()
     * @uses WebUserType::setBusiness_Address()
     * @uses WebUserType::setBusiness_Phone_XRef()
     * @uses WebUserType::setBusiness_Phone()
     * @uses WebUserType::setBusiness_Fax_XRef()
     * @uses WebUserType::setBusiness_Fax()
     * @uses WebUserType::setCurrentKey()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WebUser_Individual_DataObjectType $individual
     * @param \Drupal\netforum\xWeb\Generated\StructType\WebUser_Customer_DataObjectType $customer
     * @param \Drupal\netforum\xWeb\Generated\StructType\WebUser_Email_DataObjectType $email
     * @param \Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Address_DataObjectType $business_Address
     * @param \Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Phone_XRef_DataObjectType $business_Phone_XRef
     * @param \Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Phone_DataObjectType $business_Phone
     * @param \Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Fax_XRef_DataObjectType $business_Fax_XRef
     * @param \Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Fax_DataObjectType $business_Fax
     * @param string $currentKey
     */
    public function __construct(?\Drupal\netforum\xWeb\Generated\StructType\WebUser_Individual_DataObjectType $individual = null, ?\Drupal\netforum\xWeb\Generated\StructType\WebUser_Customer_DataObjectType $customer = null, ?\Drupal\netforum\xWeb\Generated\StructType\WebUser_Email_DataObjectType $email = null, ?\Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Address_DataObjectType $business_Address = null, ?\Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Phone_XRef_DataObjectType $business_Phone_XRef = null, ?\Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Phone_DataObjectType $business_Phone = null, ?\Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Fax_XRef_DataObjectType $business_Fax_XRef = null, ?\Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Fax_DataObjectType $business_Fax = null, ?string $currentKey = null)
    {
        $this
            ->setIndividual($individual)
            ->setCustomer($customer)
            ->setEmail($email)
            ->setBusiness_Address($business_Address)
            ->setBusiness_Phone_XRef($business_Phone_XRef)
            ->setBusiness_Phone($business_Phone)
            ->setBusiness_Fax_XRef($business_Fax_XRef)
            ->setBusiness_Fax($business_Fax)
            ->setCurrentKey($currentKey);
    }
    /**
     * Get Individual value
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebUser_Individual_DataObjectType|null
     */
    public function getIndividual(): ?\Drupal\netforum\xWeb\Generated\StructType\WebUser_Individual_DataObjectType
    {
        return $this->Individual;
    }
    /**
     * Set Individual value
     * @param \Drupal\netforum\xWeb\Generated\StructType\WebUser_Individual_DataObjectType $individual
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebUserType
     */
    public function setIndividual(?\Drupal\netforum\xWeb\Generated\StructType\WebUser_Individual_DataObjectType $individual = null): self
    {
        $this->Individual = $individual;
        
        return $this;
    }
    /**
     * Get Customer value
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebUser_Customer_DataObjectType|null
     */
    public function getCustomer(): ?\Drupal\netforum\xWeb\Generated\StructType\WebUser_Customer_DataObjectType
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \Drupal\netforum\xWeb\Generated\StructType\WebUser_Customer_DataObjectType $customer
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebUserType
     */
    public function setCustomer(?\Drupal\netforum\xWeb\Generated\StructType\WebUser_Customer_DataObjectType $customer = null): self
    {
        $this->Customer = $customer;
        
        return $this;
    }
    /**
     * Get Email value
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebUser_Email_DataObjectType|null
     */
    public function getEmail(): ?\Drupal\netforum\xWeb\Generated\StructType\WebUser_Email_DataObjectType
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param \Drupal\netforum\xWeb\Generated\StructType\WebUser_Email_DataObjectType $email
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebUserType
     */
    public function setEmail(?\Drupal\netforum\xWeb\Generated\StructType\WebUser_Email_DataObjectType $email = null): self
    {
        $this->Email = $email;
        
        return $this;
    }
    /**
     * Get Business_Address value
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Address_DataObjectType|null
     */
    public function getBusiness_Address(): ?\Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Address_DataObjectType
    {
        return $this->Business_Address;
    }
    /**
     * Set Business_Address value
     * @param \Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Address_DataObjectType $business_Address
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebUserType
     */
    public function setBusiness_Address(?\Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Address_DataObjectType $business_Address = null): self
    {
        $this->Business_Address = $business_Address;
        
        return $this;
    }
    /**
     * Get Business_Phone_XRef value
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Phone_XRef_DataObjectType|null
     */
    public function getBusiness_Phone_XRef(): ?\Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Phone_XRef_DataObjectType
    {
        return $this->Business_Phone_XRef;
    }
    /**
     * Set Business_Phone_XRef value
     * @param \Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Phone_XRef_DataObjectType $business_Phone_XRef
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebUserType
     */
    public function setBusiness_Phone_XRef(?\Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Phone_XRef_DataObjectType $business_Phone_XRef = null): self
    {
        $this->Business_Phone_XRef = $business_Phone_XRef;
        
        return $this;
    }
    /**
     * Get Business_Phone value
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Phone_DataObjectType|null
     */
    public function getBusiness_Phone(): ?\Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Phone_DataObjectType
    {
        return $this->Business_Phone;
    }
    /**
     * Set Business_Phone value
     * @param \Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Phone_DataObjectType $business_Phone
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebUserType
     */
    public function setBusiness_Phone(?\Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Phone_DataObjectType $business_Phone = null): self
    {
        $this->Business_Phone = $business_Phone;
        
        return $this;
    }
    /**
     * Get Business_Fax_XRef value
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Fax_XRef_DataObjectType|null
     */
    public function getBusiness_Fax_XRef(): ?\Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Fax_XRef_DataObjectType
    {
        return $this->Business_Fax_XRef;
    }
    /**
     * Set Business_Fax_XRef value
     * @param \Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Fax_XRef_DataObjectType $business_Fax_XRef
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebUserType
     */
    public function setBusiness_Fax_XRef(?\Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Fax_XRef_DataObjectType $business_Fax_XRef = null): self
    {
        $this->Business_Fax_XRef = $business_Fax_XRef;
        
        return $this;
    }
    /**
     * Get Business_Fax value
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Fax_DataObjectType|null
     */
    public function getBusiness_Fax(): ?\Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Fax_DataObjectType
    {
        return $this->Business_Fax;
    }
    /**
     * Set Business_Fax value
     * @param \Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Fax_DataObjectType $business_Fax
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebUserType
     */
    public function setBusiness_Fax(?\Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Fax_DataObjectType $business_Fax = null): self
    {
        $this->Business_Fax = $business_Fax;
        
        return $this;
    }
    /**
     * Get CurrentKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentKey(): ?string
    {
        return $this->CurrentKey ?? null;
    }
    /**
     * Set CurrentKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebUserType
     */
    public function setCurrentKey(?string $currentKey = null): self
    {
        // validation for constraint: string
        if (!is_null($currentKey) && !is_string($currentKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentKey, true), gettype($currentKey)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($currentKey) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $currentKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($currentKey, true)), __LINE__);
        }
        if (is_null($currentKey) || (is_array($currentKey) && empty($currentKey))) {
            unset($this->CurrentKey);
        } else {
            $this->CurrentKey = $currentKey;
        }
        
        return $this;
    }
}
