<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebUser_Business_Fax_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class WebUser_Business_Fax_DataObjectType extends AbstractStructBase
{
    /**
     * The fax_number
     * Meta information extracted from the WSDL
     * - documentation: Fax Number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $fax_number = null;
    /**
     * Constructor method for WebUser_Business_Fax_DataObjectType
     * @uses WebUser_Business_Fax_DataObjectType::setFax_number()
     * @param string $fax_number
     */
    public function __construct(?string $fax_number = null)
    {
        $this
            ->setFax_number($fax_number);
    }
    /**
     * Get fax_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFax_number(): ?string
    {
        return $this->fax_number ?? null;
    }
    /**
     * Set fax_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fax_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Fax_DataObjectType
     */
    public function setFax_number(?string $fax_number = null): self
    {
        // validation for constraint: string
        if (!is_null($fax_number) && !is_string($fax_number)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax_number, true), gettype($fax_number)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($fax_number) && mb_strlen((string) $fax_number) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $fax_number)), __LINE__);
        }
        if (is_null($fax_number) || (is_array($fax_number) && empty($fax_number))) {
            unset($this->fax_number);
        } else {
            $this->fax_number = $fax_number;
        }
        
        return $this;
    }
}
