<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebUser_Business_Fax_XRef_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class WebUser_Business_Fax_XRef_DataObjectType extends AbstractStructBase
{
    /**
     * The cfx_extension
     * Meta information extracted from the WSDL
     * - documentation: Fax Extension. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cfx_extension = null;
    /**
     * Constructor method for WebUser_Business_Fax_XRef_DataObjectType
     * @uses WebUser_Business_Fax_XRef_DataObjectType::setCfx_extension()
     * @param string $cfx_extension
     */
    public function __construct(?string $cfx_extension = null)
    {
        $this
            ->setCfx_extension($cfx_extension);
    }
    /**
     * Get cfx_extension value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCfx_extension(): ?string
    {
        return $this->cfx_extension ?? null;
    }
    /**
     * Set cfx_extension value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cfx_extension
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebUser_Business_Fax_XRef_DataObjectType
     */
    public function setCfx_extension(?string $cfx_extension = null): self
    {
        // validation for constraint: string
        if (!is_null($cfx_extension) && !is_string($cfx_extension)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cfx_extension, true), gettype($cfx_extension)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($cfx_extension) && mb_strlen((string) $cfx_extension) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $cfx_extension)), __LINE__);
        }
        if (is_null($cfx_extension) || (is_array($cfx_extension) && empty($cfx_extension))) {
            unset($this->cfx_extension);
        } else {
            $this->cfx_extension = $cfx_extension;
        }
        
        return $this;
    }
}
