<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for xWebVersion StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:xWebVersion
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class XWebVersion extends AbstractStructBase
{
    /**
     * The Build
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $Build = null;
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Drupal\netforum\xWeb\Generated\StructType\VersionClass|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\VersionClass $Version = null;
    /**
     * The Server
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $Server = null;
    /**
     * The Database
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $Database = null;
    /**
     * Constructor method for xWebVersion
     * @uses XWebVersion::setBuild()
     * @uses XWebVersion::setVersion()
     * @uses XWebVersion::setServer()
     * @uses XWebVersion::setDatabase()
     * @param string $build
     * @param \Drupal\netforum\xWeb\Generated\StructType\VersionClass $version
     * @param string $server
     * @param string $database
     */
    public function __construct(?string $build = null, ?\Drupal\netforum\xWeb\Generated\StructType\VersionClass $version = null, ?string $server = null, ?string $database = null)
    {
        $this
            ->setBuild($build)
            ->setVersion($version)
            ->setServer($server)
            ->setDatabase($database);
    }
    /**
     * Get Build value
     * @return string|null
     */
    public function getBuild(): ?string
    {
        return $this->Build;
    }
    /**
     * Set Build value
     * @param string $build
     * @return \Drupal\netforum\xWeb\Generated\StructType\XWebVersion
     */
    public function setBuild(?string $build = null): self
    {
        // validation for constraint: string
        if (!is_null($build) && !is_string($build)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($build, true), gettype($build)), __LINE__);
        }
        $this->Build = $build;
        
        return $this;
    }
    /**
     * Get Version value
     * @return \Drupal\netforum\xWeb\Generated\StructType\VersionClass|null
     */
    public function getVersion(): ?\Drupal\netforum\xWeb\Generated\StructType\VersionClass
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param \Drupal\netforum\xWeb\Generated\StructType\VersionClass $version
     * @return \Drupal\netforum\xWeb\Generated\StructType\XWebVersion
     */
    public function setVersion(?\Drupal\netforum\xWeb\Generated\StructType\VersionClass $version = null): self
    {
        $this->Version = $version;
        
        return $this;
    }
    /**
     * Get Server value
     * @return string|null
     */
    public function getServer(): ?string
    {
        return $this->Server;
    }
    /**
     * Set Server value
     * @param string $server
     * @return \Drupal\netforum\xWeb\Generated\StructType\XWebVersion
     */
    public function setServer(?string $server = null): self
    {
        // validation for constraint: string
        if (!is_null($server) && !is_string($server)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($server, true), gettype($server)), __LINE__);
        }
        $this->Server = $server;
        
        return $this;
    }
    /**
     * Get Database value
     * @return string|null
     */
    public function getDatabase(): ?string
    {
        return $this->Database;
    }
    /**
     * Set Database value
     * @param string $database
     * @return \Drupal\netforum\xWeb\Generated\StructType\XWebVersion
     */
    public function setDatabase(?string $database = null): self
    {
        // validation for constraint: string
        if (!is_null($database) && !is_string($database)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($database, true), gettype($database)), __LINE__);
        }
        $this->Database = $database;
        
        return $this;
    }
}
