<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Object StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Object
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class _Object extends AbstractStructBase
{
    /**
     * The obj_key
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $obj_key = null;
    /**
     * The obj_name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $obj_name = null;
    /**
     * The obj_description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $obj_description = null;
    /**
     * The ListTable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Drupal\netforum\xWeb\Generated\StructType\ListTable|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ListTable $ListTable = null;
    /**
     * Constructor method for Object
     * @uses _Object::setObj_key()
     * @uses _Object::setObj_name()
     * @uses _Object::setObj_description()
     * @uses _Object::setListTable()
     * @param string $obj_key
     * @param string $obj_name
     * @param string $obj_description
     * @param \Drupal\netforum\xWeb\Generated\StructType\ListTable $listTable
     */
    public function __construct(?string $obj_key = null, ?string $obj_name = null, ?string $obj_description = null, ?\Drupal\netforum\xWeb\Generated\StructType\ListTable $listTable = null)
    {
        $this
            ->setObj_key($obj_key)
            ->setObj_name($obj_name)
            ->setObj_description($obj_description)
            ->setListTable($listTable);
    }
    /**
     * Get obj_key value
     * @return string|null
     */
    public function getObj_key(): ?string
    {
        return $this->obj_key;
    }
    /**
     * Set obj_key value
     * @param string $obj_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\_Object
     */
    public function setObj_key(?string $obj_key = null): self
    {
        // validation for constraint: string
        if (!is_null($obj_key) && !is_string($obj_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($obj_key, true), gettype($obj_key)), __LINE__);
        }
        $this->obj_key = $obj_key;
        
        return $this;
    }
    /**
     * Get obj_name value
     * @return string|null
     */
    public function getObj_name(): ?string
    {
        return $this->obj_name;
    }
    /**
     * Set obj_name value
     * @param string $obj_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\_Object
     */
    public function setObj_name(?string $obj_name = null): self
    {
        // validation for constraint: string
        if (!is_null($obj_name) && !is_string($obj_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($obj_name, true), gettype($obj_name)), __LINE__);
        }
        $this->obj_name = $obj_name;
        
        return $this;
    }
    /**
     * Get obj_description value
     * @return string|null
     */
    public function getObj_description(): ?string
    {
        return $this->obj_description;
    }
    /**
     * Set obj_description value
     * @param string $obj_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\_Object
     */
    public function setObj_description(?string $obj_description = null): self
    {
        // validation for constraint: string
        if (!is_null($obj_description) && !is_string($obj_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($obj_description, true), gettype($obj_description)), __LINE__);
        }
        $this->obj_description = $obj_description;
        
        return $this;
    }
    /**
     * Get ListTable value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ListTable|null
     */
    public function getListTable(): ?\Drupal\netforum\xWeb\Generated\StructType\ListTable
    {
        return $this->ListTable;
    }
    /**
     * Set ListTable value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ListTable $listTable
     * @return \Drupal\netforum\xWeb\Generated\StructType\_Object
     */
    public function setListTable(?\Drupal\netforum\xWeb\Generated\StructType\ListTable $listTable = null): self
    {
        $this->ListTable = $listTable;
        
        return $this;
    }
}
