<?php

declare(strict_types=1);

namespace Drupal\Tests\netforum\Utilities;

/**
 * Generates random text.
 */
final class RandomText {

  private function __construct() {}

  /**
   * Generate a random hex string.
   *
   * The resulting string length will be 2 * $bytes.
   *
   * @throws \Random\RandomException
   *   Thrown if it was not possible to gather sufficient entropy.
   * @throws \InvalidArgumentException
   *   Thrown if $bytes is less than 1.
   */
  public static function getRandomText(int $bytes): string {
    if ($bytes < 1) {
      throw new \InvalidArgumentException('Number of bytes must be greater than 0.');
    }

    return bin2hex(random_bytes($bytes));
  }

}
