<?php

declare(strict_types=1);

namespace Drupal\Tests\netforum\xWeb;

/**
 * Class loader to load the NetForum xWeb SDK generated classes.
 */
class ClassLoader {

  public function __construct(public string $classNamespace, public string $classBaseDir) {
    spl_autoload_register([$this, 'loadClass']);
  }

  public function loadClass(string $class): void {
    if (!str_starts_with($class, $this->classNamespace)) {
      return;
    }

    $relativeClass = substr($class, strlen($this->classNamespace));
    $file = $this->classBaseDir . str_replace('\\', DIRECTORY_SEPARATOR, $relativeClass) . '.php';

    if (is_file($file)) {
      require $file;
    }
  }

}
