<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\ArrayType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDonation ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfDonation
 * @subpackage Arrays
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
class ArrayOfDonation extends AbstractStructArrayBase
{
    /**
     * The Donation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Drupal\netforum\xWeb\Generated\StructType\Donation[]|null
     */
    protected ?array $Donation = null;
    /**
     * Constructor method for ArrayOfDonation
     * @uses ArrayOfDonation::setDonation()
     * @param \Drupal\netforum\xWeb\Generated\StructType\Donation[] $donation
     */
    public function __construct(?array $donation = null)
    {
        $this
            ->setDonation($donation);
    }
    /**
     * Get Donation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Drupal\netforum\xWeb\Generated\StructType\Donation[]|null
     */
    public function getDonation(): ?array
    {
        return $this->Donation ?? null;
    }
    /**
     * This method is responsible for validating the value(s) passed to the setDonation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDonation method
     * This has to validate that each item contained by the array match the itemType constraint
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDonationForArrayConstraintFromSetDonation(?array $values = []): string
    {
        if (!is_array($values)) {
            return '';
        }
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDonationDonationItem) {
            // validation for constraint: itemType
            if (!$arrayOfDonationDonationItem instanceof \Drupal\netforum\xWeb\Generated\StructType\Donation) {
                $invalidValues[] = is_object($arrayOfDonationDonationItem) ? get_class($arrayOfDonationDonationItem) : sprintf('%s(%s)', gettype($arrayOfDonationDonationItem), var_export($arrayOfDonationDonationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Donation property can only contain items of type \Drupal\netforum\xWeb\Generated\StructType\Donation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        
        return $message;
    }
    /**
     * Set Donation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws InvalidArgumentException
     * @param \Drupal\netforum\xWeb\Generated\StructType\Donation[] $donation
     * @return \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfDonation
     */
    public function setDonation(?array $donation = null): self
    {
        // validation for constraint: array
        if ('' !== ($donationArrayErrorMessage = self::validateDonationForArrayConstraintFromSetDonation($donation))) {
            throw new InvalidArgumentException($donationArrayErrorMessage, __LINE__);
        }
        if (is_null($donation) || (is_array($donation) && empty($donation))) {
            unset($this->Donation);
        } else {
            $this->Donation = $donation;
        }
        
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Drupal\netforum\xWeb\Generated\StructType\Donation|null
     */
    public function current(): ?\Drupal\netforum\xWeb\Generated\StructType\Donation
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Drupal\netforum\xWeb\Generated\StructType\Donation|null
     */
    public function item($index): ?\Drupal\netforum\xWeb\Generated\StructType\Donation
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Drupal\netforum\xWeb\Generated\StructType\Donation|null
     */
    public function first(): ?\Drupal\netforum\xWeb\Generated\StructType\Donation
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Drupal\netforum\xWeb\Generated\StructType\Donation|null
     */
    public function last(): ?\Drupal\netforum\xWeb\Generated\StructType\Donation
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Drupal\netforum\xWeb\Generated\StructType\Donation|null
     */
    public function offsetGet($offset): ?\Drupal\netforum\xWeb\Generated\StructType\Donation
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws InvalidArgumentException
     * @param \Drupal\netforum\xWeb\Generated\StructType\Donation $item
     * @return \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfDonation
     */
    public function add($item): self
    {
        // validation for constraint: itemType
        if (!$item instanceof \Drupal\netforum\xWeb\Generated\StructType\Donation) {
            throw new InvalidArgumentException(sprintf('The Donation property can only contain items of type \Drupal\netforum\xWeb\Generated\StructType\Donation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Donation
     */
    public function getAttributeName(): string
    {
        return 'Donation';
    }
}
