<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\ArrayType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfParameter ArrayType
 * @subpackage Arrays
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
class ArrayOfParameter extends AbstractStructArrayBase
{
    /**
     * The Parameter
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Drupal\netforum\xWeb\Generated\StructType\Parameter[]
     */
    protected ?array $Parameter = null;
    /**
     * Constructor method for ArrayOfParameter
     * @uses ArrayOfParameter::setParameter()
     * @param \Drupal\netforum\xWeb\Generated\StructType\Parameter[] $parameter
     */
    public function __construct(?array $parameter = null)
    {
        $this
            ->setParameter($parameter);
    }
    /**
     * Get Parameter value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Parameter[]
     */
    public function getParameter(): ?array
    {
        return $this->Parameter;
    }
    /**
     * This method is responsible for validating the value(s) passed to the setParameter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParameter method
     * This has to validate that each item contained by the array match the itemType constraint
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParameterForArrayConstraintFromSetParameter(?array $values = []): string
    {
        if (!is_array($values)) {
            return '';
        }
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfParameterParameterItem) {
            // validation for constraint: itemType
            if (!$arrayOfParameterParameterItem instanceof \Drupal\netforum\xWeb\Generated\StructType\Parameter) {
                $invalidValues[] = is_object($arrayOfParameterParameterItem) ? get_class($arrayOfParameterParameterItem) : sprintf('%s(%s)', gettype($arrayOfParameterParameterItem), var_export($arrayOfParameterParameterItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Parameter property can only contain items of type \Drupal\netforum\xWeb\Generated\StructType\Parameter, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        
        return $message;
    }
    /**
     * Set Parameter value
     * @throws InvalidArgumentException
     * @param \Drupal\netforum\xWeb\Generated\StructType\Parameter[] $parameter
     * @return \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfParameter
     */
    public function setParameter(?array $parameter = null): self
    {
        // validation for constraint: array
        if ('' !== ($parameterArrayErrorMessage = self::validateParameterForArrayConstraintFromSetParameter($parameter))) {
            throw new InvalidArgumentException($parameterArrayErrorMessage, __LINE__);
        }
        $this->Parameter = $parameter;
        
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Drupal\netforum\xWeb\Generated\StructType\Parameter|null
     */
    public function current(): ?\Drupal\netforum\xWeb\Generated\StructType\Parameter
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Drupal\netforum\xWeb\Generated\StructType\Parameter|null
     */
    public function item($index): ?\Drupal\netforum\xWeb\Generated\StructType\Parameter
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Drupal\netforum\xWeb\Generated\StructType\Parameter|null
     */
    public function first(): ?\Drupal\netforum\xWeb\Generated\StructType\Parameter
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Drupal\netforum\xWeb\Generated\StructType\Parameter|null
     */
    public function last(): ?\Drupal\netforum\xWeb\Generated\StructType\Parameter
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Drupal\netforum\xWeb\Generated\StructType\Parameter|null
     */
    public function offsetGet($offset): ?\Drupal\netforum\xWeb\Generated\StructType\Parameter
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws InvalidArgumentException
     * @param \Drupal\netforum\xWeb\Generated\StructType\Parameter $item
     * @return \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfParameter
     */
    public function add($item): self
    {
        // validation for constraint: itemType
        if (!$item instanceof \Drupal\netforum\xWeb\Generated\StructType\Parameter) {
            throw new InvalidArgumentException(sprintf('The Parameter property can only contain items of type \Drupal\netforum\xWeb\Generated\StructType\Parameter, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Parameter
     */
    public function getAttributeName(): string
    {
        return 'Parameter';
    }
}
