<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\ArrayType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfQueryParameter ArrayType
 * @subpackage Arrays
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
class ArrayOfQueryParameter extends AbstractStructArrayBase
{
    /**
     * The QueryParameter
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Drupal\netforum\xWeb\Generated\StructType\QueryParameter[]|null
     */
    protected ?array $QueryParameter = null;
    /**
     * Constructor method for ArrayOfQueryParameter
     * @uses ArrayOfQueryParameter::setQueryParameter()
     * @param \Drupal\netforum\xWeb\Generated\StructType\QueryParameter[] $queryParameter
     */
    public function __construct(?array $queryParameter = null)
    {
        $this
            ->setQueryParameter($queryParameter);
    }
    /**
     * Get QueryParameter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Drupal\netforum\xWeb\Generated\StructType\QueryParameter[]|null
     */
    public function getQueryParameter(): ?array
    {
        return $this->QueryParameter ?? null;
    }
    /**
     * This method is responsible for validating the value(s) passed to the setQueryParameter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQueryParameter method
     * This has to validate that each item contained by the array match the itemType constraint
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQueryParameterForArrayConstraintFromSetQueryParameter(?array $values = []): string
    {
        if (!is_array($values)) {
            return '';
        }
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfQueryParameterQueryParameterItem) {
            // validation for constraint: itemType
            if (!$arrayOfQueryParameterQueryParameterItem instanceof \Drupal\netforum\xWeb\Generated\StructType\QueryParameter) {
                $invalidValues[] = is_object($arrayOfQueryParameterQueryParameterItem) ? get_class($arrayOfQueryParameterQueryParameterItem) : sprintf('%s(%s)', gettype($arrayOfQueryParameterQueryParameterItem), var_export($arrayOfQueryParameterQueryParameterItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The QueryParameter property can only contain items of type \Drupal\netforum\xWeb\Generated\StructType\QueryParameter, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        
        return $message;
    }
    /**
     * Set QueryParameter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws InvalidArgumentException
     * @param \Drupal\netforum\xWeb\Generated\StructType\QueryParameter[] $queryParameter
     * @return \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfQueryParameter
     */
    public function setQueryParameter(?array $queryParameter = null): self
    {
        // validation for constraint: array
        if ('' !== ($queryParameterArrayErrorMessage = self::validateQueryParameterForArrayConstraintFromSetQueryParameter($queryParameter))) {
            throw new InvalidArgumentException($queryParameterArrayErrorMessage, __LINE__);
        }
        if (is_null($queryParameter) || (is_array($queryParameter) && empty($queryParameter))) {
            unset($this->QueryParameter);
        } else {
            $this->QueryParameter = $queryParameter;
        }
        
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Drupal\netforum\xWeb\Generated\StructType\QueryParameter|null
     */
    public function current(): ?\Drupal\netforum\xWeb\Generated\StructType\QueryParameter
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Drupal\netforum\xWeb\Generated\StructType\QueryParameter|null
     */
    public function item($index): ?\Drupal\netforum\xWeb\Generated\StructType\QueryParameter
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Drupal\netforum\xWeb\Generated\StructType\QueryParameter|null
     */
    public function first(): ?\Drupal\netforum\xWeb\Generated\StructType\QueryParameter
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Drupal\netforum\xWeb\Generated\StructType\QueryParameter|null
     */
    public function last(): ?\Drupal\netforum\xWeb\Generated\StructType\QueryParameter
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Drupal\netforum\xWeb\Generated\StructType\QueryParameter|null
     */
    public function offsetGet($offset): ?\Drupal\netforum\xWeb\Generated\StructType\QueryParameter
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws InvalidArgumentException
     * @param \Drupal\netforum\xWeb\Generated\StructType\QueryParameter $item
     * @return \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfQueryParameter
     */
    public function add($item): self
    {
        // validation for constraint: itemType
        if (!$item instanceof \Drupal\netforum\xWeb\Generated\StructType\QueryParameter) {
            throw new InvalidArgumentException(sprintf('The QueryParameter property can only contain items of type \Drupal\netforum\xWeb\Generated\StructType\QueryParameter, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string QueryParameter
     */
    public function getAttributeName(): string
    {
        return 'QueryParameter';
    }
}
