<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\ArrayType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfString ArrayType
 * @subpackage Arrays
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
class ArrayOfString extends AbstractStructArrayBase
{
    /**
     * The ControlName
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]|null
     */
    protected ?array $ControlName = null;
    /**
     * Constructor method for ArrayOfString
     * @uses ArrayOfString::setControlName()
     * @param string[] $controlName
     */
    public function __construct(?array $controlName = null)
    {
        $this
            ->setControlName($controlName);
    }
    /**
     * Get ControlName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getControlName(): ?array
    {
        return $this->ControlName ?? null;
    }
    /**
     * This method is responsible for validating the value(s) passed to the setControlName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setControlName method
     * This has to validate that each item contained by the array match the itemType constraint
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateControlNameForArrayConstraintFromSetControlName(?array $values = []): string
    {
        if (!is_array($values)) {
            return '';
        }
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfStringControlNameItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOfStringControlNameItem)) {
                $invalidValues[] = is_object($arrayOfStringControlNameItem) ? get_class($arrayOfStringControlNameItem) : sprintf('%s(%s)', gettype($arrayOfStringControlNameItem), var_export($arrayOfStringControlNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ControlName property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        
        return $message;
    }
    /**
     * Set ControlName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws InvalidArgumentException
     * @param string[] $controlName
     * @return \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfString
     */
    public function setControlName(?array $controlName = null): self
    {
        // validation for constraint: array
        if ('' !== ($controlNameArrayErrorMessage = self::validateControlNameForArrayConstraintFromSetControlName($controlName))) {
            throw new InvalidArgumentException($controlNameArrayErrorMessage, __LINE__);
        }
        if (is_null($controlName) || (is_array($controlName) && empty($controlName))) {
            unset($this->ControlName);
        } else {
            $this->ControlName = $controlName;
        }
        
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current(): ?string
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index): ?string
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first(): ?string
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last(): ?string
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset): ?string
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ControlName
     */
    public function getAttributeName(): string
    {
        return 'ControlName';
    }
}
