<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\ArrayType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfString1 ArrayType
 * @subpackage Arrays
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
class ArrayOfString1 extends AbstractStructArrayBase
{
    /**
     * The Module
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]|null
     */
    protected ?array $Module = null;
    /**
     * Constructor method for ArrayOfString1
     * @uses ArrayOfString1::setModule()
     * @param string[] $module
     */
    public function __construct(?array $module = null)
    {
        $this
            ->setModule($module);
    }
    /**
     * Get Module value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getModule(): ?array
    {
        return $this->Module ?? null;
    }
    /**
     * This method is responsible for validating the value(s) passed to the setModule method
     * This method is willingly generated in order to preserve the one-line inline validation within the setModule method
     * This has to validate that each item contained by the array match the itemType constraint
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateModuleForArrayConstraintFromSetModule(?array $values = []): string
    {
        if (!is_array($values)) {
            return '';
        }
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfString1ModuleItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOfString1ModuleItem)) {
                $invalidValues[] = is_object($arrayOfString1ModuleItem) ? get_class($arrayOfString1ModuleItem) : sprintf('%s(%s)', gettype($arrayOfString1ModuleItem), var_export($arrayOfString1ModuleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Module property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        
        return $message;
    }
    /**
     * Set Module value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws InvalidArgumentException
     * @param string[] $module
     * @return \Drupal\netforum\xWeb\Generated\ArrayType\ArrayOfString1
     */
    public function setModule(?array $module = null): self
    {
        // validation for constraint: array
        if ('' !== ($moduleArrayErrorMessage = self::validateModuleForArrayConstraintFromSetModule($module))) {
            throw new InvalidArgumentException($moduleArrayErrorMessage, __LINE__);
        }
        if (is_null($module) || (is_array($module) && empty($module))) {
            unset($this->Module);
        } else {
            $this->Module = $module;
        }
        
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current(): ?string
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index): ?string
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first(): ?string
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last(): ?string
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset): ?string
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Module
     */
    public function getAttributeName(): string
    {
        return 'Module';
    }
}
