<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\ServiceType;

use SoapFault;
use Drupal\netforum\xWeb\SoapClientBase;

/**
 * This class stands for all operations
 * @subpackage Services
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
class Service extends SoapClientBase
{
    /**
     * Sets the AuthorizationToken SoapHeader param
     * @uses SoapClientBase::setSoapHeader()
     * @param \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken $authorizationToken
     * @param string $namespace
     * @param bool $mustUnderstand
     * @param string|null $actor
     * @return \Drupal\netforum\xWeb\Generated\ServiceType\Service
     */
    public function setSoapHeaderAuthorizationToken(\Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken $authorizationToken, string $namespace = 'http://www.avectra.com/2005/', bool $mustUnderstand = false, ?string $actor = null): self
    {
        return $this->setSoapHeader($namespace, 'AuthorizationToken', $authorizationToken, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartMembershipRefresh
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Refreshes the membership object
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipRefresh $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipRefreshResponse|bool
     */
    public function WEBCentralizedShoppingCartMembershipRefresh(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipRefresh $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartMembershipRefresh = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartMembershipRefresh', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartMembershipRefresh;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartMembershipAddMembership
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Add a membership to the shopping cart.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipAddMembership $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipAddMembershipResponse|bool
     */
    public function WEBCentralizedShoppingCartMembershipAddMembership(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipAddMembership $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartMembershipAddMembership = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartMembershipAddMembership', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartMembershipAddMembership;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartMebmershipRemoveMembership
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Remove a membership from the shopping cart.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMebmershipRemoveMembership $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMebmershipRemoveMembershipResponse|bool
     */
    public function WEBCentralizedShoppingCartMebmershipRemoveMembership(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMebmershipRemoveMembership $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartMebmershipRemoveMembership = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartMebmershipRemoveMembership', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartMebmershipRemoveMembership;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named RenewMembership
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Add a renewal of the specified membership to a new or existing Shopping Cart.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\RenewMembership $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\RenewMembershipResponse|bool
     */
    public function RenewMembership(\Drupal\netforum\xWeb\Generated\StructType\RenewMembership $parameters)
    {
        try {
            $this->setResult($resultRenewMembership = $this->getSoapClient()->__soapCall('RenewMembership', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultRenewMembership;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartMembershipOpenInvoiceGetList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves List of open invoices - a record with a membership type, indicates a
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipOpenInvoiceGetList $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipOpenInvoiceGetListResponse|bool
     */
    public function WEBCentralizedShoppingCartMembershipOpenInvoiceGetList(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipOpenInvoiceGetList $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartMembershipOpenInvoiceGetList = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartMembershipOpenInvoiceGetList', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartMembershipOpenInvoiceGetList;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartMembershipOpenInvoiceGet
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Returns an existing open invoice object
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipOpenInvoiceGet $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipOpenInvoiceGetResponse|bool
     */
    public function WEBCentralizedShoppingCartMembershipOpenInvoiceGet(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipOpenInvoiceGet $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartMembershipOpenInvoiceGet = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartMembershipOpenInvoiceGet', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartMembershipOpenInvoiceGet;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartMembershipOpenInvoiceAdd
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Adds the open invoice to the shopping cart
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipOpenInvoiceAdd $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipOpenInvoiceAddResponse|bool
     */
    public function WEBCentralizedShoppingCartMembershipOpenInvoiceAdd(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipOpenInvoiceAdd $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartMembershipOpenInvoiceAdd = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartMembershipOpenInvoiceAdd', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartMembershipOpenInvoiceAdd;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartExhibitorGetExhibitList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Returns a list of exhibits
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartExhibitorGetExhibitList $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartExhibitorGetExhibitListResponse|bool
     */
    public function WEBCentralizedShoppingCartExhibitorGetExhibitList(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartExhibitorGetExhibitList $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartExhibitorGetExhibitList = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartExhibitorGetExhibitList', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartExhibitorGetExhibitList;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartExhibitorGetNew
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Returns a new exhibitor object
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartExhibitorGetNew $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartExhibitorGetNewResponse|bool
     */
    public function WEBCentralizedShoppingCartExhibitorGetNew(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartExhibitorGetNew $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartExhibitorGetNew = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartExhibitorGetNew', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartExhibitorGetNew;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartExhibitorGet
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Returns an existing exhibitor object
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartExhibitorGet $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartExhibitorGetResponse|bool
     */
    public function WEBCentralizedShoppingCartExhibitorGet(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartExhibitorGet $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartExhibitorGet = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartExhibitorGet', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartExhibitorGet;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartExhibitorGetBoothTypeList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Returns a list of available booth types by exhibit key
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartExhibitorGetBoothTypeList $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartExhibitorGetBoothTypeListResponse|bool
     */
    public function WEBCentralizedShoppingCartExhibitorGetBoothTypeList(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartExhibitorGetBoothTypeList $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartExhibitorGetBoothTypeList = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartExhibitorGetBoothTypeList', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartExhibitorGetBoothTypeList;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartExhibitorGetBoothCategoryList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Returns a list of available booth categories by exhibit key
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartExhibitorGetBoothCategoryList $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartExhibitorGetBoothCategoryListResponse|bool
     */
    public function WEBCentralizedShoppingCartExhibitorGetBoothCategoryList(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartExhibitorGetBoothCategoryList $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartExhibitorGetBoothCategoryList = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartExhibitorGetBoothCategoryList', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartExhibitorGetBoothCategoryList;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartExhibitorGetBoothList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetBoothList $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetBoothListResponse|bool
     */
    public function WEBCentralizedShoppingCartExhibitorGetBoothList(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetBoothList $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartExhibitorGetBoothList = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartExhibitorGetBoothList', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartExhibitorGetBoothList;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartExhibitorSetLineItems
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartExhibitorSetLineItems $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartExhibitorSetLineItemsResponse|bool
     */
    public function WEBCentralizedShoppingCartExhibitorSetLineItems(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartExhibitorSetLineItems $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartExhibitorSetLineItems = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartExhibitorSetLineItems', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartExhibitorSetLineItems;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartExhibitorSetLineItemsWithCart
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartExhibitorSetLineItemsWithCart $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartExhibitorSetLineItemsWithCartResponse|bool
     */
    public function WEBCentralizedShoppingCartExhibitorSetLineItemsWithCart(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartExhibitorSetLineItemsWithCart $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartExhibitorSetLineItemsWithCart = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartExhibitorSetLineItemsWithCart', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartExhibitorSetLineItemsWithCart;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartExhibitorAddExhibitor
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartExhibitorAddExhibitor $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartExhibitorAddExhibitorResponse|bool
     */
    public function WEBCentralizedShoppingCartExhibitorAddExhibitor(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartExhibitorAddExhibitor $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartExhibitorAddExhibitor = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartExhibitorAddExhibitor', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartExhibitorAddExhibitor;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetShippingOptions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Shipping Product List.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetShippingOptions $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetShippingOptionsResponse|bool
     */
    public function WEBCentralizedShoppingCartGetShippingOptions(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetShippingOptions $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetShippingOptions = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetShippingOptions', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetShippingOptions;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartAddShippingItem
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Add a shipping item to Centralized Shopping Cart
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartAddShippingItem $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartAddShippingItemResponse|bool
     */
    public function WEBCentralizedShoppingCartAddShippingItem(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartAddShippingItem $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartAddShippingItem = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartAddShippingItem', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartAddShippingItem;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetPaymentOptions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Available Payment Methods.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetPaymentOptions $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetPaymentOptionsResponse|bool
     */
    public function WEBCentralizedShoppingCartGetPaymentOptions(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetPaymentOptions $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetPaymentOptions = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetPaymentOptions', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetPaymentOptions;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetInstallmentFrequencyOptions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Installment Frequency Options. Assign ord_frequency to desired value. To generate Installments, set values for the following fields: ord_num_of_installments, ord_frequency, ord_ait_key
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetInstallmentFrequencyOptions $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetInstallmentFrequencyOptionsResponse|bool
     */
    public function WEBCentralizedShoppingCartGetInstallmentFrequencyOptions(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetInstallmentFrequencyOptions $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetInstallmentFrequencyOptions = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetInstallmentFrequencyOptions', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetInstallmentFrequencyOptions;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetInstallmentTermsOptions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Installment Terms Options. Assign ord_ait_key to desired value. To generate Installments, set values for the following fields: ord_num_of_installments, ord_frequency, ord_ait_key
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetInstallmentTermsOptions $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetInstallmentTermsOptionsResponse|bool
     */
    public function WEBCentralizedShoppingCartGetInstallmentTermsOptions(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetInstallmentTermsOptions $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetInstallmentTermsOptions = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetInstallmentTermsOptions', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetInstallmentTermsOptions;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetProductLineItem
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Returns Product Detail / Line Item.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductLineItem $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductLineItemResponse|bool
     */
    public function WEBCentralizedShoppingCartGetProductLineItem(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductLineItem $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetProductLineItem = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetProductLineItem', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetProductLineItem;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetProductLineItemWithCart
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Returns Product Detail / Line Item.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductLineItemWithCart $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductLineItemWithCartResponse|bool
     */
    public function WEBCentralizedShoppingCartGetProductLineItemWithCart(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductLineItemWithCart $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetProductLineItemWithCart = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetProductLineItemWithCart', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetProductLineItemWithCart;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartLoadLineItem
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Loads a line item.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartLoadLineItem $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartLoadLineItemResponse|bool
     */
    public function WEBCentralizedShoppingCartLoadLineItem(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartLoadLineItem $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartLoadLineItem = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartLoadLineItem', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartLoadLineItem;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartAddLineItem
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Adds a line item to Centralized Shopping Cart
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartAddLineItem $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartAddLineItemResponse|bool
     */
    public function WEBCentralizedShoppingCartAddLineItem(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartAddLineItem $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartAddLineItem = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartAddLineItem', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartAddLineItem;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartRemoveLineItem
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Removes a line item from Centralized Shopping Cart
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartRemoveLineItem $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartRemoveLineItemResponse|bool
     */
    public function WEBCentralizedShoppingCartRemoveLineItem(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartRemoveLineItem $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartRemoveLineItem = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartRemoveLineItem', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartRemoveLineItem;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartRemoveAllLineItems
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Removes all line items from Centralized Shopping Cart
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartRemoveAllLineItems $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartRemoveAllLineItemsResponse|bool
     */
    public function WEBCentralizedShoppingCartRemoveAllLineItems(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartRemoveAllLineItems $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartRemoveAllLineItems = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartRemoveAllLineItems', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartRemoveAllLineItems;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetAccreditationList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Accreditation List
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetAccreditationList $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetAccreditationListResponse|bool
     */
    public function WEBCentralizedShoppingCartGetAccreditationList(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetAccreditationList $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetAccreditationList = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetAccreditationList', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetAccreditationList;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetAccreditationListByCustomer
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Accreditation List by Customer
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetAccreditationListByCustomer $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetAccreditationListByCustomerResponse|bool
     */
    public function WEBCentralizedShoppingCartGetAccreditationListByCustomer(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetAccreditationListByCustomer $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetAccreditationListByCustomer = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetAccreditationListByCustomer', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetAccreditationListByCustomer;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetAccreditationFeeList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Accreditation Type Fee List
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetAccreditationFeeList $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetAccreditationFeeListResponse|bool
     */
    public function WEBCentralizedShoppingCartGetAccreditationFeeList(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetAccreditationFeeList $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetAccreditationFeeList = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetAccreditationFeeList', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetAccreditationFeeList;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetAccreditationTypeList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Accreditation Type List
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetAccreditationTypeList $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetAccreditationTypeListResponse|bool
     */
    public function WEBCentralizedShoppingCartGetAccreditationTypeList(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetAccreditationTypeList $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetAccreditationTypeList = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetAccreditationTypeList', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetAccreditationTypeList;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetAccreditationTypeStatusList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves AccreditationType Status List
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetAccreditationTypeStatusList $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetAccreditationTypeStatusListResponse|bool
     */
    public function WEBCentralizedShoppingCartGetAccreditationTypeStatusList(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetAccreditationTypeStatusList $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetAccreditationTypeStatusList = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetAccreditationTypeStatusList', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetAccreditationTypeStatusList;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartAccreditationGet
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Returns an existing Accreditation
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartAccreditationGet $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartAccreditationGetResponse|bool
     */
    public function WEBCentralizedShoppingCartAccreditationGet(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartAccreditationGet $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartAccreditationGet = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartAccreditationGet', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartAccreditationGet;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartAccreditationGetNew
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Returns a new Accreditation object
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartAccreditationGetNew $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartAccreditationGetNewResponse|bool
     */
    public function WEBCentralizedShoppingCartAccreditationGetNew(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartAccreditationGetNew $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartAccreditationGetNew = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartAccreditationGetNew', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartAccreditationGetNew;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartAccreditationSetLineItems
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Adds/Removes Accreditationn Fees. Use this method before the Accreditation object is added to Centralized Order Entry
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartAccreditationSetLineItems $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartAccreditationSetLineItemsResponse|bool
     */
    public function WEBCentralizedShoppingCartAccreditationSetLineItems(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartAccreditationSetLineItems $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartAccreditationSetLineItems = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartAccreditationSetLineItems', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartAccreditationSetLineItems;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartAccreditationAddAccreditation
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Add a accreditation to the shopping cart.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartAccreditationAddAccreditation $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartAccreditationAddAccreditationResponse|bool
     */
    public function WEBCentralizedShoppingCartAccreditationAddAccreditation(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartAccreditationAddAccreditation $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartAccreditationAddAccreditation = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartAccreditationAddAccreditation', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartAccreditationAddAccreditation;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDateTime
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\GetDateTime $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetDateTimeResponse|bool
     */
    public function GetDateTime(\Drupal\netforum\xWeb\Generated\StructType\GetDateTime $parameters)
    {
        try {
            $this->setResult($resultGetDateTime = $this->getSoapClient()->__soapCall('GetDateTime', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultGetDateTime;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named MetaDataGetForm
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Form Controls By Form Key
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\MetaDataGetForm $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\MetaDataGetFormResponse|bool
     */
    public function MetaDataGetForm(\Drupal\netforum\xWeb\Generated\StructType\MetaDataGetForm $parameters)
    {
        try {
            $this->setResult($resultMetaDataGetForm = $this->getSoapClient()->__soapCall('MetaDataGetForm', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultMetaDataGetForm;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named MetaDataGetFormForFacadeObject
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Form Controls By Form Key
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\MetaDataGetFormForFacadeObject $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\MetaDataGetFormForFacadeObjectResponse|bool
     */
    public function MetaDataGetFormForFacadeObject(\Drupal\netforum\xWeb\Generated\StructType\MetaDataGetFormForFacadeObject $parameters)
    {
        try {
            $this->setResult($resultMetaDataGetFormForFacadeObject = $this->getSoapClient()->__soapCall('MetaDataGetFormForFacadeObject', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultMetaDataGetFormForFacadeObject;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * MetaDataGetFormControlForFacadeObject
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Form Control details By Form Key and control name
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\MetaDataGetFormControlForFacadeObject $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\MetaDataGetFormControlForFacadeObjectResponse|bool
     */
    public function MetaDataGetFormControlForFacadeObject(\Drupal\netforum\xWeb\Generated\StructType\MetaDataGetFormControlForFacadeObject $parameters)
    {
        try {
            $this->setResult($resultMetaDataGetFormControlForFacadeObject = $this->getSoapClient()->__soapCall('MetaDataGetFormControlForFacadeObject', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultMetaDataGetFormControlForFacadeObject;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named MetaDataGetFormForIndividual
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Form Controls By Form Key
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\MetaDataGetFormForIndividual $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\MetaDataGetFormForIndividualResponse|bool
     */
    public function MetaDataGetFormForIndividual(\Drupal\netforum\xWeb\Generated\StructType\MetaDataGetFormForIndividual $parameters)
    {
        try {
            $this->setResult($resultMetaDataGetFormForIndividual = $this->getSoapClient()->__soapCall('MetaDataGetFormForIndividual', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultMetaDataGetFormForIndividual;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named MetaDataGetWizard
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Wizard detaild by key
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\MetaDataGetWizard $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\MetaDataGetWizardResponse|bool
     */
    public function MetaDataGetWizard(\Drupal\netforum\xWeb\Generated\StructType\MetaDataGetWizard $parameters)
    {
        try {
            $this->setResult($resultMetaDataGetWizard = $this->getSoapClient()->__soapCall('MetaDataGetWizard', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultMetaDataGetWizard;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named MetaDataGetWizardForm
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Wizard form detaild by key
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\MetaDataGetWizardForm $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\MetaDataGetWizardFormResponse|bool
     */
    public function MetaDataGetWizardForm(\Drupal\netforum\xWeb\Generated\StructType\MetaDataGetWizardForm $parameters)
    {
        try {
            $this->setResult($resultMetaDataGetWizardForm = $this->getSoapClient()->__soapCall('MetaDataGetWizardForm', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultMetaDataGetWizardForm;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBColumnGetColumnValuesByColumnName
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves the column values for DropDownLists and ListBoxes.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBColumnGetColumnValuesByColumnName $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBColumnGetColumnValuesByColumnNameResponse|bool
     */
    public function WEBColumnGetColumnValuesByColumnName(\Drupal\netforum\xWeb\Generated\StructType\WEBColumnGetColumnValuesByColumnName $parameters)
    {
        try {
            $this->setResult($resultWEBColumnGetColumnValuesByColumnName = $this->getSoapClient()->__soapCall('WEBColumnGetColumnValuesByColumnName', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBColumnGetColumnValuesByColumnName;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPromotionalMailingTypes
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Get available promotional mailing types available for customers
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\GetPromotionalMailingTypes $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetPromotionalMailingTypesResponse|bool
     */
    public function GetPromotionalMailingTypes(\Drupal\netforum\xWeb\Generated\StructType\GetPromotionalMailingTypes $parameters)
    {
        try {
            $this->setResult($resultGetPromotionalMailingTypes = $this->getSoapClient()->__soapCall('GetPromotionalMailingTypes', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultGetPromotionalMailingTypes;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSubscriptionMailingTypes
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Get available subscription mailing types available for customers
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\GetSubscriptionMailingTypes $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetSubscriptionMailingTypesResponse|bool
     */
    public function GetSubscriptionMailingTypes(\Drupal\netforum\xWeb\Generated\StructType\GetSubscriptionMailingTypes $parameters)
    {
        try {
            $this->setResult($resultGetSubscriptionMailingTypes = $this->getSoapClient()->__soapCall('GetSubscriptionMailingTypes', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultGetSubscriptionMailingTypes;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerCommunicationPreference
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieve an individual's contact preference for a single mailing type.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\GetCustomerCommunicationPreference $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetCustomerCommunicationPreferenceResponse|bool
     */
    public function GetCustomerCommunicationPreference(\Drupal\netforum\xWeb\Generated\StructType\GetCustomerCommunicationPreference $parameters)
    {
        try {
            $this->setResult($resultGetCustomerCommunicationPreference = $this->getSoapClient()->__soapCall('GetCustomerCommunicationPreference', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultGetCustomerCommunicationPreference;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetAllCustomerCommunicationPreferences
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieve an individual's contact preferences.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\GetAllCustomerCommunicationPreferences $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetAllCustomerCommunicationPreferencesResponse|bool
     */
    public function GetAllCustomerCommunicationPreferences(\Drupal\netforum\xWeb\Generated\StructType\GetAllCustomerCommunicationPreferences $parameters)
    {
        try {
            $this->setResult($resultGetAllCustomerCommunicationPreferences = $this->getSoapClient()->__soapCall('GetAllCustomerCommunicationPreferences', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultGetAllCustomerCommunicationPreferences;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * SetCustomerCommunicationPreferences
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Set an individual's contact preferences.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\SetCustomerCommunicationPreferences $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\SetCustomerCommunicationPreferencesResponse|bool
     */
    public function SetCustomerCommunicationPreferences(\Drupal\netforum\xWeb\Generated\StructType\SetCustomerCommunicationPreferences $parameters)
    {
        try {
            $this->setResult($resultSetCustomerCommunicationPreferences = $this->getSoapClient()->__soapCall('SetCustomerCommunicationPreferences', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultSetCustomerCommunicationPreferences;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetFundraisingEventRegistrationTotal
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Get the fundraising goal and achieved amount for a fundraising event participant.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\GetFundraisingEventRegistrantionTotal $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetFundraisingEventRegistrantionTotalResponse|bool
     */
    public function GetFundraisingEventRegistrationTotal(\Drupal\netforum\xWeb\Generated\StructType\GetFundraisingEventRegistrantionTotal $parameters)
    {
        try {
            $this->setResult($resultGetFundraisingEventRegistrationTotal = $this->getSoapClient()->__soapCall('GetFundraisingEventRegistrationTotal', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultGetFundraisingEventRegistrationTotal;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFundraisingEventDonations
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Get a list of donations provided to a fundraising event partifipant.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\GetFundraisingEventDonations $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetFundraisingEventDonationsResponse|bool
     */
    public function GetFundraisingEventDonations(\Drupal\netforum\xWeb\Generated\StructType\GetFundraisingEventDonations $parameters)
    {
        try {
            $this->setResult($resultGetFundraisingEventDonations = $this->getSoapClient()->__soapCall('GetFundraisingEventDonations', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultGetFundraisingEventDonations;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFundraisingEventDonationUrl
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Get a link to a web page that be used to donate on behalf of a fundraising event participant.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\GetFundraisingEventDonationUrl $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetFundraisingEventDonationUrlResponse|bool
     */
    public function GetFundraisingEventDonationUrl(\Drupal\netforum\xWeb\Generated\StructType\GetFundraisingEventDonationUrl $parameters)
    {
        try {
            $this->setResult($resultGetFundraisingEventDonationUrl = $this->getSoapClient()->__soapCall('GetFundraisingEventDonationUrl', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultGetFundraisingEventDonationUrl;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named CeuApplyExternalCredits
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Add ceu credits to an individual. Existing credits can be updated based on the credit externalId.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\CeuApplyExternalCredits $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\CeuApplyExternalCreditsResponse|bool
     */
    public function CeuApplyExternalCredits(\Drupal\netforum\xWeb\Generated\StructType\CeuApplyExternalCredits $parameters)
    {
        try {
            $this->setResult($resultCeuApplyExternalCredits = $this->getSoapClient()->__soapCall('CeuApplyExternalCredits', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultCeuApplyExternalCredits;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBActivityGetRegistrantTracks
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Registrant Tracks
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBActivityGetRegistrantTracks $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBActivityGetRegistrantTracksResponse|bool
     */
    public function WEBActivityGetRegistrantTracks(\Drupal\netforum\xWeb\Generated\StructType\WEBActivityGetRegistrantTracks $parameters)
    {
        try {
            $this->setResult($resultWEBActivityGetRegistrantTracks = $this->getSoapClient()->__soapCall('WEBActivityGetRegistrantTracks', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBActivityGetRegistrantTracks;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBActivityGetRegistrantGuests
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Registrant Guests
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBActivityGetRegistrantGuests $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBActivityGetRegistrantGuestsResponse|bool
     */
    public function WEBActivityGetRegistrantGuests(\Drupal\netforum\xWeb\Generated\StructType\WEBActivityGetRegistrantGuests $parameters)
    {
        try {
            $this->setResult($resultWEBActivityGetRegistrantGuests = $this->getSoapClient()->__soapCall('WEBActivityGetRegistrantGuests', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBActivityGetRegistrantGuests;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBCommitteeGetCommitteeList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves List of Active Committees.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeGetCommitteeList $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeGetCommitteeListResponse|bool
     */
    public function WEBCommitteeGetCommitteeList(\Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeGetCommitteeList $parameters)
    {
        try {
            $this->setResult($resultWEBCommitteeGetCommitteeList = $this->getSoapClient()->__soapCall('WEBCommitteeGetCommitteeList', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCommitteeGetCommitteeList;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBCommitteeGetCommitteeListByName
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves List of Active Committees by name.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeGetCommitteeListByName $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeGetCommitteeListByNameResponse|bool
     */
    public function WEBCommitteeGetCommitteeListByName(\Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeGetCommitteeListByName $parameters)
    {
        try {
            $this->setResult($resultWEBCommitteeGetCommitteeListByName = $this->getSoapClient()->__soapCall('WEBCommitteeGetCommitteeListByName', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCommitteeGetCommitteeListByName;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCommitteeGetCommitteesByCustomer
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Committee List for logged in web user.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeGetCommitteesByCustomer $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeGetCommitteesByCustomerResponse|bool
     */
    public function WEBCommitteeGetCommitteesByCustomer(\Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeGetCommitteesByCustomer $parameters)
    {
        try {
            $this->setResult($resultWEBCommitteeGetCommitteesByCustomer = $this->getSoapClient()->__soapCall('WEBCommitteeGetCommitteesByCustomer', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCommitteeGetCommitteesByCustomer;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCommitteeGetSubCommitteeListByCommittee
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves List of Active Sub-Committees.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeGetSubCommitteeListByCommittee $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeGetSubCommitteeListByCommitteeResponse|bool
     */
    public function WEBCommitteeGetSubCommitteeListByCommittee(\Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeGetSubCommitteeListByCommittee $parameters)
    {
        try {
            $this->setResult($resultWEBCommitteeGetSubCommitteeListByCommittee = $this->getSoapClient()->__soapCall('WEBCommitteeGetSubCommitteeListByCommittee', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCommitteeGetSubCommitteeListByCommittee;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBCommitteeGetMembers
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Committee Members for specified committee.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeGetMembers $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeGetMembersResponse|bool
     */
    public function WEBCommitteeGetMembers(\Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeGetMembers $parameters)
    {
        try {
            $this->setResult($resultWEBCommitteeGetMembers = $this->getSoapClient()->__soapCall('WEBCommitteeGetMembers', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCommitteeGetMembers;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBCommitteeGetDocuments
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Committee Documents for specified committee.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeGetDocuments $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeGetDocumentsResponse|bool
     */
    public function WEBCommitteeGetDocuments(\Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeGetDocuments $parameters)
    {
        try {
            $this->setResult($resultWEBCommitteeGetDocuments = $this->getSoapClient()->__soapCall('WEBCommitteeGetDocuments', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCommitteeGetDocuments;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBCommitteeGetCommitteeByKey
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Returns committee information.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeGetCommitteeByKey $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeGetCommitteeByKeyResponse|bool
     */
    public function WEBCommitteeGetCommitteeByKey(\Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeGetCommitteeByKey $parameters)
    {
        try {
            $this->setResult($resultWEBCommitteeGetCommitteeByKey = $this->getSoapClient()->__soapCall('WEBCommitteeGetCommitteeByKey', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCommitteeGetCommitteeByKey;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBCommitteeGet
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Returns committee information.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeGet $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeGetResponse|bool
     */
    public function WEBCommitteeGet(\Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeGet $parameters)
    {
        try {
            $this->setResult($resultWEBCommitteeGet = $this->getSoapClient()->__soapCall('WEBCommitteeGet', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCommitteeGet;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBCommitteeNominationInsert
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Adds a committee nomination.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeNominationInsert $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeNominationInsertResponse|bool
     */
    public function WEBCommitteeNominationInsert(\Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeNominationInsert $parameters)
    {
        try {
            $this->setResult($resultWEBCommitteeNominationInsert = $this->getSoapClient()->__soapCall('WEBCommitteeNominationInsert', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCommitteeNominationInsert;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBCommitteeGetPositionList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves position list by committee.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeGetPositionList $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeGetPositionListResponse|bool
     */
    public function WEBCommitteeGetPositionList(\Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeGetPositionList $parameters)
    {
        try {
            $this->setResult($resultWEBCommitteeGetPositionList = $this->getSoapClient()->__soapCall('WEBCommitteeGetPositionList', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCommitteeGetPositionList;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBMemberDirectorySearch
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Searches the membership directory.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBMemberDirectorySearch $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBMemberDirectorySearchResponse|bool
     */
    public function WEBMemberDirectorySearch(\Drupal\netforum\xWeb\Generated\StructType\WEBMemberDirectorySearch $parameters)
    {
        try {
            $this->setResult($resultWEBMemberDirectorySearch = $this->getSoapClient()->__soapCall('WEBMemberDirectorySearch', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBMemberDirectorySearch;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBMemberDirectoryOrganizationSearch
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Searches the membership directory.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBMemberDirectoryOrganizationSearch $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBMemberDirectoryOrganizationSearchResponse|bool
     */
    public function WEBMemberDirectoryOrganizationSearch(\Drupal\netforum\xWeb\Generated\StructType\WEBMemberDirectoryOrganizationSearch $parameters)
    {
        try {
            $this->setResult($resultWEBMemberDirectoryOrganizationSearch = $this->getSoapClient()->__soapCall('WEBMemberDirectoryOrganizationSearch', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBMemberDirectoryOrganizationSearch;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBChaptersGetChapterList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves list of chapters.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBChaptersGetChapterList $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBChaptersGetChapterListResponse|bool
     */
    public function WEBChaptersGetChapterList(\Drupal\netforum\xWeb\Generated\StructType\WEBChaptersGetChapterList $parameters)
    {
        try {
            $this->setResult($resultWEBChaptersGetChapterList = $this->getSoapClient()->__soapCall('WEBChaptersGetChapterList', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBChaptersGetChapterList;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBChaptersGetChapterListByName
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves list of chapters by name.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBChaptersGetChapterListByName $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBChaptersGetChapterListByNameResponse|bool
     */
    public function WEBChaptersGetChapterListByName(\Drupal\netforum\xWeb\Generated\StructType\WEBChaptersGetChapterListByName $parameters)
    {
        try {
            $this->setResult($resultWEBChaptersGetChapterListByName = $this->getSoapClient()->__soapCall('WEBChaptersGetChapterListByName', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBChaptersGetChapterListByName;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBChaptersGetChapterMembershipRoster
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves a chapter's roster.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBChaptersGetChapterMembershipRoster $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBChaptersGetChapterMembershipRosterResponse|bool
     */
    public function WEBChaptersGetChapterMembershipRoster(\Drupal\netforum\xWeb\Generated\StructType\WEBChaptersGetChapterMembershipRoster $parameters)
    {
        try {
            $this->setResult($resultWEBChaptersGetChapterMembershipRoster = $this->getSoapClient()->__soapCall('WEBChaptersGetChapterMembershipRoster', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBChaptersGetChapterMembershipRoster;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBChaptersGetChapterOfficers
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves a chapter's officers.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBChaptersGetChapterOfficers $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBChaptersGetChapterOfficersResponse|bool
     */
    public function WEBChaptersGetChapterOfficers(\Drupal\netforum\xWeb\Generated\StructType\WEBChaptersGetChapterOfficers $parameters)
    {
        try {
            $this->setResult($resultWEBChaptersGetChapterOfficers = $this->getSoapClient()->__soapCall('WEBChaptersGetChapterOfficers', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBChaptersGetChapterOfficers;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBChaptersGetChapterByKey
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Returns chapter information.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBChaptersGetChapterByKey $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBChaptersGetChapterByKeyResponse|bool
     */
    public function WEBChaptersGetChapterByKey(\Drupal\netforum\xWeb\Generated\StructType\WEBChaptersGetChapterByKey $parameters)
    {
        try {
            $this->setResult($resultWEBChaptersGetChapterByKey = $this->getSoapClient()->__soapCall('WEBChaptersGetChapterByKey', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBChaptersGetChapterByKey;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBChapterGet
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Returns chapter information.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBChapterGet $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBChapterGetResponse|bool
     */
    public function WEBChapterGet(\Drupal\netforum\xWeb\Generated\StructType\WEBChapterGet $parameters)
    {
        try {
            $this->setResult($resultWEBChapterGet = $this->getSoapClient()->__soapCall('WEBChapterGet', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBChapterGet;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartStoreForeWeb
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Saves a shopping cart order for an existing customer in mox table
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartStoreForeWeb $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartStoreForeWebResponse|bool
     */
    public function WEBCentralizedShoppingCartStoreForeWeb(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartStoreForeWeb $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartStoreForeWeb = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartStoreForeWeb', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartStoreForeWeb;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetPendingOrder
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves the most recent shopping cart order for a specific customer which was saved using WEBCentralizedShoppingCartStoreForeWeb method
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetPendingOrder $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetPendingOrderResponse|bool
     */
    public function WEBCentralizedShoppingCartGetPendingOrder(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetPendingOrder $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetPendingOrder = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetPendingOrder', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetPendingOrder;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBCentralizedShoppingCartGetNew
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Returns a new shopping cart
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetNew $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetNewResponse|bool
     */
    public function WEBCentralizedShoppingCartGetNew(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetNew $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetNew = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetNew', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetNew;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBCentralizedShoppingCartGet
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Returns a new shopping cart
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGet $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetResponse|bool
     */
    public function WEBCentralizedShoppingCartGet(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGet $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGet = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGet', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGet;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetWithLineItem
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Returns a new shopping cart, with a line item added
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetWithLineItem $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetWithLineItemResponse|bool
     */
    public function WEBCentralizedShoppingCartGetWithLineItem(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetWithLineItem $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetWithLineItem = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetWithLineItem', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetWithLineItem;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBCentralizedShoppingCartRefresh
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Refresh Shopping cart
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartRefresh $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartRefreshResponse|bool
     */
    public function WEBCentralizedShoppingCartRefresh(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartRefresh $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartRefresh = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartRefresh', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartRefresh;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBCentralizedShoppingCartInsert
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Create Order and/or Invoice. To process a Paypal Express Checkout payment, be sure to set the payment method (pin_apm_key) accordingly and provide the token and payer id (pin_paypaltoken and pin_paypalpayerid respectively
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartInsert $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartInsertResponse|bool
     */
    public function WEBCentralizedShoppingCartInsert(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartInsert $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartInsert = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartInsert', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartInsert;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartApplySourceCode
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Apply a source code to Centralized Shopping Cart
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartApplySourceCode $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartApplySourceCodeResponse|bool
     */
    public function WEBCentralizedShoppingCartApplySourceCode(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartApplySourceCode $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartApplySourceCode = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartApplySourceCode', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartApplySourceCode;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartClearSourceCode
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Clears the source code that is applied to Centralized Shopping Cart
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartClearSourceCode $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartClearSourceCodeResponse|bool
     */
    public function WEBCentralizedShoppingCartClearSourceCode(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartClearSourceCode $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartClearSourceCode = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartClearSourceCode', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartClearSourceCode;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartApplyDiscountCode
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Add a discount code to Centralized Shopping Cart
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartApplyDiscountCode $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartApplyDiscountCodeResponse|bool
     */
    public function WEBCentralizedShoppingCartApplyDiscountCode(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartApplyDiscountCode $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartApplyDiscountCode = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartApplyDiscountCode', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartApplyDiscountCode;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetProductTypeList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Product Type List
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductTypeList $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductTypeListResponse|bool
     */
    public function WEBCentralizedShoppingCartGetProductTypeList(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductTypeList $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetProductTypeList = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetProductTypeList', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetProductTypeList;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetProductCategoryList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Product Category List
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductCategoryList $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductCategoryListResponse|bool
     */
    public function WEBCentralizedShoppingCartGetProductCategoryList(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductCategoryList $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetProductCategoryList = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetProductCategoryList', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetProductCategoryList;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetProductList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Product List; includes price range
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductList $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductListResponse|bool
     */
    public function WEBCentralizedShoppingCartGetProductList(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductList $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetProductList = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetProductList', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetProductList;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetProductListByName
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Product List by name; includes price range
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductListByName $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductListByNameResponse|bool
     */
    public function WEBCentralizedShoppingCartGetProductListByName(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductListByName $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetProductListByName = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetProductListByName', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetProductListByName;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetProductByKey
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Product Info; includes price range
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductByKey $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductByKeyResponse|bool
     */
    public function WEBCentralizedShoppingCartGetProductByKey(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductByKey $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetProductByKey = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetProductByKey', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetProductByKey;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetProductListKeys
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves List of product keys
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductListKeys $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductListKeysResponse|bool
     */
    public function WEBCentralizedShoppingCartGetProductListKeys(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductListKeys $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetProductListKeys = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetProductListKeys', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetProductListKeys;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetProductComplements
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves list of all product complements
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductComplements $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductComplementsResponse|bool
     */
    public function WEBCentralizedShoppingCartGetProductComplements(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductComplements $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetProductComplements = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetProductComplements', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetProductComplements;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetProductComplementListByProductKey
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves list of product complements for specified product
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductComplementListByProductKey $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductComplementListByProductKeyResponse|bool
     */
    public function WEBCentralizedShoppingCartGetProductComplementListByProductKey(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductComplementListByProductKey $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetProductComplementListByProductKey = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetProductComplementListByProductKey', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetProductComplementListByProductKey;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetProductSubstitutes
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves list of all product substitutes
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductSubstitutes $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductSubstitutesResponse|bool
     */
    public function WEBCentralizedShoppingCartGetProductSubstitutes(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductSubstitutes $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetProductSubstitutes = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetProductSubstitutes', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetProductSubstitutes;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetProductSubstituteListByProductKey
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves list of product substitutes for specified product
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductSubstituteListByProductKey $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductSubstituteListByProductKeyResponse|bool
     */
    public function WEBCentralizedShoppingCartGetProductSubstituteListByProductKey(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductSubstituteListByProductKey $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetProductSubstituteListByProductKey = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetProductSubstituteListByProductKey', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetProductSubstituteListByProductKey;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetProductListAlsoPurchasedByProductKey
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves list of all products also purchased
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductListAlsoPurchasedByProductKey $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductListAlsoPurchasedByProductKeyResponse|bool
     */
    public function WEBCentralizedShoppingCartGetProductListAlsoPurchasedByProductKey(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductListAlsoPurchasedByProductKey $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetProductListAlsoPurchasedByProductKey = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetProductListAlsoPurchasedByProductKey', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetProductListAlsoPurchasedByProductKey;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetMerchandiseList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Merchandise List.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetMerchandiseList $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetMerchandiseListResponse|bool
     */
    public function WEBCentralizedShoppingCartGetMerchandiseList(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetMerchandiseList $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetMerchandiseList = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetMerchandiseList', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetMerchandiseList;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetMerchandiseList_Ignore_PC
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Merchandise List without Pricing Control Check.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetMerchandiseList_Ignore_PC $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetMerchandiseList_Ignore_PCResponse|bool
     */
    public function WEBCentralizedShoppingCartGetMerchandiseList_Ignore_PC(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetMerchandiseList_Ignore_PC $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetMerchandiseList_Ignore_PC = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetMerchandiseList_Ignore_PC', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetMerchandiseList_Ignore_PC;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetPublicationList_Ignore_PC
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Publication List without Pricing Control Check.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetPublicationList_Ignore_PC $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetPublicationList_Ignore_PCResponse|bool
     */
    public function WEBCentralizedShoppingCartGetPublicationList_Ignore_PC(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetPublicationList_Ignore_PC $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetPublicationList_Ignore_PC = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetPublicationList_Ignore_PC', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetPublicationList_Ignore_PC;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetSubscriptionList_Ignore_PC
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Subscription List without Pricing Control Check.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetSubscriptionList_Ignore_PC $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetSubscriptionList_Ignore_PCResponse|bool
     */
    public function WEBCentralizedShoppingCartGetSubscriptionList_Ignore_PC(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetSubscriptionList_Ignore_PC $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetSubscriptionList_Ignore_PC = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetSubscriptionList_Ignore_PC', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetSubscriptionList_Ignore_PC;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetEventList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Event List
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventList $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventListResponse|bool
     */
    public function WEBCentralizedShoppingCartGetEventList(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventList $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetEventList = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetEventList', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetEventList;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetEventListByName
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Event List By Name
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventListByName $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventListByNameResponse|bool
     */
    public function WEBCentralizedShoppingCartGetEventListByName(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventListByName $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetEventListByName = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetEventListByName', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetEventListByName;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetEventByKey
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Event Info
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventByKey $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventByKeyResponse|bool
     */
    public function WEBCentralizedShoppingCartGetEventByKey(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventByKey $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetEventByKey = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetEventByKey', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetEventByKey;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetEventListKeys
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves List of event keys
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventListKeys $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventListKeysResponse|bool
     */
    public function WEBCentralizedShoppingCartGetEventListKeys(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventListKeys $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetEventListKeys = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetEventListKeys', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetEventListKeys;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetTrackListByEventKey
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Track list by event
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetTrackListByEventKey $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetTrackListByEventKeyResponse|bool
     */
    public function WEBCentralizedShoppingCartGetTrackListByEventKey(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetTrackListByEventKey $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetTrackListByEventKey = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetTrackListByEventKey', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetTrackListByEventKey;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetSessionListByEventKey
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Session list by event
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetSessionListByEventKey $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetSessionListByEventKeyResponse|bool
     */
    public function WEBCentralizedShoppingCartGetSessionListByEventKey(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetSessionListByEventKey $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetSessionListByEventKey = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetSessionListByEventKey', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetSessionListByEventKey;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetFacultyListByEventKey
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves faculty list by event
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetFacultyListByEventKey $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetFacultyListByEventKeyResponse|bool
     */
    public function WEBCentralizedShoppingCartGetFacultyListByEventKey(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetFacultyListByEventKey $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetFacultyListByEventKey = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetFacultyListByEventKey', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetFacultyListByEventKey;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetFacultyListBySessionKey
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves faculty list by session
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetFacultyListBySessionKey $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetFacultyListBySessionKeyResponse|bool
     */
    public function WEBCentralizedShoppingCartGetFacultyListBySessionKey(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetFacultyListBySessionKey $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetFacultyListBySessionKey = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetFacultyListBySessionKey', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetFacultyListBySessionKey;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetSponsorListByEventKey
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves sponsor list by event
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetSponsorListByEventKey $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetSponsorListByEventKeyResponse|bool
     */
    public function WEBCentralizedShoppingCartGetSponsorListByEventKey(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetSponsorListByEventKey $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetSponsorListByEventKey = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetSponsorListByEventKey', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetSponsorListByEventKey;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetSponsorListBySessionKey
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves sponsor list by session
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetSponsorListBySessionKey $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetSponsorListBySessionKeyResponse|bool
     */
    public function WEBCentralizedShoppingCartGetSponsorListBySessionKey(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetSponsorListBySessionKey $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetSponsorListBySessionKey = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetSponsorListBySessionKey', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetSponsorListBySessionKey;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetSessionListByTrackKey
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Session Info by track
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetSessionListByTrackKey $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetSessionListByTrackKeyResponse|bool
     */
    public function WEBCentralizedShoppingCartGetSessionListByTrackKey(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetSessionListByTrackKey $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetSessionListByTrackKey = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetSessionListByTrackKey', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetSessionListByTrackKey;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetEventRegistrantTypeList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves All Event Registrant Type List
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventRegistrantTypeList $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventRegistrantTypeListResponse|bool
     */
    public function WEBCentralizedShoppingCartGetEventRegistrantTypeList(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventRegistrantTypeList $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetEventRegistrantTypeList = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetEventRegistrantTypeList', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetEventRegistrantTypeList;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetEventRegistrantRoomTypeList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Housing Room Type List
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventRegistrantRoomTypeList $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventRegistrantRoomTypeListResponse|bool
     */
    public function WEBCentralizedShoppingCartGetEventRegistrantRoomTypeList(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventRegistrantRoomTypeList $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetEventRegistrantRoomTypeList = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetEventRegistrantRoomTypeList', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetEventRegistrantRoomTypeList;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetEventRegistrantTypeListByEvent
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Event Registrant Type List by event
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventRegistrantTypeListByEvent $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventRegistrantTypeListByEventResponse|bool
     */
    public function WEBCentralizedShoppingCartGetEventRegistrantTypeListByEvent(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventRegistrantTypeListByEvent $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetEventRegistrantTypeListByEvent = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetEventRegistrantTypeListByEvent', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetEventRegistrantTypeListByEvent;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetEventGuestRegistrantTypeListByEvent
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Event Guest Registrant Type List by event
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventGuestRegistrantTypeListByEvent $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventGuestRegistrantTypeListByEventResponse|bool
     */
    public function WEBCentralizedShoppingCartGetEventGuestRegistrantTypeListByEvent(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventGuestRegistrantTypeListByEvent $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetEventGuestRegistrantTypeListByEvent = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetEventGuestRegistrantTypeListByEvent', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetEventGuestRegistrantTypeListByEvent;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetEventRegistrantSourceCodeList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Event Registrant Type List
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventRegistrantSourceCodeList $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventRegistrantSourceCodeListResponse|bool
     */
    public function WEBCentralizedShoppingCartGetEventRegistrantSourceCodeList(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventRegistrantSourceCodeList $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetEventRegistrantSourceCodeList = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetEventRegistrantSourceCodeList', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetEventRegistrantSourceCodeList;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetEventRegistrantGroupIndividualList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Event Registrant Type List by event
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventRegistrantGroupIndividualList $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventRegistrantGroupIndividualListResponse|bool
     */
    public function WEBCentralizedShoppingCartGetEventRegistrantGroupIndividualList(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventRegistrantGroupIndividualList $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetEventRegistrantGroupIndividualList = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetEventRegistrantGroupIndividualList', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetEventRegistrantGroupIndividualList;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartEventRegistrantGet
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Returns an existing event registration
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantGet $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantGetResponse|bool
     */
    public function WEBCentralizedShoppingCartEventRegistrantGet(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantGet $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartEventRegistrantGet = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartEventRegistrantGet', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartEventRegistrantGet;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartEventRegistrantGetNew
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Returns a new event registration object
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantGetNew $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantGetNewResponse|bool
     */
    public function WEBCentralizedShoppingCartEventRegistrantGetNew(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantGetNew $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartEventRegistrantGetNew = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartEventRegistrantGetNew', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartEventRegistrantGetNew;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartEventRegistrantGroupGet
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Returns an existing group event registration
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantGroupGet $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantGroupGetResponse|bool
     */
    public function WEBCentralizedShoppingCartEventRegistrantGroupGet(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantGroupGet $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartEventRegistrantGroupGet = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartEventRegistrantGroupGet', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartEventRegistrantGroupGet;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartEventRegistrantGroupGetNew
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Returns a new group event registration object
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantGroupGetNew $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantGroupGetNewResponse|bool
     */
    public function WEBCentralizedShoppingCartEventRegistrantGroupGetNew(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantGroupGetNew $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartEventRegistrantGroupGetNew = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartEventRegistrantGroupGetNew', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartEventRegistrantGroupGetNew;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetEventFees
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Event Registration Fees.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventFees $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventFeesResponse|bool
     */
    public function WEBCentralizedShoppingCartGetEventFees(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventFees $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetEventFees = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetEventFees', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetEventFees;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetEventTrackFees
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Event Track Registration Fees.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventTrackFees $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventTrackFeesResponse|bool
     */
    public function WEBCentralizedShoppingCartGetEventTrackFees(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventTrackFees $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetEventTrackFees = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetEventTrackFees', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetEventTrackFees;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGetEventSessionFees
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Event Session Registration Fees.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventSessionFees $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventSessionFeesResponse|bool
     */
    public function WEBCentralizedShoppingCartGetEventSessionFees(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventSessionFees $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGetEventSessionFees = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGetEventSessionFees', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGetEventSessionFees;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartEventRegistrantSetLineItems
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Adds/Removes Event Registration Fees. Use this method before the registration object is added to Centralized Order Entry
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantSetLineItems $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantSetLineItemsResponse|bool
     */
    public function WEBCentralizedShoppingCartEventRegistrantSetLineItems(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantSetLineItems $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartEventRegistrantSetLineItems = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartEventRegistrantSetLineItems', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartEventRegistrantSetLineItems;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartEventRegistrantSetLineItemsWithCart
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Adds/Removes Event Registration Fees. Use this method after the registration object is added to Centralized Order Entry
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantSetLineItemsWithCart $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantSetLineItemsWithCartResponse|bool
     */
    public function WEBCentralizedShoppingCartEventRegistrantSetLineItemsWithCart(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantSetLineItemsWithCart $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartEventRegistrantSetLineItemsWithCart = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartEventRegistrantSetLineItemsWithCart', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartEventRegistrantSetLineItemsWithCart;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartEventRegistrantSetLineItemsWithGroupRegistration
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Adds/Removes Event Registration Fees. Use this method after the registration object is added to Centralized Order Entry
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantSetLineItemsWithGroupRegistration $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantSetLineItemsWithGroupRegistrationResponse|bool
     */
    public function WEBCentralizedShoppingCartEventRegistrantSetLineItemsWithGroupRegistration(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantSetLineItemsWithGroupRegistration $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartEventRegistrantSetLineItemsWithGroupRegistration = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartEventRegistrantSetLineItemsWithGroupRegistration', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartEventRegistrantSetLineItemsWithGroupRegistration;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartEventRegistrantRefresh
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Refreshes the registration object
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantRefresh $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantRefreshResponse|bool
     */
    public function WEBCentralizedShoppingCartEventRegistrantRefresh(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantRefresh $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartEventRegistrantRefresh = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartEventRegistrantRefresh', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartEventRegistrantRefresh;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartAddEventRegistrant
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Add a registrant to the shopping cart.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartAddEventRegistrant $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartAddEventRegistrantResponse|bool
     */
    public function WEBCentralizedShoppingCartAddEventRegistrant(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartAddEventRegistrant $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartAddEventRegistrant = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartAddEventRegistrant', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartAddEventRegistrant;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartRemoveEventRegistrant
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Remove a registrant from the shopping cart.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartRemoveEventRegistrant $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartRemoveEventRegistrantResponse|bool
     */
    public function WEBCentralizedShoppingCartRemoveEventRegistrant(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartRemoveEventRegistrant $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartRemoveEventRegistrant = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartRemoveEventRegistrant', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartRemoveEventRegistrant;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartEventRegistrantGroupRefresh
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Refreshes the group registration object
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantGroupRefresh $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantGroupRefreshResponse|bool
     */
    public function WEBCentralizedShoppingCartEventRegistrantGroupRefresh(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantGroupRefresh $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartEventRegistrantGroupRefresh = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartEventRegistrantGroupRefresh', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartEventRegistrantGroupRefresh;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartAddEventRegistrantToGroup
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Add an individual registration to a group registration.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartAddEventRegistrantToGroup $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartAddEventRegistrantToGroupResponse|bool
     */
    public function WEBCentralizedShoppingCartAddEventRegistrantToGroup(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartAddEventRegistrantToGroup $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartAddEventRegistrantToGroup = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartAddEventRegistrantToGroup', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartAddEventRegistrantToGroup;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartRemoveEventRegistrantFromGroup
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Remove a registration from a group registration.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartRemoveEventRegistrantFromGroup $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartRemoveEventRegistrantFromGroupResponse|bool
     */
    public function WEBCentralizedShoppingCartRemoveEventRegistrantFromGroup(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartRemoveEventRegistrantFromGroup $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartRemoveEventRegistrantFromGroup = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartRemoveEventRegistrantFromGroup', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartRemoveEventRegistrantFromGroup;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartAddEventRegistrantGroup
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Add a group registration to the shopping cart.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartAddEventRegistrantGroup $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartAddEventRegistrantGroupResponse|bool
     */
    public function WEBCentralizedShoppingCartAddEventRegistrantGroup(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartAddEventRegistrantGroup $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartAddEventRegistrantGroup = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartAddEventRegistrantGroup', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartAddEventRegistrantGroup;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartRemoveEventRegistrantGroup
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Remove a group registration from the shopping cart.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartRemoveEventRegistrantGroup $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartRemoveEventRegistrantGroupResponse|bool
     */
    public function WEBCentralizedShoppingCartRemoveEventRegistrantGroup(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartRemoveEventRegistrantGroup $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartRemoveEventRegistrantGroup = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartRemoveEventRegistrantGroup', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartRemoveEventRegistrantGroup;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGiftGetGiftProductList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Gift List
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftGetGiftProductList $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftGetGiftProductListResponse|bool
     */
    public function WEBCentralizedShoppingCartGiftGetGiftProductList(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftGetGiftProductList $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGiftGetGiftProductList = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGiftGetGiftProductList', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGiftGetGiftProductList;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGiftGetGiftProductListByName
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Gift List By Name
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftGetGiftProductListByName $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftGetGiftProductListByNameResponse|bool
     */
    public function WEBCentralizedShoppingCartGiftGetGiftProductListByName(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftGetGiftProductListByName $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGiftGetGiftProductListByName = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGiftGetGiftProductListByName', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGiftGetGiftProductListByName;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGiftGetGiftProductByKey
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Gift Info (use prc_key for GiftKey)
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftGetGiftProductByKey $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftGetGiftProductByKeyResponse|bool
     */
    public function WEBCentralizedShoppingCartGiftGetGiftProductByKey(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftGetGiftProductByKey $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGiftGetGiftProductByKey = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGiftGetGiftProductByKey', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGiftGetGiftProductByKey;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGiftGetGiftProductListKeys
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves List of gift keys
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftGetGiftProductListKeys $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftGetGiftProductListKeysResponse|bool
     */
    public function WEBCentralizedShoppingCartGiftGetGiftProductListKeys(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftGetGiftProductListKeys $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGiftGetGiftProductListKeys = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGiftGetGiftProductListKeys', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGiftGetGiftProductListKeys;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGiftGetGiftTypeList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves All Gift Type List (selected value should be set to gft_gty_key)
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftGetGiftTypeList $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftGetGiftTypeListResponse|bool
     */
    public function WEBCentralizedShoppingCartGiftGetGiftTypeList(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftGetGiftTypeList $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGiftGetGiftTypeList = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGiftGetGiftTypeList', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGiftGetGiftTypeList;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGiftGetPremiumProductsListByGift
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Gift Premium Products (should set selected value to gft_prm_prc_key)
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftGetPremiumProductsListByGift $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftGetPremiumProductsListByGiftResponse|bool
     */
    public function WEBCentralizedShoppingCartGiftGetPremiumProductsListByGift(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftGetPremiumProductsListByGift $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGiftGetPremiumProductsListByGift = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGiftGetPremiumProductsListByGift', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGiftGetPremiumProductsListByGift;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGiftFundraisingGet
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Returns an existing fundraising gift
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftFundraisingGet $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftFundraisingGetResponse|bool
     */
    public function WEBCentralizedShoppingCartGiftFundraisingGet(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftFundraisingGet $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGiftFundraisingGet = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGiftFundraisingGet', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGiftFundraisingGet;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGiftFundraisingGetNew
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Returns a new fundraising gift object
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftFundraisingGetNew $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftFundraisingGetNewResponse|bool
     */
    public function WEBCentralizedShoppingCartGiftFundraisingGetNew(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftFundraisingGetNew $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGiftFundraisingGetNew = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGiftFundraisingGetNew', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGiftFundraisingGetNew;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGiftFundraisingSetLineItems
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Adds/Removes Gift line items. Use this method before the Fundraising Gift object is added to Centralized Order Entry
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftFundraisingSetLineItems $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftFundraisingSetLineItemsResponse|bool
     */
    public function WEBCentralizedShoppingCartGiftFundraisingSetLineItems(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftFundraisingSetLineItems $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGiftFundraisingSetLineItems = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGiftFundraisingSetLineItems', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGiftFundraisingSetLineItems;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGiftFundraisingSetLineItemsWithCart
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Adds/Removes Gift line items. Use this method after the fundraising gift is added to Centralized Order Entry
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftFundraisingSetLineItemsWithCart $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftFundraisingSetLineItemsWithCartResponse|bool
     */
    public function WEBCentralizedShoppingCartGiftFundraisingSetLineItemsWithCart(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftFundraisingSetLineItemsWithCart $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGiftFundraisingSetLineItemsWithCart = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGiftFundraisingSetLineItemsWithCart', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGiftFundraisingSetLineItemsWithCart;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGiftFundraisingRefresh
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Refreshes the fundraising gift object
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftFundraisingRefresh $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftFundraisingRefreshResponse|bool
     */
    public function WEBCentralizedShoppingCartGiftFundraisingRefresh(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftFundraisingRefresh $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGiftFundraisingRefresh = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGiftFundraisingRefresh', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGiftFundraisingRefresh;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGiftAddGiftFundraising
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Add a fundraising gift to the shopping cart.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftAddGiftFundraising $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftAddGiftFundraisingResponse|bool
     */
    public function WEBCentralizedShoppingCartGiftAddGiftFundraising(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftAddGiftFundraising $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGiftAddGiftFundraising = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGiftAddGiftFundraising', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGiftAddGiftFundraising;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartGiftRemoveFundraisingGift
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Remove a fundraising gift from the shopping cart.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftRemoveFundraisingGift $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftRemoveFundraisingGiftResponse|bool
     */
    public function WEBCentralizedShoppingCartGiftRemoveFundraisingGift(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftRemoveFundraisingGift $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartGiftRemoveFundraisingGift = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartGiftRemoveFundraisingGift', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartGiftRemoveFundraisingGift;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartMembershipGetPackageList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Memembership Package List; the package product key mbr_pak_prd_key can be set in the membership object with the value of asp_pak_prd_key returned in this list.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetPackageList $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetPackageListResponse|bool
     */
    public function WEBCentralizedShoppingCartMembershipGetPackageList(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetPackageList $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartMembershipGetPackageList = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartMembershipGetPackageList', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartMembershipGetPackageList;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartMembershipGetRenewalPackageList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Memembership Package List; the package product key mbr_pak_prd_key can be set in the membership object with the value of asp_pak_prd_key returned in this list.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetRenewalPackageList $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetRenewalPackageListResponse|bool
     */
    public function WEBCentralizedShoppingCartMembershipGetRenewalPackageList(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetRenewalPackageList $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartMembershipGetRenewalPackageList = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartMembershipGetRenewalPackageList', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartMembershipGetRenewalPackageList;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartMembershipGetMembershipTypeList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Memembership Type List.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetMembershipTypeList $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetMembershipTypeListResponse|bool
     */
    public function WEBCentralizedShoppingCartMembershipGetMembershipTypeList(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetMembershipTypeList $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartMembershipGetMembershipTypeList = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartMembershipGetMembershipTypeList', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartMembershipGetMembershipTypeList;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartMembershipGetPackageListByName
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Membership Package List By Name
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetPackageListByName $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetPackageListByNameResponse|bool
     */
    public function WEBCentralizedShoppingCartMembershipGetPackageListByName(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetPackageListByName $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartMembershipGetPackageListByName = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartMembershipGetPackageListByName', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartMembershipGetPackageListByName;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartMembershipGetPackageListByMembershipTypeKey
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Membership Package List By Membership Type
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetPackageListByMembershipTypeKey $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetPackageListByMembershipTypeKeyResponse|bool
     */
    public function WEBCentralizedShoppingCartMembershipGetPackageListByMembershipTypeKey(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetPackageListByMembershipTypeKey $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartMembershipGetPackageListByMembershipTypeKey = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartMembershipGetPackageListByMembershipTypeKey', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartMembershipGetPackageListByMembershipTypeKey;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartMembershipGetPackageByKey
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Package Info (use value of asp_pak_prd_key for PackageKey)
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetPackageByKey $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetPackageByKeyResponse|bool
     */
    public function WEBCentralizedShoppingCartMembershipGetPackageByKey(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetPackageByKey $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartMembershipGetPackageByKey = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartMembershipGetPackageByKey', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartMembershipGetPackageByKey;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartMembershipGetPackageListKeys
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves List of package keys
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetPackageListKeys $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetPackageListKeysResponse|bool
     */
    public function WEBCentralizedShoppingCartMembershipGetPackageListKeys(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetPackageListKeys $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartMembershipGetPackageListKeys = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartMembershipGetPackageListKeys', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartMembershipGetPackageListKeys;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartMembershipGetPackageComponentList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves List of package components
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetPackageComponentList $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetPackageComponentListResponse|bool
     */
    public function WEBCentralizedShoppingCartMembershipGetPackageComponentList(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetPackageComponentList $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartMembershipGetPackageComponentList = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartMembershipGetPackageComponentList', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartMembershipGetPackageComponentList;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartMembershipGetPackageComponentListFromObject
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves List of package components with custom prices from the membership object; mbr_pak_prd_key and mbr_cst_key must both be set.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetPackageComponentListFromObject $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetPackageComponentListFromObjectResponse|bool
     */
    public function WEBCentralizedShoppingCartMembershipGetPackageComponentListFromObject(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetPackageComponentListFromObject $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartMembershipGetPackageComponentListFromObject = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartMembershipGetPackageComponentListFromObject', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartMembershipGetPackageComponentListFromObject;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartMembershipGet
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Returns an existing membership object
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGet $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetResponse|bool
     */
    public function WEBCentralizedShoppingCartMembershipGet(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGet $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartMembershipGet = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartMembershipGet', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartMembershipGet;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartMembershipGetNew
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Returns a new membership object
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetNew $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetNewResponse|bool
     */
    public function WEBCentralizedShoppingCartMembershipGetNew(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetNew $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartMembershipGetNew = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartMembershipGetNew', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartMembershipGetNew;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartMembesrhipSetLineItems
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Adds/Removes membership package line items. Use this method before the membership object is added to Centralized Order Entry
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembesrhipSetLineItems $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembesrhipSetLineItemsResponse|bool
     */
    public function WEBCentralizedShoppingCartMembesrhipSetLineItems(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembesrhipSetLineItems $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartMembesrhipSetLineItems = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartMembesrhipSetLineItems', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartMembesrhipSetLineItems;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartMembershipSetLineItemsWithCart
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Adds/Removes membership pacakge line items. Use this method after the membership object is added to Centralized Order Entry
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipSetLineItemsWithCart $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipSetLineItemsWithCartResponse|bool
     */
    public function WEBCentralizedShoppingCartMembershipSetLineItemsWithCart(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipSetLineItemsWithCart $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartMembershipSetLineItemsWithCart = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartMembershipSetLineItemsWithCart', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartMembershipSetLineItemsWithCart;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartOpenInvoiceAdd
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Adds an open invoice and returns the object
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartOpenInvoiceAdd $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartOpenInvoiceAddResponse|bool
     */
    public function WEBCentralizedShoppingCartOpenInvoiceAdd(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartOpenInvoiceAdd $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartOpenInvoiceAdd = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartOpenInvoiceAdd', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartOpenInvoiceAdd;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartOpenInvoiceGet
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Returns an existing open invoice
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartOpenInvoiceGet $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartOpenInvoiceGetResponse|bool
     */
    public function WEBCentralizedShoppingCartOpenInvoiceGet(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartOpenInvoiceGet $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartOpenInvoiceGet = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartOpenInvoiceGet', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartOpenInvoiceGet;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBCentralizedShoppingCartOpenInvoiceGetList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves List of open invoices - invoice date, invoice ID, total, amt paid, balance, amt due
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartOpenInvoiceGetList $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartOpenInvoiceGetListResponse|bool
     */
    public function WEBCentralizedShoppingCartOpenInvoiceGetList(\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartOpenInvoiceGetList $parameters)
    {
        try {
            $this->setResult($resultWEBCentralizedShoppingCartOpenInvoiceGetList = $this->getSoapClient()->__soapCall('WEBCentralizedShoppingCartOpenInvoiceGetList', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBCentralizedShoppingCartOpenInvoiceGetList;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named Authenticate
     * Meta information extracted from the WSDL
     * - documentation: Passing correct credentials to this method will return an authentication token - without an authentication token, the rest of the xWeb web methods will be inoperable. The authentication token is governed by the group privileges
     * assigned to the account invoking the xWeb web methods. Please consult with the administrator of the netForum database to ensure your level of authorization. This method MUST be the first method invoked at xWeb, as the authentication token that is
     * returned is required for every xWeb method.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\Authenticate $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\AuthenticateResponse|bool
     */
    public function Authenticate(\Drupal\netforum\xWeb\Generated\StructType\Authenticate $parameters)
    {
        try {
            $this->setResult($resultAuthenticate = $this->getSoapClient()->__soapCall('Authenticate', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultAuthenticate;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named AuthorizeOutlook
     * Meta information extracted from the WSDL
     * - documentation: Passing correct credentials to this method will return an authentication token - without an authentication token, the rest of the xWeb web methods will be inoperable. The authentication token is governed by the group privileges
     * assigned to the account invoking the xWeb web methods. Please consult with the administrator of the netForum database to ensure your level of authorization. This method MUST be the first method invoked at xWeb, as the authentication token that is
     * returned is required for every xWeb method.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\AuthorizeOutlook $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\AuthorizeOutlookResponse|bool
     */
    public function AuthorizeOutlook(\Drupal\netforum\xWeb\Generated\StructType\AuthorizeOutlook $parameters)
    {
        try {
            $this->setResult($resultAuthorizeOutlook = $this->getSoapClient()->__soapCall('AuthorizeOutlook', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultAuthorizeOutlook;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named AuthenticateLdap
     * Meta information extracted from the WSDL
     * - documentation: Passing correct credentials to this method will return an authentication token - without an authentication token, the rest of the xWeb web methods will be inoperable. The authentication token is governed by the group privileges
     * assigned to the account invoking the xWeb web methods. Please consult with the administrator of the netForum database to ensure your level of authorization. This method MUST be the first method invoked at xWeb, as the authentication token that is
     * returned is required for every xWeb method.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\AuthenticateLdap $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\AuthenticateLdapResponse|bool
     */
    public function AuthenticateLdap(\Drupal\netforum\xWeb\Generated\StructType\AuthenticateLdap $parameters)
    {
        try {
            $this->setResult($resultAuthenticateLdap = $this->getSoapClient()->__soapCall('AuthenticateLdap', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultAuthenticateLdap;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WebLogin
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Provides an authentication token for a valid customer login and password. The value for the login field depends on a netForum Systems Option ("useEmailForAuthorization"), so please check with the netforum administrator for the
     * setting. If there are more than one record with the exact same login and password combination, then the service will return the first match. The keyOverride parameter is an implementation specific parameter (web.config change) to force xWeb to return
     * the customer key (cst_key) for a valid credential.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WebLogin $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebLoginResponse|bool
     */
    public function WebLogin(\Drupal\netforum\xWeb\Generated\StructType\WebLogin $parameters)
    {
        try {
            $this->setResult($resultWebLogin = $this->getSoapClient()->__soapCall('WebLogin', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWebLogin;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WebValidate
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Provides the customer key (cst_key) for the authenticated token that is passed as a parameter - this method can be invoked after a successful WebLogin() method returns an authentication token. The authentication token is the only
     * parameter for this method.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WebValidate $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebValidateResponse|bool
     */
    public function WebValidate(\Drupal\netforum\xWeb\Generated\StructType\WebValidate $parameters)
    {
        try {
            $this->setResult($resultWebValidate = $this->getSoapClient()->__soapCall('WebValidate', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWebValidate;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WebLogout
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Forces the authentication token to be destroyed - this method is the companion method to the WebLogin() method or the WebValidate() method. xWeb doesn't return an Xml Node for success.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WebLogout $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WebLogoutResponse|bool
     */
    public function WebLogout(\Drupal\netforum\xWeb\Generated\StructType\WebLogout $parameters)
    {
        try {
            $this->setResult($resultWebLogout = $this->getSoapClient()->__soapCall('WebLogout', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWebLogout;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetQuery
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Provides a means of retrieving single or multiple data records and returns either the specific columns (pruning the number of elements is governed by how the netforum facade object was constructed, for example, the one-to-many
     * relationships cannot be rendered in a flat-view - in these cases, no value will be returned for the impacted elements) or the complete Facade object record (returning all the fields associated with a netForum Facade object can be done by passing a *
     * as the sole value for the szColumnList value).
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\GetQuery $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetQueryResponse|bool
     */
    public function GetQuery(\Drupal\netforum\xWeb\Generated\StructType\GetQuery $parameters)
    {
        try {
            $this->setResult($resultGetQuery = $this->getSoapClient()->__soapCall('GetQuery', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultGetQuery;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDynamicQuery
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieve data from a query that was built in the netForum iWeb Run Query form.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\GetDynamicQuery $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetDynamicQueryResponse|bool
     */
    public function GetDynamicQuery(\Drupal\netforum\xWeb\Generated\StructType\GetDynamicQuery $parameters)
    {
        try {
            $this->setResult($resultGetDynamicQuery = $this->getSoapClient()->__soapCall('GetDynamicQuery', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultGetDynamicQuery;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDynamicQueryDefinition
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieve definition of an iWeb Dynamic Query
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\GetDynamicQueryDefinition $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetDynamicQueryDefinitionResponse|bool
     */
    public function GetDynamicQueryDefinition(\Drupal\netforum\xWeb\Generated\StructType\GetDynamicQueryDefinition $parameters)
    {
        try {
            $this->setResult($resultGetDynamicQueryDefinition = $this->getSoapClient()->__soapCall('GetDynamicQueryDefinition', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultGetDynamicQueryDefinition;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAudienceList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves list of all audiences that a user can run.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\GetAudienceList $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetAudienceListResponse|bool
     */
    public function GetAudienceList(\Drupal\netforum\xWeb\Generated\StructType\GetAudienceList $parameters)
    {
        try {
            $this->setResult($resultGetAudienceList = $this->getSoapClient()->__soapCall('GetAudienceList', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultGetAudienceList;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAudience
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieve data from an audience that was built in the netForum iWeb Audience form.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\GetAudience $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetAudienceResponse|bool
     */
    public function GetAudience(\Drupal\netforum\xWeb\Generated\StructType\GetAudience $parameters)
    {
        try {
            $this->setResult($resultGetAudience = $this->getSoapClient()->__soapCall('GetAudience', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultGetAudience;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAudienceDefinition
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieve definition of an iWeb Audience.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\GetAudienceDefinition $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetAudienceDefinitionResponse|bool
     */
    public function GetAudienceDefinition(\Drupal\netforum\xWeb\Generated\StructType\GetAudienceDefinition $parameters)
    {
        try {
            $this->setResult($resultGetAudienceDefinition = $this->getSoapClient()->__soapCall('GetAudienceDefinition', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultGetAudienceDefinition;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetQueryDefinition
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Returns XmlNode with List Table definition for a given netFORUM Object. This information is provided for documentation for using the GetQuery web method.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\GetQueryDefinition $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetQueryDefinitionResponse|bool
     */
    public function GetQueryDefinition(\Drupal\netforum\xWeb\Generated\StructType\GetQueryDefinition $parameters)
    {
        try {
            $this->setResult($resultGetQueryDefinition = $this->getSoapClient()->__soapCall('GetQueryDefinition', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultGetQueryDefinition;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFacadeXMLSchema
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Provides a W3C XML Schema for any netFORUM Facade object. The only parameter for this method is a valid ObjectName - the textual display name of the object for which the Xml Schema document is being requested (individual, address,
     * etc.). The Xml Schema document that is returned contains the data relationships, the datatypes, and the documentation for each element and group. In short, this method returns a complete snapshot of the netForum Facade object.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\GetFacadeXMLSchema $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetFacadeXMLSchemaResponse|bool
     */
    public function GetFacadeXMLSchema(\Drupal\netforum\xWeb\Generated\StructType\GetFacadeXMLSchema $parameters)
    {
        try {
            $this->setResult($resultGetFacadeXMLSchema = $this->getSoapClient()->__soapCall('GetFacadeXMLSchema', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultGetFacadeXMLSchema;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFacadeObjectList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves the complete list of netForum Facade Objects that can be invoked.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\GetFacadeObjectList $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetFacadeObjectListResponse|bool
     */
    public function GetFacadeObjectList(\Drupal\netforum\xWeb\Generated\StructType\GetFacadeObjectList $parameters)
    {
        try {
            $this->setResult($resultGetFacadeObjectList = $this->getSoapClient()->__soapCall('GetFacadeObjectList', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultGetFacadeObjectList;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFacadeObject
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Returns all the fields and related data for the requested object. This method is marked for removal - the GetQuery() method returns same functionality.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\GetFacadeObject $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetFacadeObjectResponse|bool
     */
    public function GetFacadeObject(\Drupal\netforum\xWeb\Generated\StructType\GetFacadeObject $parameters)
    {
        try {
            $this->setResult($resultGetFacadeObject = $this->getSoapClient()->__soapCall('GetFacadeObject', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultGetFacadeObject;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateFacadeObject
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Updates a netForum Facade object and returns the modified netForum Facade object record. Parameters: szObjectName, szObjectKey, oNode. szObjectName - the textual display name of the object for which the schema information is being
     * Requested (individual, address, etc.). szObjectKey - the GUID representing an object's unique identity (primary key). oNode - an XML node containing elements that correspond to the Facade object's fields used to update the netForum data store.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\UpdateFacadeObject $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\UpdateFacadeObjectResponse|bool
     */
    public function UpdateFacadeObject(\Drupal\netforum\xWeb\Generated\StructType\UpdateFacadeObject $parameters)
    {
        try {
            $this->setResult($resultUpdateFacadeObject = $this->getSoapClient()->__soapCall('UpdateFacadeObject', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultUpdateFacadeObject;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertFacadeObject
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Inserts a netForum Facade object and if successful returns the primary key of the Facade object record that was created.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\InsertFacadeObject $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\InsertFacadeObjectResponse|bool
     */
    public function InsertFacadeObject(\Drupal\netforum\xWeb\Generated\StructType\InsertFacadeObject $parameters)
    {
        try {
            $this->setResult($resultInsertFacadeObject = $this->getSoapClient()->__soapCall('InsertFacadeObject', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultInsertFacadeObject;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetIndividualInformation
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Returns basic contact information for the individual.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\GetIndividualInformation $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetIndividualInformationResponse|bool
     */
    public function GetIndividualInformation(\Drupal\netforum\xWeb\Generated\StructType\GetIndividualInformation $parameters)
    {
        try {
            $this->setResult($resultGetIndividualInformation = $this->getSoapClient()->__soapCall('GetIndividualInformation', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultGetIndividualInformation;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetIndividualInformation
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Updates basic contact information for the individual.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\SetIndividualInformation $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\SetIndividualInformationResponse|bool
     */
    public function SetIndividualInformation(\Drupal\netforum\xWeb\Generated\StructType\SetIndividualInformation $parameters)
    {
        try {
            $this->setResult($resultSetIndividualInformation = $this->getSoapClient()->__soapCall('SetIndividualInformation', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultSetIndividualInformation;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named NewIndividualInformation
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Creates basic contact information for the individual.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\NewIndividualInformation $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\NewIndividualInformationResponse|bool
     */
    public function NewIndividualInformation(\Drupal\netforum\xWeb\Generated\StructType\NewIndividualInformation $parameters)
    {
        try {
            $this->setResult($resultNewIndividualInformation = $this->getSoapClient()->__soapCall('NewIndividualInformation', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultNewIndividualInformation;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrganizationInformation
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Returns basic contact information for the organization.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\GetOrganizationInformation $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetOrganizationInformationResponse|bool
     */
    public function GetOrganizationInformation(\Drupal\netforum\xWeb\Generated\StructType\GetOrganizationInformation $parameters)
    {
        try {
            $this->setResult($resultGetOrganizationInformation = $this->getSoapClient()->__soapCall('GetOrganizationInformation', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultGetOrganizationInformation;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetOrganizationInformation
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Updates basic contact information for the organization.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\SetOrganizationInformation $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\SetOrganizationInformationResponse|bool
     */
    public function SetOrganizationInformation(\Drupal\netforum\xWeb\Generated\StructType\SetOrganizationInformation $parameters)
    {
        try {
            $this->setResult($resultSetOrganizationInformation = $this->getSoapClient()->__soapCall('SetOrganizationInformation', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultSetOrganizationInformation;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named NewOrganizationInformation
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Creates basic contact information for the organization.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\NewOrganizationInformation $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\NewOrganizationInformationResponse|bool
     */
    public function NewOrganizationInformation(\Drupal\netforum\xWeb\Generated\StructType\NewOrganizationInformation $parameters)
    {
        try {
            $this->setResult($resultNewOrganizationInformation = $this->getSoapClient()->__soapCall('NewOrganizationInformation', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultNewOrganizationInformation;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateInvoice
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Returns the inserted key(s) for the invoice. Parameters: XmlNode or 3DES encrypted string.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\CreateInvoice $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\CreateInvoiceResponse|bool
     */
    public function CreateInvoice(\Drupal\netforum\xWeb\Generated\StructType\CreateInvoice $parameters)
    {
        try {
            $this->setResult($resultCreateInvoice = $this->getSoapClient()->__soapCall('CreateInvoice', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultCreateInvoice;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreatePayment
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Returns the inserted key(s) for the payment. Parameters: XmlNode or 3DES encrypted string.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\CreatePayment $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\CreatePaymentResponse|bool
     */
    public function CreatePayment(\Drupal\netforum\xWeb\Generated\StructType\CreatePayment $parameters)
    {
        try {
            $this->setResult($resultCreatePayment = $this->getSoapClient()->__soapCall('CreatePayment', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultCreatePayment;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateAdvocacyData
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Inserts advocacy data for US Representatives and US Senators. This method can only create content and cannot update content.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\CreateAdvocacyData $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\CreateAdvocacyDataResponse|bool
     */
    public function CreateAdvocacyData(\Drupal\netforum\xWeb\Generated\StructType\CreateAdvocacyData $parameters)
    {
        try {
            $this->setResult($resultCreateAdvocacyData = $this->getSoapClient()->__soapCall('CreateAdvocacyData', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultCreateAdvocacyData;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetActionTypeList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Return a list of available action types.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\GetActionTypeList $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetActionTypeListResponse|bool
     */
    public function GetActionTypeList(\Drupal\netforum\xWeb\Generated\StructType\GetActionTypeList $parameters)
    {
        try {
            $this->setResult($resultGetActionTypeList = $this->getSoapClient()->__soapCall('GetActionTypeList', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultGetActionTypeList;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetActionSubTypeList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Return a list of action sub types for a specified action type.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\GetActionSubTypeList $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetActionSubTypeListResponse|bool
     */
    public function GetActionSubTypeList(\Drupal\netforum\xWeb\Generated\StructType\GetActionSubTypeList $parameters)
    {
        try {
            $this->setResult($resultGetActionSubTypeList = $this->getSoapClient()->__soapCall('GetActionSubTypeList', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultGetActionSubTypeList;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertCustomerAction
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Insert an action record for a customer.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\InsertCustomerAction $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\InsertCustomerActionResponse|bool
     */
    public function InsertCustomerAction(\Drupal\netforum\xWeb\Generated\StructType\InsertCustomerAction $parameters)
    {
        try {
            $this->setResult($resultInsertCustomerAction = $this->getSoapClient()->__soapCall('InsertCustomerAction', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultInsertCustomerAction;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertActionSubType
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Create a new action sub type for a specified action type.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\InsertActionSubType $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\InsertActionSubTypeResponse|bool
     */
    public function InsertActionSubType(\Drupal\netforum\xWeb\Generated\StructType\InsertActionSubType $parameters)
    {
        try {
            $this->setResult($resultInsertActionSubType = $this->getSoapClient()->__soapCall('InsertActionSubType', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultInsertActionSubType;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ElectronicSubscriptionGetCustomerListByIP
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Return a list of cst of the IP.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\ElectronicSubscriptionGetCstListByIP $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\ElectronicSubscriptionGetCstListByIPResponse|bool
     */
    public function ElectronicSubscriptionGetCustomerListByIP(\Drupal\netforum\xWeb\Generated\StructType\ElectronicSubscriptionGetCstListByIP $parameters)
    {
        try {
            $this->setResult($resultElectronicSubscriptionGetCustomerListByIP = $this->getSoapClient()->__soapCall('ElectronicSubscriptionGetCustomerListByIP', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultElectronicSubscriptionGetCustomerListByIP;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ElectronicSubscriptionGetPurchasedSubscriptionsByCustomer
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Return a list of Subscriptions of Customer.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\ElectronicSubscriptionGetPurchasedSubscriptionsByCustomer $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\ElectronicSubscriptionGetPurchasedSubscriptionsByCustomerResponse|bool
     */
    public function ElectronicSubscriptionGetPurchasedSubscriptionsByCustomer(\Drupal\netforum\xWeb\Generated\StructType\ElectronicSubscriptionGetPurchasedSubscriptionsByCustomer $parameters)
    {
        try {
            $this->setResult($resultElectronicSubscriptionGetPurchasedSubscriptionsByCustomer = $this->getSoapClient()->__soapCall('ElectronicSubscriptionGetPurchasedSubscriptionsByCustomer', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultElectronicSubscriptionGetPurchasedSubscriptionsByCustomer;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExecuteMethod
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\ExecuteMethod $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\ExecuteMethodResponse|bool
     */
    public function ExecuteMethod(\Drupal\netforum\xWeb\Generated\StructType\ExecuteMethod $parameters)
    {
        try {
            $this->setResult($resultExecuteMethod = $this->getSoapClient()->__soapCall('ExecuteMethod', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultExecuteMethod;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVersion
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Provides version information about the xWeb application and Database Server and Name.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\GetVersion $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetVersionResponse|bool
     */
    public function GetVersion(\Drupal\netforum\xWeb\Generated\StructType\GetVersion $parameters)
    {
        try {
            $this->setResult($resultGetVersion = $this->getSoapClient()->__soapCall('GetVersion', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultGetVersion;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named TestConnection
     * Meta information extracted from the WSDL
     * - documentation: Tests the applications connection to the database.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\TestConnection $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\TestConnectionResponse|bool
     */
    public function TestConnection(\Drupal\netforum\xWeb\Generated\StructType\TestConnection $parameters)
    {
        try {
            $this->setResult($resultTestConnection = $this->getSoapClient()->__soapCall('TestConnection', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultTestConnection;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTimeZones
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Get a list of all the time zones defined in netFORUM.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\GetTimeZones $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetTimeZonesResponse|bool
     */
    public function GetTimeZones(\Drupal\netforum\xWeb\Generated\StructType\GetTimeZones $parameters)
    {
        try {
            $this->setResult($resultGetTimeZones = $this->getSoapClient()->__soapCall('GetTimeZones', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultGetTimeZones;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named MergeCustomers
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Merges one or more customers in the customersToMerge list with the customer designated by the cst_key_keep parameter. The method returns a MergeCustomersResult containing detailed information about the results of the merger of each
     * customer and module.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\MergeCustomers $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\MergeCustomersResponse|bool
     */
    public function MergeCustomers(\Drupal\netforum\xWeb\Generated\StructType\MergeCustomers $parameters)
    {
        try {
            $this->setResult($resultMergeCustomers = $this->getSoapClient()->__soapCall('MergeCustomers', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultMergeCustomers;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMergeCustomerModules
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Returns a list of Module groups for the merging of customers.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\GetMergeCustomerModules $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\GetMergeCustomerModulesResponse|bool
     */
    public function GetMergeCustomerModules(\Drupal\netforum\xWeb\Generated\StructType\GetMergeCustomerModules $parameters)
    {
        try {
            $this->setResult($resultGetMergeCustomerModules = $this->getSoapClient()->__soapCall('GetMergeCustomerModules', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultGetMergeCustomerModules;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBGetSystemOptions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves WEB integration relevent system options.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBGetSystemOptions $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBGetSystemOptionsResponse|bool
     */
    public function WEBGetSystemOptions(\Drupal\netforum\xWeb\Generated\StructType\WEBGetSystemOptions $parameters)
    {
        try {
            $this->setResult($resultWEBGetSystemOptions = $this->getSoapClient()->__soapCall('WEBGetSystemOptions', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBGetSystemOptions;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBUpdateSystemOption
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Updates a netForum System Option and returns the modified netForum Facade object record. Parameters: szOptionName, szOptionValue. Returns true if successful, false otherwise.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBUpdateSystemOption $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBUpdateSystemOptionResponse|bool
     */
    public function WEBUpdateSystemOption(\Drupal\netforum\xWeb\Generated\StructType\WEBUpdateSystemOption $parameters)
    {
        try {
            $this->setResult($resultWEBUpdateSystemOption = $this->getSoapClient()->__soapCall('WEBUpdateSystemOption', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBUpdateSystemOption;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBGetAllRoles
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves netForum roles.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBGetAllRoles $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBGetAllRolesResponse|bool
     */
    public function WEBGetAllRoles(\Drupal\netforum\xWeb\Generated\StructType\WEBGetAllRoles $parameters)
    {
        try {
            $this->setResult($resultWEBGetAllRoles = $this->getSoapClient()->__soapCall('WEBGetAllRoles', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBGetAllRoles;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBFindUsersInRole
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Matches username to specified role and returns matching usernames.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBFindUsersInRole $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBFindUsersInRoleResponse|bool
     */
    public function WEBFindUsersInRole(\Drupal\netforum\xWeb\Generated\StructType\WEBFindUsersInRole $parameters)
    {
        try {
            $this->setResult($resultWEBFindUsersInRole = $this->getSoapClient()->__soapCall('WEBFindUsersInRole', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBFindUsersInRole;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBGetRolesForUser
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves all roles for specified username.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBGetRolesForUser $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBGetRolesForUserResponse|bool
     */
    public function WEBGetRolesForUser(\Drupal\netforum\xWeb\Generated\StructType\WEBGetRolesForUser $parameters)
    {
        try {
            $this->setResult($resultWEBGetRolesForUser = $this->getSoapClient()->__soapCall('WEBGetRolesForUser', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBGetRolesForUser;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBGetUsersInRole
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves all users in a specified role.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBGetUsersInRole $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBGetUsersInRoleResponse|bool
     */
    public function WEBGetUsersInRole(\Drupal\netforum\xWeb\Generated\StructType\WEBGetUsersInRole $parameters)
    {
        try {
            $this->setResult($resultWEBGetUsersInRole = $this->getSoapClient()->__soapCall('WEBGetUsersInRole', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBGetUsersInRole;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBIsUserInRole
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Returns a boolean indicating if the user is in the specified role.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBIsUserInRole $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBIsUserInRoleResponse|bool
     */
    public function WEBIsUserInRole(\Drupal\netforum\xWeb\Generated\StructType\WEBIsUserInRole $parameters)
    {
        try {
            $this->setResult($resultWEBIsUserInRole = $this->getSoapClient()->__soapCall('WEBIsUserInRole', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBIsUserInRole;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBRoleExists
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Returns a boolean indicating if the specified role exists.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBRoleExists $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBRoleExistsResponse|bool
     */
    public function WEBRoleExists(\Drupal\netforum\xWeb\Generated\StructType\WEBRoleExists $parameters)
    {
        try {
            $this->setResult($resultWEBRoleExists = $this->getSoapClient()->__soapCall('WEBRoleExists', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBRoleExists;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBWebUserChangePassword
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Changes the user password. Returns true if successful, false otherwise.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserChangePassword $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserChangePasswordResponse|bool
     */
    public function WEBWebUserChangePassword(\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserChangePassword $parameters)
    {
        try {
            $this->setResult($resultWEBWebUserChangePassword = $this->getSoapClient()->__soapCall('WEBWebUserChangePassword', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBWebUserChangePassword;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBWebUserCreate
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Creates a web user. if susccessul, returns cst_recno used subsequently as username. if email is used as login id, leave username empty.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserCreate $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserCreateResponse|bool
     */
    public function WEBWebUserCreate(\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserCreate $parameters)
    {
        try {
            $this->setResult($resultWEBWebUserCreate = $this->getSoapClient()->__soapCall('WEBWebUserCreate', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBWebUserCreate;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBWebUserUpdate
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Creates a web user. if susccessul, returns cst_recno used subsequently as username. if email is used as login id, leave username empty.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserUpdate $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserUpdateResponse|bool
     */
    public function WEBWebUserUpdate(\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserUpdate $parameters)
    {
        try {
            $this->setResult($resultWEBWebUserUpdate = $this->getSoapClient()->__soapCall('WEBWebUserUpdate', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBWebUserUpdate;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBWebUserFindUsersByEmail
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Matches username to specified email and returns matching users.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserFindUsersByEmail $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserFindUsersByEmailResponse|bool
     */
    public function WEBWebUserFindUsersByEmail(\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserFindUsersByEmail $parameters)
    {
        try {
            $this->setResult($resultWEBWebUserFindUsersByEmail = $this->getSoapClient()->__soapCall('WEBWebUserFindUsersByEmail', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBWebUserFindUsersByEmail;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBWebUserFindUsersByDomain
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Matches username to domain and returns matching users.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserFindUsersByDomain $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserFindUsersByDomainResponse|bool
     */
    public function WEBWebUserFindUsersByDomain(\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserFindUsersByDomain $parameters)
    {
        try {
            $this->setResult($resultWEBWebUserFindUsersByDomain = $this->getSoapClient()->__soapCall('WEBWebUserFindUsersByDomain', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBWebUserFindUsersByDomain;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBWebUserFindOrganizationsByDomain
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Matches organizations to domain and returns matching organizations.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserFindOrganizationsByDomain $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserFindOrganizationsByDomainResponse|bool
     */
    public function WEBWebUserFindOrganizationsByDomain(\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserFindOrganizationsByDomain $parameters)
    {
        try {
            $this->setResult($resultWEBWebUserFindOrganizationsByDomain = $this->getSoapClient()->__soapCall('WEBWebUserFindOrganizationsByDomain', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBWebUserFindOrganizationsByDomain;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBWebUserFindUsersByName
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: returns web users with a matching userName, firstName or lastName.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserFindUsersByName $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserFindUsersByNameResponse|bool
     */
    public function WEBWebUserFindUsersByName(\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserFindUsersByName $parameters)
    {
        try {
            $this->setResult($resultWEBWebUserFindUsersByName = $this->getSoapClient()->__soapCall('WEBWebUserFindUsersByName', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBWebUserFindUsersByName;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBWebUserFindUsersByUserNameFirstNameLastName
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: returns web users with a matching userName, firstName and lastName.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserFindUsersByUserNameFirstNameLastName $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserFindUsersByUserNameFirstNameLastNameResponse|bool
     */
    public function WEBWebUserFindUsersByUserNameFirstNameLastName(\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserFindUsersByUserNameFirstNameLastName $parameters)
    {
        try {
            $this->setResult($resultWEBWebUserFindUsersByUserNameFirstNameLastName = $this->getSoapClient()->__soapCall('WEBWebUserFindUsersByUserNameFirstNameLastName', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBWebUserFindUsersByUserNameFirstNameLastName;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBWebUserGet
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: returns web user info.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserGet $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserGetResponse|bool
     */
    public function WEBWebUserGet(\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserGet $parameters)
    {
        try {
            $this->setResult($resultWEBWebUserGet = $this->getSoapClient()->__soapCall('WEBWebUserGet', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBWebUserGet;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBWebUserGetByRecno_Custom
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: returns web user info.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserGetByRecno_Custom $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserGetByRecno_CustomResponse|bool
     */
    public function WEBWebUserGetByRecno_Custom(\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserGetByRecno_Custom $parameters)
    {
        try {
            $this->setResult($resultWEBWebUserGetByRecno_Custom = $this->getSoapClient()->__soapCall('WEBWebUserGetByRecno_Custom', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBWebUserGetByRecno_Custom;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBWebUserUnlock
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: unlock the web user. Returns true if successful, false otherwise.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserUnlock $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserUnlockResponse|bool
     */
    public function WEBWebUserUnlock(\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserUnlock $parameters)
    {
        try {
            $this->setResult($resultWEBWebUserUnlock = $this->getSoapClient()->__soapCall('WEBWebUserUnlock', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBWebUserUnlock;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBWebUserLock
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: lock-out the web user. Returns true if successful, false otherwise.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserLock $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserLockResponse|bool
     */
    public function WEBWebUserLock(\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserLock $parameters)
    {
        try {
            $this->setResult($resultWEBWebUserLock = $this->getSoapClient()->__soapCall('WEBWebUserLock', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBWebUserLock;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBWebUserLogin
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: pass login id/email and password to validate the web user. Returns Web User Info if successful.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserLogin $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserLoginResponse|bool
     */
    public function WEBWebUserLogin(\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserLogin $parameters)
    {
        try {
            $this->setResult($resultWEBWebUserLogin = $this->getSoapClient()->__soapCall('WEBWebUserLogin', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBWebUserLogin;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBWebUserLoginAndRememberMe
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: pass login id/email and password to validate the web user and return a remember-me token. Returns Web User Info if successful.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserLoginAndRememberMe $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserLoginAndRememberMeResponse|bool
     */
    public function WEBWebUserLoginAndRememberMe(\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserLoginAndRememberMe $parameters)
    {
        try {
            $this->setResult($resultWEBWebUserLoginAndRememberMe = $this->getSoapClient()->__soapCall('WEBWebUserLoginAndRememberMe', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBWebUserLoginAndRememberMe;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBWebUserLoginByRememberMe
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Provides the Web User info for the authenticated token that is passed as a parameter - this method can be invoked after a successful Login that returns an authentication token. The authentication token is the only parameter for this
     * method.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserLoginByRememberMe $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserLoginByRememberMeResponse|bool
     */
    public function WEBWebUserLoginByRememberMe(\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserLoginByRememberMe $parameters)
    {
        try {
            $this->setResult($resultWEBWebUserLoginByRememberMe = $this->getSoapClient()->__soapCall('WEBWebUserLoginByRememberMe', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBWebUserLoginByRememberMe;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBWebUserValidateLogin
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: pass login id/email and password to validate the web user. Returns Web User info if validated.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserValidateLogin $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserValidateLoginResponse|bool
     */
    public function WEBWebUserValidateLogin(\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserValidateLogin $parameters)
    {
        try {
            $this->setResult($resultWEBWebUserValidateLogin = $this->getSoapClient()->__soapCall('WEBWebUserValidateLogin', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBWebUserValidateLogin;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBWebUserValidateToken
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Provides the Web User info for the authenticated token that is passed as a parameter - this method can be invoked after a successful Login that returns an authentication token. The authentication token is the only parameter for this
     * method.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserValidateToken $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserValidateTokenResponse|bool
     */
    public function WEBWebUserValidateToken(\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserValidateToken $parameters)
    {
        try {
            $this->setResult($resultWEBWebUserValidateToken = $this->getSoapClient()->__soapCall('WEBWebUserValidateToken', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBWebUserValidateToken;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBWebUserLogin_Custom
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: pass login id/email and password to validate the web user. Returns cst_recno/username if successful.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserLogin_Custom $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserLogin_CustomResponse|bool
     */
    public function WEBWebUserLogin_Custom(\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserLogin_Custom $parameters)
    {
        try {
            $this->setResult($resultWEBWebUserLogin_Custom = $this->getSoapClient()->__soapCall('WEBWebUserLogin_Custom', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBWebUserLogin_Custom;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBWebUserLoginByRecno_Custom
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: pass login id/email and password to validate the web user. Returns cst_recno/username if successful.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserLoginByRecno_Custom $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserLoginByRecno_CustomResponse|bool
     */
    public function WEBWebUserLoginByRecno_Custom(\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserLoginByRecno_Custom $parameters)
    {
        try {
            $this->setResult($resultWEBWebUserLoginByRecno_Custom = $this->getSoapClient()->__soapCall('WEBWebUserLoginByRecno_Custom', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBWebUserLoginByRecno_Custom;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBWebUserValidateLogin_Custom
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: pass login id/email and password to validate the web user. Returns cst_recno/username if validated.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserValidateLogin_Custom $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserValidateLogin_CustomResponse|bool
     */
    public function WEBWebUserValidateLogin_Custom(\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserValidateLogin_Custom $parameters)
    {
        try {
            $this->setResult($resultWEBWebUserValidateLogin_Custom = $this->getSoapClient()->__soapCall('WEBWebUserValidateLogin_Custom', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBWebUserValidateLogin_Custom;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBWebUserValidateToken_Custom
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Provides the cst_recno for the authenticated token that is passed as a parameter - this method can be invoked after a successful Login that returns an authentication token. The authentication token is the only parameter for this
     * method.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserValidateToken_Custom $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBWebUserValidateToken_CustomResponse|bool
     */
    public function WEBWebUserValidateToken_Custom(\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserValidateToken_Custom $parameters)
    {
        try {
            $this->setResult($resultWEBWebUserValidateToken_Custom = $this->getSoapClient()->__soapCall('WEBWebUserValidateToken_Custom', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBWebUserValidateToken_Custom;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBIndividualGet
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Gets an individual's Info.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBIndividualGet $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBIndividualGetResponse|bool
     */
    public function WEBIndividualGet(\Drupal\netforum\xWeb\Generated\StructType\WEBIndividualGet $parameters)
    {
        try {
            $this->setResult($resultWEBIndividualGet = $this->getSoapClient()->__soapCall('WEBIndividualGet', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBIndividualGet;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBIndividualUpdate
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Updates an individual's infor.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBIndividualUpdate $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBIndividualUpdateResponse|bool
     */
    public function WEBIndividualUpdate(\Drupal\netforum\xWeb\Generated\StructType\WEBIndividualUpdate $parameters)
    {
        try {
            $this->setResult($resultWEBIndividualUpdate = $this->getSoapClient()->__soapCall('WEBIndividualUpdate', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBIndividualUpdate;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBIndividualInsert
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Inserts a new individual.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBIndividualInsert $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBIndividualInsertResponse|bool
     */
    public function WEBIndividualInsert(\Drupal\netforum\xWeb\Generated\StructType\WEBIndividualInsert $parameters)
    {
        try {
            $this->setResult($resultWEBIndividualInsert = $this->getSoapClient()->__soapCall('WEBIndividualInsert', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBIndividualInsert;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBIndividualGetGenders
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves a list of available gender values. A gender code can be assigned to ind_gender when inserting/updating an individual.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBIndividualGetGenders $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBIndividualGetGendersResponse|bool
     */
    public function WEBIndividualGetGenders(\Drupal\netforum\xWeb\Generated\StructType\WEBIndividualGetGenders $parameters)
    {
        try {
            $this->setResult($resultWEBIndividualGetGenders = $this->getSoapClient()->__soapCall('WEBIndividualGetGenders', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBIndividualGetGenders;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBIndividualGetPrefixes
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves a list of individual prefixes. A prefix code can be assigned to ind_prf_code when inserting/updating an individual.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBIndividualGetPrefixes $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBIndividualGetPrefixesResponse|bool
     */
    public function WEBIndividualGetPrefixes(\Drupal\netforum\xWeb\Generated\StructType\WEBIndividualGetPrefixes $parameters)
    {
        try {
            $this->setResult($resultWEBIndividualGetPrefixes = $this->getSoapClient()->__soapCall('WEBIndividualGetPrefixes', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBIndividualGetPrefixes;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBIndividualGetPronouns
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves a list of available Pronoun values. A pronoun code can be assigned to ind_prn_code when inserting/updating an individual.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBIndividualGetPronouns $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBIndividualGetPronounsResponse|bool
     */
    public function WEBIndividualGetPronouns(\Drupal\netforum\xWeb\Generated\StructType\WEBIndividualGetPronouns $parameters)
    {
        try {
            $this->setResult($resultWEBIndividualGetPronouns = $this->getSoapClient()->__soapCall('WEBIndividualGetPronouns', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBIndividualGetPronouns;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBIndividualGetSuffixes
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves a list of individual suffixes. A suffix code can be assigned to ind_sfx_code when inserting/updating an individual.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBIndividualGetSuffixes $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBIndividualGetSuffixesResponse|bool
     */
    public function WEBIndividualGetSuffixes(\Drupal\netforum\xWeb\Generated\StructType\WEBIndividualGetSuffixes $parameters)
    {
        try {
            $this->setResult($resultWEBIndividualGetSuffixes = $this->getSoapClient()->__soapCall('WEBIndividualGetSuffixes', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBIndividualGetSuffixes;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBAddressGetTypes
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves a list of address types. An address type key can be assigned to cxa_adt_key when inserting/updating an address.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBAddressGetTypes $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBAddressGetTypesResponse|bool
     */
    public function WEBAddressGetTypes(\Drupal\netforum\xWeb\Generated\StructType\WEBAddressGetTypes $parameters)
    {
        try {
            $this->setResult($resultWEBAddressGetTypes = $this->getSoapClient()->__soapCall('WEBAddressGetTypes', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBAddressGetTypes;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBAddressGetCountries
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves a list of countries. A country code can be assigned to adr_country when inserting/updating an address.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBAddressGetCountries $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBAddressGetCountriesResponse|bool
     */
    public function WEBAddressGetCountries(\Drupal\netforum\xWeb\Generated\StructType\WEBAddressGetCountries $parameters)
    {
        try {
            $this->setResult($resultWEBAddressGetCountries = $this->getSoapClient()->__soapCall('WEBAddressGetCountries', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBAddressGetCountries;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBAddressGetStates
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves a list of states. A state code can be assigned to adr_state when inserting/updating an address.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBAddressGetStates $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBAddressGetStatesResponse|bool
     */
    public function WEBAddressGetStates(\Drupal\netforum\xWeb\Generated\StructType\WEBAddressGetStates $parameters)
    {
        try {
            $this->setResult($resultWEBAddressGetStates = $this->getSoapClient()->__soapCall('WEBAddressGetStates', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBAddressGetStates;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBAddressGet
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Gets a customer's address info.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBAddressGet $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBAddressGetResponse|bool
     */
    public function WEBAddressGet(\Drupal\netforum\xWeb\Generated\StructType\WEBAddressGet $parameters)
    {
        try {
            $this->setResult($resultWEBAddressGet = $this->getSoapClient()->__soapCall('WEBAddressGet', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBAddressGet;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBAddressUpdate
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Updates a customer's address info.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBAddressUpdate $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBAddressUpdateResponse|bool
     */
    public function WEBAddressUpdate(\Drupal\netforum\xWeb\Generated\StructType\WEBAddressUpdate $parameters)
    {
        try {
            $this->setResult($resultWEBAddressUpdate = $this->getSoapClient()->__soapCall('WEBAddressUpdate', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBAddressUpdate;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBAddressInsert
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Inserts a new customer address.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBAddressInsert $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBAddressInsertResponse|bool
     */
    public function WEBAddressInsert(\Drupal\netforum\xWeb\Generated\StructType\WEBAddressInsert $parameters)
    {
        try {
            $this->setResult($resultWEBAddressInsert = $this->getSoapClient()->__soapCall('WEBAddressInsert', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBAddressInsert;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBAddressGetAddressesByCustomer
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves list of addresses for specified customer.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBAddressGetAddressesByCustomer $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBAddressGetAddressesByCustomerResponse|bool
     */
    public function WEBAddressGetAddressesByCustomer(\Drupal\netforum\xWeb\Generated\StructType\WEBAddressGetAddressesByCustomer $parameters)
    {
        try {
            $this->setResult($resultWEBAddressGetAddressesByCustomer = $this->getSoapClient()->__soapCall('WEBAddressGetAddressesByCustomer', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBAddressGetAddressesByCustomer;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBPhoneGetTypes
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves a list of phone types. A phone type key can be assigned to cph_pht_key when inserting/updating a phone number.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBPhoneGetTypes $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBPhoneGetTypesResponse|bool
     */
    public function WEBPhoneGetTypes(\Drupal\netforum\xWeb\Generated\StructType\WEBPhoneGetTypes $parameters)
    {
        try {
            $this->setResult($resultWEBPhoneGetTypes = $this->getSoapClient()->__soapCall('WEBPhoneGetTypes', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBPhoneGetTypes;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBPhoneGet
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Gets a customer's phone info.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBPhoneGet $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBPhoneGetResponse|bool
     */
    public function WEBPhoneGet(\Drupal\netforum\xWeb\Generated\StructType\WEBPhoneGet $parameters)
    {
        try {
            $this->setResult($resultWEBPhoneGet = $this->getSoapClient()->__soapCall('WEBPhoneGet', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBPhoneGet;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBPhoneUpdate
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Updates a customer's fax info.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBPhoneUpdate $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBPhoneUpdateResponse|bool
     */
    public function WEBPhoneUpdate(\Drupal\netforum\xWeb\Generated\StructType\WEBPhoneUpdate $parameters)
    {
        try {
            $this->setResult($resultWEBPhoneUpdate = $this->getSoapClient()->__soapCall('WEBPhoneUpdate', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBPhoneUpdate;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBPhoneInsert
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Inserts a new customer phone.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBPhoneInsert $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBPhoneInsertResponse|bool
     */
    public function WEBPhoneInsert(\Drupal\netforum\xWeb\Generated\StructType\WEBPhoneInsert $parameters)
    {
        try {
            $this->setResult($resultWEBPhoneInsert = $this->getSoapClient()->__soapCall('WEBPhoneInsert', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBPhoneInsert;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBPhoneGetPhonesByCustomer
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves list of phone numbers for specified customer.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBPhoneGetPhonesByCustomer $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBPhoneGetPhonesByCustomerResponse|bool
     */
    public function WEBPhoneGetPhonesByCustomer(\Drupal\netforum\xWeb\Generated\StructType\WEBPhoneGetPhonesByCustomer $parameters)
    {
        try {
            $this->setResult($resultWEBPhoneGetPhonesByCustomer = $this->getSoapClient()->__soapCall('WEBPhoneGetPhonesByCustomer', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBPhoneGetPhonesByCustomer;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBFaxGetTypes
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves a list of fax types. A fax type key can be assigned to cfx_fxt_key when inserting/updating a fax number.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBFaxGetTypes $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBFaxGetTypesResponse|bool
     */
    public function WEBFaxGetTypes(\Drupal\netforum\xWeb\Generated\StructType\WEBFaxGetTypes $parameters)
    {
        try {
            $this->setResult($resultWEBFaxGetTypes = $this->getSoapClient()->__soapCall('WEBFaxGetTypes', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBFaxGetTypes;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBFaxGet
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Gets a customer's fax info.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBFaxGet $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBFaxGetResponse|bool
     */
    public function WEBFaxGet(\Drupal\netforum\xWeb\Generated\StructType\WEBFaxGet $parameters)
    {
        try {
            $this->setResult($resultWEBFaxGet = $this->getSoapClient()->__soapCall('WEBFaxGet', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBFaxGet;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBFaxUpdate
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Updates a customer's fax info.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBFaxUpdate $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBFaxUpdateResponse|bool
     */
    public function WEBFaxUpdate(\Drupal\netforum\xWeb\Generated\StructType\WEBFaxUpdate $parameters)
    {
        try {
            $this->setResult($resultWEBFaxUpdate = $this->getSoapClient()->__soapCall('WEBFaxUpdate', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBFaxUpdate;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBFaxInsert
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Inserts a new customer fax.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBFaxInsert $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBFaxInsertResponse|bool
     */
    public function WEBFaxInsert(\Drupal\netforum\xWeb\Generated\StructType\WEBFaxInsert $parameters)
    {
        try {
            $this->setResult($resultWEBFaxInsert = $this->getSoapClient()->__soapCall('WEBFaxInsert', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBFaxInsert;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBFaxGetFaxesByCustomer
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves list of faxes for specified customer.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBFaxGetFaxesByCustomer $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBFaxGetFaxesByCustomerResponse|bool
     */
    public function WEBFaxGetFaxesByCustomer(\Drupal\netforum\xWeb\Generated\StructType\WEBFaxGetFaxesByCustomer $parameters)
    {
        try {
            $this->setResult($resultWEBFaxGetFaxesByCustomer = $this->getSoapClient()->__soapCall('WEBFaxGetFaxesByCustomer', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBFaxGetFaxesByCustomer;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBEmailGet
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Gets a customer's email info.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBEmailGet $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBEmailGetResponse|bool
     */
    public function WEBEmailGet(\Drupal\netforum\xWeb\Generated\StructType\WEBEmailGet $parameters)
    {
        try {
            $this->setResult($resultWEBEmailGet = $this->getSoapClient()->__soapCall('WEBEmailGet', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBEmailGet;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBEmailUpdate
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Updates a customer's email info.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBEmailUpdate $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBEmailUpdateResponse|bool
     */
    public function WEBEmailUpdate(\Drupal\netforum\xWeb\Generated\StructType\WEBEmailUpdate $parameters)
    {
        try {
            $this->setResult($resultWEBEmailUpdate = $this->getSoapClient()->__soapCall('WEBEmailUpdate', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBEmailUpdate;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBEmailInsert
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Inserts a new customer email.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBEmailInsert $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBEmailInsertResponse|bool
     */
    public function WEBEmailInsert(\Drupal\netforum\xWeb\Generated\StructType\WEBEmailInsert $parameters)
    {
        try {
            $this->setResult($resultWEBEmailInsert = $this->getSoapClient()->__soapCall('WEBEmailInsert', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBEmailInsert;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBEmailGetEmailsByCustomer
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves list of emails for specified customer.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBEmailGetEmailsByCustomer $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBEmailGetEmailsByCustomerResponse|bool
     */
    public function WEBEmailGetEmailsByCustomer(\Drupal\netforum\xWeb\Generated\StructType\WEBEmailGetEmailsByCustomer $parameters)
    {
        try {
            $this->setResult($resultWEBEmailGetEmailsByCustomer = $this->getSoapClient()->__soapCall('WEBEmailGetEmailsByCustomer', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBEmailGetEmailsByCustomer;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBOrganizationGetTypes
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves a list of organization types. The organization type code can be assigned to org_ogt_code when inserting/updating an organization.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBOrganizationGetTypes $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBOrganizationGetTypesResponse|bool
     */
    public function WEBOrganizationGetTypes(\Drupal\netforum\xWeb\Generated\StructType\WEBOrganizationGetTypes $parameters)
    {
        try {
            $this->setResult($resultWEBOrganizationGetTypes = $this->getSoapClient()->__soapCall('WEBOrganizationGetTypes', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBOrganizationGetTypes;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBOrganizationGet
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Gets an individual's Organization Info.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBOrganizationGet $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBOrganizationGetResponse|bool
     */
    public function WEBOrganizationGet(\Drupal\netforum\xWeb\Generated\StructType\WEBOrganizationGet $parameters)
    {
        try {
            $this->setResult($resultWEBOrganizationGet = $this->getSoapClient()->__soapCall('WEBOrganizationGet', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBOrganizationGet;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBOrganizationUpdate
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Updates an individual's Organization info.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBOrganizationUpdate $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBOrganizationUpdateResponse|bool
     */
    public function WEBOrganizationUpdate(\Drupal\netforum\xWeb\Generated\StructType\WEBOrganizationUpdate $parameters)
    {
        try {
            $this->setResult($resultWEBOrganizationUpdate = $this->getSoapClient()->__soapCall('WEBOrganizationUpdate', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBOrganizationUpdate;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBOrganizationInsert
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Inserts a new organization.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBOrganizationInsert $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBOrganizationInsertResponse|bool
     */
    public function WEBOrganizationInsert(\Drupal\netforum\xWeb\Generated\StructType\WEBOrganizationInsert $parameters)
    {
        try {
            $this->setResult($resultWEBOrganizationInsert = $this->getSoapClient()->__soapCall('WEBOrganizationInsert', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBOrganizationInsert;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBContactRequestInsert
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Creates a new contact request.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBContactRequestInsert $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBContactRequestInsertResponse|bool
     */
    public function WEBContactRequestInsert(\Drupal\netforum\xWeb\Generated\StructType\WEBContactRequestInsert $parameters)
    {
        try {
            $this->setResult($resultWEBContactRequestInsert = $this->getSoapClient()->__soapCall('WEBContactRequestInsert', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBContactRequestInsert;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBContactRequestGetOriginations
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves a list of contact request originations.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBContactRequestGetOriginations $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBContactRequestGetOriginationsResponse|bool
     */
    public function WEBContactRequestGetOriginations(\Drupal\netforum\xWeb\Generated\StructType\WEBContactRequestGetOriginations $parameters)
    {
        try {
            $this->setResult($resultWEBContactRequestGetOriginations = $this->getSoapClient()->__soapCall('WEBContactRequestGetOriginations', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBContactRequestGetOriginations;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBContactRequestGetPriorities
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves a list of contact request priorities.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBContactRequestGetPriorities $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBContactRequestGetPrioritiesResponse|bool
     */
    public function WEBContactRequestGetPriorities(\Drupal\netforum\xWeb\Generated\StructType\WEBContactRequestGetPriorities $parameters)
    {
        try {
            $this->setResult($resultWEBContactRequestGetPriorities = $this->getSoapClient()->__soapCall('WEBContactRequestGetPriorities', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBContactRequestGetPriorities;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBContactRequestGetRequestTypes
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves a list of contact request types.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBContactRequestGetRequestTypes $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBContactRequestGetRequestTypesResponse|bool
     */
    public function WEBContactRequestGetRequestTypes(\Drupal\netforum\xWeb\Generated\StructType\WEBContactRequestGetRequestTypes $parameters)
    {
        try {
            $this->setResult($resultWEBContactRequestGetRequestTypes = $this->getSoapClient()->__soapCall('WEBContactRequestGetRequestTypes', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBContactRequestGetRequestTypes;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBContactRequestGetRequestTypeReasons
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves a list of contact request reasons for all types.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBContactRequestGetRequestTypeReasons $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBContactRequestGetRequestTypeReasonsResponse|bool
     */
    public function WEBContactRequestGetRequestTypeReasons(\Drupal\netforum\xWeb\Generated\StructType\WEBContactRequestGetRequestTypeReasons $parameters)
    {
        try {
            $this->setResult($resultWEBContactRequestGetRequestTypeReasons = $this->getSoapClient()->__soapCall('WEBContactRequestGetRequestTypeReasons', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBContactRequestGetRequestTypeReasons;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBContactRequestGetStatuses
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves a list of contact request statuses.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBContactRequestGetStatuses $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBContactRequestGetStatusesResponse|bool
     */
    public function WEBContactRequestGetStatuses(\Drupal\netforum\xWeb\Generated\StructType\WEBContactRequestGetStatuses $parameters)
    {
        try {
            $this->setResult($resultWEBContactRequestGetStatuses = $this->getSoapClient()->__soapCall('WEBContactRequestGetStatuses', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBContactRequestGetStatuses;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBActivityGetPurchasedProductsByCustomer
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves list of purchased products by customer.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBActivityGetPurchasedProductsByCustomer $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBActivityGetPurchasedProductsByCustomerResponse|bool
     */
    public function WEBActivityGetPurchasedProductsByCustomer(\Drupal\netforum\xWeb\Generated\StructType\WEBActivityGetPurchasedProductsByCustomer $parameters)
    {
        try {
            $this->setResult($resultWEBActivityGetPurchasedProductsByCustomer = $this->getSoapClient()->__soapCall('WEBActivityGetPurchasedProductsByCustomer', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBActivityGetPurchasedProductsByCustomer;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBActivityGetPurchasedEventsByCustomer
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves list of purchased events by customer.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBActivityGetPurchasedEventsByCustomer $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBActivityGetPurchasedEventsByCustomerResponse|bool
     */
    public function WEBActivityGetPurchasedEventsByCustomer(\Drupal\netforum\xWeb\Generated\StructType\WEBActivityGetPurchasedEventsByCustomer $parameters)
    {
        try {
            $this->setResult($resultWEBActivityGetPurchasedEventsByCustomer = $this->getSoapClient()->__soapCall('WEBActivityGetPurchasedEventsByCustomer', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBActivityGetPurchasedEventsByCustomer;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBActivityAlreadyRegisteredForEvent
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Returns TRUE if the customer is already registered for the event..
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBActivityAlreadyRegisteredForEvent $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBActivityAlreadyRegisteredForEventResponse|bool
     */
    public function WEBActivityAlreadyRegisteredForEvent(\Drupal\netforum\xWeb\Generated\StructType\WEBActivityAlreadyRegisteredForEvent $parameters)
    {
        try {
            $this->setResult($resultWEBActivityAlreadyRegisteredForEvent = $this->getSoapClient()->__soapCall('WEBActivityAlreadyRegisteredForEvent', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBActivityAlreadyRegisteredForEvent;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBActivityNumberOfRegisteredGuests
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Returns the number of guests attached to a particular registration.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBActivityNumberOfRegisteredGuests $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBActivityNumberOfRegisteredGuestsResponse|bool
     */
    public function WEBActivityNumberOfRegisteredGuests(\Drupal\netforum\xWeb\Generated\StructType\WEBActivityNumberOfRegisteredGuests $parameters)
    {
        try {
            $this->setResult($resultWEBActivityNumberOfRegisteredGuests = $this->getSoapClient()->__soapCall('WEBActivityNumberOfRegisteredGuests', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBActivityNumberOfRegisteredGuests;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBActivityGetPurchasedMembershipsByCustomer
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves list of purchased memberships by customer.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBActivityGetPurchasedMembershipsByCustomer $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBActivityGetPurchasedMembershipsByCustomerResponse|bool
     */
    public function WEBActivityGetPurchasedMembershipsByCustomer(\Drupal\netforum\xWeb\Generated\StructType\WEBActivityGetPurchasedMembershipsByCustomer $parameters)
    {
        try {
            $this->setResult($resultWEBActivityGetPurchasedMembershipsByCustomer = $this->getSoapClient()->__soapCall('WEBActivityGetPurchasedMembershipsByCustomer', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBActivityGetPurchasedMembershipsByCustomer;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBActivityGetPurchasedChapterMembershipsByCustomer
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves list of purchased chapter memberships by customer.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBActivityGetPurchasedChapterMembershipsByCustomer $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBActivityGetPurchasedChapterMembershipsByCustomerResponse|bool
     */
    public function WEBActivityGetPurchasedChapterMembershipsByCustomer(\Drupal\netforum\xWeb\Generated\StructType\WEBActivityGetPurchasedChapterMembershipsByCustomer $parameters)
    {
        try {
            $this->setResult($resultWEBActivityGetPurchasedChapterMembershipsByCustomer = $this->getSoapClient()->__soapCall('WEBActivityGetPurchasedChapterMembershipsByCustomer', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBActivityGetPurchasedChapterMembershipsByCustomer;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * WEBActivityGetPurchasedDownoadableProductsByCustomer
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves list of downloadable purchased products by customer.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBActivityGetPurchasedDownoadableProductsByCustomer $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBActivityGetPurchasedDownoadableProductsByCustomerResponse|bool
     */
    public function WEBActivityGetPurchasedDownoadableProductsByCustomer(\Drupal\netforum\xWeb\Generated\StructType\WEBActivityGetPurchasedDownoadableProductsByCustomer $parameters)
    {
        try {
            $this->setResult($resultWEBActivityGetPurchasedDownoadableProductsByCustomer = $this->getSoapClient()->__soapCall('WEBActivityGetPurchasedDownoadableProductsByCustomer', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBActivityGetPurchasedDownoadableProductsByCustomer;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBActivityGetRegistrantEvents
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Registrant Events.
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBActivityGetRegistrantEvents $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBActivityGetRegistrantEventsResponse|bool
     */
    public function WEBActivityGetRegistrantEvents(\Drupal\netforum\xWeb\Generated\StructType\WEBActivityGetRegistrantEvents $parameters)
    {
        try {
            $this->setResult($resultWEBActivityGetRegistrantEvents = $this->getSoapClient()->__soapCall('WEBActivityGetRegistrantEvents', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBActivityGetRegistrantEvents;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Method to call the operation originally named WEBActivityGetRegistrantSessions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthorizationToken
     * - SOAPHeaderNamespaces: http://www.avectra.com/2005/
     * - SOAPHeaderTypes: \Drupal\netforum\xWeb\Generated\StructType\AuthorizationToken
     * - SOAPHeaders: required
     * - documentation: Retrieves Registrant Sessions
     * @uses SoapClientBase::getSoapClient()
     * @uses SoapClientBase::setResult()
     * @uses SoapClientBase::saveLastError()
     * @param \Drupal\netforum\xWeb\Generated\StructType\WEBActivityGetRegistrantSessions $parameters
     * @return \Drupal\netforum\xWeb\Generated\StructType\WEBActivityGetRegistrantSessionsResponse|bool
     */
    public function WEBActivityGetRegistrantSessions(\Drupal\netforum\xWeb\Generated\StructType\WEBActivityGetRegistrantSessions $parameters)
    {
        try {
            $this->setResult($resultWEBActivityGetRegistrantSessions = $this->getSoapClient()->__soapCall('WEBActivityGetRegistrantSessions', [
                $parameters,
            ], [], [], $this->outputHeaders));
        
            return $resultWEBActivityGetRegistrantSessions;
        } catch (SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
        
            return false;
        }
    }
    /**
     * Returns the result
     * @see SoapClientBase::getResult()
     * @return \Drupal\netforum\xWeb\Generated\StructType\AuthenticateLdapResponse|\Drupal\netforum\xWeb\Generated\StructType\AuthenticateResponse|\Drupal\netforum\xWeb\Generated\StructType\AuthorizeOutlookResponse|\Drupal\netforum\xWeb\Generated\StructType\CeuApplyExternalCreditsResponse|\Drupal\netforum\xWeb\Generated\StructType\CreateAdvocacyDataResponse|\Drupal\netforum\xWeb\Generated\StructType\CreateInvoiceResponse|\Drupal\netforum\xWeb\Generated\StructType\CreatePaymentResponse|\Drupal\netforum\xWeb\Generated\StructType\ElectronicSubscriptionGetCstListByIPResponse|\Drupal\netforum\xWeb\Generated\StructType\ElectronicSubscriptionGetPurchasedSubscriptionsByCustomerResponse|\Drupal\netforum\xWeb\Generated\StructType\ExecuteMethodResponse|\Drupal\netforum\xWeb\Generated\StructType\GetActionSubTypeListResponse|\Drupal\netforum\xWeb\Generated\StructType\GetActionTypeListResponse|\Drupal\netforum\xWeb\Generated\StructType\GetAllCustomerCommunicationPreferencesResponse|\Drupal\netforum\xWeb\Generated\StructType\GetAudienceDefinitionResponse|\Drupal\netforum\xWeb\Generated\StructType\GetAudienceListResponse|\Drupal\netforum\xWeb\Generated\StructType\GetAudienceResponse|\Drupal\netforum\xWeb\Generated\StructType\GetCustomerCommunicationPreferenceResponse|\Drupal\netforum\xWeb\Generated\StructType\GetDateTimeResponse|\Drupal\netforum\xWeb\Generated\StructType\GetDynamicQueryDefinitionResponse|\Drupal\netforum\xWeb\Generated\StructType\GetDynamicQueryResponse|\Drupal\netforum\xWeb\Generated\StructType\GetFacadeObjectListResponse|\Drupal\netforum\xWeb\Generated\StructType\GetFacadeObjectResponse|\Drupal\netforum\xWeb\Generated\StructType\GetFacadeXMLSchemaResponse|\Drupal\netforum\xWeb\Generated\StructType\GetFundraisingEventDonationsResponse|\Drupal\netforum\xWeb\Generated\StructType\GetFundraisingEventDonationUrlResponse|\Drupal\netforum\xWeb\Generated\StructType\GetFundraisingEventRegistrantionTotalResponse|\Drupal\netforum\xWeb\Generated\StructType\GetIndividualInformationResponse|\Drupal\netforum\xWeb\Generated\StructType\GetMergeCustomerModulesResponse|\Drupal\netforum\xWeb\Generated\StructType\GetOrganizationInformationResponse|\Drupal\netforum\xWeb\Generated\StructType\GetPromotionalMailingTypesResponse|\Drupal\netforum\xWeb\Generated\StructType\GetQueryDefinitionResponse|\Drupal\netforum\xWeb\Generated\StructType\GetQueryResponse|\Drupal\netforum\xWeb\Generated\StructType\GetSubscriptionMailingTypesResponse|\Drupal\netforum\xWeb\Generated\StructType\GetTimeZonesResponse|\Drupal\netforum\xWeb\Generated\StructType\GetVersionResponse|\Drupal\netforum\xWeb\Generated\StructType\InsertActionSubTypeResponse|\Drupal\netforum\xWeb\Generated\StructType\InsertCustomerActionResponse|\Drupal\netforum\xWeb\Generated\StructType\InsertFacadeObjectResponse|\Drupal\netforum\xWeb\Generated\StructType\MergeCustomersResponse|\Drupal\netforum\xWeb\Generated\StructType\MetaDataGetFormControlForFacadeObjectResponse|\Drupal\netforum\xWeb\Generated\StructType\MetaDataGetFormForFacadeObjectResponse|\Drupal\netforum\xWeb\Generated\StructType\MetaDataGetFormForIndividualResponse|\Drupal\netforum\xWeb\Generated\StructType\MetaDataGetFormResponse|\Drupal\netforum\xWeb\Generated\StructType\MetaDataGetWizardFormResponse|\Drupal\netforum\xWeb\Generated\StructType\MetaDataGetWizardResponse|\Drupal\netforum\xWeb\Generated\StructType\NewIndividualInformationResponse|\Drupal\netforum\xWeb\Generated\StructType\NewOrganizationInformationResponse|\Drupal\netforum\xWeb\Generated\StructType\RenewMembershipResponse|\Drupal\netforum\xWeb\Generated\StructType\SetCustomerCommunicationPreferencesResponse|\Drupal\netforum\xWeb\Generated\StructType\SetIndividualInformationResponse|\Drupal\netforum\xWeb\Generated\StructType\SetOrganizationInformationResponse|\Drupal\netforum\xWeb\Generated\StructType\TestConnectionResponse|\Drupal\netforum\xWeb\Generated\StructType\UpdateFacadeObjectResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBActivityAlreadyRegisteredForEventResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBActivityGetPurchasedChapterMembershipsByCustomerResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBActivityGetPurchasedDownoadableProductsByCustomerResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBActivityGetPurchasedEventsByCustomerResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBActivityGetPurchasedMembershipsByCustomerResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBActivityGetPurchasedProductsByCustomerResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBActivityGetRegistrantEventsResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBActivityGetRegistrantGuestsResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBActivityGetRegistrantSessionsResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBActivityGetRegistrantTracksResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBActivityNumberOfRegisteredGuestsResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBAddressGetAddressesByCustomerResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBAddressGetCountriesResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBAddressGetResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBAddressGetStatesResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBAddressGetTypesResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBAddressInsertResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBAddressUpdateResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartAccreditationAddAccreditationResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartAccreditationGetNewResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartAccreditationGetResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartAccreditationSetLineItemsResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartAddEventRegistrantGroupResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartAddEventRegistrantResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartAddEventRegistrantToGroupResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartAddLineItemResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartAddShippingItemResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartApplyDiscountCodeResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartApplySourceCodeResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartClearSourceCodeResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantGetNewResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantGetResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantGroupGetNewResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantGroupGetResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantGroupRefreshResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantRefreshResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantSetLineItemsResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantSetLineItemsWithCartResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartEventRegistrantSetLineItemsWithGroupRegistrationResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartExhibitorAddExhibitorResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartExhibitorGetBoothCategoryListResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartExhibitorGetBoothTypeListResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartExhibitorGetExhibitListResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartExhibitorGetNewResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartExhibitorGetResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartExhibitorSetLineItemsResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartExhibitorSetLineItemsWithCartResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetAccreditationFeeListResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetAccreditationListByCustomerResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetAccreditationListResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetAccreditationTypeListResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetAccreditationTypeStatusListResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetBoothListResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventByKeyResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventFeesResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventGuestRegistrantTypeListByEventResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventListByNameResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventListKeysResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventListResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventRegistrantGroupIndividualListResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventRegistrantRoomTypeListResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventRegistrantSourceCodeListResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventRegistrantTypeListByEventResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventRegistrantTypeListResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventSessionFeesResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetEventTrackFeesResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetFacultyListByEventKeyResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetFacultyListBySessionKeyResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetInstallmentFrequencyOptionsResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetInstallmentTermsOptionsResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetMerchandiseListResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetMerchandiseList_Ignore_PCResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetNewResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetPaymentOptionsResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetPendingOrderResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductByKeyResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductCategoryListResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductComplementListByProductKeyResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductComplementsResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductLineItemResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductLineItemWithCartResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductListAlsoPurchasedByProductKeyResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductListByNameResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductListKeysResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductListResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductSubstituteListByProductKeyResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductSubstitutesResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetProductTypeListResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetPublicationList_Ignore_PCResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetSessionListByEventKeyResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetSessionListByTrackKeyResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetShippingOptionsResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetSponsorListByEventKeyResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetSponsorListBySessionKeyResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetSubscriptionList_Ignore_PCResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetTrackListByEventKeyResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGetWithLineItemResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftAddGiftFundraisingResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftFundraisingGetNewResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftFundraisingGetResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftFundraisingRefreshResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftFundraisingSetLineItemsResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftFundraisingSetLineItemsWithCartResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftGetGiftProductByKeyResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftGetGiftProductListByNameResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftGetGiftProductListKeysResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftGetGiftProductListResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftGetGiftTypeListResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftGetPremiumProductsListByGiftResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartGiftRemoveFundraisingGiftResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartInsertResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartLoadLineItemResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMebmershipRemoveMembershipResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipAddMembershipResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetMembershipTypeListResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetNewResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetPackageByKeyResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetPackageComponentListFromObjectResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetPackageComponentListResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetPackageListByMembershipTypeKeyResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetPackageListByNameResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetPackageListKeysResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetPackageListResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetRenewalPackageListResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipGetResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipOpenInvoiceAddResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipOpenInvoiceGetListResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipOpenInvoiceGetResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipRefreshResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembershipSetLineItemsWithCartResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartMembesrhipSetLineItemsResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartOpenInvoiceAddResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartOpenInvoiceGetListResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartOpenInvoiceGetResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartRefreshResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartRemoveAllLineItemsResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartRemoveEventRegistrantFromGroupResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartRemoveEventRegistrantGroupResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartRemoveEventRegistrantResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartRemoveLineItemResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCentralizedShoppingCartStoreForeWebResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBChapterGetResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBChaptersGetChapterByKeyResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBChaptersGetChapterListByNameResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBChaptersGetChapterListResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBChaptersGetChapterMembershipRosterResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBChaptersGetChapterOfficersResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBColumnGetColumnValuesByColumnNameResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeGetCommitteeByKeyResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeGetCommitteeListByNameResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeGetCommitteeListResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeGetCommitteesByCustomerResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeGetDocumentsResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeGetMembersResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeGetPositionListResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeGetResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeGetSubCommitteeListByCommitteeResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBCommitteeNominationInsertResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBContactRequestGetOriginationsResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBContactRequestGetPrioritiesResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBContactRequestGetRequestTypeReasonsResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBContactRequestGetRequestTypesResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBContactRequestGetStatusesResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBContactRequestInsertResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBEmailGetEmailsByCustomerResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBEmailGetResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBEmailInsertResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBEmailUpdateResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBFaxGetFaxesByCustomerResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBFaxGetResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBFaxGetTypesResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBFaxInsertResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBFaxUpdateResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBFindUsersInRoleResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBGetAllRolesResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBGetRolesForUserResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBGetSystemOptionsResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBGetUsersInRoleResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBIndividualGetGendersResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBIndividualGetPrefixesResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBIndividualGetPronounsResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBIndividualGetResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBIndividualGetSuffixesResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBIndividualInsertResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBIndividualUpdateResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBIsUserInRoleResponse|\Drupal\netforum\xWeb\Generated\StructType\WebLoginResponse|\Drupal\netforum\xWeb\Generated\StructType\WebLogoutResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBMemberDirectoryOrganizationSearchResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBMemberDirectorySearchResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBOrganizationGetResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBOrganizationGetTypesResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBOrganizationInsertResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBOrganizationUpdateResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBPhoneGetPhonesByCustomerResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBPhoneGetResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBPhoneGetTypesResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBPhoneInsertResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBPhoneUpdateResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBRoleExistsResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBUpdateSystemOptionResponse|\Drupal\netforum\xWeb\Generated\StructType\WebValidateResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserChangePasswordResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserCreateResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserFindOrganizationsByDomainResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserFindUsersByDomainResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserFindUsersByEmailResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserFindUsersByNameResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserFindUsersByUserNameFirstNameLastNameResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserGetByRecno_CustomResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserGetResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserLockResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserLoginAndRememberMeResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserLoginByRecno_CustomResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserLoginByRememberMeResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserLoginResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserLogin_CustomResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserUnlockResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserUpdateResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserValidateLoginResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserValidateLogin_CustomResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserValidateTokenResponse|\Drupal\netforum\xWeb\Generated\StructType\WEBWebUserValidateToken_CustomResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
