<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AVFormAction StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class AVFormAction extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    protected string $Type;
    /**
     * The Exit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    protected bool $Exit;
    /**
     * The DestinationWizardFormKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $DestinationWizardFormKey = null;
    /**
     * Constructor method for AVFormAction
     * @uses AVFormAction::setType()
     * @uses AVFormAction::setExit()
     * @uses AVFormAction::setDestinationWizardFormKey()
     * @param string $type
     * @param bool $exit
     * @param string $destinationWizardFormKey
     */
    public function __construct(string $type, bool $exit, ?string $destinationWizardFormKey = null)
    {
        $this
            ->setType($type)
            ->setExit($exit)
            ->setDestinationWizardFormKey($destinationWizardFormKey);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType(): string
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \Drupal\netforum\xWeb\Generated\EnumType\ActionType::valueIsValid()
     * @uses \Drupal\netforum\xWeb\Generated\EnumType\ActionType::getValidValues()
     * @throws InvalidArgumentException
     * @param string $type
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVFormAction
     */
    public function setType(string $type): self
    {
        // validation for constraint: enumeration
        if (!\Drupal\netforum\xWeb\Generated\EnumType\ActionType::valueIsValid($type)) {
            throw new InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Drupal\netforum\xWeb\Generated\EnumType\ActionType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \Drupal\netforum\xWeb\Generated\EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        
        return $this;
    }
    /**
     * Get Exit value
     * @return bool
     */
    public function getExit(): bool
    {
        return $this->Exit;
    }
    /**
     * Set Exit value
     * @param bool $exit
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVFormAction
     */
    public function setExit(bool $exit): self
    {
        // validation for constraint: boolean
        if (!is_null($exit) && !is_bool($exit)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exit, true), gettype($exit)), __LINE__);
        }
        $this->Exit = $exit;
        
        return $this;
    }
    /**
     * Get DestinationWizardFormKey value
     * @return string|null
     */
    public function getDestinationWizardFormKey(): ?string
    {
        return $this->DestinationWizardFormKey;
    }
    /**
     * Set DestinationWizardFormKey value
     * @param string $destinationWizardFormKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\AVFormAction
     */
    public function setDestinationWizardFormKey(?string $destinationWizardFormKey = null): self
    {
        // validation for constraint: string
        if (!is_null($destinationWizardFormKey) && !is_string($destinationWizardFormKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationWizardFormKey, true), gettype($destinationWizardFormKey)), __LINE__);
        }
        $this->DestinationWizardFormKey = $destinationWizardFormKey;
        
        return $this;
    }
}
