<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccreditationAreaType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class AccreditationAreaType extends AbstractStructBase
{
    /**
     * The Accreditation_Customer
     * @var \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Customer_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Customer_DataObjectType $Accreditation_Customer = null;
    /**
     * The Customer
     * @var \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_DataObjectType $Customer = null;
    /**
     * The Customer_Address
     * @var \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Address_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Address_DataObjectType $Customer_Address = null;
    /**
     * The Customer_Primary_Address
     * @var \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType $Customer_Primary_Address = null;
    /**
     * The Organization
     * @var \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Organization_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Organization_DataObjectType $Organization = null;
    /**
     * The Accreditation
     * @var \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_DataObjectType $Accreditation = null;
    /**
     * The Accreditation_Status
     * @var \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Status_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Status_DataObjectType $Accreditation_Status = null;
    /**
     * The Accreditation_Type
     * @var \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Type_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Type_DataObjectType $Accreditation_Type = null;
    /**
     * The Individual_Organization_CEO_Affiliation
     * @var \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CEO_Affiliation_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CEO_Affiliation_DataObjectType $Individual_Organization_CEO_Affiliation = null;
    /**
     * The Affiliated_CEO
     * @var \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CEO_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CEO_DataObjectType $Affiliated_CEO = null;
    /**
     * The Individual_Organization_CAO_Affiliation
     * @var \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType $Individual_Organization_CAO_Affiliation = null;
    /**
     * The Affiliated_CAO
     * @var \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType $Affiliated_CAO = null;
    /**
     * The Individual_Organization_CMOA_ffiliation
     * @var \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CMOA_ffiliation_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CMOA_ffiliation_DataObjectType $Individual_Organization_CMOA_ffiliation = null;
    /**
     * The Affiliated_CMO
     * @var \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CMO_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CMO_DataObjectType $Affiliated_CMO = null;
    /**
     * The Individual_Organization_Survey_Contact_Affiliation
     * @var \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType $Individual_Organization_Survey_Contact_Affiliation = null;
    /**
     * The Affiliated_Survey_Contact
     * @var \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_Survey_Contact_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_Survey_Contact_DataObjectType $Affiliated_Survey_Contact = null;
    /**
     * The Individual_Decision_Letter_Recipient
     * @var \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType $Individual_Decision_Letter_Recipient = null;
    /**
     * The Decision_Letter_Recipient
     * @var \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Decision_Letter_Recipient_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Decision_Letter_Recipient_DataObjectType $Decision_Letter_Recipient = null;
    /**
     * The Invoice
     * @var \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Invoice_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Invoice_DataObjectType $Invoice = null;
    /**
     * The Payment
     * @var \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_DataObjectType $Payment = null;
    /**
     * The Payment_Info
     * @var \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType $Payment_Info = null;
    /**
     * The Payment_Method
     * @var \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Method_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Method_DataObjectType $Payment_Method = null;
    /**
     * The Invoice_DetailCollection
     * @var \Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType $Invoice_DetailCollection = null;
    /**
     * The CurrentKey
     * Meta information extracted from the WSDL
     * - documentation: Primary Key.The current key is the record key for the object. This field must be set whenever updating an existing database record. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $CurrentKey = null;
    /**
     * Constructor method for AccreditationAreaType
     * @uses AccreditationAreaType::setAccreditation_Customer()
     * @uses AccreditationAreaType::setCustomer()
     * @uses AccreditationAreaType::setCustomer_Address()
     * @uses AccreditationAreaType::setCustomer_Primary_Address()
     * @uses AccreditationAreaType::setOrganization()
     * @uses AccreditationAreaType::setAccreditation()
     * @uses AccreditationAreaType::setAccreditation_Status()
     * @uses AccreditationAreaType::setAccreditation_Type()
     * @uses AccreditationAreaType::setIndividual_Organization_CEO_Affiliation()
     * @uses AccreditationAreaType::setAffiliated_CEO()
     * @uses AccreditationAreaType::setIndividual_Organization_CAO_Affiliation()
     * @uses AccreditationAreaType::setAffiliated_CAO()
     * @uses AccreditationAreaType::setIndividual_Organization_CMOA_ffiliation()
     * @uses AccreditationAreaType::setAffiliated_CMO()
     * @uses AccreditationAreaType::setIndividual_Organization_Survey_Contact_Affiliation()
     * @uses AccreditationAreaType::setAffiliated_Survey_Contact()
     * @uses AccreditationAreaType::setIndividual_Decision_Letter_Recipient()
     * @uses AccreditationAreaType::setDecision_Letter_Recipient()
     * @uses AccreditationAreaType::setInvoice()
     * @uses AccreditationAreaType::setPayment()
     * @uses AccreditationAreaType::setPayment_Info()
     * @uses AccreditationAreaType::setPayment_Method()
     * @uses AccreditationAreaType::setInvoice_DetailCollection()
     * @uses AccreditationAreaType::setCurrentKey()
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Customer_DataObjectType $accreditation_Customer
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_DataObjectType $customer
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Address_DataObjectType $customer_Address
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType $customer_Primary_Address
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Organization_DataObjectType $organization
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_DataObjectType $accreditation
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Status_DataObjectType $accreditation_Status
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Type_DataObjectType $accreditation_Type
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CEO_Affiliation_DataObjectType $individual_Organization_CEO_Affiliation
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CEO_DataObjectType $affiliated_CEO
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType $individual_Organization_CAO_Affiliation
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType $affiliated_CAO
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CMOA_ffiliation_DataObjectType $individual_Organization_CMOA_ffiliation
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CMO_DataObjectType $affiliated_CMO
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType $individual_Organization_Survey_Contact_Affiliation
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_Survey_Contact_DataObjectType $affiliated_Survey_Contact
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType $individual_Decision_Letter_Recipient
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Decision_Letter_Recipient_DataObjectType $decision_Letter_Recipient
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Invoice_DataObjectType $invoice
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_DataObjectType $payment
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType $payment_Info
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Method_DataObjectType $payment_Method
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType $invoice_DetailCollection
     * @param string $currentKey
     */
    public function __construct(?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Customer_DataObjectType $accreditation_Customer = null, ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_DataObjectType $customer = null, ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Address_DataObjectType $customer_Address = null, ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType $customer_Primary_Address = null, ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Organization_DataObjectType $organization = null, ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_DataObjectType $accreditation = null, ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Status_DataObjectType $accreditation_Status = null, ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Type_DataObjectType $accreditation_Type = null, ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CEO_Affiliation_DataObjectType $individual_Organization_CEO_Affiliation = null, ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CEO_DataObjectType $affiliated_CEO = null, ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType $individual_Organization_CAO_Affiliation = null, ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType $affiliated_CAO = null, ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CMOA_ffiliation_DataObjectType $individual_Organization_CMOA_ffiliation = null, ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CMO_DataObjectType $affiliated_CMO = null, ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType $individual_Organization_Survey_Contact_Affiliation = null, ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_Survey_Contact_DataObjectType $affiliated_Survey_Contact = null, ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType $individual_Decision_Letter_Recipient = null, ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Decision_Letter_Recipient_DataObjectType $decision_Letter_Recipient = null, ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Invoice_DataObjectType $invoice = null, ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_DataObjectType $payment = null, ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType $payment_Info = null, ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Method_DataObjectType $payment_Method = null, ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType $invoice_DetailCollection = null, ?string $currentKey = null)
    {
        $this
            ->setAccreditation_Customer($accreditation_Customer)
            ->setCustomer($customer)
            ->setCustomer_Address($customer_Address)
            ->setCustomer_Primary_Address($customer_Primary_Address)
            ->setOrganization($organization)
            ->setAccreditation($accreditation)
            ->setAccreditation_Status($accreditation_Status)
            ->setAccreditation_Type($accreditation_Type)
            ->setIndividual_Organization_CEO_Affiliation($individual_Organization_CEO_Affiliation)
            ->setAffiliated_CEO($affiliated_CEO)
            ->setIndividual_Organization_CAO_Affiliation($individual_Organization_CAO_Affiliation)
            ->setAffiliated_CAO($affiliated_CAO)
            ->setIndividual_Organization_CMOA_ffiliation($individual_Organization_CMOA_ffiliation)
            ->setAffiliated_CMO($affiliated_CMO)
            ->setIndividual_Organization_Survey_Contact_Affiliation($individual_Organization_Survey_Contact_Affiliation)
            ->setAffiliated_Survey_Contact($affiliated_Survey_Contact)
            ->setIndividual_Decision_Letter_Recipient($individual_Decision_Letter_Recipient)
            ->setDecision_Letter_Recipient($decision_Letter_Recipient)
            ->setInvoice($invoice)
            ->setPayment($payment)
            ->setPayment_Info($payment_Info)
            ->setPayment_Method($payment_Method)
            ->setInvoice_DetailCollection($invoice_DetailCollection)
            ->setCurrentKey($currentKey);
    }
    /**
     * Get Accreditation_Customer value
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Customer_DataObjectType|null
     */
    public function getAccreditation_Customer(): ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Customer_DataObjectType
    {
        return $this->Accreditation_Customer;
    }
    /**
     * Set Accreditation_Customer value
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Customer_DataObjectType $accreditation_Customer
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationAreaType
     */
    public function setAccreditation_Customer(?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Customer_DataObjectType $accreditation_Customer = null): self
    {
        $this->Accreditation_Customer = $accreditation_Customer;
        
        return $this;
    }
    /**
     * Get Customer value
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_DataObjectType|null
     */
    public function getCustomer(): ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_DataObjectType
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_DataObjectType $customer
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationAreaType
     */
    public function setCustomer(?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_DataObjectType $customer = null): self
    {
        $this->Customer = $customer;
        
        return $this;
    }
    /**
     * Get Customer_Address value
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Address_DataObjectType|null
     */
    public function getCustomer_Address(): ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Address_DataObjectType
    {
        return $this->Customer_Address;
    }
    /**
     * Set Customer_Address value
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Address_DataObjectType $customer_Address
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationAreaType
     */
    public function setCustomer_Address(?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Address_DataObjectType $customer_Address = null): self
    {
        $this->Customer_Address = $customer_Address;
        
        return $this;
    }
    /**
     * Get Customer_Primary_Address value
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType|null
     */
    public function getCustomer_Primary_Address(): ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType
    {
        return $this->Customer_Primary_Address;
    }
    /**
     * Set Customer_Primary_Address value
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType $customer_Primary_Address
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationAreaType
     */
    public function setCustomer_Primary_Address(?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Customer_Primary_Address_DataObjectType $customer_Primary_Address = null): self
    {
        $this->Customer_Primary_Address = $customer_Primary_Address;
        
        return $this;
    }
    /**
     * Get Organization value
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Organization_DataObjectType|null
     */
    public function getOrganization(): ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Organization_DataObjectType
    {
        return $this->Organization;
    }
    /**
     * Set Organization value
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Organization_DataObjectType $organization
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationAreaType
     */
    public function setOrganization(?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Organization_DataObjectType $organization = null): self
    {
        $this->Organization = $organization;
        
        return $this;
    }
    /**
     * Get Accreditation value
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_DataObjectType|null
     */
    public function getAccreditation(): ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_DataObjectType
    {
        return $this->Accreditation;
    }
    /**
     * Set Accreditation value
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_DataObjectType $accreditation
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationAreaType
     */
    public function setAccreditation(?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_DataObjectType $accreditation = null): self
    {
        $this->Accreditation = $accreditation;
        
        return $this;
    }
    /**
     * Get Accreditation_Status value
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Status_DataObjectType|null
     */
    public function getAccreditation_Status(): ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Status_DataObjectType
    {
        return $this->Accreditation_Status;
    }
    /**
     * Set Accreditation_Status value
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Status_DataObjectType $accreditation_Status
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationAreaType
     */
    public function setAccreditation_Status(?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Status_DataObjectType $accreditation_Status = null): self
    {
        $this->Accreditation_Status = $accreditation_Status;
        
        return $this;
    }
    /**
     * Get Accreditation_Type value
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Type_DataObjectType|null
     */
    public function getAccreditation_Type(): ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Type_DataObjectType
    {
        return $this->Accreditation_Type;
    }
    /**
     * Set Accreditation_Type value
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Type_DataObjectType $accreditation_Type
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationAreaType
     */
    public function setAccreditation_Type(?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Type_DataObjectType $accreditation_Type = null): self
    {
        $this->Accreditation_Type = $accreditation_Type;
        
        return $this;
    }
    /**
     * Get Individual_Organization_CEO_Affiliation value
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CEO_Affiliation_DataObjectType|null
     */
    public function getIndividual_Organization_CEO_Affiliation(): ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CEO_Affiliation_DataObjectType
    {
        return $this->Individual_Organization_CEO_Affiliation;
    }
    /**
     * Set Individual_Organization_CEO_Affiliation value
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CEO_Affiliation_DataObjectType $individual_Organization_CEO_Affiliation
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationAreaType
     */
    public function setIndividual_Organization_CEO_Affiliation(?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CEO_Affiliation_DataObjectType $individual_Organization_CEO_Affiliation = null): self
    {
        $this->Individual_Organization_CEO_Affiliation = $individual_Organization_CEO_Affiliation;
        
        return $this;
    }
    /**
     * Get Affiliated_CEO value
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CEO_DataObjectType|null
     */
    public function getAffiliated_CEO(): ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CEO_DataObjectType
    {
        return $this->Affiliated_CEO;
    }
    /**
     * Set Affiliated_CEO value
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CEO_DataObjectType $affiliated_CEO
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationAreaType
     */
    public function setAffiliated_CEO(?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CEO_DataObjectType $affiliated_CEO = null): self
    {
        $this->Affiliated_CEO = $affiliated_CEO;
        
        return $this;
    }
    /**
     * Get Individual_Organization_CAO_Affiliation value
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType|null
     */
    public function getIndividual_Organization_CAO_Affiliation(): ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType
    {
        return $this->Individual_Organization_CAO_Affiliation;
    }
    /**
     * Set Individual_Organization_CAO_Affiliation value
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType $individual_Organization_CAO_Affiliation
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationAreaType
     */
    public function setIndividual_Organization_CAO_Affiliation(?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType $individual_Organization_CAO_Affiliation = null): self
    {
        $this->Individual_Organization_CAO_Affiliation = $individual_Organization_CAO_Affiliation;
        
        return $this;
    }
    /**
     * Get Affiliated_CAO value
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType|null
     */
    public function getAffiliated_CAO(): ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType
    {
        return $this->Affiliated_CAO;
    }
    /**
     * Set Affiliated_CAO value
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType $affiliated_CAO
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationAreaType
     */
    public function setAffiliated_CAO(?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CAO_DataObjectType $affiliated_CAO = null): self
    {
        $this->Affiliated_CAO = $affiliated_CAO;
        
        return $this;
    }
    /**
     * Get Individual_Organization_CMOA_ffiliation value
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CMOA_ffiliation_DataObjectType|null
     */
    public function getIndividual_Organization_CMOA_ffiliation(): ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CMOA_ffiliation_DataObjectType
    {
        return $this->Individual_Organization_CMOA_ffiliation;
    }
    /**
     * Set Individual_Organization_CMOA_ffiliation value
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CMOA_ffiliation_DataObjectType $individual_Organization_CMOA_ffiliation
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationAreaType
     */
    public function setIndividual_Organization_CMOA_ffiliation(?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CMOA_ffiliation_DataObjectType $individual_Organization_CMOA_ffiliation = null): self
    {
        $this->Individual_Organization_CMOA_ffiliation = $individual_Organization_CMOA_ffiliation;
        
        return $this;
    }
    /**
     * Get Affiliated_CMO value
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CMO_DataObjectType|null
     */
    public function getAffiliated_CMO(): ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CMO_DataObjectType
    {
        return $this->Affiliated_CMO;
    }
    /**
     * Set Affiliated_CMO value
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CMO_DataObjectType $affiliated_CMO
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationAreaType
     */
    public function setAffiliated_CMO(?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_CMO_DataObjectType $affiliated_CMO = null): self
    {
        $this->Affiliated_CMO = $affiliated_CMO;
        
        return $this;
    }
    /**
     * Get Individual_Organization_Survey_Contact_Affiliation value
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType|null
     */
    public function getIndividual_Organization_Survey_Contact_Affiliation(): ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType
    {
        return $this->Individual_Organization_Survey_Contact_Affiliation;
    }
    /**
     * Set Individual_Organization_Survey_Contact_Affiliation value
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType $individual_Organization_Survey_Contact_Affiliation
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationAreaType
     */
    public function setIndividual_Organization_Survey_Contact_Affiliation(?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_Survey_Contact_Affiliation_DataObjectType $individual_Organization_Survey_Contact_Affiliation = null): self
    {
        $this->Individual_Organization_Survey_Contact_Affiliation = $individual_Organization_Survey_Contact_Affiliation;
        
        return $this;
    }
    /**
     * Get Affiliated_Survey_Contact value
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_Survey_Contact_DataObjectType|null
     */
    public function getAffiliated_Survey_Contact(): ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_Survey_Contact_DataObjectType
    {
        return $this->Affiliated_Survey_Contact;
    }
    /**
     * Set Affiliated_Survey_Contact value
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_Survey_Contact_DataObjectType $affiliated_Survey_Contact
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationAreaType
     */
    public function setAffiliated_Survey_Contact(?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Affiliated_Survey_Contact_DataObjectType $affiliated_Survey_Contact = null): self
    {
        $this->Affiliated_Survey_Contact = $affiliated_Survey_Contact;
        
        return $this;
    }
    /**
     * Get Individual_Decision_Letter_Recipient value
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType|null
     */
    public function getIndividual_Decision_Letter_Recipient(): ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType
    {
        return $this->Individual_Decision_Letter_Recipient;
    }
    /**
     * Set Individual_Decision_Letter_Recipient value
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType $individual_Decision_Letter_Recipient
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationAreaType
     */
    public function setIndividual_Decision_Letter_Recipient(?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Decision_Letter_Recipient_DataObjectType $individual_Decision_Letter_Recipient = null): self
    {
        $this->Individual_Decision_Letter_Recipient = $individual_Decision_Letter_Recipient;
        
        return $this;
    }
    /**
     * Get Decision_Letter_Recipient value
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Decision_Letter_Recipient_DataObjectType|null
     */
    public function getDecision_Letter_Recipient(): ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Decision_Letter_Recipient_DataObjectType
    {
        return $this->Decision_Letter_Recipient;
    }
    /**
     * Set Decision_Letter_Recipient value
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Decision_Letter_Recipient_DataObjectType $decision_Letter_Recipient
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationAreaType
     */
    public function setDecision_Letter_Recipient(?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Decision_Letter_Recipient_DataObjectType $decision_Letter_Recipient = null): self
    {
        $this->Decision_Letter_Recipient = $decision_Letter_Recipient;
        
        return $this;
    }
    /**
     * Get Invoice value
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Invoice_DataObjectType|null
     */
    public function getInvoice(): ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Invoice_DataObjectType
    {
        return $this->Invoice;
    }
    /**
     * Set Invoice value
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Invoice_DataObjectType $invoice
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationAreaType
     */
    public function setInvoice(?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Invoice_DataObjectType $invoice = null): self
    {
        $this->Invoice = $invoice;
        
        return $this;
    }
    /**
     * Get Payment value
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_DataObjectType|null
     */
    public function getPayment(): ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_DataObjectType
    {
        return $this->Payment;
    }
    /**
     * Set Payment value
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_DataObjectType $payment
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationAreaType
     */
    public function setPayment(?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_DataObjectType $payment = null): self
    {
        $this->Payment = $payment;
        
        return $this;
    }
    /**
     * Get Payment_Info value
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType|null
     */
    public function getPayment_Info(): ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType
    {
        return $this->Payment_Info;
    }
    /**
     * Set Payment_Info value
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType $payment_Info
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationAreaType
     */
    public function setPayment_Info(?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Info_DataObjectType $payment_Info = null): self
    {
        $this->Payment_Info = $payment_Info;
        
        return $this;
    }
    /**
     * Get Payment_Method value
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Method_DataObjectType|null
     */
    public function getPayment_Method(): ?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Method_DataObjectType
    {
        return $this->Payment_Method;
    }
    /**
     * Set Payment_Method value
     * @param \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Method_DataObjectType $payment_Method
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationAreaType
     */
    public function setPayment_Method(?\Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Payment_Method_DataObjectType $payment_Method = null): self
    {
        $this->Payment_Method = $payment_Method;
        
        return $this;
    }
    /**
     * Get Invoice_DetailCollection value
     * @return \Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType|null
     */
    public function getInvoice_DetailCollection(): ?\Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType
    {
        return $this->Invoice_DetailCollection;
    }
    /**
     * Set Invoice_DetailCollection value
     * @param \Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType $invoice_DetailCollection
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationAreaType
     */
    public function setInvoice_DetailCollection(?\Drupal\netforum\xWeb\Generated\StructType\Invoice_DetailCollectionType $invoice_DetailCollection = null): self
    {
        $this->Invoice_DetailCollection = $invoice_DetailCollection;
        
        return $this;
    }
    /**
     * Get CurrentKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentKey(): ?string
    {
        return $this->CurrentKey ?? null;
    }
    /**
     * Set CurrentKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationAreaType
     */
    public function setCurrentKey(?string $currentKey = null): self
    {
        // validation for constraint: string
        if (!is_null($currentKey) && !is_string($currentKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentKey, true), gettype($currentKey)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($currentKey) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $currentKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($currentKey, true)), __LINE__);
        }
        if (is_null($currentKey) || (is_array($currentKey) && empty($currentKey))) {
            unset($this->CurrentKey);
        } else {
            $this->CurrentKey = $currentKey;
        }
        
        return $this;
    }
}
