<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccreditationArea_Accreditation_Customer_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class AccreditationArea_Accreditation_Customer_DataObjectType extends AbstractStructBase
{
    /**
     * The amc_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $amc_key = null;
    /**
     * The amc_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Accreditation Customer Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $amc_cst_key = null;
    /**
     * The amc_start_date
     * Meta information extracted from the WSDL
     * - documentation: Accreditation Start Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $amc_start_date = null;
    /**
     * The amc_end_date
     * Meta information extracted from the WSDL
     * - documentation: Accreditation End Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $amc_end_date = null;
    /**
     * The amc_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $amc_add_user = null;
    /**
     * The amc_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $amc_add_date = null;
    /**
     * The amc_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $amc_change_user = null;
    /**
     * The amc_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $amc_change_date = null;
    /**
     * The amc_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $amc_delete_flag = null;
    /**
     * The amc_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $amc_key_ext = null;
    /**
     * The amc_ixo_cao_key
     * Meta information extracted from the WSDL
     * - documentation: Chief Administrative Officer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $amc_ixo_cao_key = null;
    /**
     * The amc_ama_key
     * Meta information extracted from the WSDL
     * - documentation: Accreditation Code Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $amc_ama_key = null;
    /**
     * The amc_inv_code
     * Meta information extracted from the WSDL
     * - documentation: Invoice Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $amc_inv_code = null;
    /**
     * The amc_ixo_ceo_key
     * Meta information extracted from the WSDL
     * - documentation: Chief Executive Officer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $amc_ixo_ceo_key = null;
    /**
     * The amc_ams_key
     * Meta information extracted from the WSDL
     * - documentation: Accreditation Status Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $amc_ams_key = null;
    /**
     * The amc_ixo_cmo_key
     * Meta information extracted from the WSDL
     * - documentation: Chief Medical Officer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $amc_ixo_cmo_key = null;
    /**
     * The amc_ixo_adl_key
     * Meta information extracted from the WSDL
     * - documentation: Accreditation Decision Letter Recipient. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $amc_ixo_adl_key = null;
    /**
     * The amc_renewal_letter_date
     * Meta information extracted from the WSDL
     * - documentation: Date renewal letter sent. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $amc_renewal_letter_date = null;
    /**
     * The amc_amt_key
     * Meta information extracted from the WSDL
     * - documentation: Accreditation Type Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $amc_amt_key = null;
    /**
     * The amc_decision_date
     * Meta information extracted from the WSDL
     * - documentation: Accreditation Decision Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $amc_decision_date = null;
    /**
     * The amc_renewal_letter_sent
     * Meta information extracted from the WSDL
     * - documentation: Last renewal letter sent. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $amc_renewal_letter_sent = null;
    /**
     * The amc_dupe_check
     * Meta information extracted from the WSDL
     * - documentation: Dupe Check. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $amc_dupe_check = null;
    /**
     * The amc_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $amc_entity_key = null;
    /**
     * The amc_ivd_key
     * Meta information extracted from the WSDL
     * - documentation: Invoice Detail Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $amc_ivd_key = null;
    /**
     * The amc_ixo_surveycontact_key
     * Meta information extracted from the WSDL
     * - documentation: Survey Contact Person. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $amc_ixo_surveycontact_key = null;
    /**
     * The amc_status_date
     * Meta information extracted from the WSDL
     * - documentation: Status Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $amc_status_date = null;
    /**
     * The amc_ord_code
     * Meta information extracted from the WSDL
     * - documentation: Order Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $amc_ord_code = null;
    /**
     * The amc_odd_key
     * Meta information extracted from the WSDL
     * - documentation: Order Detail Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $amc_odd_key = null;
    /**
     * The amc_bup_prd_key
     * Meta information extracted from the WSDL
     * - documentation: bundle component product key.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $amc_bup_prd_key = null;
    /**
     * Constructor method for AccreditationArea_Accreditation_Customer_DataObjectType
     * @uses AccreditationArea_Accreditation_Customer_DataObjectType::setAmc_key()
     * @uses AccreditationArea_Accreditation_Customer_DataObjectType::setAmc_cst_key()
     * @uses AccreditationArea_Accreditation_Customer_DataObjectType::setAmc_start_date()
     * @uses AccreditationArea_Accreditation_Customer_DataObjectType::setAmc_end_date()
     * @uses AccreditationArea_Accreditation_Customer_DataObjectType::setAmc_add_user()
     * @uses AccreditationArea_Accreditation_Customer_DataObjectType::setAmc_add_date()
     * @uses AccreditationArea_Accreditation_Customer_DataObjectType::setAmc_change_user()
     * @uses AccreditationArea_Accreditation_Customer_DataObjectType::setAmc_change_date()
     * @uses AccreditationArea_Accreditation_Customer_DataObjectType::setAmc_delete_flag()
     * @uses AccreditationArea_Accreditation_Customer_DataObjectType::setAmc_key_ext()
     * @uses AccreditationArea_Accreditation_Customer_DataObjectType::setAmc_ixo_cao_key()
     * @uses AccreditationArea_Accreditation_Customer_DataObjectType::setAmc_ama_key()
     * @uses AccreditationArea_Accreditation_Customer_DataObjectType::setAmc_inv_code()
     * @uses AccreditationArea_Accreditation_Customer_DataObjectType::setAmc_ixo_ceo_key()
     * @uses AccreditationArea_Accreditation_Customer_DataObjectType::setAmc_ams_key()
     * @uses AccreditationArea_Accreditation_Customer_DataObjectType::setAmc_ixo_cmo_key()
     * @uses AccreditationArea_Accreditation_Customer_DataObjectType::setAmc_ixo_adl_key()
     * @uses AccreditationArea_Accreditation_Customer_DataObjectType::setAmc_renewal_letter_date()
     * @uses AccreditationArea_Accreditation_Customer_DataObjectType::setAmc_amt_key()
     * @uses AccreditationArea_Accreditation_Customer_DataObjectType::setAmc_decision_date()
     * @uses AccreditationArea_Accreditation_Customer_DataObjectType::setAmc_renewal_letter_sent()
     * @uses AccreditationArea_Accreditation_Customer_DataObjectType::setAmc_dupe_check()
     * @uses AccreditationArea_Accreditation_Customer_DataObjectType::setAmc_entity_key()
     * @uses AccreditationArea_Accreditation_Customer_DataObjectType::setAmc_ivd_key()
     * @uses AccreditationArea_Accreditation_Customer_DataObjectType::setAmc_ixo_surveycontact_key()
     * @uses AccreditationArea_Accreditation_Customer_DataObjectType::setAmc_status_date()
     * @uses AccreditationArea_Accreditation_Customer_DataObjectType::setAmc_ord_code()
     * @uses AccreditationArea_Accreditation_Customer_DataObjectType::setAmc_odd_key()
     * @uses AccreditationArea_Accreditation_Customer_DataObjectType::setAmc_bup_prd_key()
     * @param string $amc_key
     * @param string $amc_cst_key
     * @param string $amc_start_date
     * @param string $amc_end_date
     * @param string $amc_add_user
     * @param string $amc_add_date
     * @param string $amc_change_user
     * @param string $amc_change_date
     * @param string $amc_delete_flag
     * @param string $amc_key_ext
     * @param string $amc_ixo_cao_key
     * @param string $amc_ama_key
     * @param string $amc_inv_code
     * @param string $amc_ixo_ceo_key
     * @param string $amc_ams_key
     * @param string $amc_ixo_cmo_key
     * @param string $amc_ixo_adl_key
     * @param string $amc_renewal_letter_date
     * @param string $amc_amt_key
     * @param string $amc_decision_date
     * @param int $amc_renewal_letter_sent
     * @param string $amc_dupe_check
     * @param string $amc_entity_key
     * @param string $amc_ivd_key
     * @param string $amc_ixo_surveycontact_key
     * @param string $amc_status_date
     * @param string $amc_ord_code
     * @param string $amc_odd_key
     * @param string $amc_bup_prd_key
     */
    public function __construct(?string $amc_key = null, ?string $amc_cst_key = null, ?string $amc_start_date = null, ?string $amc_end_date = null, ?string $amc_add_user = null, ?string $amc_add_date = null, ?string $amc_change_user = null, ?string $amc_change_date = null, ?string $amc_delete_flag = null, ?string $amc_key_ext = null, ?string $amc_ixo_cao_key = null, ?string $amc_ama_key = null, ?string $amc_inv_code = null, ?string $amc_ixo_ceo_key = null, ?string $amc_ams_key = null, ?string $amc_ixo_cmo_key = null, ?string $amc_ixo_adl_key = null, ?string $amc_renewal_letter_date = null, ?string $amc_amt_key = null, ?string $amc_decision_date = null, ?int $amc_renewal_letter_sent = null, ?string $amc_dupe_check = null, ?string $amc_entity_key = null, ?string $amc_ivd_key = null, ?string $amc_ixo_surveycontact_key = null, ?string $amc_status_date = null, ?string $amc_ord_code = null, ?string $amc_odd_key = null, ?string $amc_bup_prd_key = null)
    {
        $this
            ->setAmc_key($amc_key)
            ->setAmc_cst_key($amc_cst_key)
            ->setAmc_start_date($amc_start_date)
            ->setAmc_end_date($amc_end_date)
            ->setAmc_add_user($amc_add_user)
            ->setAmc_add_date($amc_add_date)
            ->setAmc_change_user($amc_change_user)
            ->setAmc_change_date($amc_change_date)
            ->setAmc_delete_flag($amc_delete_flag)
            ->setAmc_key_ext($amc_key_ext)
            ->setAmc_ixo_cao_key($amc_ixo_cao_key)
            ->setAmc_ama_key($amc_ama_key)
            ->setAmc_inv_code($amc_inv_code)
            ->setAmc_ixo_ceo_key($amc_ixo_ceo_key)
            ->setAmc_ams_key($amc_ams_key)
            ->setAmc_ixo_cmo_key($amc_ixo_cmo_key)
            ->setAmc_ixo_adl_key($amc_ixo_adl_key)
            ->setAmc_renewal_letter_date($amc_renewal_letter_date)
            ->setAmc_amt_key($amc_amt_key)
            ->setAmc_decision_date($amc_decision_date)
            ->setAmc_renewal_letter_sent($amc_renewal_letter_sent)
            ->setAmc_dupe_check($amc_dupe_check)
            ->setAmc_entity_key($amc_entity_key)
            ->setAmc_ivd_key($amc_ivd_key)
            ->setAmc_ixo_surveycontact_key($amc_ixo_surveycontact_key)
            ->setAmc_status_date($amc_status_date)
            ->setAmc_ord_code($amc_ord_code)
            ->setAmc_odd_key($amc_odd_key)
            ->setAmc_bup_prd_key($amc_bup_prd_key);
    }
    /**
     * Get amc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmc_key(): ?string
    {
        return $this->amc_key ?? null;
    }
    /**
     * Set amc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Customer_DataObjectType
     */
    public function setAmc_key(?string $amc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($amc_key) && !is_string($amc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amc_key, true), gettype($amc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($amc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $amc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($amc_key, true)), __LINE__);
        }
        if (is_null($amc_key) || (is_array($amc_key) && empty($amc_key))) {
            unset($this->amc_key);
        } else {
            $this->amc_key = $amc_key;
        }
        
        return $this;
    }
    /**
     * Get amc_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmc_cst_key(): ?string
    {
        return $this->amc_cst_key ?? null;
    }
    /**
     * Set amc_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amc_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Customer_DataObjectType
     */
    public function setAmc_cst_key(?string $amc_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($amc_cst_key) && !is_string($amc_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amc_cst_key, true), gettype($amc_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($amc_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $amc_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($amc_cst_key, true)), __LINE__);
        }
        if (is_null($amc_cst_key) || (is_array($amc_cst_key) && empty($amc_cst_key))) {
            unset($this->amc_cst_key);
        } else {
            $this->amc_cst_key = $amc_cst_key;
        }
        
        return $this;
    }
    /**
     * Get amc_start_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmc_start_date(): ?string
    {
        return $this->amc_start_date ?? null;
    }
    /**
     * Set amc_start_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amc_start_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Customer_DataObjectType
     */
    public function setAmc_start_date(?string $amc_start_date = null): self
    {
        // validation for constraint: string
        if (!is_null($amc_start_date) && !is_string($amc_start_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amc_start_date, true), gettype($amc_start_date)), __LINE__);
        }
        if (is_null($amc_start_date) || (is_array($amc_start_date) && empty($amc_start_date))) {
            unset($this->amc_start_date);
        } else {
            $this->amc_start_date = $amc_start_date;
        }
        
        return $this;
    }
    /**
     * Get amc_end_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmc_end_date(): ?string
    {
        return $this->amc_end_date ?? null;
    }
    /**
     * Set amc_end_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amc_end_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Customer_DataObjectType
     */
    public function setAmc_end_date(?string $amc_end_date = null): self
    {
        // validation for constraint: string
        if (!is_null($amc_end_date) && !is_string($amc_end_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amc_end_date, true), gettype($amc_end_date)), __LINE__);
        }
        if (is_null($amc_end_date) || (is_array($amc_end_date) && empty($amc_end_date))) {
            unset($this->amc_end_date);
        } else {
            $this->amc_end_date = $amc_end_date;
        }
        
        return $this;
    }
    /**
     * Get amc_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmc_add_user(): ?string
    {
        return $this->amc_add_user ?? null;
    }
    /**
     * Set amc_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amc_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Customer_DataObjectType
     */
    public function setAmc_add_user(?string $amc_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($amc_add_user) && !is_string($amc_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amc_add_user, true), gettype($amc_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($amc_add_user) && mb_strlen((string) $amc_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $amc_add_user)), __LINE__);
        }
        if (is_null($amc_add_user) || (is_array($amc_add_user) && empty($amc_add_user))) {
            unset($this->amc_add_user);
        } else {
            $this->amc_add_user = $amc_add_user;
        }
        
        return $this;
    }
    /**
     * Get amc_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmc_add_date(): ?string
    {
        return $this->amc_add_date ?? null;
    }
    /**
     * Set amc_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amc_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Customer_DataObjectType
     */
    public function setAmc_add_date(?string $amc_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($amc_add_date) && !is_string($amc_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amc_add_date, true), gettype($amc_add_date)), __LINE__);
        }
        if (is_null($amc_add_date) || (is_array($amc_add_date) && empty($amc_add_date))) {
            unset($this->amc_add_date);
        } else {
            $this->amc_add_date = $amc_add_date;
        }
        
        return $this;
    }
    /**
     * Get amc_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmc_change_user(): ?string
    {
        return $this->amc_change_user ?? null;
    }
    /**
     * Set amc_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amc_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Customer_DataObjectType
     */
    public function setAmc_change_user(?string $amc_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($amc_change_user) && !is_string($amc_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amc_change_user, true), gettype($amc_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($amc_change_user) && mb_strlen((string) $amc_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $amc_change_user)), __LINE__);
        }
        if (is_null($amc_change_user) || (is_array($amc_change_user) && empty($amc_change_user))) {
            unset($this->amc_change_user);
        } else {
            $this->amc_change_user = $amc_change_user;
        }
        
        return $this;
    }
    /**
     * Get amc_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmc_change_date(): ?string
    {
        return $this->amc_change_date ?? null;
    }
    /**
     * Set amc_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amc_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Customer_DataObjectType
     */
    public function setAmc_change_date(?string $amc_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($amc_change_date) && !is_string($amc_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amc_change_date, true), gettype($amc_change_date)), __LINE__);
        }
        if (is_null($amc_change_date) || (is_array($amc_change_date) && empty($amc_change_date))) {
            unset($this->amc_change_date);
        } else {
            $this->amc_change_date = $amc_change_date;
        }
        
        return $this;
    }
    /**
     * Get amc_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmc_delete_flag(): ?string
    {
        return $this->amc_delete_flag ?? null;
    }
    /**
     * Set amc_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amc_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Customer_DataObjectType
     */
    public function setAmc_delete_flag(?string $amc_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($amc_delete_flag) && !is_string($amc_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amc_delete_flag, true), gettype($amc_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($amc_delete_flag) && $amc_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($amc_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($amc_delete_flag) && $amc_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($amc_delete_flag, true)), __LINE__);
        }
        if (is_null($amc_delete_flag) || (is_array($amc_delete_flag) && empty($amc_delete_flag))) {
            unset($this->amc_delete_flag);
        } else {
            $this->amc_delete_flag = $amc_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get amc_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmc_key_ext(): ?string
    {
        return $this->amc_key_ext ?? null;
    }
    /**
     * Set amc_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amc_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Customer_DataObjectType
     */
    public function setAmc_key_ext(?string $amc_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($amc_key_ext) && !is_string($amc_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amc_key_ext, true), gettype($amc_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($amc_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $amc_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($amc_key_ext, true)), __LINE__);
        }
        if (is_null($amc_key_ext) || (is_array($amc_key_ext) && empty($amc_key_ext))) {
            unset($this->amc_key_ext);
        } else {
            $this->amc_key_ext = $amc_key_ext;
        }
        
        return $this;
    }
    /**
     * Get amc_ixo_cao_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmc_ixo_cao_key(): ?string
    {
        return $this->amc_ixo_cao_key ?? null;
    }
    /**
     * Set amc_ixo_cao_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amc_ixo_cao_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Customer_DataObjectType
     */
    public function setAmc_ixo_cao_key(?string $amc_ixo_cao_key = null): self
    {
        // validation for constraint: string
        if (!is_null($amc_ixo_cao_key) && !is_string($amc_ixo_cao_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amc_ixo_cao_key, true), gettype($amc_ixo_cao_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($amc_ixo_cao_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $amc_ixo_cao_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($amc_ixo_cao_key, true)), __LINE__);
        }
        if (is_null($amc_ixo_cao_key) || (is_array($amc_ixo_cao_key) && empty($amc_ixo_cao_key))) {
            unset($this->amc_ixo_cao_key);
        } else {
            $this->amc_ixo_cao_key = $amc_ixo_cao_key;
        }
        
        return $this;
    }
    /**
     * Get amc_ama_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmc_ama_key(): ?string
    {
        return $this->amc_ama_key ?? null;
    }
    /**
     * Set amc_ama_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amc_ama_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Customer_DataObjectType
     */
    public function setAmc_ama_key(?string $amc_ama_key = null): self
    {
        // validation for constraint: string
        if (!is_null($amc_ama_key) && !is_string($amc_ama_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amc_ama_key, true), gettype($amc_ama_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($amc_ama_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $amc_ama_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($amc_ama_key, true)), __LINE__);
        }
        if (is_null($amc_ama_key) || (is_array($amc_ama_key) && empty($amc_ama_key))) {
            unset($this->amc_ama_key);
        } else {
            $this->amc_ama_key = $amc_ama_key;
        }
        
        return $this;
    }
    /**
     * Get amc_inv_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmc_inv_code(): ?string
    {
        return $this->amc_inv_code ?? null;
    }
    /**
     * Set amc_inv_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amc_inv_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Customer_DataObjectType
     */
    public function setAmc_inv_code(?string $amc_inv_code = null): self
    {
        // validation for constraint: string
        if (!is_null($amc_inv_code) && !is_string($amc_inv_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amc_inv_code, true), gettype($amc_inv_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($amc_inv_code) && mb_strlen((string) $amc_inv_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $amc_inv_code)), __LINE__);
        }
        if (is_null($amc_inv_code) || (is_array($amc_inv_code) && empty($amc_inv_code))) {
            unset($this->amc_inv_code);
        } else {
            $this->amc_inv_code = $amc_inv_code;
        }
        
        return $this;
    }
    /**
     * Get amc_ixo_ceo_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmc_ixo_ceo_key(): ?string
    {
        return $this->amc_ixo_ceo_key ?? null;
    }
    /**
     * Set amc_ixo_ceo_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amc_ixo_ceo_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Customer_DataObjectType
     */
    public function setAmc_ixo_ceo_key(?string $amc_ixo_ceo_key = null): self
    {
        // validation for constraint: string
        if (!is_null($amc_ixo_ceo_key) && !is_string($amc_ixo_ceo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amc_ixo_ceo_key, true), gettype($amc_ixo_ceo_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($amc_ixo_ceo_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $amc_ixo_ceo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($amc_ixo_ceo_key, true)), __LINE__);
        }
        if (is_null($amc_ixo_ceo_key) || (is_array($amc_ixo_ceo_key) && empty($amc_ixo_ceo_key))) {
            unset($this->amc_ixo_ceo_key);
        } else {
            $this->amc_ixo_ceo_key = $amc_ixo_ceo_key;
        }
        
        return $this;
    }
    /**
     * Get amc_ams_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmc_ams_key(): ?string
    {
        return $this->amc_ams_key ?? null;
    }
    /**
     * Set amc_ams_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amc_ams_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Customer_DataObjectType
     */
    public function setAmc_ams_key(?string $amc_ams_key = null): self
    {
        // validation for constraint: string
        if (!is_null($amc_ams_key) && !is_string($amc_ams_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amc_ams_key, true), gettype($amc_ams_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($amc_ams_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $amc_ams_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($amc_ams_key, true)), __LINE__);
        }
        if (is_null($amc_ams_key) || (is_array($amc_ams_key) && empty($amc_ams_key))) {
            unset($this->amc_ams_key);
        } else {
            $this->amc_ams_key = $amc_ams_key;
        }
        
        return $this;
    }
    /**
     * Get amc_ixo_cmo_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmc_ixo_cmo_key(): ?string
    {
        return $this->amc_ixo_cmo_key ?? null;
    }
    /**
     * Set amc_ixo_cmo_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amc_ixo_cmo_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Customer_DataObjectType
     */
    public function setAmc_ixo_cmo_key(?string $amc_ixo_cmo_key = null): self
    {
        // validation for constraint: string
        if (!is_null($amc_ixo_cmo_key) && !is_string($amc_ixo_cmo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amc_ixo_cmo_key, true), gettype($amc_ixo_cmo_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($amc_ixo_cmo_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $amc_ixo_cmo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($amc_ixo_cmo_key, true)), __LINE__);
        }
        if (is_null($amc_ixo_cmo_key) || (is_array($amc_ixo_cmo_key) && empty($amc_ixo_cmo_key))) {
            unset($this->amc_ixo_cmo_key);
        } else {
            $this->amc_ixo_cmo_key = $amc_ixo_cmo_key;
        }
        
        return $this;
    }
    /**
     * Get amc_ixo_adl_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmc_ixo_adl_key(): ?string
    {
        return $this->amc_ixo_adl_key ?? null;
    }
    /**
     * Set amc_ixo_adl_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amc_ixo_adl_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Customer_DataObjectType
     */
    public function setAmc_ixo_adl_key(?string $amc_ixo_adl_key = null): self
    {
        // validation for constraint: string
        if (!is_null($amc_ixo_adl_key) && !is_string($amc_ixo_adl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amc_ixo_adl_key, true), gettype($amc_ixo_adl_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($amc_ixo_adl_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $amc_ixo_adl_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($amc_ixo_adl_key, true)), __LINE__);
        }
        if (is_null($amc_ixo_adl_key) || (is_array($amc_ixo_adl_key) && empty($amc_ixo_adl_key))) {
            unset($this->amc_ixo_adl_key);
        } else {
            $this->amc_ixo_adl_key = $amc_ixo_adl_key;
        }
        
        return $this;
    }
    /**
     * Get amc_renewal_letter_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmc_renewal_letter_date(): ?string
    {
        return $this->amc_renewal_letter_date ?? null;
    }
    /**
     * Set amc_renewal_letter_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amc_renewal_letter_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Customer_DataObjectType
     */
    public function setAmc_renewal_letter_date(?string $amc_renewal_letter_date = null): self
    {
        // validation for constraint: string
        if (!is_null($amc_renewal_letter_date) && !is_string($amc_renewal_letter_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amc_renewal_letter_date, true), gettype($amc_renewal_letter_date)), __LINE__);
        }
        if (is_null($amc_renewal_letter_date) || (is_array($amc_renewal_letter_date) && empty($amc_renewal_letter_date))) {
            unset($this->amc_renewal_letter_date);
        } else {
            $this->amc_renewal_letter_date = $amc_renewal_letter_date;
        }
        
        return $this;
    }
    /**
     * Get amc_amt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmc_amt_key(): ?string
    {
        return $this->amc_amt_key ?? null;
    }
    /**
     * Set amc_amt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amc_amt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Customer_DataObjectType
     */
    public function setAmc_amt_key(?string $amc_amt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($amc_amt_key) && !is_string($amc_amt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amc_amt_key, true), gettype($amc_amt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($amc_amt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $amc_amt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($amc_amt_key, true)), __LINE__);
        }
        if (is_null($amc_amt_key) || (is_array($amc_amt_key) && empty($amc_amt_key))) {
            unset($this->amc_amt_key);
        } else {
            $this->amc_amt_key = $amc_amt_key;
        }
        
        return $this;
    }
    /**
     * Get amc_decision_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmc_decision_date(): ?string
    {
        return $this->amc_decision_date ?? null;
    }
    /**
     * Set amc_decision_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amc_decision_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Customer_DataObjectType
     */
    public function setAmc_decision_date(?string $amc_decision_date = null): self
    {
        // validation for constraint: string
        if (!is_null($amc_decision_date) && !is_string($amc_decision_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amc_decision_date, true), gettype($amc_decision_date)), __LINE__);
        }
        if (is_null($amc_decision_date) || (is_array($amc_decision_date) && empty($amc_decision_date))) {
            unset($this->amc_decision_date);
        } else {
            $this->amc_decision_date = $amc_decision_date;
        }
        
        return $this;
    }
    /**
     * Get amc_renewal_letter_sent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAmc_renewal_letter_sent(): ?int
    {
        return $this->amc_renewal_letter_sent ?? null;
    }
    /**
     * Set amc_renewal_letter_sent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $amc_renewal_letter_sent
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Customer_DataObjectType
     */
    public function setAmc_renewal_letter_sent(?int $amc_renewal_letter_sent = null): self
    {
        // validation for constraint: int
        if (!is_null($amc_renewal_letter_sent) && !(is_int($amc_renewal_letter_sent) || ctype_digit($amc_renewal_letter_sent))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amc_renewal_letter_sent, true), gettype($amc_renewal_letter_sent)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($amc_renewal_letter_sent) && $amc_renewal_letter_sent > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($amc_renewal_letter_sent, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($amc_renewal_letter_sent) && $amc_renewal_letter_sent < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($amc_renewal_letter_sent, true)), __LINE__);
        }
        if (is_null($amc_renewal_letter_sent) || (is_array($amc_renewal_letter_sent) && empty($amc_renewal_letter_sent))) {
            unset($this->amc_renewal_letter_sent);
        } else {
            $this->amc_renewal_letter_sent = $amc_renewal_letter_sent;
        }
        
        return $this;
    }
    /**
     * Get amc_dupe_check value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmc_dupe_check(): ?string
    {
        return $this->amc_dupe_check ?? null;
    }
    /**
     * Set amc_dupe_check value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amc_dupe_check
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Customer_DataObjectType
     */
    public function setAmc_dupe_check(?string $amc_dupe_check = null): self
    {
        // validation for constraint: string
        if (!is_null($amc_dupe_check) && !is_string($amc_dupe_check)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amc_dupe_check, true), gettype($amc_dupe_check)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($amc_dupe_check) && mb_strlen((string) $amc_dupe_check) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $amc_dupe_check)), __LINE__);
        }
        if (is_null($amc_dupe_check) || (is_array($amc_dupe_check) && empty($amc_dupe_check))) {
            unset($this->amc_dupe_check);
        } else {
            $this->amc_dupe_check = $amc_dupe_check;
        }
        
        return $this;
    }
    /**
     * Get amc_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmc_entity_key(): ?string
    {
        return $this->amc_entity_key ?? null;
    }
    /**
     * Set amc_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amc_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Customer_DataObjectType
     */
    public function setAmc_entity_key(?string $amc_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($amc_entity_key) && !is_string($amc_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amc_entity_key, true), gettype($amc_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($amc_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $amc_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($amc_entity_key, true)), __LINE__);
        }
        if (is_null($amc_entity_key) || (is_array($amc_entity_key) && empty($amc_entity_key))) {
            unset($this->amc_entity_key);
        } else {
            $this->amc_entity_key = $amc_entity_key;
        }
        
        return $this;
    }
    /**
     * Get amc_ivd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmc_ivd_key(): ?string
    {
        return $this->amc_ivd_key ?? null;
    }
    /**
     * Set amc_ivd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amc_ivd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Customer_DataObjectType
     */
    public function setAmc_ivd_key(?string $amc_ivd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($amc_ivd_key) && !is_string($amc_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amc_ivd_key, true), gettype($amc_ivd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($amc_ivd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $amc_ivd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($amc_ivd_key, true)), __LINE__);
        }
        if (is_null($amc_ivd_key) || (is_array($amc_ivd_key) && empty($amc_ivd_key))) {
            unset($this->amc_ivd_key);
        } else {
            $this->amc_ivd_key = $amc_ivd_key;
        }
        
        return $this;
    }
    /**
     * Get amc_ixo_surveycontact_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmc_ixo_surveycontact_key(): ?string
    {
        return $this->amc_ixo_surveycontact_key ?? null;
    }
    /**
     * Set amc_ixo_surveycontact_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amc_ixo_surveycontact_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Customer_DataObjectType
     */
    public function setAmc_ixo_surveycontact_key(?string $amc_ixo_surveycontact_key = null): self
    {
        // validation for constraint: string
        if (!is_null($amc_ixo_surveycontact_key) && !is_string($amc_ixo_surveycontact_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amc_ixo_surveycontact_key, true), gettype($amc_ixo_surveycontact_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($amc_ixo_surveycontact_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $amc_ixo_surveycontact_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($amc_ixo_surveycontact_key, true)), __LINE__);
        }
        if (is_null($amc_ixo_surveycontact_key) || (is_array($amc_ixo_surveycontact_key) && empty($amc_ixo_surveycontact_key))) {
            unset($this->amc_ixo_surveycontact_key);
        } else {
            $this->amc_ixo_surveycontact_key = $amc_ixo_surveycontact_key;
        }
        
        return $this;
    }
    /**
     * Get amc_status_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmc_status_date(): ?string
    {
        return $this->amc_status_date ?? null;
    }
    /**
     * Set amc_status_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amc_status_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Customer_DataObjectType
     */
    public function setAmc_status_date(?string $amc_status_date = null): self
    {
        // validation for constraint: string
        if (!is_null($amc_status_date) && !is_string($amc_status_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amc_status_date, true), gettype($amc_status_date)), __LINE__);
        }
        if (is_null($amc_status_date) || (is_array($amc_status_date) && empty($amc_status_date))) {
            unset($this->amc_status_date);
        } else {
            $this->amc_status_date = $amc_status_date;
        }
        
        return $this;
    }
    /**
     * Get amc_ord_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmc_ord_code(): ?string
    {
        return $this->amc_ord_code ?? null;
    }
    /**
     * Set amc_ord_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amc_ord_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Customer_DataObjectType
     */
    public function setAmc_ord_code(?string $amc_ord_code = null): self
    {
        // validation for constraint: string
        if (!is_null($amc_ord_code) && !is_string($amc_ord_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amc_ord_code, true), gettype($amc_ord_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($amc_ord_code) && mb_strlen((string) $amc_ord_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $amc_ord_code)), __LINE__);
        }
        if (is_null($amc_ord_code) || (is_array($amc_ord_code) && empty($amc_ord_code))) {
            unset($this->amc_ord_code);
        } else {
            $this->amc_ord_code = $amc_ord_code;
        }
        
        return $this;
    }
    /**
     * Get amc_odd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmc_odd_key(): ?string
    {
        return $this->amc_odd_key ?? null;
    }
    /**
     * Set amc_odd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amc_odd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Customer_DataObjectType
     */
    public function setAmc_odd_key(?string $amc_odd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($amc_odd_key) && !is_string($amc_odd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amc_odd_key, true), gettype($amc_odd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($amc_odd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $amc_odd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($amc_odd_key, true)), __LINE__);
        }
        if (is_null($amc_odd_key) || (is_array($amc_odd_key) && empty($amc_odd_key))) {
            unset($this->amc_odd_key);
        } else {
            $this->amc_odd_key = $amc_odd_key;
        }
        
        return $this;
    }
    /**
     * Get amc_bup_prd_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmc_bup_prd_key(): ?string
    {
        return $this->amc_bup_prd_key ?? null;
    }
    /**
     * Set amc_bup_prd_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amc_bup_prd_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Customer_DataObjectType
     */
    public function setAmc_bup_prd_key(?string $amc_bup_prd_key = null): self
    {
        // validation for constraint: string
        if (!is_null($amc_bup_prd_key) && !is_string($amc_bup_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amc_bup_prd_key, true), gettype($amc_bup_prd_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($amc_bup_prd_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $amc_bup_prd_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($amc_bup_prd_key, true)), __LINE__);
        }
        if (is_null($amc_bup_prd_key) || (is_array($amc_bup_prd_key) && empty($amc_bup_prd_key))) {
            unset($this->amc_bup_prd_key);
        } else {
            $this->amc_bup_prd_key = $amc_bup_prd_key;
        }
        
        return $this;
    }
}
