<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccreditationArea_Accreditation_Status_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class AccreditationArea_Accreditation_Status_DataObjectType extends AbstractStructBase
{
    /**
     * The ams_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ams_key = null;
    /**
     * The ams_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ams_add_user = null;
    /**
     * The ams_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ams_add_date = null;
    /**
     * The ams_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ams_change_user = null;
    /**
     * The ams_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ams_change_date = null;
    /**
     * The ams_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ams_delete_flag = null;
    /**
     * The ams_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ams_entity_key = null;
    /**
     * The ams_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ams_key_ext = null;
    /**
     * The ams_desc
     * Meta information extracted from the WSDL
     * - documentation: Status Desc. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 200
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ams_desc = null;
    /**
     * Constructor method for AccreditationArea_Accreditation_Status_DataObjectType
     * @uses AccreditationArea_Accreditation_Status_DataObjectType::setAms_key()
     * @uses AccreditationArea_Accreditation_Status_DataObjectType::setAms_add_user()
     * @uses AccreditationArea_Accreditation_Status_DataObjectType::setAms_add_date()
     * @uses AccreditationArea_Accreditation_Status_DataObjectType::setAms_change_user()
     * @uses AccreditationArea_Accreditation_Status_DataObjectType::setAms_change_date()
     * @uses AccreditationArea_Accreditation_Status_DataObjectType::setAms_delete_flag()
     * @uses AccreditationArea_Accreditation_Status_DataObjectType::setAms_entity_key()
     * @uses AccreditationArea_Accreditation_Status_DataObjectType::setAms_key_ext()
     * @uses AccreditationArea_Accreditation_Status_DataObjectType::setAms_desc()
     * @param string $ams_key
     * @param string $ams_add_user
     * @param string $ams_add_date
     * @param string $ams_change_user
     * @param string $ams_change_date
     * @param string $ams_delete_flag
     * @param string $ams_entity_key
     * @param string $ams_key_ext
     * @param string $ams_desc
     */
    public function __construct(?string $ams_key = null, ?string $ams_add_user = null, ?string $ams_add_date = null, ?string $ams_change_user = null, ?string $ams_change_date = null, ?string $ams_delete_flag = null, ?string $ams_entity_key = null, ?string $ams_key_ext = null, ?string $ams_desc = null)
    {
        $this
            ->setAms_key($ams_key)
            ->setAms_add_user($ams_add_user)
            ->setAms_add_date($ams_add_date)
            ->setAms_change_user($ams_change_user)
            ->setAms_change_date($ams_change_date)
            ->setAms_delete_flag($ams_delete_flag)
            ->setAms_entity_key($ams_entity_key)
            ->setAms_key_ext($ams_key_ext)
            ->setAms_desc($ams_desc);
    }
    /**
     * Get ams_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAms_key(): ?string
    {
        return $this->ams_key ?? null;
    }
    /**
     * Set ams_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ams_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Status_DataObjectType
     */
    public function setAms_key(?string $ams_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ams_key) && !is_string($ams_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ams_key, true), gettype($ams_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ams_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ams_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ams_key, true)), __LINE__);
        }
        if (is_null($ams_key) || (is_array($ams_key) && empty($ams_key))) {
            unset($this->ams_key);
        } else {
            $this->ams_key = $ams_key;
        }
        
        return $this;
    }
    /**
     * Get ams_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAms_add_user(): ?string
    {
        return $this->ams_add_user ?? null;
    }
    /**
     * Set ams_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ams_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Status_DataObjectType
     */
    public function setAms_add_user(?string $ams_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ams_add_user) && !is_string($ams_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ams_add_user, true), gettype($ams_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ams_add_user) && mb_strlen((string) $ams_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ams_add_user)), __LINE__);
        }
        if (is_null($ams_add_user) || (is_array($ams_add_user) && empty($ams_add_user))) {
            unset($this->ams_add_user);
        } else {
            $this->ams_add_user = $ams_add_user;
        }
        
        return $this;
    }
    /**
     * Get ams_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAms_add_date(): ?string
    {
        return $this->ams_add_date ?? null;
    }
    /**
     * Set ams_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ams_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Status_DataObjectType
     */
    public function setAms_add_date(?string $ams_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ams_add_date) && !is_string($ams_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ams_add_date, true), gettype($ams_add_date)), __LINE__);
        }
        if (is_null($ams_add_date) || (is_array($ams_add_date) && empty($ams_add_date))) {
            unset($this->ams_add_date);
        } else {
            $this->ams_add_date = $ams_add_date;
        }
        
        return $this;
    }
    /**
     * Get ams_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAms_change_user(): ?string
    {
        return $this->ams_change_user ?? null;
    }
    /**
     * Set ams_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ams_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Status_DataObjectType
     */
    public function setAms_change_user(?string $ams_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ams_change_user) && !is_string($ams_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ams_change_user, true), gettype($ams_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ams_change_user) && mb_strlen((string) $ams_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ams_change_user)), __LINE__);
        }
        if (is_null($ams_change_user) || (is_array($ams_change_user) && empty($ams_change_user))) {
            unset($this->ams_change_user);
        } else {
            $this->ams_change_user = $ams_change_user;
        }
        
        return $this;
    }
    /**
     * Get ams_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAms_change_date(): ?string
    {
        return $this->ams_change_date ?? null;
    }
    /**
     * Set ams_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ams_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Status_DataObjectType
     */
    public function setAms_change_date(?string $ams_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ams_change_date) && !is_string($ams_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ams_change_date, true), gettype($ams_change_date)), __LINE__);
        }
        if (is_null($ams_change_date) || (is_array($ams_change_date) && empty($ams_change_date))) {
            unset($this->ams_change_date);
        } else {
            $this->ams_change_date = $ams_change_date;
        }
        
        return $this;
    }
    /**
     * Get ams_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAms_delete_flag(): ?string
    {
        return $this->ams_delete_flag ?? null;
    }
    /**
     * Set ams_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ams_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Status_DataObjectType
     */
    public function setAms_delete_flag(?string $ams_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ams_delete_flag) && !is_string($ams_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ams_delete_flag, true), gettype($ams_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ams_delete_flag) && $ams_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ams_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ams_delete_flag) && $ams_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ams_delete_flag, true)), __LINE__);
        }
        if (is_null($ams_delete_flag) || (is_array($ams_delete_flag) && empty($ams_delete_flag))) {
            unset($this->ams_delete_flag);
        } else {
            $this->ams_delete_flag = $ams_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get ams_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAms_entity_key(): ?string
    {
        return $this->ams_entity_key ?? null;
    }
    /**
     * Set ams_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ams_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Status_DataObjectType
     */
    public function setAms_entity_key(?string $ams_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ams_entity_key) && !is_string($ams_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ams_entity_key, true), gettype($ams_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ams_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ams_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ams_entity_key, true)), __LINE__);
        }
        if (is_null($ams_entity_key) || (is_array($ams_entity_key) && empty($ams_entity_key))) {
            unset($this->ams_entity_key);
        } else {
            $this->ams_entity_key = $ams_entity_key;
        }
        
        return $this;
    }
    /**
     * Get ams_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAms_key_ext(): ?string
    {
        return $this->ams_key_ext ?? null;
    }
    /**
     * Set ams_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ams_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Status_DataObjectType
     */
    public function setAms_key_ext(?string $ams_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($ams_key_ext) && !is_string($ams_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ams_key_ext, true), gettype($ams_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ams_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ams_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ams_key_ext, true)), __LINE__);
        }
        if (is_null($ams_key_ext) || (is_array($ams_key_ext) && empty($ams_key_ext))) {
            unset($this->ams_key_ext);
        } else {
            $this->ams_key_ext = $ams_key_ext;
        }
        
        return $this;
    }
    /**
     * Get ams_desc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAms_desc(): ?string
    {
        return $this->ams_desc ?? null;
    }
    /**
     * Set ams_desc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ams_desc
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Accreditation_Status_DataObjectType
     */
    public function setAms_desc(?string $ams_desc = null): self
    {
        // validation for constraint: string
        if (!is_null($ams_desc) && !is_string($ams_desc)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ams_desc, true), gettype($ams_desc)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($ams_desc) && mb_strlen((string) $ams_desc) > 200) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen((string) $ams_desc)), __LINE__);
        }
        if (is_null($ams_desc) || (is_array($ams_desc) && empty($ams_desc))) {
            unset($this->ams_desc);
        } else {
            $this->ams_desc = $ams_desc;
        }
        
        return $this;
    }
}
