<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType extends AbstractStructBase
{
    /**
     * The axo__ixo_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $axo__ixo_key = null;
    /**
     * The axo__ixo_rlt_code
     * Meta information extracted from the WSDL
     * - documentation: Relationship Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $axo__ixo_rlt_code = null;
    /**
     * The axo__ixo_title
     * Meta information extracted from the WSDL
     * - documentation: Title. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 150
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $axo__ixo_title = null;
    /**
     * The axo__ixo_start_date
     * Meta information extracted from the WSDL
     * - documentation: Start Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $axo__ixo_start_date = null;
    /**
     * The axo__ixo_end_date
     * Meta information extracted from the WSDL
     * - documentation: End Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $axo__ixo_end_date = null;
    /**
     * The axo__ixo_ind_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Individual Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $axo__ixo_ind_cst_key = null;
    /**
     * The axo__ixo_org_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Organization Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $axo__ixo_org_cst_key = null;
    /**
     * The axo__ixo_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $axo__ixo_add_date = null;
    /**
     * The axo__ixo_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $axo__ixo_add_user = null;
    /**
     * The axo__ixo_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $axo__ixo_change_date = null;
    /**
     * The axo__ixo_rlt_key
     * Meta information extracted from the WSDL
     * - documentation: Relationship Type Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $axo__ixo_rlt_key = null;
    /**
     * The axo__ixo_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $axo__ixo_change_user = null;
    /**
     * The axo__ixo_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $axo__ixo_delete_flag = null;
    /**
     * The axo__ixo_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $axo__ixo_key_ext = null;
    /**
     * The axo__ixo_cst_key_owner
     * Meta information extracted from the WSDL
     * - documentation: Owning Customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $axo__ixo_cst_key_owner = null;
    /**
     * The axo__ixo_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $axo__ixo_entity_key = null;
    /**
     * The axo__ixo_void_flag
     * Meta information extracted from the WSDL
     * - documentation: Void Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $axo__ixo_void_flag = null;
    /**
     * Constructor method for
     * AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType
     * @uses AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType::setAxo__ixo_key()
     * @uses AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType::setAxo__ixo_rlt_code()
     * @uses AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType::setAxo__ixo_title()
     * @uses AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType::setAxo__ixo_start_date()
     * @uses AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType::setAxo__ixo_end_date()
     * @uses AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType::setAxo__ixo_ind_cst_key()
     * @uses AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType::setAxo__ixo_org_cst_key()
     * @uses AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType::setAxo__ixo_add_date()
     * @uses AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType::setAxo__ixo_add_user()
     * @uses AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType::setAxo__ixo_change_date()
     * @uses AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType::setAxo__ixo_rlt_key()
     * @uses AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType::setAxo__ixo_change_user()
     * @uses AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType::setAxo__ixo_delete_flag()
     * @uses AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType::setAxo__ixo_key_ext()
     * @uses AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType::setAxo__ixo_cst_key_owner()
     * @uses AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType::setAxo__ixo_entity_key()
     * @uses AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType::setAxo__ixo_void_flag()
     * @param string $axo__ixo_key
     * @param string $axo__ixo_rlt_code
     * @param string $axo__ixo_title
     * @param string $axo__ixo_start_date
     * @param string $axo__ixo_end_date
     * @param string $axo__ixo_ind_cst_key
     * @param string $axo__ixo_org_cst_key
     * @param string $axo__ixo_add_date
     * @param string $axo__ixo_add_user
     * @param string $axo__ixo_change_date
     * @param string $axo__ixo_rlt_key
     * @param string $axo__ixo_change_user
     * @param string $axo__ixo_delete_flag
     * @param string $axo__ixo_key_ext
     * @param string $axo__ixo_cst_key_owner
     * @param string $axo__ixo_entity_key
     * @param string $axo__ixo_void_flag
     */
    public function __construct(?string $axo__ixo_key = null, ?string $axo__ixo_rlt_code = null, ?string $axo__ixo_title = null, ?string $axo__ixo_start_date = null, ?string $axo__ixo_end_date = null, ?string $axo__ixo_ind_cst_key = null, ?string $axo__ixo_org_cst_key = null, ?string $axo__ixo_add_date = null, ?string $axo__ixo_add_user = null, ?string $axo__ixo_change_date = null, ?string $axo__ixo_rlt_key = null, ?string $axo__ixo_change_user = null, ?string $axo__ixo_delete_flag = null, ?string $axo__ixo_key_ext = null, ?string $axo__ixo_cst_key_owner = null, ?string $axo__ixo_entity_key = null, ?string $axo__ixo_void_flag = null)
    {
        $this
            ->setAxo__ixo_key($axo__ixo_key)
            ->setAxo__ixo_rlt_code($axo__ixo_rlt_code)
            ->setAxo__ixo_title($axo__ixo_title)
            ->setAxo__ixo_start_date($axo__ixo_start_date)
            ->setAxo__ixo_end_date($axo__ixo_end_date)
            ->setAxo__ixo_ind_cst_key($axo__ixo_ind_cst_key)
            ->setAxo__ixo_org_cst_key($axo__ixo_org_cst_key)
            ->setAxo__ixo_add_date($axo__ixo_add_date)
            ->setAxo__ixo_add_user($axo__ixo_add_user)
            ->setAxo__ixo_change_date($axo__ixo_change_date)
            ->setAxo__ixo_rlt_key($axo__ixo_rlt_key)
            ->setAxo__ixo_change_user($axo__ixo_change_user)
            ->setAxo__ixo_delete_flag($axo__ixo_delete_flag)
            ->setAxo__ixo_key_ext($axo__ixo_key_ext)
            ->setAxo__ixo_cst_key_owner($axo__ixo_cst_key_owner)
            ->setAxo__ixo_entity_key($axo__ixo_entity_key)
            ->setAxo__ixo_void_flag($axo__ixo_void_flag);
    }
    /**
     * Get axo__ixo_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAxo__ixo_key(): ?string
    {
        return $this->axo__ixo_key ?? null;
    }
    /**
     * Set axo__ixo_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $axo__ixo_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType
     */
    public function setAxo__ixo_key(?string $axo__ixo_key = null): self
    {
        // validation for constraint: string
        if (!is_null($axo__ixo_key) && !is_string($axo__ixo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($axo__ixo_key, true), gettype($axo__ixo_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($axo__ixo_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $axo__ixo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($axo__ixo_key, true)), __LINE__);
        }
        if (is_null($axo__ixo_key) || (is_array($axo__ixo_key) && empty($axo__ixo_key))) {
            unset($this->axo__ixo_key);
        } else {
            $this->axo__ixo_key = $axo__ixo_key;
        }
        
        return $this;
    }
    /**
     * Get axo__ixo_rlt_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAxo__ixo_rlt_code(): ?string
    {
        return $this->axo__ixo_rlt_code ?? null;
    }
    /**
     * Set axo__ixo_rlt_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $axo__ixo_rlt_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType
     */
    public function setAxo__ixo_rlt_code(?string $axo__ixo_rlt_code = null): self
    {
        // validation for constraint: string
        if (!is_null($axo__ixo_rlt_code) && !is_string($axo__ixo_rlt_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($axo__ixo_rlt_code, true), gettype($axo__ixo_rlt_code)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($axo__ixo_rlt_code) && mb_strlen((string) $axo__ixo_rlt_code) > 80) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen((string) $axo__ixo_rlt_code)), __LINE__);
        }
        if (is_null($axo__ixo_rlt_code) || (is_array($axo__ixo_rlt_code) && empty($axo__ixo_rlt_code))) {
            unset($this->axo__ixo_rlt_code);
        } else {
            $this->axo__ixo_rlt_code = $axo__ixo_rlt_code;
        }
        
        return $this;
    }
    /**
     * Get axo__ixo_title value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAxo__ixo_title(): ?string
    {
        return $this->axo__ixo_title ?? null;
    }
    /**
     * Set axo__ixo_title value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $axo__ixo_title
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType
     */
    public function setAxo__ixo_title(?string $axo__ixo_title = null): self
    {
        // validation for constraint: string
        if (!is_null($axo__ixo_title) && !is_string($axo__ixo_title)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($axo__ixo_title, true), gettype($axo__ixo_title)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($axo__ixo_title) && mb_strlen((string) $axo__ixo_title) > 150) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen((string) $axo__ixo_title)), __LINE__);
        }
        if (is_null($axo__ixo_title) || (is_array($axo__ixo_title) && empty($axo__ixo_title))) {
            unset($this->axo__ixo_title);
        } else {
            $this->axo__ixo_title = $axo__ixo_title;
        }
        
        return $this;
    }
    /**
     * Get axo__ixo_start_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAxo__ixo_start_date(): ?string
    {
        return $this->axo__ixo_start_date ?? null;
    }
    /**
     * Set axo__ixo_start_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $axo__ixo_start_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType
     */
    public function setAxo__ixo_start_date(?string $axo__ixo_start_date = null): self
    {
        // validation for constraint: string
        if (!is_null($axo__ixo_start_date) && !is_string($axo__ixo_start_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($axo__ixo_start_date, true), gettype($axo__ixo_start_date)), __LINE__);
        }
        if (is_null($axo__ixo_start_date) || (is_array($axo__ixo_start_date) && empty($axo__ixo_start_date))) {
            unset($this->axo__ixo_start_date);
        } else {
            $this->axo__ixo_start_date = $axo__ixo_start_date;
        }
        
        return $this;
    }
    /**
     * Get axo__ixo_end_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAxo__ixo_end_date(): ?string
    {
        return $this->axo__ixo_end_date ?? null;
    }
    /**
     * Set axo__ixo_end_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $axo__ixo_end_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType
     */
    public function setAxo__ixo_end_date(?string $axo__ixo_end_date = null): self
    {
        // validation for constraint: string
        if (!is_null($axo__ixo_end_date) && !is_string($axo__ixo_end_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($axo__ixo_end_date, true), gettype($axo__ixo_end_date)), __LINE__);
        }
        if (is_null($axo__ixo_end_date) || (is_array($axo__ixo_end_date) && empty($axo__ixo_end_date))) {
            unset($this->axo__ixo_end_date);
        } else {
            $this->axo__ixo_end_date = $axo__ixo_end_date;
        }
        
        return $this;
    }
    /**
     * Get axo__ixo_ind_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAxo__ixo_ind_cst_key(): ?string
    {
        return $this->axo__ixo_ind_cst_key ?? null;
    }
    /**
     * Set axo__ixo_ind_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $axo__ixo_ind_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType
     */
    public function setAxo__ixo_ind_cst_key(?string $axo__ixo_ind_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($axo__ixo_ind_cst_key) && !is_string($axo__ixo_ind_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($axo__ixo_ind_cst_key, true), gettype($axo__ixo_ind_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($axo__ixo_ind_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $axo__ixo_ind_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($axo__ixo_ind_cst_key, true)), __LINE__);
        }
        if (is_null($axo__ixo_ind_cst_key) || (is_array($axo__ixo_ind_cst_key) && empty($axo__ixo_ind_cst_key))) {
            unset($this->axo__ixo_ind_cst_key);
        } else {
            $this->axo__ixo_ind_cst_key = $axo__ixo_ind_cst_key;
        }
        
        return $this;
    }
    /**
     * Get axo__ixo_org_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAxo__ixo_org_cst_key(): ?string
    {
        return $this->axo__ixo_org_cst_key ?? null;
    }
    /**
     * Set axo__ixo_org_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $axo__ixo_org_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType
     */
    public function setAxo__ixo_org_cst_key(?string $axo__ixo_org_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($axo__ixo_org_cst_key) && !is_string($axo__ixo_org_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($axo__ixo_org_cst_key, true), gettype($axo__ixo_org_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($axo__ixo_org_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $axo__ixo_org_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($axo__ixo_org_cst_key, true)), __LINE__);
        }
        if (is_null($axo__ixo_org_cst_key) || (is_array($axo__ixo_org_cst_key) && empty($axo__ixo_org_cst_key))) {
            unset($this->axo__ixo_org_cst_key);
        } else {
            $this->axo__ixo_org_cst_key = $axo__ixo_org_cst_key;
        }
        
        return $this;
    }
    /**
     * Get axo__ixo_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAxo__ixo_add_date(): ?string
    {
        return $this->axo__ixo_add_date ?? null;
    }
    /**
     * Set axo__ixo_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $axo__ixo_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType
     */
    public function setAxo__ixo_add_date(?string $axo__ixo_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($axo__ixo_add_date) && !is_string($axo__ixo_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($axo__ixo_add_date, true), gettype($axo__ixo_add_date)), __LINE__);
        }
        if (is_null($axo__ixo_add_date) || (is_array($axo__ixo_add_date) && empty($axo__ixo_add_date))) {
            unset($this->axo__ixo_add_date);
        } else {
            $this->axo__ixo_add_date = $axo__ixo_add_date;
        }
        
        return $this;
    }
    /**
     * Get axo__ixo_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAxo__ixo_add_user(): ?string
    {
        return $this->axo__ixo_add_user ?? null;
    }
    /**
     * Set axo__ixo_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $axo__ixo_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType
     */
    public function setAxo__ixo_add_user(?string $axo__ixo_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($axo__ixo_add_user) && !is_string($axo__ixo_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($axo__ixo_add_user, true), gettype($axo__ixo_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($axo__ixo_add_user) && mb_strlen((string) $axo__ixo_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $axo__ixo_add_user)), __LINE__);
        }
        if (is_null($axo__ixo_add_user) || (is_array($axo__ixo_add_user) && empty($axo__ixo_add_user))) {
            unset($this->axo__ixo_add_user);
        } else {
            $this->axo__ixo_add_user = $axo__ixo_add_user;
        }
        
        return $this;
    }
    /**
     * Get axo__ixo_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAxo__ixo_change_date(): ?string
    {
        return $this->axo__ixo_change_date ?? null;
    }
    /**
     * Set axo__ixo_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $axo__ixo_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType
     */
    public function setAxo__ixo_change_date(?string $axo__ixo_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($axo__ixo_change_date) && !is_string($axo__ixo_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($axo__ixo_change_date, true), gettype($axo__ixo_change_date)), __LINE__);
        }
        if (is_null($axo__ixo_change_date) || (is_array($axo__ixo_change_date) && empty($axo__ixo_change_date))) {
            unset($this->axo__ixo_change_date);
        } else {
            $this->axo__ixo_change_date = $axo__ixo_change_date;
        }
        
        return $this;
    }
    /**
     * Get axo__ixo_rlt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAxo__ixo_rlt_key(): ?string
    {
        return $this->axo__ixo_rlt_key ?? null;
    }
    /**
     * Set axo__ixo_rlt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $axo__ixo_rlt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType
     */
    public function setAxo__ixo_rlt_key(?string $axo__ixo_rlt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($axo__ixo_rlt_key) && !is_string($axo__ixo_rlt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($axo__ixo_rlt_key, true), gettype($axo__ixo_rlt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($axo__ixo_rlt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $axo__ixo_rlt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($axo__ixo_rlt_key, true)), __LINE__);
        }
        if (is_null($axo__ixo_rlt_key) || (is_array($axo__ixo_rlt_key) && empty($axo__ixo_rlt_key))) {
            unset($this->axo__ixo_rlt_key);
        } else {
            $this->axo__ixo_rlt_key = $axo__ixo_rlt_key;
        }
        
        return $this;
    }
    /**
     * Get axo__ixo_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAxo__ixo_change_user(): ?string
    {
        return $this->axo__ixo_change_user ?? null;
    }
    /**
     * Set axo__ixo_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $axo__ixo_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType
     */
    public function setAxo__ixo_change_user(?string $axo__ixo_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($axo__ixo_change_user) && !is_string($axo__ixo_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($axo__ixo_change_user, true), gettype($axo__ixo_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($axo__ixo_change_user) && mb_strlen((string) $axo__ixo_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $axo__ixo_change_user)), __LINE__);
        }
        if (is_null($axo__ixo_change_user) || (is_array($axo__ixo_change_user) && empty($axo__ixo_change_user))) {
            unset($this->axo__ixo_change_user);
        } else {
            $this->axo__ixo_change_user = $axo__ixo_change_user;
        }
        
        return $this;
    }
    /**
     * Get axo__ixo_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAxo__ixo_delete_flag(): ?string
    {
        return $this->axo__ixo_delete_flag ?? null;
    }
    /**
     * Set axo__ixo_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $axo__ixo_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType
     */
    public function setAxo__ixo_delete_flag(?string $axo__ixo_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($axo__ixo_delete_flag) && !is_string($axo__ixo_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($axo__ixo_delete_flag, true), gettype($axo__ixo_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($axo__ixo_delete_flag) && $axo__ixo_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($axo__ixo_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($axo__ixo_delete_flag) && $axo__ixo_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($axo__ixo_delete_flag, true)), __LINE__);
        }
        if (is_null($axo__ixo_delete_flag) || (is_array($axo__ixo_delete_flag) && empty($axo__ixo_delete_flag))) {
            unset($this->axo__ixo_delete_flag);
        } else {
            $this->axo__ixo_delete_flag = $axo__ixo_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get axo__ixo_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAxo__ixo_key_ext(): ?string
    {
        return $this->axo__ixo_key_ext ?? null;
    }
    /**
     * Set axo__ixo_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $axo__ixo_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType
     */
    public function setAxo__ixo_key_ext(?string $axo__ixo_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($axo__ixo_key_ext) && !is_string($axo__ixo_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($axo__ixo_key_ext, true), gettype($axo__ixo_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($axo__ixo_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $axo__ixo_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($axo__ixo_key_ext, true)), __LINE__);
        }
        if (is_null($axo__ixo_key_ext) || (is_array($axo__ixo_key_ext) && empty($axo__ixo_key_ext))) {
            unset($this->axo__ixo_key_ext);
        } else {
            $this->axo__ixo_key_ext = $axo__ixo_key_ext;
        }
        
        return $this;
    }
    /**
     * Get axo__ixo_cst_key_owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAxo__ixo_cst_key_owner(): ?string
    {
        return $this->axo__ixo_cst_key_owner ?? null;
    }
    /**
     * Set axo__ixo_cst_key_owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $axo__ixo_cst_key_owner
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType
     */
    public function setAxo__ixo_cst_key_owner(?string $axo__ixo_cst_key_owner = null): self
    {
        // validation for constraint: string
        if (!is_null($axo__ixo_cst_key_owner) && !is_string($axo__ixo_cst_key_owner)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($axo__ixo_cst_key_owner, true), gettype($axo__ixo_cst_key_owner)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($axo__ixo_cst_key_owner) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $axo__ixo_cst_key_owner)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($axo__ixo_cst_key_owner, true)), __LINE__);
        }
        if (is_null($axo__ixo_cst_key_owner) || (is_array($axo__ixo_cst_key_owner) && empty($axo__ixo_cst_key_owner))) {
            unset($this->axo__ixo_cst_key_owner);
        } else {
            $this->axo__ixo_cst_key_owner = $axo__ixo_cst_key_owner;
        }
        
        return $this;
    }
    /**
     * Get axo__ixo_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAxo__ixo_entity_key(): ?string
    {
        return $this->axo__ixo_entity_key ?? null;
    }
    /**
     * Set axo__ixo_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $axo__ixo_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType
     */
    public function setAxo__ixo_entity_key(?string $axo__ixo_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($axo__ixo_entity_key) && !is_string($axo__ixo_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($axo__ixo_entity_key, true), gettype($axo__ixo_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($axo__ixo_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $axo__ixo_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($axo__ixo_entity_key, true)), __LINE__);
        }
        if (is_null($axo__ixo_entity_key) || (is_array($axo__ixo_entity_key) && empty($axo__ixo_entity_key))) {
            unset($this->axo__ixo_entity_key);
        } else {
            $this->axo__ixo_entity_key = $axo__ixo_entity_key;
        }
        
        return $this;
    }
    /**
     * Get axo__ixo_void_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAxo__ixo_void_flag(): ?string
    {
        return $this->axo__ixo_void_flag ?? null;
    }
    /**
     * Set axo__ixo_void_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $axo__ixo_void_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\AccreditationArea_Individual_Organization_CAO_Affiliation_DataObjectType
     */
    public function setAxo__ixo_void_flag(?string $axo__ixo_void_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($axo__ixo_void_flag) && !is_string($axo__ixo_void_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($axo__ixo_void_flag, true), gettype($axo__ixo_void_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($axo__ixo_void_flag) && $axo__ixo_void_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($axo__ixo_void_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($axo__ixo_void_flag) && $axo__ixo_void_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($axo__ixo_void_flag, true)), __LINE__);
        }
        if (is_null($axo__ixo_void_flag) || (is_array($axo__ixo_void_flag) && empty($axo__ixo_void_flag))) {
            unset($this->axo__ixo_void_flag);
        } else {
            $this->axo__ixo_void_flag = $axo__ixo_void_flag;
        }
        
        return $this;
    }
}
