<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CentralizedOrderEntry_Company-Business_Unit_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class CentralizedOrderEntry_Company_Business_Unit_DataObjectType extends AbstractStructBase
{
    /**
     * The atc_code
     * Meta information extracted from the WSDL
     * - documentation: Business Unit. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $atc_code = null;
    /**
     * The atc_name
     * Meta information extracted from the WSDL
     * - documentation: Unit Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 90
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $atc_name = null;
    /**
     * The atc_asn_code
     * Meta information extracted from the WSDL
     * - documentation: Association. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $atc_asn_code = null;
    /**
     * The atc_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $atc_add_user = null;
    /**
     * The atc_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $atc_add_date = null;
    /**
     * The atc_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $atc_change_user = null;
    /**
     * The atc_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $atc_change_date = null;
    /**
     * The atc_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $atc_delete_flag = null;
    /**
     * The atc_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $atc_key = null;
    /**
     * The atc_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $atc_key_ext = null;
    /**
     * The atc_gla_revenue_key
     * Meta information extracted from the WSDL
     * - documentation: Default Revenue Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $atc_gla_revenue_key = null;
    /**
     * The atc_gla_liability_key
     * Meta information extracted from the WSDL
     * - documentation: Default Liability Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $atc_gla_liability_key = null;
    /**
     * The atc_gla_return_key
     * Meta information extracted from the WSDL
     * - documentation: Default Return Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $atc_gla_return_key = null;
    /**
     * The atc_gla_deferred_key
     * Meta information extracted from the WSDL
     * - documentation: Default Deferred Revenue Accou. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $atc_gla_deferred_key = null;
    /**
     * The atc_gla_writeoff_key
     * Meta information extracted from the WSDL
     * - documentation: Default Writeoff Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $atc_gla_writeoff_key = null;
    /**
     * The atc_gla_inventory_key
     * Meta information extracted from the WSDL
     * - documentation: Default Inventory Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $atc_gla_inventory_key = null;
    /**
     * The atc_gla_cogs_key
     * Meta information extracted from the WSDL
     * - documentation: Default COGS Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $atc_gla_cogs_key = null;
    /**
     * The atc_gla_ar_key
     * Meta information extracted from the WSDL
     * - documentation: Default A/R Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $atc_gla_ar_key = null;
    /**
     * The atc_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $atc_entity_key = null;
    /**
     * The atc_gla_overpayment_key
     * Meta information extracted from the WSDL
     * - documentation: Overpayment Liability Account. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $atc_gla_overpayment_key = null;
    /**
     * The atc_ait_key
     * Meta information extracted from the WSDL
     * - documentation: Terms. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $atc_ait_key = null;
    /**
     * The atc_currency_code
     * Meta information extracted from the WSDL
     * - documentation: Currency Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $atc_currency_code = null;
    /**
     * The atc_gla_realized_gain_key
     * Meta information extracted from the WSDL
     * - documentation: Realized Gain. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $atc_gla_realized_gain_key = null;
    /**
     * The atc_gla_realized_loss_key
     * Meta information extracted from the WSDL
     * - documentation: Realized Loss. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $atc_gla_realized_loss_key = null;
    /**
     * The atc_gla_rounding_key
     * Meta information extracted from the WSDL
     * - documentation: Rounding. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $atc_gla_rounding_key = null;
    /**
     * The atc_tax_id
     * Meta information extracted from the WSDL
     * - documentation: Tax ID. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $atc_tax_id = null;
    /**
     * The atc_nsf_prc_key
     * Meta information extracted from the WSDL
     * - documentation: Default NSF Fee. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $atc_nsf_prc_key = null;
    /**
     * Constructor method for
     * CentralizedOrderEntry_Company-Business_Unit_DataObjectType
     * @uses CentralizedOrderEntry_Company_Business_Unit_DataObjectType::setAtc_code()
     * @uses CentralizedOrderEntry_Company_Business_Unit_DataObjectType::setAtc_name()
     * @uses CentralizedOrderEntry_Company_Business_Unit_DataObjectType::setAtc_asn_code()
     * @uses CentralizedOrderEntry_Company_Business_Unit_DataObjectType::setAtc_add_user()
     * @uses CentralizedOrderEntry_Company_Business_Unit_DataObjectType::setAtc_add_date()
     * @uses CentralizedOrderEntry_Company_Business_Unit_DataObjectType::setAtc_change_user()
     * @uses CentralizedOrderEntry_Company_Business_Unit_DataObjectType::setAtc_change_date()
     * @uses CentralizedOrderEntry_Company_Business_Unit_DataObjectType::setAtc_delete_flag()
     * @uses CentralizedOrderEntry_Company_Business_Unit_DataObjectType::setAtc_key()
     * @uses CentralizedOrderEntry_Company_Business_Unit_DataObjectType::setAtc_key_ext()
     * @uses CentralizedOrderEntry_Company_Business_Unit_DataObjectType::setAtc_gla_revenue_key()
     * @uses CentralizedOrderEntry_Company_Business_Unit_DataObjectType::setAtc_gla_liability_key()
     * @uses CentralizedOrderEntry_Company_Business_Unit_DataObjectType::setAtc_gla_return_key()
     * @uses CentralizedOrderEntry_Company_Business_Unit_DataObjectType::setAtc_gla_deferred_key()
     * @uses CentralizedOrderEntry_Company_Business_Unit_DataObjectType::setAtc_gla_writeoff_key()
     * @uses CentralizedOrderEntry_Company_Business_Unit_DataObjectType::setAtc_gla_inventory_key()
     * @uses CentralizedOrderEntry_Company_Business_Unit_DataObjectType::setAtc_gla_cogs_key()
     * @uses CentralizedOrderEntry_Company_Business_Unit_DataObjectType::setAtc_gla_ar_key()
     * @uses CentralizedOrderEntry_Company_Business_Unit_DataObjectType::setAtc_entity_key()
     * @uses CentralizedOrderEntry_Company_Business_Unit_DataObjectType::setAtc_gla_overpayment_key()
     * @uses CentralizedOrderEntry_Company_Business_Unit_DataObjectType::setAtc_ait_key()
     * @uses CentralizedOrderEntry_Company_Business_Unit_DataObjectType::setAtc_currency_code()
     * @uses CentralizedOrderEntry_Company_Business_Unit_DataObjectType::setAtc_gla_realized_gain_key()
     * @uses CentralizedOrderEntry_Company_Business_Unit_DataObjectType::setAtc_gla_realized_loss_key()
     * @uses CentralizedOrderEntry_Company_Business_Unit_DataObjectType::setAtc_gla_rounding_key()
     * @uses CentralizedOrderEntry_Company_Business_Unit_DataObjectType::setAtc_tax_id()
     * @uses CentralizedOrderEntry_Company_Business_Unit_DataObjectType::setAtc_nsf_prc_key()
     * @param string $atc_code
     * @param string $atc_name
     * @param string $atc_asn_code
     * @param string $atc_add_user
     * @param string $atc_add_date
     * @param string $atc_change_user
     * @param string $atc_change_date
     * @param string $atc_delete_flag
     * @param string $atc_key
     * @param string $atc_key_ext
     * @param string $atc_gla_revenue_key
     * @param string $atc_gla_liability_key
     * @param string $atc_gla_return_key
     * @param string $atc_gla_deferred_key
     * @param string $atc_gla_writeoff_key
     * @param string $atc_gla_inventory_key
     * @param string $atc_gla_cogs_key
     * @param string $atc_gla_ar_key
     * @param string $atc_entity_key
     * @param string $atc_gla_overpayment_key
     * @param string $atc_ait_key
     * @param string $atc_currency_code
     * @param string $atc_gla_realized_gain_key
     * @param string $atc_gla_realized_loss_key
     * @param string $atc_gla_rounding_key
     * @param string $atc_tax_id
     * @param string $atc_nsf_prc_key
     */
    public function __construct(?string $atc_code = null, ?string $atc_name = null, ?string $atc_asn_code = null, ?string $atc_add_user = null, ?string $atc_add_date = null, ?string $atc_change_user = null, ?string $atc_change_date = null, ?string $atc_delete_flag = null, ?string $atc_key = null, ?string $atc_key_ext = null, ?string $atc_gla_revenue_key = null, ?string $atc_gla_liability_key = null, ?string $atc_gla_return_key = null, ?string $atc_gla_deferred_key = null, ?string $atc_gla_writeoff_key = null, ?string $atc_gla_inventory_key = null, ?string $atc_gla_cogs_key = null, ?string $atc_gla_ar_key = null, ?string $atc_entity_key = null, ?string $atc_gla_overpayment_key = null, ?string $atc_ait_key = null, ?string $atc_currency_code = null, ?string $atc_gla_realized_gain_key = null, ?string $atc_gla_realized_loss_key = null, ?string $atc_gla_rounding_key = null, ?string $atc_tax_id = null, ?string $atc_nsf_prc_key = null)
    {
        $this
            ->setAtc_code($atc_code)
            ->setAtc_name($atc_name)
            ->setAtc_asn_code($atc_asn_code)
            ->setAtc_add_user($atc_add_user)
            ->setAtc_add_date($atc_add_date)
            ->setAtc_change_user($atc_change_user)
            ->setAtc_change_date($atc_change_date)
            ->setAtc_delete_flag($atc_delete_flag)
            ->setAtc_key($atc_key)
            ->setAtc_key_ext($atc_key_ext)
            ->setAtc_gla_revenue_key($atc_gla_revenue_key)
            ->setAtc_gla_liability_key($atc_gla_liability_key)
            ->setAtc_gla_return_key($atc_gla_return_key)
            ->setAtc_gla_deferred_key($atc_gla_deferred_key)
            ->setAtc_gla_writeoff_key($atc_gla_writeoff_key)
            ->setAtc_gla_inventory_key($atc_gla_inventory_key)
            ->setAtc_gla_cogs_key($atc_gla_cogs_key)
            ->setAtc_gla_ar_key($atc_gla_ar_key)
            ->setAtc_entity_key($atc_entity_key)
            ->setAtc_gla_overpayment_key($atc_gla_overpayment_key)
            ->setAtc_ait_key($atc_ait_key)
            ->setAtc_currency_code($atc_currency_code)
            ->setAtc_gla_realized_gain_key($atc_gla_realized_gain_key)
            ->setAtc_gla_realized_loss_key($atc_gla_realized_loss_key)
            ->setAtc_gla_rounding_key($atc_gla_rounding_key)
            ->setAtc_tax_id($atc_tax_id)
            ->setAtc_nsf_prc_key($atc_nsf_prc_key);
    }
    /**
     * Get atc_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAtc_code(): ?string
    {
        return $this->atc_code ?? null;
    }
    /**
     * Set atc_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $atc_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Company_Business_Unit_DataObjectType
     */
    public function setAtc_code(?string $atc_code = null): self
    {
        // validation for constraint: string
        if (!is_null($atc_code) && !is_string($atc_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($atc_code, true), gettype($atc_code)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($atc_code) && mb_strlen((string) $atc_code) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $atc_code)), __LINE__);
        }
        if (is_null($atc_code) || (is_array($atc_code) && empty($atc_code))) {
            unset($this->atc_code);
        } else {
            $this->atc_code = $atc_code;
        }
        
        return $this;
    }
    /**
     * Get atc_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAtc_name(): ?string
    {
        return $this->atc_name ?? null;
    }
    /**
     * Set atc_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $atc_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Company_Business_Unit_DataObjectType
     */
    public function setAtc_name(?string $atc_name = null): self
    {
        // validation for constraint: string
        if (!is_null($atc_name) && !is_string($atc_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($atc_name, true), gettype($atc_name)), __LINE__);
        }
        // validation for constraint: maxLength(90)
        if (!is_null($atc_name) && mb_strlen((string) $atc_name) > 90) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 90', mb_strlen((string) $atc_name)), __LINE__);
        }
        if (is_null($atc_name) || (is_array($atc_name) && empty($atc_name))) {
            unset($this->atc_name);
        } else {
            $this->atc_name = $atc_name;
        }
        
        return $this;
    }
    /**
     * Get atc_asn_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAtc_asn_code(): ?string
    {
        return $this->atc_asn_code ?? null;
    }
    /**
     * Set atc_asn_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $atc_asn_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Company_Business_Unit_DataObjectType
     */
    public function setAtc_asn_code(?string $atc_asn_code = null): self
    {
        // validation for constraint: string
        if (!is_null($atc_asn_code) && !is_string($atc_asn_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($atc_asn_code, true), gettype($atc_asn_code)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($atc_asn_code) && mb_strlen((string) $atc_asn_code) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $atc_asn_code)), __LINE__);
        }
        if (is_null($atc_asn_code) || (is_array($atc_asn_code) && empty($atc_asn_code))) {
            unset($this->atc_asn_code);
        } else {
            $this->atc_asn_code = $atc_asn_code;
        }
        
        return $this;
    }
    /**
     * Get atc_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAtc_add_user(): ?string
    {
        return $this->atc_add_user ?? null;
    }
    /**
     * Set atc_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $atc_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Company_Business_Unit_DataObjectType
     */
    public function setAtc_add_user(?string $atc_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($atc_add_user) && !is_string($atc_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($atc_add_user, true), gettype($atc_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($atc_add_user) && mb_strlen((string) $atc_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $atc_add_user)), __LINE__);
        }
        if (is_null($atc_add_user) || (is_array($atc_add_user) && empty($atc_add_user))) {
            unset($this->atc_add_user);
        } else {
            $this->atc_add_user = $atc_add_user;
        }
        
        return $this;
    }
    /**
     * Get atc_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAtc_add_date(): ?string
    {
        return $this->atc_add_date ?? null;
    }
    /**
     * Set atc_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $atc_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Company_Business_Unit_DataObjectType
     */
    public function setAtc_add_date(?string $atc_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($atc_add_date) && !is_string($atc_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($atc_add_date, true), gettype($atc_add_date)), __LINE__);
        }
        if (is_null($atc_add_date) || (is_array($atc_add_date) && empty($atc_add_date))) {
            unset($this->atc_add_date);
        } else {
            $this->atc_add_date = $atc_add_date;
        }
        
        return $this;
    }
    /**
     * Get atc_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAtc_change_user(): ?string
    {
        return $this->atc_change_user ?? null;
    }
    /**
     * Set atc_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $atc_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Company_Business_Unit_DataObjectType
     */
    public function setAtc_change_user(?string $atc_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($atc_change_user) && !is_string($atc_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($atc_change_user, true), gettype($atc_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($atc_change_user) && mb_strlen((string) $atc_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $atc_change_user)), __LINE__);
        }
        if (is_null($atc_change_user) || (is_array($atc_change_user) && empty($atc_change_user))) {
            unset($this->atc_change_user);
        } else {
            $this->atc_change_user = $atc_change_user;
        }
        
        return $this;
    }
    /**
     * Get atc_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAtc_change_date(): ?string
    {
        return $this->atc_change_date ?? null;
    }
    /**
     * Set atc_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $atc_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Company_Business_Unit_DataObjectType
     */
    public function setAtc_change_date(?string $atc_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($atc_change_date) && !is_string($atc_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($atc_change_date, true), gettype($atc_change_date)), __LINE__);
        }
        if (is_null($atc_change_date) || (is_array($atc_change_date) && empty($atc_change_date))) {
            unset($this->atc_change_date);
        } else {
            $this->atc_change_date = $atc_change_date;
        }
        
        return $this;
    }
    /**
     * Get atc_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAtc_delete_flag(): ?string
    {
        return $this->atc_delete_flag ?? null;
    }
    /**
     * Set atc_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $atc_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Company_Business_Unit_DataObjectType
     */
    public function setAtc_delete_flag(?string $atc_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($atc_delete_flag) && !is_string($atc_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($atc_delete_flag, true), gettype($atc_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($atc_delete_flag) && $atc_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($atc_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($atc_delete_flag) && $atc_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($atc_delete_flag, true)), __LINE__);
        }
        if (is_null($atc_delete_flag) || (is_array($atc_delete_flag) && empty($atc_delete_flag))) {
            unset($this->atc_delete_flag);
        } else {
            $this->atc_delete_flag = $atc_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get atc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAtc_key(): ?string
    {
        return $this->atc_key ?? null;
    }
    /**
     * Set atc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $atc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Company_Business_Unit_DataObjectType
     */
    public function setAtc_key(?string $atc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($atc_key) && !is_string($atc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($atc_key, true), gettype($atc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($atc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $atc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($atc_key, true)), __LINE__);
        }
        if (is_null($atc_key) || (is_array($atc_key) && empty($atc_key))) {
            unset($this->atc_key);
        } else {
            $this->atc_key = $atc_key;
        }
        
        return $this;
    }
    /**
     * Get atc_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAtc_key_ext(): ?string
    {
        return $this->atc_key_ext ?? null;
    }
    /**
     * Set atc_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $atc_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Company_Business_Unit_DataObjectType
     */
    public function setAtc_key_ext(?string $atc_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($atc_key_ext) && !is_string($atc_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($atc_key_ext, true), gettype($atc_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($atc_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $atc_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($atc_key_ext, true)), __LINE__);
        }
        if (is_null($atc_key_ext) || (is_array($atc_key_ext) && empty($atc_key_ext))) {
            unset($this->atc_key_ext);
        } else {
            $this->atc_key_ext = $atc_key_ext;
        }
        
        return $this;
    }
    /**
     * Get atc_gla_revenue_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAtc_gla_revenue_key(): ?string
    {
        return $this->atc_gla_revenue_key ?? null;
    }
    /**
     * Set atc_gla_revenue_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $atc_gla_revenue_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Company_Business_Unit_DataObjectType
     */
    public function setAtc_gla_revenue_key(?string $atc_gla_revenue_key = null): self
    {
        // validation for constraint: string
        if (!is_null($atc_gla_revenue_key) && !is_string($atc_gla_revenue_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($atc_gla_revenue_key, true), gettype($atc_gla_revenue_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($atc_gla_revenue_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $atc_gla_revenue_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($atc_gla_revenue_key, true)), __LINE__);
        }
        if (is_null($atc_gla_revenue_key) || (is_array($atc_gla_revenue_key) && empty($atc_gla_revenue_key))) {
            unset($this->atc_gla_revenue_key);
        } else {
            $this->atc_gla_revenue_key = $atc_gla_revenue_key;
        }
        
        return $this;
    }
    /**
     * Get atc_gla_liability_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAtc_gla_liability_key(): ?string
    {
        return $this->atc_gla_liability_key ?? null;
    }
    /**
     * Set atc_gla_liability_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $atc_gla_liability_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Company_Business_Unit_DataObjectType
     */
    public function setAtc_gla_liability_key(?string $atc_gla_liability_key = null): self
    {
        // validation for constraint: string
        if (!is_null($atc_gla_liability_key) && !is_string($atc_gla_liability_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($atc_gla_liability_key, true), gettype($atc_gla_liability_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($atc_gla_liability_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $atc_gla_liability_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($atc_gla_liability_key, true)), __LINE__);
        }
        if (is_null($atc_gla_liability_key) || (is_array($atc_gla_liability_key) && empty($atc_gla_liability_key))) {
            unset($this->atc_gla_liability_key);
        } else {
            $this->atc_gla_liability_key = $atc_gla_liability_key;
        }
        
        return $this;
    }
    /**
     * Get atc_gla_return_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAtc_gla_return_key(): ?string
    {
        return $this->atc_gla_return_key ?? null;
    }
    /**
     * Set atc_gla_return_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $atc_gla_return_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Company_Business_Unit_DataObjectType
     */
    public function setAtc_gla_return_key(?string $atc_gla_return_key = null): self
    {
        // validation for constraint: string
        if (!is_null($atc_gla_return_key) && !is_string($atc_gla_return_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($atc_gla_return_key, true), gettype($atc_gla_return_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($atc_gla_return_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $atc_gla_return_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($atc_gla_return_key, true)), __LINE__);
        }
        if (is_null($atc_gla_return_key) || (is_array($atc_gla_return_key) && empty($atc_gla_return_key))) {
            unset($this->atc_gla_return_key);
        } else {
            $this->atc_gla_return_key = $atc_gla_return_key;
        }
        
        return $this;
    }
    /**
     * Get atc_gla_deferred_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAtc_gla_deferred_key(): ?string
    {
        return $this->atc_gla_deferred_key ?? null;
    }
    /**
     * Set atc_gla_deferred_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $atc_gla_deferred_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Company_Business_Unit_DataObjectType
     */
    public function setAtc_gla_deferred_key(?string $atc_gla_deferred_key = null): self
    {
        // validation for constraint: string
        if (!is_null($atc_gla_deferred_key) && !is_string($atc_gla_deferred_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($atc_gla_deferred_key, true), gettype($atc_gla_deferred_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($atc_gla_deferred_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $atc_gla_deferred_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($atc_gla_deferred_key, true)), __LINE__);
        }
        if (is_null($atc_gla_deferred_key) || (is_array($atc_gla_deferred_key) && empty($atc_gla_deferred_key))) {
            unset($this->atc_gla_deferred_key);
        } else {
            $this->atc_gla_deferred_key = $atc_gla_deferred_key;
        }
        
        return $this;
    }
    /**
     * Get atc_gla_writeoff_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAtc_gla_writeoff_key(): ?string
    {
        return $this->atc_gla_writeoff_key ?? null;
    }
    /**
     * Set atc_gla_writeoff_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $atc_gla_writeoff_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Company_Business_Unit_DataObjectType
     */
    public function setAtc_gla_writeoff_key(?string $atc_gla_writeoff_key = null): self
    {
        // validation for constraint: string
        if (!is_null($atc_gla_writeoff_key) && !is_string($atc_gla_writeoff_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($atc_gla_writeoff_key, true), gettype($atc_gla_writeoff_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($atc_gla_writeoff_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $atc_gla_writeoff_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($atc_gla_writeoff_key, true)), __LINE__);
        }
        if (is_null($atc_gla_writeoff_key) || (is_array($atc_gla_writeoff_key) && empty($atc_gla_writeoff_key))) {
            unset($this->atc_gla_writeoff_key);
        } else {
            $this->atc_gla_writeoff_key = $atc_gla_writeoff_key;
        }
        
        return $this;
    }
    /**
     * Get atc_gla_inventory_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAtc_gla_inventory_key(): ?string
    {
        return $this->atc_gla_inventory_key ?? null;
    }
    /**
     * Set atc_gla_inventory_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $atc_gla_inventory_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Company_Business_Unit_DataObjectType
     */
    public function setAtc_gla_inventory_key(?string $atc_gla_inventory_key = null): self
    {
        // validation for constraint: string
        if (!is_null($atc_gla_inventory_key) && !is_string($atc_gla_inventory_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($atc_gla_inventory_key, true), gettype($atc_gla_inventory_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($atc_gla_inventory_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $atc_gla_inventory_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($atc_gla_inventory_key, true)), __LINE__);
        }
        if (is_null($atc_gla_inventory_key) || (is_array($atc_gla_inventory_key) && empty($atc_gla_inventory_key))) {
            unset($this->atc_gla_inventory_key);
        } else {
            $this->atc_gla_inventory_key = $atc_gla_inventory_key;
        }
        
        return $this;
    }
    /**
     * Get atc_gla_cogs_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAtc_gla_cogs_key(): ?string
    {
        return $this->atc_gla_cogs_key ?? null;
    }
    /**
     * Set atc_gla_cogs_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $atc_gla_cogs_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Company_Business_Unit_DataObjectType
     */
    public function setAtc_gla_cogs_key(?string $atc_gla_cogs_key = null): self
    {
        // validation for constraint: string
        if (!is_null($atc_gla_cogs_key) && !is_string($atc_gla_cogs_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($atc_gla_cogs_key, true), gettype($atc_gla_cogs_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($atc_gla_cogs_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $atc_gla_cogs_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($atc_gla_cogs_key, true)), __LINE__);
        }
        if (is_null($atc_gla_cogs_key) || (is_array($atc_gla_cogs_key) && empty($atc_gla_cogs_key))) {
            unset($this->atc_gla_cogs_key);
        } else {
            $this->atc_gla_cogs_key = $atc_gla_cogs_key;
        }
        
        return $this;
    }
    /**
     * Get atc_gla_ar_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAtc_gla_ar_key(): ?string
    {
        return $this->atc_gla_ar_key ?? null;
    }
    /**
     * Set atc_gla_ar_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $atc_gla_ar_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Company_Business_Unit_DataObjectType
     */
    public function setAtc_gla_ar_key(?string $atc_gla_ar_key = null): self
    {
        // validation for constraint: string
        if (!is_null($atc_gla_ar_key) && !is_string($atc_gla_ar_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($atc_gla_ar_key, true), gettype($atc_gla_ar_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($atc_gla_ar_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $atc_gla_ar_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($atc_gla_ar_key, true)), __LINE__);
        }
        if (is_null($atc_gla_ar_key) || (is_array($atc_gla_ar_key) && empty($atc_gla_ar_key))) {
            unset($this->atc_gla_ar_key);
        } else {
            $this->atc_gla_ar_key = $atc_gla_ar_key;
        }
        
        return $this;
    }
    /**
     * Get atc_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAtc_entity_key(): ?string
    {
        return $this->atc_entity_key ?? null;
    }
    /**
     * Set atc_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $atc_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Company_Business_Unit_DataObjectType
     */
    public function setAtc_entity_key(?string $atc_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($atc_entity_key) && !is_string($atc_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($atc_entity_key, true), gettype($atc_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($atc_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $atc_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($atc_entity_key, true)), __LINE__);
        }
        if (is_null($atc_entity_key) || (is_array($atc_entity_key) && empty($atc_entity_key))) {
            unset($this->atc_entity_key);
        } else {
            $this->atc_entity_key = $atc_entity_key;
        }
        
        return $this;
    }
    /**
     * Get atc_gla_overpayment_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAtc_gla_overpayment_key(): ?string
    {
        return $this->atc_gla_overpayment_key ?? null;
    }
    /**
     * Set atc_gla_overpayment_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $atc_gla_overpayment_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Company_Business_Unit_DataObjectType
     */
    public function setAtc_gla_overpayment_key(?string $atc_gla_overpayment_key = null): self
    {
        // validation for constraint: string
        if (!is_null($atc_gla_overpayment_key) && !is_string($atc_gla_overpayment_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($atc_gla_overpayment_key, true), gettype($atc_gla_overpayment_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($atc_gla_overpayment_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $atc_gla_overpayment_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($atc_gla_overpayment_key, true)), __LINE__);
        }
        if (is_null($atc_gla_overpayment_key) || (is_array($atc_gla_overpayment_key) && empty($atc_gla_overpayment_key))) {
            unset($this->atc_gla_overpayment_key);
        } else {
            $this->atc_gla_overpayment_key = $atc_gla_overpayment_key;
        }
        
        return $this;
    }
    /**
     * Get atc_ait_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAtc_ait_key(): ?string
    {
        return $this->atc_ait_key ?? null;
    }
    /**
     * Set atc_ait_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $atc_ait_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Company_Business_Unit_DataObjectType
     */
    public function setAtc_ait_key(?string $atc_ait_key = null): self
    {
        // validation for constraint: string
        if (!is_null($atc_ait_key) && !is_string($atc_ait_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($atc_ait_key, true), gettype($atc_ait_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($atc_ait_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $atc_ait_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($atc_ait_key, true)), __LINE__);
        }
        if (is_null($atc_ait_key) || (is_array($atc_ait_key) && empty($atc_ait_key))) {
            unset($this->atc_ait_key);
        } else {
            $this->atc_ait_key = $atc_ait_key;
        }
        
        return $this;
    }
    /**
     * Get atc_currency_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAtc_currency_code(): ?string
    {
        return $this->atc_currency_code ?? null;
    }
    /**
     * Set atc_currency_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $atc_currency_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Company_Business_Unit_DataObjectType
     */
    public function setAtc_currency_code(?string $atc_currency_code = null): self
    {
        // validation for constraint: string
        if (!is_null($atc_currency_code) && !is_string($atc_currency_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($atc_currency_code, true), gettype($atc_currency_code)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($atc_currency_code) && mb_strlen((string) $atc_currency_code) > 3) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen((string) $atc_currency_code)), __LINE__);
        }
        if (is_null($atc_currency_code) || (is_array($atc_currency_code) && empty($atc_currency_code))) {
            unset($this->atc_currency_code);
        } else {
            $this->atc_currency_code = $atc_currency_code;
        }
        
        return $this;
    }
    /**
     * Get atc_gla_realized_gain_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAtc_gla_realized_gain_key(): ?string
    {
        return $this->atc_gla_realized_gain_key ?? null;
    }
    /**
     * Set atc_gla_realized_gain_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $atc_gla_realized_gain_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Company_Business_Unit_DataObjectType
     */
    public function setAtc_gla_realized_gain_key(?string $atc_gla_realized_gain_key = null): self
    {
        // validation for constraint: string
        if (!is_null($atc_gla_realized_gain_key) && !is_string($atc_gla_realized_gain_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($atc_gla_realized_gain_key, true), gettype($atc_gla_realized_gain_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($atc_gla_realized_gain_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $atc_gla_realized_gain_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($atc_gla_realized_gain_key, true)), __LINE__);
        }
        if (is_null($atc_gla_realized_gain_key) || (is_array($atc_gla_realized_gain_key) && empty($atc_gla_realized_gain_key))) {
            unset($this->atc_gla_realized_gain_key);
        } else {
            $this->atc_gla_realized_gain_key = $atc_gla_realized_gain_key;
        }
        
        return $this;
    }
    /**
     * Get atc_gla_realized_loss_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAtc_gla_realized_loss_key(): ?string
    {
        return $this->atc_gla_realized_loss_key ?? null;
    }
    /**
     * Set atc_gla_realized_loss_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $atc_gla_realized_loss_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Company_Business_Unit_DataObjectType
     */
    public function setAtc_gla_realized_loss_key(?string $atc_gla_realized_loss_key = null): self
    {
        // validation for constraint: string
        if (!is_null($atc_gla_realized_loss_key) && !is_string($atc_gla_realized_loss_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($atc_gla_realized_loss_key, true), gettype($atc_gla_realized_loss_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($atc_gla_realized_loss_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $atc_gla_realized_loss_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($atc_gla_realized_loss_key, true)), __LINE__);
        }
        if (is_null($atc_gla_realized_loss_key) || (is_array($atc_gla_realized_loss_key) && empty($atc_gla_realized_loss_key))) {
            unset($this->atc_gla_realized_loss_key);
        } else {
            $this->atc_gla_realized_loss_key = $atc_gla_realized_loss_key;
        }
        
        return $this;
    }
    /**
     * Get atc_gla_rounding_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAtc_gla_rounding_key(): ?string
    {
        return $this->atc_gla_rounding_key ?? null;
    }
    /**
     * Set atc_gla_rounding_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $atc_gla_rounding_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Company_Business_Unit_DataObjectType
     */
    public function setAtc_gla_rounding_key(?string $atc_gla_rounding_key = null): self
    {
        // validation for constraint: string
        if (!is_null($atc_gla_rounding_key) && !is_string($atc_gla_rounding_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($atc_gla_rounding_key, true), gettype($atc_gla_rounding_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($atc_gla_rounding_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $atc_gla_rounding_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($atc_gla_rounding_key, true)), __LINE__);
        }
        if (is_null($atc_gla_rounding_key) || (is_array($atc_gla_rounding_key) && empty($atc_gla_rounding_key))) {
            unset($this->atc_gla_rounding_key);
        } else {
            $this->atc_gla_rounding_key = $atc_gla_rounding_key;
        }
        
        return $this;
    }
    /**
     * Get atc_tax_id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAtc_tax_id(): ?string
    {
        return $this->atc_tax_id ?? null;
    }
    /**
     * Set atc_tax_id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $atc_tax_id
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Company_Business_Unit_DataObjectType
     */
    public function setAtc_tax_id(?string $atc_tax_id = null): self
    {
        // validation for constraint: string
        if (!is_null($atc_tax_id) && !is_string($atc_tax_id)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($atc_tax_id, true), gettype($atc_tax_id)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($atc_tax_id) && mb_strlen((string) $atc_tax_id) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $atc_tax_id)), __LINE__);
        }
        if (is_null($atc_tax_id) || (is_array($atc_tax_id) && empty($atc_tax_id))) {
            unset($this->atc_tax_id);
        } else {
            $this->atc_tax_id = $atc_tax_id;
        }
        
        return $this;
    }
    /**
     * Get atc_nsf_prc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAtc_nsf_prc_key(): ?string
    {
        return $this->atc_nsf_prc_key ?? null;
    }
    /**
     * Set atc_nsf_prc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $atc_nsf_prc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Company_Business_Unit_DataObjectType
     */
    public function setAtc_nsf_prc_key(?string $atc_nsf_prc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($atc_nsf_prc_key) && !is_string($atc_nsf_prc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($atc_nsf_prc_key, true), gettype($atc_nsf_prc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($atc_nsf_prc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $atc_nsf_prc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($atc_nsf_prc_key, true)), __LINE__);
        }
        if (is_null($atc_nsf_prc_key) || (is_array($atc_nsf_prc_key) && empty($atc_nsf_prc_key))) {
            unset($this->atc_nsf_prc_key);
        } else {
            $this->atc_nsf_prc_key = $atc_nsf_prc_key;
        }
        
        return $this;
    }
}
