<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CentralizedOrderEntry_Credit_Available_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class CentralizedOrderEntry_Credit_Available_DataObjectType extends AbstractStructBase
{
    /**
     * The caa_cst_key
     * Meta information extracted from the WSDL
     * - documentation: cst key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $caa_cst_key = null;
    /**
     * The caa_cst_credit_available
     * Meta information extracted from the WSDL
     * - documentation: credit available. | Avectra netForum defined simpleType.
     * - base: s:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 25
     * @var float|null
     */
    protected ?float $caa_cst_credit_available = null;
    /**
     * The caa_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $caa_entity_key = null;
    /**
     * Constructor method for CentralizedOrderEntry_Credit_Available_DataObjectType
     * @uses CentralizedOrderEntry_Credit_Available_DataObjectType::setCaa_cst_key()
     * @uses CentralizedOrderEntry_Credit_Available_DataObjectType::setCaa_cst_credit_available()
     * @uses CentralizedOrderEntry_Credit_Available_DataObjectType::setCaa_entity_key()
     * @param string $caa_cst_key
     * @param float $caa_cst_credit_available
     * @param string $caa_entity_key
     */
    public function __construct(?string $caa_cst_key = null, ?float $caa_cst_credit_available = null, ?string $caa_entity_key = null)
    {
        $this
            ->setCaa_cst_key($caa_cst_key)
            ->setCaa_cst_credit_available($caa_cst_credit_available)
            ->setCaa_entity_key($caa_entity_key);
    }
    /**
     * Get caa_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCaa_cst_key(): ?string
    {
        return $this->caa_cst_key ?? null;
    }
    /**
     * Set caa_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $caa_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Credit_Available_DataObjectType
     */
    public function setCaa_cst_key(?string $caa_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($caa_cst_key) && !is_string($caa_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($caa_cst_key, true), gettype($caa_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($caa_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $caa_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($caa_cst_key, true)), __LINE__);
        }
        if (is_null($caa_cst_key) || (is_array($caa_cst_key) && empty($caa_cst_key))) {
            unset($this->caa_cst_key);
        } else {
            $this->caa_cst_key = $caa_cst_key;
        }
        
        return $this;
    }
    /**
     * Get caa_cst_credit_available value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCaa_cst_credit_available(): ?float
    {
        return $this->caa_cst_credit_available ?? null;
    }
    /**
     * Set caa_cst_credit_available value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $caa_cst_credit_available
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Credit_Available_DataObjectType
     */
    public function setCaa_cst_credit_available(?float $caa_cst_credit_available = null): self
    {
        // validation for constraint: float
        if (!is_null($caa_cst_credit_available) && !(is_float($caa_cst_credit_available) || is_numeric($caa_cst_credit_available))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($caa_cst_credit_available, true), gettype($caa_cst_credit_available)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($caa_cst_credit_available) && mb_strlen(mb_substr((string) $caa_cst_credit_available, false !== mb_strpos((string) $caa_cst_credit_available, '.') ? mb_strpos((string) $caa_cst_credit_available, '.') + 1 : mb_strlen((string) $caa_cst_credit_available))) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($caa_cst_credit_available, true), mb_strlen(mb_substr((string) $caa_cst_credit_available, mb_strpos((string) $caa_cst_credit_available, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(25)
        if (!is_null($caa_cst_credit_available) && mb_strlen(preg_replace('/(\D)/', '', (string) $caa_cst_credit_available)) > 25) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 25 digits, "%d" given', var_export($caa_cst_credit_available, true), mb_strlen(preg_replace('/(\D)/', '', (string) $caa_cst_credit_available))), __LINE__);
        }
        if (is_null($caa_cst_credit_available) || (is_array($caa_cst_credit_available) && empty($caa_cst_credit_available))) {
            unset($this->caa_cst_credit_available);
        } else {
            $this->caa_cst_credit_available = $caa_cst_credit_available;
        }
        
        return $this;
    }
    /**
     * Get caa_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCaa_entity_key(): ?string
    {
        return $this->caa_entity_key ?? null;
    }
    /**
     * Set caa_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $caa_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_Credit_Available_DataObjectType
     */
    public function setCaa_entity_key(?string $caa_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($caa_entity_key) && !is_string($caa_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($caa_entity_key, true), gettype($caa_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($caa_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $caa_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($caa_entity_key, true)), __LINE__);
        }
        if (is_null($caa_entity_key) || (is_array($caa_entity_key) && empty($caa_entity_key))) {
            unset($this->caa_entity_key);
        } else {
            $this->caa_entity_key = $caa_entity_key;
        }
        
        return $this;
    }
}
