<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CentralizedOrderEntry_InstallmentBilling_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class CentralizedOrderEntry_InstallmentBilling_DataObjectType extends AbstractStructBase
{
    /**
     * The ord_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_key = null;
    /**
     * The ord_cst_key
     * Meta information extracted from the WSDL
     * - documentation: customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_cst_key = null;
    /**
     * The ord_frequency
     * Meta information extracted from the WSDL
     * - documentation: frequency. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ord_frequency = null;
    /**
     * The ord_ptr_key
     * Meta information extracted from the WSDL
     * - documentation: term. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_ptr_key = null;
    /**
     * The ord_last_bill_date
     * Meta information extracted from the WSDL
     * - documentation: last bill date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_last_bill_date = null;
    /**
     * The ord_proforma
     * Meta information extracted from the WSDL
     * - documentation: proforma.This element has a default value of '0'. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_proforma = null;
    /**
     * The ord_type
     * Meta information extracted from the WSDL
     * - documentation: type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_type = null;
    /**
     * The ord_pin_key
     * Meta information extracted from the WSDL
     * - documentation: payment info. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_pin_key = null;
    /**
     * The ord_num_of_installments
     * Meta information extracted from the WSDL
     * - documentation: number of installments. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ord_num_of_installments = null;
    /**
     * The ord_num_invoices_to_date
     * Meta information extracted from the WSDL
     * - documentation: num invoices to date. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ord_num_invoices_to_date = null;
    /**
     * The ord_cst_billing_key
     * Meta information extracted from the WSDL
     * - documentation: bill to customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_cst_billing_key = null;
    /**
     * The ord_ind_cst_billing_key
     * Meta information extracted from the WSDL
     * - documentation: billing contact. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_ind_cst_billing_key = null;
    /**
     * The ord_cxa_key
     * Meta information extracted from the WSDL
     * - documentation: billing address. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_cxa_key = null;
    /**
     * The ord_cph_key
     * Meta information extracted from the WSDL
     * - documentation: phone. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_cph_key = null;
    /**
     * The ord_cfx_key
     * Meta information extracted from the WSDL
     * - documentation: fax. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_cfx_key = null;
    /**
     * The ord_eml_key
     * Meta information extracted from the WSDL
     * - documentation: email. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_eml_key = null;
    /**
     * The ord_pref_comm_method
     * Meta information extracted from the WSDL
     * - documentation: pref comm method. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_pref_comm_method = null;
    /**
     * The ord_src_key
     * Meta information extracted from the WSDL
     * - documentation: source code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_src_key = null;
    /**
     * The ord_med_key
     * Meta information extracted from the WSDL
     * - documentation: media code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_med_key = null;
    /**
     * The ord_notes_internal
     * Meta information extracted from the WSDL
     * - documentation: notes internal. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 300
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_notes_internal = null;
    /**
     * The ord_notes_external
     * Meta information extracted from the WSDL
     * - documentation: notes external. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 300
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_notes_external = null;
    /**
     * The ord_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_add_user = null;
    /**
     * The ord_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_add_date = null;
    /**
     * The ord_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_change_user = null;
    /**
     * The ord_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_change_date = null;
    /**
     * The ord_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_delete_flag = null;
    /**
     * The ord_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_entity_key = null;
    /**
     * The ord_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_key_ext = null;
    /**
     * The ord_ait_key
     * Meta information extracted from the WSDL
     * - documentation: invoice terms. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_ait_key = null;
    /**
     * The ord_first_process_date
     * Meta information extracted from the WSDL
     * - documentation: Process First Invoice on. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_first_process_date = null;
    /**
     * The ord_code
     * Meta information extracted from the WSDL
     * - documentation: order code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_code = null;
    /**
     * The ord_close_flag
     * Meta information extracted from the WSDL
     * - documentation: order closed. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_close_flag = null;
    /**
     * The ord_milestone_flag
     * Meta information extracted from the WSDL
     * - documentation: milestone based. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_milestone_flag = null;
    /**
     * The ord_cpi_key
     * Meta information extracted from the WSDL
     * - documentation: Customer Payment Info. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_cpi_key = null;
    /**
     * The ord_auto_pay
     * Meta information extracted from the WSDL
     * - documentation: Auto-Pay Installments. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_auto_pay = null;
    /**
     * The ord_orig_trans_type
     * Meta information extracted from the WSDL
     * - documentation: Original Transaction Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_orig_trans_type = null;
    /**
     * The ord_po_number
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Number. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_po_number = null;
    /**
     * The ord_cur_key
     * Meta information extracted from the WSDL
     * - documentation: Currency. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_cur_key = null;
    /**
     * The ord_trx_date
     * Meta information extracted from the WSDL
     * - documentation: Order Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_trx_date = null;
    /**
     * The ord_sfo_key
     * Meta information extracted from the WSDL
     * - documentation: opportunity. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $ord_sfo_key = null;
    /**
     * The ord_group_flag
     * Meta information extracted from the WSDL
     * - documentation: Group order for reporting. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_group_flag = null;
    /**
     * The ord_group_description
     * Meta information extracted from the WSDL
     * - documentation: Order Group Description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 300
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_group_description = null;
    /**
     * The ord_recurring_date_1
     * Meta information extracted from the WSDL
     * - documentation: First Date. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ord_recurring_date_1 = null;
    /**
     * The ord_recurring_date_2
     * Meta information extracted from the WSDL
     * - documentation: Second Date. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $ord_recurring_date_2 = null;
    /**
     * The ord_cpi_consent_date
     * Meta information extracted from the WSDL
     * - documentation: Date cardholder consented to store their payment info for installment/recurring/renewal payments.. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $ord_cpi_consent_date = null;
    /**
     * Constructor method for CentralizedOrderEntry_InstallmentBilling_DataObjectType
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_key()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_cst_key()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_frequency()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_ptr_key()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_last_bill_date()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_proforma()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_type()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_pin_key()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_num_of_installments()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_num_invoices_to_date()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_cst_billing_key()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_ind_cst_billing_key()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_cxa_key()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_cph_key()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_cfx_key()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_eml_key()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_pref_comm_method()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_src_key()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_med_key()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_notes_internal()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_notes_external()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_add_user()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_add_date()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_change_user()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_change_date()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_delete_flag()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_entity_key()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_key_ext()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_ait_key()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_first_process_date()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_code()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_close_flag()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_milestone_flag()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_cpi_key()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_auto_pay()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_orig_trans_type()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_po_number()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_cur_key()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_trx_date()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_sfo_key()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_group_flag()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_group_description()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_recurring_date_1()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_recurring_date_2()
     * @uses CentralizedOrderEntry_InstallmentBilling_DataObjectType::setOrd_cpi_consent_date()
     * @param string $ord_key
     * @param string $ord_cst_key
     * @param int $ord_frequency
     * @param string $ord_ptr_key
     * @param string $ord_last_bill_date
     * @param string $ord_proforma
     * @param string $ord_type
     * @param string $ord_pin_key
     * @param int $ord_num_of_installments
     * @param int $ord_num_invoices_to_date
     * @param string $ord_cst_billing_key
     * @param string $ord_ind_cst_billing_key
     * @param string $ord_cxa_key
     * @param string $ord_cph_key
     * @param string $ord_cfx_key
     * @param string $ord_eml_key
     * @param string $ord_pref_comm_method
     * @param string $ord_src_key
     * @param string $ord_med_key
     * @param string $ord_notes_internal
     * @param string $ord_notes_external
     * @param string $ord_add_user
     * @param string $ord_add_date
     * @param string $ord_change_user
     * @param string $ord_change_date
     * @param string $ord_delete_flag
     * @param string $ord_entity_key
     * @param string $ord_key_ext
     * @param string $ord_ait_key
     * @param string $ord_first_process_date
     * @param string $ord_code
     * @param string $ord_close_flag
     * @param string $ord_milestone_flag
     * @param string $ord_cpi_key
     * @param string $ord_auto_pay
     * @param string $ord_orig_trans_type
     * @param string $ord_po_number
     * @param string $ord_cur_key
     * @param string $ord_trx_date
     * @param string $ord_sfo_key
     * @param string $ord_group_flag
     * @param string $ord_group_description
     * @param int $ord_recurring_date_1
     * @param int $ord_recurring_date_2
     * @param string $ord_cpi_consent_date
     */
    public function __construct(?string $ord_key = null, ?string $ord_cst_key = null, ?int $ord_frequency = null, ?string $ord_ptr_key = null, ?string $ord_last_bill_date = null, ?string $ord_proforma = null, ?string $ord_type = null, ?string $ord_pin_key = null, ?int $ord_num_of_installments = null, ?int $ord_num_invoices_to_date = null, ?string $ord_cst_billing_key = null, ?string $ord_ind_cst_billing_key = null, ?string $ord_cxa_key = null, ?string $ord_cph_key = null, ?string $ord_cfx_key = null, ?string $ord_eml_key = null, ?string $ord_pref_comm_method = null, ?string $ord_src_key = null, ?string $ord_med_key = null, ?string $ord_notes_internal = null, ?string $ord_notes_external = null, ?string $ord_add_user = null, ?string $ord_add_date = null, ?string $ord_change_user = null, ?string $ord_change_date = null, ?string $ord_delete_flag = null, ?string $ord_entity_key = null, ?string $ord_key_ext = null, ?string $ord_ait_key = null, ?string $ord_first_process_date = null, ?string $ord_code = null, ?string $ord_close_flag = null, ?string $ord_milestone_flag = null, ?string $ord_cpi_key = null, ?string $ord_auto_pay = null, ?string $ord_orig_trans_type = null, ?string $ord_po_number = null, ?string $ord_cur_key = null, ?string $ord_trx_date = null, ?string $ord_sfo_key = null, ?string $ord_group_flag = null, ?string $ord_group_description = null, ?int $ord_recurring_date_1 = null, ?int $ord_recurring_date_2 = null, ?string $ord_cpi_consent_date = null)
    {
        $this
            ->setOrd_key($ord_key)
            ->setOrd_cst_key($ord_cst_key)
            ->setOrd_frequency($ord_frequency)
            ->setOrd_ptr_key($ord_ptr_key)
            ->setOrd_last_bill_date($ord_last_bill_date)
            ->setOrd_proforma($ord_proforma)
            ->setOrd_type($ord_type)
            ->setOrd_pin_key($ord_pin_key)
            ->setOrd_num_of_installments($ord_num_of_installments)
            ->setOrd_num_invoices_to_date($ord_num_invoices_to_date)
            ->setOrd_cst_billing_key($ord_cst_billing_key)
            ->setOrd_ind_cst_billing_key($ord_ind_cst_billing_key)
            ->setOrd_cxa_key($ord_cxa_key)
            ->setOrd_cph_key($ord_cph_key)
            ->setOrd_cfx_key($ord_cfx_key)
            ->setOrd_eml_key($ord_eml_key)
            ->setOrd_pref_comm_method($ord_pref_comm_method)
            ->setOrd_src_key($ord_src_key)
            ->setOrd_med_key($ord_med_key)
            ->setOrd_notes_internal($ord_notes_internal)
            ->setOrd_notes_external($ord_notes_external)
            ->setOrd_add_user($ord_add_user)
            ->setOrd_add_date($ord_add_date)
            ->setOrd_change_user($ord_change_user)
            ->setOrd_change_date($ord_change_date)
            ->setOrd_delete_flag($ord_delete_flag)
            ->setOrd_entity_key($ord_entity_key)
            ->setOrd_key_ext($ord_key_ext)
            ->setOrd_ait_key($ord_ait_key)
            ->setOrd_first_process_date($ord_first_process_date)
            ->setOrd_code($ord_code)
            ->setOrd_close_flag($ord_close_flag)
            ->setOrd_milestone_flag($ord_milestone_flag)
            ->setOrd_cpi_key($ord_cpi_key)
            ->setOrd_auto_pay($ord_auto_pay)
            ->setOrd_orig_trans_type($ord_orig_trans_type)
            ->setOrd_po_number($ord_po_number)
            ->setOrd_cur_key($ord_cur_key)
            ->setOrd_trx_date($ord_trx_date)
            ->setOrd_sfo_key($ord_sfo_key)
            ->setOrd_group_flag($ord_group_flag)
            ->setOrd_group_description($ord_group_description)
            ->setOrd_recurring_date_1($ord_recurring_date_1)
            ->setOrd_recurring_date_2($ord_recurring_date_2)
            ->setOrd_cpi_consent_date($ord_cpi_consent_date);
    }
    /**
     * Get ord_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_key(): ?string
    {
        return $this->ord_key ?? null;
    }
    /**
     * Set ord_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_key(?string $ord_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_key) && !is_string($ord_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_key, true), gettype($ord_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_key, true)), __LINE__);
        }
        if (is_null($ord_key) || (is_array($ord_key) && empty($ord_key))) {
            unset($this->ord_key);
        } else {
            $this->ord_key = $ord_key;
        }
        
        return $this;
    }
    /**
     * Get ord_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_cst_key(): ?string
    {
        return $this->ord_cst_key ?? null;
    }
    /**
     * Set ord_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_cst_key(?string $ord_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_cst_key) && !is_string($ord_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_cst_key, true), gettype($ord_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_cst_key, true)), __LINE__);
        }
        if (is_null($ord_cst_key) || (is_array($ord_cst_key) && empty($ord_cst_key))) {
            unset($this->ord_cst_key);
        } else {
            $this->ord_cst_key = $ord_cst_key;
        }
        
        return $this;
    }
    /**
     * Get ord_frequency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrd_frequency(): ?int
    {
        return $this->ord_frequency ?? null;
    }
    /**
     * Set ord_frequency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ord_frequency
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_frequency(?int $ord_frequency = null): self
    {
        // validation for constraint: int
        if (!is_null($ord_frequency) && !(is_int($ord_frequency) || ctype_digit($ord_frequency))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ord_frequency, true), gettype($ord_frequency)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ord_frequency) && $ord_frequency > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ord_frequency, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ord_frequency) && $ord_frequency < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ord_frequency, true)), __LINE__);
        }
        if (is_null($ord_frequency) || (is_array($ord_frequency) && empty($ord_frequency))) {
            unset($this->ord_frequency);
        } else {
            $this->ord_frequency = $ord_frequency;
        }
        
        return $this;
    }
    /**
     * Get ord_ptr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_ptr_key(): ?string
    {
        return $this->ord_ptr_key ?? null;
    }
    /**
     * Set ord_ptr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_ptr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_ptr_key(?string $ord_ptr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_ptr_key) && !is_string($ord_ptr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_ptr_key, true), gettype($ord_ptr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_ptr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_ptr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_ptr_key, true)), __LINE__);
        }
        if (is_null($ord_ptr_key) || (is_array($ord_ptr_key) && empty($ord_ptr_key))) {
            unset($this->ord_ptr_key);
        } else {
            $this->ord_ptr_key = $ord_ptr_key;
        }
        
        return $this;
    }
    /**
     * Get ord_last_bill_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_last_bill_date(): ?string
    {
        return $this->ord_last_bill_date ?? null;
    }
    /**
     * Set ord_last_bill_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_last_bill_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_last_bill_date(?string $ord_last_bill_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_last_bill_date) && !is_string($ord_last_bill_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_last_bill_date, true), gettype($ord_last_bill_date)), __LINE__);
        }
        if (is_null($ord_last_bill_date) || (is_array($ord_last_bill_date) && empty($ord_last_bill_date))) {
            unset($this->ord_last_bill_date);
        } else {
            $this->ord_last_bill_date = $ord_last_bill_date;
        }
        
        return $this;
    }
    /**
     * Get ord_proforma value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_proforma(): ?string
    {
        return $this->ord_proforma ?? null;
    }
    /**
     * Set ord_proforma value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_proforma
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_proforma(?string $ord_proforma = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_proforma) && !is_string($ord_proforma)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_proforma, true), gettype($ord_proforma)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ord_proforma) && $ord_proforma > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ord_proforma, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ord_proforma) && $ord_proforma < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ord_proforma, true)), __LINE__);
        }
        if (is_null($ord_proforma) || (is_array($ord_proforma) && empty($ord_proforma))) {
            unset($this->ord_proforma);
        } else {
            $this->ord_proforma = $ord_proforma;
        }
        
        return $this;
    }
    /**
     * Get ord_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_type(): ?string
    {
        return $this->ord_type ?? null;
    }
    /**
     * Set ord_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_type(?string $ord_type = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_type) && !is_string($ord_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_type, true), gettype($ord_type)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($ord_type) && mb_strlen((string) $ord_type) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $ord_type)), __LINE__);
        }
        if (is_null($ord_type) || (is_array($ord_type) && empty($ord_type))) {
            unset($this->ord_type);
        } else {
            $this->ord_type = $ord_type;
        }
        
        return $this;
    }
    /**
     * Get ord_pin_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_pin_key(): ?string
    {
        return $this->ord_pin_key ?? null;
    }
    /**
     * Set ord_pin_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_pin_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_pin_key(?string $ord_pin_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_pin_key) && !is_string($ord_pin_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_pin_key, true), gettype($ord_pin_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_pin_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_pin_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_pin_key, true)), __LINE__);
        }
        if (is_null($ord_pin_key) || (is_array($ord_pin_key) && empty($ord_pin_key))) {
            unset($this->ord_pin_key);
        } else {
            $this->ord_pin_key = $ord_pin_key;
        }
        
        return $this;
    }
    /**
     * Get ord_num_of_installments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrd_num_of_installments(): ?int
    {
        return $this->ord_num_of_installments ?? null;
    }
    /**
     * Set ord_num_of_installments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ord_num_of_installments
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_num_of_installments(?int $ord_num_of_installments = null): self
    {
        // validation for constraint: int
        if (!is_null($ord_num_of_installments) && !(is_int($ord_num_of_installments) || ctype_digit($ord_num_of_installments))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ord_num_of_installments, true), gettype($ord_num_of_installments)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ord_num_of_installments) && $ord_num_of_installments > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ord_num_of_installments, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ord_num_of_installments) && $ord_num_of_installments < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ord_num_of_installments, true)), __LINE__);
        }
        if (is_null($ord_num_of_installments) || (is_array($ord_num_of_installments) && empty($ord_num_of_installments))) {
            unset($this->ord_num_of_installments);
        } else {
            $this->ord_num_of_installments = $ord_num_of_installments;
        }
        
        return $this;
    }
    /**
     * Get ord_num_invoices_to_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrd_num_invoices_to_date(): ?int
    {
        return $this->ord_num_invoices_to_date ?? null;
    }
    /**
     * Set ord_num_invoices_to_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ord_num_invoices_to_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_num_invoices_to_date(?int $ord_num_invoices_to_date = null): self
    {
        // validation for constraint: int
        if (!is_null($ord_num_invoices_to_date) && !(is_int($ord_num_invoices_to_date) || ctype_digit($ord_num_invoices_to_date))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ord_num_invoices_to_date, true), gettype($ord_num_invoices_to_date)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ord_num_invoices_to_date) && $ord_num_invoices_to_date > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ord_num_invoices_to_date, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ord_num_invoices_to_date) && $ord_num_invoices_to_date < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ord_num_invoices_to_date, true)), __LINE__);
        }
        if (is_null($ord_num_invoices_to_date) || (is_array($ord_num_invoices_to_date) && empty($ord_num_invoices_to_date))) {
            unset($this->ord_num_invoices_to_date);
        } else {
            $this->ord_num_invoices_to_date = $ord_num_invoices_to_date;
        }
        
        return $this;
    }
    /**
     * Get ord_cst_billing_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_cst_billing_key(): ?string
    {
        return $this->ord_cst_billing_key ?? null;
    }
    /**
     * Set ord_cst_billing_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_cst_billing_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_cst_billing_key(?string $ord_cst_billing_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_cst_billing_key) && !is_string($ord_cst_billing_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_cst_billing_key, true), gettype($ord_cst_billing_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_cst_billing_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_cst_billing_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_cst_billing_key, true)), __LINE__);
        }
        if (is_null($ord_cst_billing_key) || (is_array($ord_cst_billing_key) && empty($ord_cst_billing_key))) {
            unset($this->ord_cst_billing_key);
        } else {
            $this->ord_cst_billing_key = $ord_cst_billing_key;
        }
        
        return $this;
    }
    /**
     * Get ord_ind_cst_billing_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_ind_cst_billing_key(): ?string
    {
        return $this->ord_ind_cst_billing_key ?? null;
    }
    /**
     * Set ord_ind_cst_billing_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_ind_cst_billing_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_ind_cst_billing_key(?string $ord_ind_cst_billing_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_ind_cst_billing_key) && !is_string($ord_ind_cst_billing_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_ind_cst_billing_key, true), gettype($ord_ind_cst_billing_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_ind_cst_billing_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_ind_cst_billing_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_ind_cst_billing_key, true)), __LINE__);
        }
        if (is_null($ord_ind_cst_billing_key) || (is_array($ord_ind_cst_billing_key) && empty($ord_ind_cst_billing_key))) {
            unset($this->ord_ind_cst_billing_key);
        } else {
            $this->ord_ind_cst_billing_key = $ord_ind_cst_billing_key;
        }
        
        return $this;
    }
    /**
     * Get ord_cxa_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_cxa_key(): ?string
    {
        return $this->ord_cxa_key ?? null;
    }
    /**
     * Set ord_cxa_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_cxa_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_cxa_key(?string $ord_cxa_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_cxa_key) && !is_string($ord_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_cxa_key, true), gettype($ord_cxa_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_cxa_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_cxa_key, true)), __LINE__);
        }
        if (is_null($ord_cxa_key) || (is_array($ord_cxa_key) && empty($ord_cxa_key))) {
            unset($this->ord_cxa_key);
        } else {
            $this->ord_cxa_key = $ord_cxa_key;
        }
        
        return $this;
    }
    /**
     * Get ord_cph_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_cph_key(): ?string
    {
        return $this->ord_cph_key ?? null;
    }
    /**
     * Set ord_cph_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_cph_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_cph_key(?string $ord_cph_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_cph_key) && !is_string($ord_cph_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_cph_key, true), gettype($ord_cph_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_cph_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_cph_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_cph_key, true)), __LINE__);
        }
        if (is_null($ord_cph_key) || (is_array($ord_cph_key) && empty($ord_cph_key))) {
            unset($this->ord_cph_key);
        } else {
            $this->ord_cph_key = $ord_cph_key;
        }
        
        return $this;
    }
    /**
     * Get ord_cfx_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_cfx_key(): ?string
    {
        return $this->ord_cfx_key ?? null;
    }
    /**
     * Set ord_cfx_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_cfx_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_cfx_key(?string $ord_cfx_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_cfx_key) && !is_string($ord_cfx_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_cfx_key, true), gettype($ord_cfx_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_cfx_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_cfx_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_cfx_key, true)), __LINE__);
        }
        if (is_null($ord_cfx_key) || (is_array($ord_cfx_key) && empty($ord_cfx_key))) {
            unset($this->ord_cfx_key);
        } else {
            $this->ord_cfx_key = $ord_cfx_key;
        }
        
        return $this;
    }
    /**
     * Get ord_eml_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_eml_key(): ?string
    {
        return $this->ord_eml_key ?? null;
    }
    /**
     * Set ord_eml_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_eml_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_eml_key(?string $ord_eml_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_eml_key) && !is_string($ord_eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_eml_key, true), gettype($ord_eml_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_eml_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_eml_key, true)), __LINE__);
        }
        if (is_null($ord_eml_key) || (is_array($ord_eml_key) && empty($ord_eml_key))) {
            unset($this->ord_eml_key);
        } else {
            $this->ord_eml_key = $ord_eml_key;
        }
        
        return $this;
    }
    /**
     * Get ord_pref_comm_method value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_pref_comm_method(): ?string
    {
        return $this->ord_pref_comm_method ?? null;
    }
    /**
     * Set ord_pref_comm_method value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_pref_comm_method
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_pref_comm_method(?string $ord_pref_comm_method = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_pref_comm_method) && !is_string($ord_pref_comm_method)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_pref_comm_method, true), gettype($ord_pref_comm_method)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($ord_pref_comm_method) && mb_strlen((string) $ord_pref_comm_method) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $ord_pref_comm_method)), __LINE__);
        }
        if (is_null($ord_pref_comm_method) || (is_array($ord_pref_comm_method) && empty($ord_pref_comm_method))) {
            unset($this->ord_pref_comm_method);
        } else {
            $this->ord_pref_comm_method = $ord_pref_comm_method;
        }
        
        return $this;
    }
    /**
     * Get ord_src_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_src_key(): ?string
    {
        return $this->ord_src_key ?? null;
    }
    /**
     * Set ord_src_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_src_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_src_key(?string $ord_src_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_src_key) && !is_string($ord_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_src_key, true), gettype($ord_src_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_src_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_src_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_src_key, true)), __LINE__);
        }
        if (is_null($ord_src_key) || (is_array($ord_src_key) && empty($ord_src_key))) {
            unset($this->ord_src_key);
        } else {
            $this->ord_src_key = $ord_src_key;
        }
        
        return $this;
    }
    /**
     * Get ord_med_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_med_key(): ?string
    {
        return $this->ord_med_key ?? null;
    }
    /**
     * Set ord_med_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_med_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_med_key(?string $ord_med_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_med_key) && !is_string($ord_med_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_med_key, true), gettype($ord_med_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_med_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_med_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_med_key, true)), __LINE__);
        }
        if (is_null($ord_med_key) || (is_array($ord_med_key) && empty($ord_med_key))) {
            unset($this->ord_med_key);
        } else {
            $this->ord_med_key = $ord_med_key;
        }
        
        return $this;
    }
    /**
     * Get ord_notes_internal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_notes_internal(): ?string
    {
        return $this->ord_notes_internal ?? null;
    }
    /**
     * Set ord_notes_internal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_notes_internal
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_notes_internal(?string $ord_notes_internal = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_notes_internal) && !is_string($ord_notes_internal)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_notes_internal, true), gettype($ord_notes_internal)), __LINE__);
        }
        // validation for constraint: maxLength(300)
        if (!is_null($ord_notes_internal) && mb_strlen((string) $ord_notes_internal) > 300) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 300', mb_strlen((string) $ord_notes_internal)), __LINE__);
        }
        if (is_null($ord_notes_internal) || (is_array($ord_notes_internal) && empty($ord_notes_internal))) {
            unset($this->ord_notes_internal);
        } else {
            $this->ord_notes_internal = $ord_notes_internal;
        }
        
        return $this;
    }
    /**
     * Get ord_notes_external value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_notes_external(): ?string
    {
        return $this->ord_notes_external ?? null;
    }
    /**
     * Set ord_notes_external value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_notes_external
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_notes_external(?string $ord_notes_external = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_notes_external) && !is_string($ord_notes_external)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_notes_external, true), gettype($ord_notes_external)), __LINE__);
        }
        // validation for constraint: maxLength(300)
        if (!is_null($ord_notes_external) && mb_strlen((string) $ord_notes_external) > 300) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 300', mb_strlen((string) $ord_notes_external)), __LINE__);
        }
        if (is_null($ord_notes_external) || (is_array($ord_notes_external) && empty($ord_notes_external))) {
            unset($this->ord_notes_external);
        } else {
            $this->ord_notes_external = $ord_notes_external;
        }
        
        return $this;
    }
    /**
     * Get ord_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_add_user(): ?string
    {
        return $this->ord_add_user ?? null;
    }
    /**
     * Set ord_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_add_user(?string $ord_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_add_user) && !is_string($ord_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_add_user, true), gettype($ord_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ord_add_user) && mb_strlen((string) $ord_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ord_add_user)), __LINE__);
        }
        if (is_null($ord_add_user) || (is_array($ord_add_user) && empty($ord_add_user))) {
            unset($this->ord_add_user);
        } else {
            $this->ord_add_user = $ord_add_user;
        }
        
        return $this;
    }
    /**
     * Get ord_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_add_date(): ?string
    {
        return $this->ord_add_date ?? null;
    }
    /**
     * Set ord_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_add_date(?string $ord_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_add_date) && !is_string($ord_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_add_date, true), gettype($ord_add_date)), __LINE__);
        }
        if (is_null($ord_add_date) || (is_array($ord_add_date) && empty($ord_add_date))) {
            unset($this->ord_add_date);
        } else {
            $this->ord_add_date = $ord_add_date;
        }
        
        return $this;
    }
    /**
     * Get ord_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_change_user(): ?string
    {
        return $this->ord_change_user ?? null;
    }
    /**
     * Set ord_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_change_user(?string $ord_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_change_user) && !is_string($ord_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_change_user, true), gettype($ord_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ord_change_user) && mb_strlen((string) $ord_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $ord_change_user)), __LINE__);
        }
        if (is_null($ord_change_user) || (is_array($ord_change_user) && empty($ord_change_user))) {
            unset($this->ord_change_user);
        } else {
            $this->ord_change_user = $ord_change_user;
        }
        
        return $this;
    }
    /**
     * Get ord_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_change_date(): ?string
    {
        return $this->ord_change_date ?? null;
    }
    /**
     * Set ord_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_change_date(?string $ord_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_change_date) && !is_string($ord_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_change_date, true), gettype($ord_change_date)), __LINE__);
        }
        if (is_null($ord_change_date) || (is_array($ord_change_date) && empty($ord_change_date))) {
            unset($this->ord_change_date);
        } else {
            $this->ord_change_date = $ord_change_date;
        }
        
        return $this;
    }
    /**
     * Get ord_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_delete_flag(): ?string
    {
        return $this->ord_delete_flag ?? null;
    }
    /**
     * Set ord_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_delete_flag(?string $ord_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_delete_flag) && !is_string($ord_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_delete_flag, true), gettype($ord_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ord_delete_flag) && $ord_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ord_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ord_delete_flag) && $ord_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ord_delete_flag, true)), __LINE__);
        }
        if (is_null($ord_delete_flag) || (is_array($ord_delete_flag) && empty($ord_delete_flag))) {
            unset($this->ord_delete_flag);
        } else {
            $this->ord_delete_flag = $ord_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get ord_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_entity_key(): ?string
    {
        return $this->ord_entity_key ?? null;
    }
    /**
     * Set ord_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_entity_key(?string $ord_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_entity_key) && !is_string($ord_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_entity_key, true), gettype($ord_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_entity_key, true)), __LINE__);
        }
        if (is_null($ord_entity_key) || (is_array($ord_entity_key) && empty($ord_entity_key))) {
            unset($this->ord_entity_key);
        } else {
            $this->ord_entity_key = $ord_entity_key;
        }
        
        return $this;
    }
    /**
     * Get ord_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_key_ext(): ?string
    {
        return $this->ord_key_ext ?? null;
    }
    /**
     * Set ord_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_key_ext(?string $ord_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_key_ext) && !is_string($ord_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_key_ext, true), gettype($ord_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_key_ext, true)), __LINE__);
        }
        if (is_null($ord_key_ext) || (is_array($ord_key_ext) && empty($ord_key_ext))) {
            unset($this->ord_key_ext);
        } else {
            $this->ord_key_ext = $ord_key_ext;
        }
        
        return $this;
    }
    /**
     * Get ord_ait_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_ait_key(): ?string
    {
        return $this->ord_ait_key ?? null;
    }
    /**
     * Set ord_ait_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_ait_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_ait_key(?string $ord_ait_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_ait_key) && !is_string($ord_ait_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_ait_key, true), gettype($ord_ait_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_ait_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_ait_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_ait_key, true)), __LINE__);
        }
        if (is_null($ord_ait_key) || (is_array($ord_ait_key) && empty($ord_ait_key))) {
            unset($this->ord_ait_key);
        } else {
            $this->ord_ait_key = $ord_ait_key;
        }
        
        return $this;
    }
    /**
     * Get ord_first_process_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_first_process_date(): ?string
    {
        return $this->ord_first_process_date ?? null;
    }
    /**
     * Set ord_first_process_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_first_process_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_first_process_date(?string $ord_first_process_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_first_process_date) && !is_string($ord_first_process_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_first_process_date, true), gettype($ord_first_process_date)), __LINE__);
        }
        if (is_null($ord_first_process_date) || (is_array($ord_first_process_date) && empty($ord_first_process_date))) {
            unset($this->ord_first_process_date);
        } else {
            $this->ord_first_process_date = $ord_first_process_date;
        }
        
        return $this;
    }
    /**
     * Get ord_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_code(): ?string
    {
        return $this->ord_code ?? null;
    }
    /**
     * Set ord_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_code(?string $ord_code = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_code) && !is_string($ord_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_code, true), gettype($ord_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($ord_code) && mb_strlen((string) $ord_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $ord_code)), __LINE__);
        }
        if (is_null($ord_code) || (is_array($ord_code) && empty($ord_code))) {
            unset($this->ord_code);
        } else {
            $this->ord_code = $ord_code;
        }
        
        return $this;
    }
    /**
     * Get ord_close_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_close_flag(): ?string
    {
        return $this->ord_close_flag ?? null;
    }
    /**
     * Set ord_close_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_close_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_close_flag(?string $ord_close_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_close_flag) && !is_string($ord_close_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_close_flag, true), gettype($ord_close_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ord_close_flag) && $ord_close_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ord_close_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ord_close_flag) && $ord_close_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ord_close_flag, true)), __LINE__);
        }
        if (is_null($ord_close_flag) || (is_array($ord_close_flag) && empty($ord_close_flag))) {
            unset($this->ord_close_flag);
        } else {
            $this->ord_close_flag = $ord_close_flag;
        }
        
        return $this;
    }
    /**
     * Get ord_milestone_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_milestone_flag(): ?string
    {
        return $this->ord_milestone_flag ?? null;
    }
    /**
     * Set ord_milestone_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_milestone_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_milestone_flag(?string $ord_milestone_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_milestone_flag) && !is_string($ord_milestone_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_milestone_flag, true), gettype($ord_milestone_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ord_milestone_flag) && $ord_milestone_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ord_milestone_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ord_milestone_flag) && $ord_milestone_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ord_milestone_flag, true)), __LINE__);
        }
        if (is_null($ord_milestone_flag) || (is_array($ord_milestone_flag) && empty($ord_milestone_flag))) {
            unset($this->ord_milestone_flag);
        } else {
            $this->ord_milestone_flag = $ord_milestone_flag;
        }
        
        return $this;
    }
    /**
     * Get ord_cpi_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_cpi_key(): ?string
    {
        return $this->ord_cpi_key ?? null;
    }
    /**
     * Set ord_cpi_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_cpi_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_cpi_key(?string $ord_cpi_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_cpi_key) && !is_string($ord_cpi_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_cpi_key, true), gettype($ord_cpi_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_cpi_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_cpi_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_cpi_key, true)), __LINE__);
        }
        if (is_null($ord_cpi_key) || (is_array($ord_cpi_key) && empty($ord_cpi_key))) {
            unset($this->ord_cpi_key);
        } else {
            $this->ord_cpi_key = $ord_cpi_key;
        }
        
        return $this;
    }
    /**
     * Get ord_auto_pay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_auto_pay(): ?string
    {
        return $this->ord_auto_pay ?? null;
    }
    /**
     * Set ord_auto_pay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_auto_pay
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_auto_pay(?string $ord_auto_pay = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_auto_pay) && !is_string($ord_auto_pay)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_auto_pay, true), gettype($ord_auto_pay)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ord_auto_pay) && $ord_auto_pay > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ord_auto_pay, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ord_auto_pay) && $ord_auto_pay < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ord_auto_pay, true)), __LINE__);
        }
        if (is_null($ord_auto_pay) || (is_array($ord_auto_pay) && empty($ord_auto_pay))) {
            unset($this->ord_auto_pay);
        } else {
            $this->ord_auto_pay = $ord_auto_pay;
        }
        
        return $this;
    }
    /**
     * Get ord_orig_trans_type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_orig_trans_type(): ?string
    {
        return $this->ord_orig_trans_type ?? null;
    }
    /**
     * Set ord_orig_trans_type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_orig_trans_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_orig_trans_type(?string $ord_orig_trans_type = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_orig_trans_type) && !is_string($ord_orig_trans_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_orig_trans_type, true), gettype($ord_orig_trans_type)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($ord_orig_trans_type) && mb_strlen((string) $ord_orig_trans_type) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $ord_orig_trans_type)), __LINE__);
        }
        if (is_null($ord_orig_trans_type) || (is_array($ord_orig_trans_type) && empty($ord_orig_trans_type))) {
            unset($this->ord_orig_trans_type);
        } else {
            $this->ord_orig_trans_type = $ord_orig_trans_type;
        }
        
        return $this;
    }
    /**
     * Get ord_po_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_po_number(): ?string
    {
        return $this->ord_po_number ?? null;
    }
    /**
     * Set ord_po_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_po_number
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_po_number(?string $ord_po_number = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_po_number) && !is_string($ord_po_number)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_po_number, true), gettype($ord_po_number)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($ord_po_number) && mb_strlen((string) $ord_po_number) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $ord_po_number)), __LINE__);
        }
        if (is_null($ord_po_number) || (is_array($ord_po_number) && empty($ord_po_number))) {
            unset($this->ord_po_number);
        } else {
            $this->ord_po_number = $ord_po_number;
        }
        
        return $this;
    }
    /**
     * Get ord_cur_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_cur_key(): ?string
    {
        return $this->ord_cur_key ?? null;
    }
    /**
     * Set ord_cur_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_cur_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_cur_key(?string $ord_cur_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_cur_key) && !is_string($ord_cur_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_cur_key, true), gettype($ord_cur_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_cur_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_cur_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_cur_key, true)), __LINE__);
        }
        if (is_null($ord_cur_key) || (is_array($ord_cur_key) && empty($ord_cur_key))) {
            unset($this->ord_cur_key);
        } else {
            $this->ord_cur_key = $ord_cur_key;
        }
        
        return $this;
    }
    /**
     * Get ord_trx_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_trx_date(): ?string
    {
        return $this->ord_trx_date ?? null;
    }
    /**
     * Set ord_trx_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_trx_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_trx_date(?string $ord_trx_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_trx_date) && !is_string($ord_trx_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_trx_date, true), gettype($ord_trx_date)), __LINE__);
        }
        if (is_null($ord_trx_date) || (is_array($ord_trx_date) && empty($ord_trx_date))) {
            unset($this->ord_trx_date);
        } else {
            $this->ord_trx_date = $ord_trx_date;
        }
        
        return $this;
    }
    /**
     * Get ord_sfo_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_sfo_key(): ?string
    {
        return $this->ord_sfo_key ?? null;
    }
    /**
     * Set ord_sfo_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_sfo_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_sfo_key(?string $ord_sfo_key = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_sfo_key) && !is_string($ord_sfo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_sfo_key, true), gettype($ord_sfo_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($ord_sfo_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $ord_sfo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($ord_sfo_key, true)), __LINE__);
        }
        if (is_null($ord_sfo_key) || (is_array($ord_sfo_key) && empty($ord_sfo_key))) {
            unset($this->ord_sfo_key);
        } else {
            $this->ord_sfo_key = $ord_sfo_key;
        }
        
        return $this;
    }
    /**
     * Get ord_group_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_group_flag(): ?string
    {
        return $this->ord_group_flag ?? null;
    }
    /**
     * Set ord_group_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_group_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_group_flag(?string $ord_group_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_group_flag) && !is_string($ord_group_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_group_flag, true), gettype($ord_group_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($ord_group_flag) && $ord_group_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($ord_group_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($ord_group_flag) && $ord_group_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($ord_group_flag, true)), __LINE__);
        }
        if (is_null($ord_group_flag) || (is_array($ord_group_flag) && empty($ord_group_flag))) {
            unset($this->ord_group_flag);
        } else {
            $this->ord_group_flag = $ord_group_flag;
        }
        
        return $this;
    }
    /**
     * Get ord_group_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_group_description(): ?string
    {
        return $this->ord_group_description ?? null;
    }
    /**
     * Set ord_group_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_group_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_group_description(?string $ord_group_description = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_group_description) && !is_string($ord_group_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_group_description, true), gettype($ord_group_description)), __LINE__);
        }
        // validation for constraint: maxLength(300)
        if (!is_null($ord_group_description) && mb_strlen((string) $ord_group_description) > 300) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 300', mb_strlen((string) $ord_group_description)), __LINE__);
        }
        if (is_null($ord_group_description) || (is_array($ord_group_description) && empty($ord_group_description))) {
            unset($this->ord_group_description);
        } else {
            $this->ord_group_description = $ord_group_description;
        }
        
        return $this;
    }
    /**
     * Get ord_recurring_date value
     * @return ord_recurring_date
     */
    public function getOrd_recurring_date_1(): ?int
    {
        return $this->ord_recurring_date_1 ?? null;
    }
    /**
     * Set ord_recurring_date value
     * @param ord_recurring_date $ord_recurring_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_recurring_date_1(?int $ord_recurring_date_1 = null): self
    {
        // validation for constraint: int
        if (!is_null($ord_recurring_date_1) && !(is_int($ord_recurring_date_1) || ctype_digit($ord_recurring_date_1))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ord_recurring_date_1, true), gettype($ord_recurring_date_1)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ord_recurring_date_1) && $ord_recurring_date_1 > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ord_recurring_date_1, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ord_recurring_date_1) && $ord_recurring_date_1 < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ord_recurring_date_1, true)), __LINE__);
        }
        if (is_null($ord_recurring_date_1) || (is_array($ord_recurring_date_1) && empty($ord_recurring_date_1))) {
            unset($this->ord_recurring_date_1);
        } else {
            $this->ord_recurring_date_1 = $ord_recurring_date_1;
        }
        
        return $this;
    }
    /**
     * Get ord_recurring_date value
     * @return ord_recurring_date
     */
    public function getOrd_recurring_date_2(): ?int
    {
        return $this->ord_recurring_date_2 ?? null;
    }
    /**
     * Set ord_recurring_date value
     * @param ord_recurring_date $ord_recurring_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_recurring_date_2(?int $ord_recurring_date_2 = null): self
    {
        // validation for constraint: int
        if (!is_null($ord_recurring_date_2) && !(is_int($ord_recurring_date_2) || ctype_digit($ord_recurring_date_2))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ord_recurring_date_2, true), gettype($ord_recurring_date_2)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($ord_recurring_date_2) && $ord_recurring_date_2 > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($ord_recurring_date_2, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($ord_recurring_date_2) && $ord_recurring_date_2 < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($ord_recurring_date_2, true)), __LINE__);
        }
        if (is_null($ord_recurring_date_2) || (is_array($ord_recurring_date_2) && empty($ord_recurring_date_2))) {
            unset($this->ord_recurring_date_2);
        } else {
            $this->ord_recurring_date_2 = $ord_recurring_date_2;
        }
        
        return $this;
    }
    /**
     * Get ord_cpi_consent_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrd_cpi_consent_date(): ?string
    {
        return $this->ord_cpi_consent_date ?? null;
    }
    /**
     * Set ord_cpi_consent_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ord_cpi_consent_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CentralizedOrderEntry_InstallmentBilling_DataObjectType
     */
    public function setOrd_cpi_consent_date(?string $ord_cpi_consent_date = null): self
    {
        // validation for constraint: string
        if (!is_null($ord_cpi_consent_date) && !is_string($ord_cpi_consent_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ord_cpi_consent_date, true), gettype($ord_cpi_consent_date)), __LINE__);
        }
        if (is_null($ord_cpi_consent_date) || (is_array($ord_cpi_consent_date) && empty($ord_cpi_consent_date))) {
            unset($this->ord_cpi_consent_date);
        } else {
            $this->ord_cpi_consent_date = $ord_cpi_consent_date;
        }
        
        return $this;
    }
}
