<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CeuApplyExternalCredits StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class CeuApplyExternalCredits extends AbstractStructBase
{
    /**
     * The credits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Drupal\netforum\xWeb\Generated\StructType\CeuCreditList
     */
    protected \Drupal\netforum\xWeb\Generated\StructType\CeuCreditList $credits;
    /**
     * The individualKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string|null
     */
    protected ?string $individualKey;
    /**
     * Constructor method for CeuApplyExternalCredits
     * @uses CeuApplyExternalCredits::setCredits()
     * @uses CeuApplyExternalCredits::setIndividualKey()
     * @param \Drupal\netforum\xWeb\Generated\StructType\CeuCreditList $credits
     * @param string $individualKey
     */
    public function __construct(\Drupal\netforum\xWeb\Generated\StructType\CeuCreditList $credits, ?string $individualKey)
    {
        $this
            ->setCredits($credits)
            ->setIndividualKey($individualKey);
    }
    /**
     * Get credits value
     * @return \Drupal\netforum\xWeb\Generated\StructType\CeuCreditList
     */
    public function getCredits(): \Drupal\netforum\xWeb\Generated\StructType\CeuCreditList
    {
        return $this->credits;
    }
    /**
     * Set credits value
     * @param \Drupal\netforum\xWeb\Generated\StructType\CeuCreditList $credits
     * @return \Drupal\netforum\xWeb\Generated\StructType\CeuApplyExternalCredits
     */
    public function setCredits(\Drupal\netforum\xWeb\Generated\StructType\CeuCreditList $credits): self
    {
        $this->credits = $credits;
        
        return $this;
    }
    /**
     * Get individualKey value
     * @return string|null
     */
    public function getIndividualKey(): ?string
    {
        return $this->individualKey;
    }
    /**
     * Set individualKey value
     * @param string $individualKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\CeuApplyExternalCredits
     */
    public function setIndividualKey(?string $individualKey): self
    {
        // validation for constraint: string
        if (!is_null($individualKey) && !is_string($individualKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($individualKey, true), gettype($individualKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($individualKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $individualKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($individualKey, true)), __LINE__);
        }
        $this->individualKey = $individualKey;
        
        return $this;
    }
}
