<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CeuCreditList StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class CeuCreditList extends AbstractStructBase
{
    /**
     * The credit
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Drupal\netforum\xWeb\Generated\StructType\CeuCredit[]
     */
    protected ?array $credit = null;
    /**
     * Constructor method for CeuCreditList
     * @uses CeuCreditList::setCredit()
     * @param \Drupal\netforum\xWeb\Generated\StructType\CeuCredit[] $credit
     */
    public function __construct(?array $credit = null)
    {
        $this
            ->setCredit($credit);
    }
    /**
     * Get credit value
     * @return \Drupal\netforum\xWeb\Generated\StructType\CeuCredit[]
     */
    public function getCredit(): ?array
    {
        return $this->credit;
    }
    /**
     * This method is responsible for validating the value(s) passed to the setCredit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCredit method
     * This has to validate that each item contained by the array match the itemType constraint
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCreditForArrayConstraintFromSetCredit(?array $values = []): string
    {
        if (!is_array($values)) {
            return '';
        }
        $message = '';
        $invalidValues = [];
        foreach ($values as $ceuCreditListCreditItem) {
            // validation for constraint: itemType
            if (!$ceuCreditListCreditItem instanceof \Drupal\netforum\xWeb\Generated\StructType\CeuCredit) {
                $invalidValues[] = is_object($ceuCreditListCreditItem) ? get_class($ceuCreditListCreditItem) : sprintf('%s(%s)', gettype($ceuCreditListCreditItem), var_export($ceuCreditListCreditItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The credit property can only contain items of type \Drupal\netforum\xWeb\Generated\StructType\CeuCredit, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        
        return $message;
    }
    /**
     * Set credit value
     * @throws InvalidArgumentException
     * @param \Drupal\netforum\xWeb\Generated\StructType\CeuCredit[] $credit
     * @return \Drupal\netforum\xWeb\Generated\StructType\CeuCreditList
     */
    public function setCredit(?array $credit = null): self
    {
        // validation for constraint: array
        if ('' !== ($creditArrayErrorMessage = self::validateCreditForArrayConstraintFromSetCredit($credit))) {
            throw new InvalidArgumentException($creditArrayErrorMessage, __LINE__);
        }
        $this->credit = $credit;
        
        return $this;
    }
    /**
     * Add item to credit value
     * @throws InvalidArgumentException
     * @param \Drupal\netforum\xWeb\Generated\StructType\CeuCredit $item
     * @return \Drupal\netforum\xWeb\Generated\StructType\CeuCreditList
     */
    public function addToCredit(\Drupal\netforum\xWeb\Generated\StructType\CeuCredit $item): self
    {
        // validation for constraint: itemType
        if (!$item instanceof \Drupal\netforum\xWeb\Generated\StructType\CeuCredit) {
            throw new InvalidArgumentException(sprintf('The credit property can only contain items of type \Drupal\netforum\xWeb\Generated\StructType\CeuCredit, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->credit[] = $item;
        
        return $this;
    }
}
