<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CeuCreditResult StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class CeuCreditResult extends AbstractStructBase
{
    /**
     * The externalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $externalId = null;
    /**
     * The resultStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $resultStatus = null;
    /**
     * The resultMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $resultMessage = null;
    /**
     * The ceu_key
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string|null
     */
    protected ?string $ceu_key;
    /**
     * Constructor method for CeuCreditResult
     * @uses CeuCreditResult::setExternalId()
     * @uses CeuCreditResult::setResultStatus()
     * @uses CeuCreditResult::setResultMessage()
     * @uses CeuCreditResult::setCeu_key()
     * @param string $externalId
     * @param string $resultStatus
     * @param string $resultMessage
     * @param string $ceu_key
     */
    public function __construct(?string $externalId = null, ?string $resultStatus = null, ?string $resultMessage = null, ?string $ceu_key)
    {
        $this
            ->setExternalId($externalId)
            ->setResultStatus($resultStatus)
            ->setResultMessage($resultMessage)
            ->setCeu_key($ceu_key);
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId(): ?string
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \Drupal\netforum\xWeb\Generated\StructType\CeuCreditResult
     */
    public function setExternalId(?string $externalId = null): self
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        
        return $this;
    }
    /**
     * Get resultStatus value
     * @return string|null
     */
    public function getResultStatus(): ?string
    {
        return $this->resultStatus;
    }
    /**
     * Set resultStatus value
     * @param string $resultStatus
     * @return \Drupal\netforum\xWeb\Generated\StructType\CeuCreditResult
     */
    public function setResultStatus(?string $resultStatus = null): self
    {
        // validation for constraint: string
        if (!is_null($resultStatus) && !is_string($resultStatus)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultStatus, true), gettype($resultStatus)), __LINE__);
        }
        $this->resultStatus = $resultStatus;
        
        return $this;
    }
    /**
     * Get resultMessage value
     * @return string|null
     */
    public function getResultMessage(): ?string
    {
        return $this->resultMessage;
    }
    /**
     * Set resultMessage value
     * @param string $resultMessage
     * @return \Drupal\netforum\xWeb\Generated\StructType\CeuCreditResult
     */
    public function setResultMessage(?string $resultMessage = null): self
    {
        // validation for constraint: string
        if (!is_null($resultMessage) && !is_string($resultMessage)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultMessage, true), gettype($resultMessage)), __LINE__);
        }
        $this->resultMessage = $resultMessage;
        
        return $this;
    }
    /**
     * Get ceu_key value
     * @return string|null
     */
    public function getCeu_key(): ?string
    {
        return $this->ceu_key;
    }
    /**
     * Set ceu_key value
     * @param string $ceu_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CeuCreditResult
     */
    public function setCeu_key(?string $ceu_key): self
    {
        // validation for constraint: string
        if (!is_null($ceu_key) && !is_string($ceu_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ceu_key, true), gettype($ceu_key)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($ceu_key) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', (string) $ceu_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($ceu_key, true)), __LINE__);
        }
        $this->ceu_key = $ceu_key;
        
        return $this;
    }
}
