<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Chapter_Fax_XRef_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Chapter_Fax_XRef_DataObjectType extends AbstractStructBase
{
    /**
     * The cfx_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cfx_key = null;
    /**
     * The cfx_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cfx_cst_key = null;
    /**
     * The cfx_fax_key
     * Meta information extracted from the WSDL
     * - documentation: Fax. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cfx_fax_key = null;
    /**
     * The cfx_fxt_key
     * Meta information extracted from the WSDL
     * - documentation: Fax Type.This element has a default value of '785c36f5-aef2-48b8-a229-3a3af0a969f1'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cfx_fxt_key = null;
    /**
     * The cfx_cst_link_key
     * Meta information extracted from the WSDL
     * - documentation: Linked Fax Customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cfx_cst_link_key = null;
    /**
     * The cfx_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cfx_add_user = null;
    /**
     * The cfx_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cfx_add_date = null;
    /**
     * The cfx_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cfx_change_user = null;
    /**
     * The cfx_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cfx_change_date = null;
    /**
     * The cfx_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cfx_delete_flag = null;
    /**
     * The cfx_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cfx_key_ext = null;
    /**
     * The cfx_unlisted_flag
     * Meta information extracted from the WSDL
     * - documentation: Unlisted Fax. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cfx_unlisted_flag = null;
    /**
     * The cfx_fax_number_complete
     * Meta information extracted from the WSDL
     * - documentation: fax number complete. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 55
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cfx_fax_number_complete = null;
    /**
     * The cfx_extension
     * Meta information extracted from the WSDL
     * - documentation: Fax Extension. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cfx_extension = null;
    /**
     * The cfx_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cfx_entity_key = null;
    /**
     * The cfx_primary
     * Meta information extracted from the WSDL
     * - documentation: Primary.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cfx_primary = null;
    /**
     * The cfx_owner
     * Meta information extracted from the WSDL
     * - documentation: Fax Owner.This element has a default value of '0'. This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cfx_owner = null;
    /**
     * The cfx_FaxLinkingDropDownList
     * Meta information extracted from the WSDL
     * - documentation: FaxLinkingDropDownList.This field is NOT a Data Field and is Read-Only. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cfx_FaxLinkingDropDownList = null;
    /**
     * Constructor method for Chapter_Fax_XRef_DataObjectType
     * @uses Chapter_Fax_XRef_DataObjectType::setCfx_key()
     * @uses Chapter_Fax_XRef_DataObjectType::setCfx_cst_key()
     * @uses Chapter_Fax_XRef_DataObjectType::setCfx_fax_key()
     * @uses Chapter_Fax_XRef_DataObjectType::setCfx_fxt_key()
     * @uses Chapter_Fax_XRef_DataObjectType::setCfx_cst_link_key()
     * @uses Chapter_Fax_XRef_DataObjectType::setCfx_add_user()
     * @uses Chapter_Fax_XRef_DataObjectType::setCfx_add_date()
     * @uses Chapter_Fax_XRef_DataObjectType::setCfx_change_user()
     * @uses Chapter_Fax_XRef_DataObjectType::setCfx_change_date()
     * @uses Chapter_Fax_XRef_DataObjectType::setCfx_delete_flag()
     * @uses Chapter_Fax_XRef_DataObjectType::setCfx_key_ext()
     * @uses Chapter_Fax_XRef_DataObjectType::setCfx_unlisted_flag()
     * @uses Chapter_Fax_XRef_DataObjectType::setCfx_fax_number_complete()
     * @uses Chapter_Fax_XRef_DataObjectType::setCfx_extension()
     * @uses Chapter_Fax_XRef_DataObjectType::setCfx_entity_key()
     * @uses Chapter_Fax_XRef_DataObjectType::setCfx_primary()
     * @uses Chapter_Fax_XRef_DataObjectType::setCfx_owner()
     * @uses Chapter_Fax_XRef_DataObjectType::setCfx_FaxLinkingDropDownList()
     * @param string $cfx_key
     * @param string $cfx_cst_key
     * @param string $cfx_fax_key
     * @param string $cfx_fxt_key
     * @param string $cfx_cst_link_key
     * @param string $cfx_add_user
     * @param string $cfx_add_date
     * @param string $cfx_change_user
     * @param string $cfx_change_date
     * @param string $cfx_delete_flag
     * @param string $cfx_key_ext
     * @param string $cfx_unlisted_flag
     * @param string $cfx_fax_number_complete
     * @param string $cfx_extension
     * @param string $cfx_entity_key
     * @param string $cfx_primary
     * @param string $cfx_owner
     * @param string $cfx_FaxLinkingDropDownList
     */
    public function __construct(?string $cfx_key = null, ?string $cfx_cst_key = null, ?string $cfx_fax_key = null, ?string $cfx_fxt_key = null, ?string $cfx_cst_link_key = null, ?string $cfx_add_user = null, ?string $cfx_add_date = null, ?string $cfx_change_user = null, ?string $cfx_change_date = null, ?string $cfx_delete_flag = null, ?string $cfx_key_ext = null, ?string $cfx_unlisted_flag = null, ?string $cfx_fax_number_complete = null, ?string $cfx_extension = null, ?string $cfx_entity_key = null, ?string $cfx_primary = null, ?string $cfx_owner = null, ?string $cfx_FaxLinkingDropDownList = null)
    {
        $this
            ->setCfx_key($cfx_key)
            ->setCfx_cst_key($cfx_cst_key)
            ->setCfx_fax_key($cfx_fax_key)
            ->setCfx_fxt_key($cfx_fxt_key)
            ->setCfx_cst_link_key($cfx_cst_link_key)
            ->setCfx_add_user($cfx_add_user)
            ->setCfx_add_date($cfx_add_date)
            ->setCfx_change_user($cfx_change_user)
            ->setCfx_change_date($cfx_change_date)
            ->setCfx_delete_flag($cfx_delete_flag)
            ->setCfx_key_ext($cfx_key_ext)
            ->setCfx_unlisted_flag($cfx_unlisted_flag)
            ->setCfx_fax_number_complete($cfx_fax_number_complete)
            ->setCfx_extension($cfx_extension)
            ->setCfx_entity_key($cfx_entity_key)
            ->setCfx_primary($cfx_primary)
            ->setCfx_owner($cfx_owner)
            ->setCfx_FaxLinkingDropDownList($cfx_FaxLinkingDropDownList);
    }
    /**
     * Get cfx_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCfx_key(): ?string
    {
        return $this->cfx_key ?? null;
    }
    /**
     * Set cfx_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cfx_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Fax_XRef_DataObjectType
     */
    public function setCfx_key(?string $cfx_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cfx_key) && !is_string($cfx_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cfx_key, true), gettype($cfx_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cfx_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cfx_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cfx_key, true)), __LINE__);
        }
        if (is_null($cfx_key) || (is_array($cfx_key) && empty($cfx_key))) {
            unset($this->cfx_key);
        } else {
            $this->cfx_key = $cfx_key;
        }
        
        return $this;
    }
    /**
     * Get cfx_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCfx_cst_key(): ?string
    {
        return $this->cfx_cst_key ?? null;
    }
    /**
     * Set cfx_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cfx_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Fax_XRef_DataObjectType
     */
    public function setCfx_cst_key(?string $cfx_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cfx_cst_key) && !is_string($cfx_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cfx_cst_key, true), gettype($cfx_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cfx_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cfx_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cfx_cst_key, true)), __LINE__);
        }
        if (is_null($cfx_cst_key) || (is_array($cfx_cst_key) && empty($cfx_cst_key))) {
            unset($this->cfx_cst_key);
        } else {
            $this->cfx_cst_key = $cfx_cst_key;
        }
        
        return $this;
    }
    /**
     * Get cfx_fax_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCfx_fax_key(): ?string
    {
        return $this->cfx_fax_key ?? null;
    }
    /**
     * Set cfx_fax_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cfx_fax_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Fax_XRef_DataObjectType
     */
    public function setCfx_fax_key(?string $cfx_fax_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cfx_fax_key) && !is_string($cfx_fax_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cfx_fax_key, true), gettype($cfx_fax_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cfx_fax_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cfx_fax_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cfx_fax_key, true)), __LINE__);
        }
        if (is_null($cfx_fax_key) || (is_array($cfx_fax_key) && empty($cfx_fax_key))) {
            unset($this->cfx_fax_key);
        } else {
            $this->cfx_fax_key = $cfx_fax_key;
        }
        
        return $this;
    }
    /**
     * Get cfx_fxt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCfx_fxt_key(): ?string
    {
        return $this->cfx_fxt_key ?? null;
    }
    /**
     * Set cfx_fxt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cfx_fxt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Fax_XRef_DataObjectType
     */
    public function setCfx_fxt_key(?string $cfx_fxt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cfx_fxt_key) && !is_string($cfx_fxt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cfx_fxt_key, true), gettype($cfx_fxt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cfx_fxt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cfx_fxt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cfx_fxt_key, true)), __LINE__);
        }
        if (is_null($cfx_fxt_key) || (is_array($cfx_fxt_key) && empty($cfx_fxt_key))) {
            unset($this->cfx_fxt_key);
        } else {
            $this->cfx_fxt_key = $cfx_fxt_key;
        }
        
        return $this;
    }
    /**
     * Get cfx_cst_link_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCfx_cst_link_key(): ?string
    {
        return $this->cfx_cst_link_key ?? null;
    }
    /**
     * Set cfx_cst_link_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cfx_cst_link_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Fax_XRef_DataObjectType
     */
    public function setCfx_cst_link_key(?string $cfx_cst_link_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cfx_cst_link_key) && !is_string($cfx_cst_link_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cfx_cst_link_key, true), gettype($cfx_cst_link_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cfx_cst_link_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cfx_cst_link_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cfx_cst_link_key, true)), __LINE__);
        }
        if (is_null($cfx_cst_link_key) || (is_array($cfx_cst_link_key) && empty($cfx_cst_link_key))) {
            unset($this->cfx_cst_link_key);
        } else {
            $this->cfx_cst_link_key = $cfx_cst_link_key;
        }
        
        return $this;
    }
    /**
     * Get cfx_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCfx_add_user(): ?string
    {
        return $this->cfx_add_user ?? null;
    }
    /**
     * Set cfx_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cfx_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Fax_XRef_DataObjectType
     */
    public function setCfx_add_user(?string $cfx_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cfx_add_user) && !is_string($cfx_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cfx_add_user, true), gettype($cfx_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cfx_add_user) && mb_strlen((string) $cfx_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cfx_add_user)), __LINE__);
        }
        if (is_null($cfx_add_user) || (is_array($cfx_add_user) && empty($cfx_add_user))) {
            unset($this->cfx_add_user);
        } else {
            $this->cfx_add_user = $cfx_add_user;
        }
        
        return $this;
    }
    /**
     * Get cfx_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCfx_add_date(): ?string
    {
        return $this->cfx_add_date ?? null;
    }
    /**
     * Set cfx_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cfx_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Fax_XRef_DataObjectType
     */
    public function setCfx_add_date(?string $cfx_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cfx_add_date) && !is_string($cfx_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cfx_add_date, true), gettype($cfx_add_date)), __LINE__);
        }
        if (is_null($cfx_add_date) || (is_array($cfx_add_date) && empty($cfx_add_date))) {
            unset($this->cfx_add_date);
        } else {
            $this->cfx_add_date = $cfx_add_date;
        }
        
        return $this;
    }
    /**
     * Get cfx_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCfx_change_user(): ?string
    {
        return $this->cfx_change_user ?? null;
    }
    /**
     * Set cfx_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cfx_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Fax_XRef_DataObjectType
     */
    public function setCfx_change_user(?string $cfx_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cfx_change_user) && !is_string($cfx_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cfx_change_user, true), gettype($cfx_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cfx_change_user) && mb_strlen((string) $cfx_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cfx_change_user)), __LINE__);
        }
        if (is_null($cfx_change_user) || (is_array($cfx_change_user) && empty($cfx_change_user))) {
            unset($this->cfx_change_user);
        } else {
            $this->cfx_change_user = $cfx_change_user;
        }
        
        return $this;
    }
    /**
     * Get cfx_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCfx_change_date(): ?string
    {
        return $this->cfx_change_date ?? null;
    }
    /**
     * Set cfx_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cfx_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Fax_XRef_DataObjectType
     */
    public function setCfx_change_date(?string $cfx_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cfx_change_date) && !is_string($cfx_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cfx_change_date, true), gettype($cfx_change_date)), __LINE__);
        }
        if (is_null($cfx_change_date) || (is_array($cfx_change_date) && empty($cfx_change_date))) {
            unset($this->cfx_change_date);
        } else {
            $this->cfx_change_date = $cfx_change_date;
        }
        
        return $this;
    }
    /**
     * Get cfx_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCfx_delete_flag(): ?string
    {
        return $this->cfx_delete_flag ?? null;
    }
    /**
     * Set cfx_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cfx_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Fax_XRef_DataObjectType
     */
    public function setCfx_delete_flag(?string $cfx_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cfx_delete_flag) && !is_string($cfx_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cfx_delete_flag, true), gettype($cfx_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cfx_delete_flag) && $cfx_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cfx_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cfx_delete_flag) && $cfx_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cfx_delete_flag, true)), __LINE__);
        }
        if (is_null($cfx_delete_flag) || (is_array($cfx_delete_flag) && empty($cfx_delete_flag))) {
            unset($this->cfx_delete_flag);
        } else {
            $this->cfx_delete_flag = $cfx_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get cfx_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCfx_key_ext(): ?string
    {
        return $this->cfx_key_ext ?? null;
    }
    /**
     * Set cfx_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cfx_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Fax_XRef_DataObjectType
     */
    public function setCfx_key_ext(?string $cfx_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($cfx_key_ext) && !is_string($cfx_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cfx_key_ext, true), gettype($cfx_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cfx_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cfx_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cfx_key_ext, true)), __LINE__);
        }
        if (is_null($cfx_key_ext) || (is_array($cfx_key_ext) && empty($cfx_key_ext))) {
            unset($this->cfx_key_ext);
        } else {
            $this->cfx_key_ext = $cfx_key_ext;
        }
        
        return $this;
    }
    /**
     * Get cfx_unlisted_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCfx_unlisted_flag(): ?string
    {
        return $this->cfx_unlisted_flag ?? null;
    }
    /**
     * Set cfx_unlisted_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cfx_unlisted_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Fax_XRef_DataObjectType
     */
    public function setCfx_unlisted_flag(?string $cfx_unlisted_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cfx_unlisted_flag) && !is_string($cfx_unlisted_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cfx_unlisted_flag, true), gettype($cfx_unlisted_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cfx_unlisted_flag) && $cfx_unlisted_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cfx_unlisted_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cfx_unlisted_flag) && $cfx_unlisted_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cfx_unlisted_flag, true)), __LINE__);
        }
        if (is_null($cfx_unlisted_flag) || (is_array($cfx_unlisted_flag) && empty($cfx_unlisted_flag))) {
            unset($this->cfx_unlisted_flag);
        } else {
            $this->cfx_unlisted_flag = $cfx_unlisted_flag;
        }
        
        return $this;
    }
    /**
     * Get cfx_fax_number_complete value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCfx_fax_number_complete(): ?string
    {
        return $this->cfx_fax_number_complete ?? null;
    }
    /**
     * Set cfx_fax_number_complete value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cfx_fax_number_complete
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Fax_XRef_DataObjectType
     */
    public function setCfx_fax_number_complete(?string $cfx_fax_number_complete = null): self
    {
        // validation for constraint: string
        if (!is_null($cfx_fax_number_complete) && !is_string($cfx_fax_number_complete)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cfx_fax_number_complete, true), gettype($cfx_fax_number_complete)), __LINE__);
        }
        // validation for constraint: maxLength(55)
        if (!is_null($cfx_fax_number_complete) && mb_strlen((string) $cfx_fax_number_complete) > 55) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 55', mb_strlen((string) $cfx_fax_number_complete)), __LINE__);
        }
        if (is_null($cfx_fax_number_complete) || (is_array($cfx_fax_number_complete) && empty($cfx_fax_number_complete))) {
            unset($this->cfx_fax_number_complete);
        } else {
            $this->cfx_fax_number_complete = $cfx_fax_number_complete;
        }
        
        return $this;
    }
    /**
     * Get cfx_extension value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCfx_extension(): ?string
    {
        return $this->cfx_extension ?? null;
    }
    /**
     * Set cfx_extension value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cfx_extension
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Fax_XRef_DataObjectType
     */
    public function setCfx_extension(?string $cfx_extension = null): self
    {
        // validation for constraint: string
        if (!is_null($cfx_extension) && !is_string($cfx_extension)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cfx_extension, true), gettype($cfx_extension)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($cfx_extension) && mb_strlen((string) $cfx_extension) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $cfx_extension)), __LINE__);
        }
        if (is_null($cfx_extension) || (is_array($cfx_extension) && empty($cfx_extension))) {
            unset($this->cfx_extension);
        } else {
            $this->cfx_extension = $cfx_extension;
        }
        
        return $this;
    }
    /**
     * Get cfx_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCfx_entity_key(): ?string
    {
        return $this->cfx_entity_key ?? null;
    }
    /**
     * Set cfx_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cfx_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Fax_XRef_DataObjectType
     */
    public function setCfx_entity_key(?string $cfx_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cfx_entity_key) && !is_string($cfx_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cfx_entity_key, true), gettype($cfx_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cfx_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cfx_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cfx_entity_key, true)), __LINE__);
        }
        if (is_null($cfx_entity_key) || (is_array($cfx_entity_key) && empty($cfx_entity_key))) {
            unset($this->cfx_entity_key);
        } else {
            $this->cfx_entity_key = $cfx_entity_key;
        }
        
        return $this;
    }
    /**
     * Get cfx_primary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCfx_primary(): ?string
    {
        return $this->cfx_primary ?? null;
    }
    /**
     * Set cfx_primary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cfx_primary
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Fax_XRef_DataObjectType
     */
    public function setCfx_primary(?string $cfx_primary = null): self
    {
        // validation for constraint: string
        if (!is_null($cfx_primary) && !is_string($cfx_primary)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cfx_primary, true), gettype($cfx_primary)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cfx_primary) && $cfx_primary > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cfx_primary, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cfx_primary) && $cfx_primary < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cfx_primary, true)), __LINE__);
        }
        if (is_null($cfx_primary) || (is_array($cfx_primary) && empty($cfx_primary))) {
            unset($this->cfx_primary);
        } else {
            $this->cfx_primary = $cfx_primary;
        }
        
        return $this;
    }
    /**
     * Get cfx_owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCfx_owner(): ?string
    {
        return $this->cfx_owner ?? null;
    }
    /**
     * Set cfx_owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cfx_owner
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Fax_XRef_DataObjectType
     */
    public function setCfx_owner(?string $cfx_owner = null): self
    {
        // validation for constraint: string
        if (!is_null($cfx_owner) && !is_string($cfx_owner)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cfx_owner, true), gettype($cfx_owner)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cfx_owner) && $cfx_owner > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cfx_owner, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cfx_owner) && $cfx_owner < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cfx_owner, true)), __LINE__);
        }
        if (is_null($cfx_owner) || (is_array($cfx_owner) && empty($cfx_owner))) {
            unset($this->cfx_owner);
        } else {
            $this->cfx_owner = $cfx_owner;
        }
        
        return $this;
    }
    /**
     * Get cfx_FaxLinkingDropDownList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCfx_FaxLinkingDropDownList(): ?string
    {
        return $this->cfx_FaxLinkingDropDownList ?? null;
    }
    /**
     * Set cfx_FaxLinkingDropDownList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cfx_FaxLinkingDropDownList
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Fax_XRef_DataObjectType
     */
    public function setCfx_FaxLinkingDropDownList(?string $cfx_FaxLinkingDropDownList = null): self
    {
        // validation for constraint: string
        if (!is_null($cfx_FaxLinkingDropDownList) && !is_string($cfx_FaxLinkingDropDownList)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cfx_FaxLinkingDropDownList, true), gettype($cfx_FaxLinkingDropDownList)), __LINE__);
        }
        if (is_null($cfx_FaxLinkingDropDownList) || (is_array($cfx_FaxLinkingDropDownList) && empty($cfx_FaxLinkingDropDownList))) {
            unset($this->cfx_FaxLinkingDropDownList);
        } else {
            $this->cfx_FaxLinkingDropDownList = $cfx_FaxLinkingDropDownList;
        }
        
        return $this;
    }
}
