<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Chapter_Prim._Contact_Address_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Chapter_Prim__Contact_Address_DataObjectType extends AbstractStructBase
{
    /**
     * The pad__adr_key
     * Meta information extracted from the WSDL
     * - documentation: Address Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pad__adr_key = null;
    /**
     * The pad__adr_cst_key_owner
     * Meta information extracted from the WSDL
     * - documentation: Address Owner. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pad__adr_cst_key_owner = null;
    /**
     * The pad__adr_line1
     * Meta information extracted from the WSDL
     * - documentation: Address Line 1. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 75
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pad__adr_line1 = null;
    /**
     * The pad__adr_line2
     * Meta information extracted from the WSDL
     * - documentation: Address Line 2. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 75
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pad__adr_line2 = null;
    /**
     * The pad__adr_line3
     * Meta information extracted from the WSDL
     * - documentation: Address Line 3. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 75
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pad__adr_line3 = null;
    /**
     * The pad__adr_city
     * Meta information extracted from the WSDL
     * - documentation: City. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pad__adr_city = null;
    /**
     * The pad__adr_state
     * Meta information extracted from the WSDL
     * - documentation: State/Territory.This element has a default value of 'NULL'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pad__adr_state = null;
    /**
     * The pad__adr_post_code
     * Meta information extracted from the WSDL
     * - documentation: Postal Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pad__adr_post_code = null;
    /**
     * The pad__adr_city_state_code
     * Meta information extracted from the WSDL
     * - documentation: City, State, Post Code. This field is automatically calculated within netForum and cannot be updated via netForum xWeb. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 104
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pad__adr_city_state_code = null;
    /**
     * The pad__adr_country
     * Meta information extracted from the WSDL
     * - documentation: Country.This element has a default value of 'UNITED STATES'. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pad__adr_country = null;
    /**
     * The pad__adr_intl_province
     * Meta information extracted from the WSDL
     * - documentation: International Province. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pad__adr_intl_province = null;
    /**
     * The pad__adr_county
     * Meta information extracted from the WSDL
     * - documentation: County. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pad__adr_county = null;
    /**
     * The pad__adr_cong_dist
     * Meta information extracted from the WSDL
     * - documentation: Congressional District. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pad__adr_cong_dist = null;
    /**
     * The pad__adr_state_house
     * Meta information extracted from the WSDL
     * - documentation: State House. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pad__adr_state_house = null;
    /**
     * The pad__adr_state_senate
     * Meta information extracted from the WSDL
     * - documentation: State Senate. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pad__adr_state_senate = null;
    /**
     * The pad__adr_latitude
     * Meta information extracted from the WSDL
     * - documentation: Latitude. | Avectra netForum defined simpleType.
     * - base: s:double
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float|null
     */
    protected ?float $pad__adr_latitude = null;
    /**
     * The pad__adr_longitude
     * Meta information extracted from the WSDL
     * - documentation: Longitude. | Avectra netForum defined simpleType.
     * - base: s:double
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float|null
     */
    protected ?float $pad__adr_longitude = null;
    /**
     * The pad__adr_mailing_label
     * Meta information extracted from the WSDL
     * - documentation: Mailing Label. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 450
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pad__adr_mailing_label = null;
    /**
     * The pad__adr_mailing_label_html
     * Meta information extracted from the WSDL
     * - documentation: Mailing Label HTML. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 450
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pad__adr_mailing_label_html = null;
    /**
     * The pad__adr_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pad__adr_add_date = null;
    /**
     * The pad__adr_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pad__adr_add_user = null;
    /**
     * The pad__adr_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pad__adr_change_date = null;
    /**
     * The pad__adr_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pad__adr_change_user = null;
    /**
     * The pad__adr_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pad__adr_delete_flag = null;
    /**
     * The pad__adr_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pad__adr_key_ext = null;
    /**
     * The pad__adr_bad_address_flag
     * Meta information extracted from the WSDL
     * - documentation: Bad Address Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pad__adr_bad_address_flag = null;
    /**
     * The pad__adr_adb_key
     * Meta information extracted from the WSDL
     * - documentation: Bad Address Type Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pad__adr_adb_key = null;
    /**
     * The pad__adr_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $pad__adr_entity_key = null;
    /**
     * The pad__adr_metro_stat_area
     * Meta information extracted from the WSDL
     * - documentation: Metropolitan Statistical Area. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pad__adr_metro_stat_area = null;
    /**
     * The pad__adr_carrier_route
     * Meta information extracted from the WSDL
     * - documentation: Carrier Route. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pad__adr_carrier_route = null;
    /**
     * The pad__adr_delivery_point_code
     * Meta information extracted from the WSDL
     * - documentation: Delivery Point Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pad__adr_delivery_point_code = null;
    /**
     * The pad__adr_lacs
     * Meta information extracted from the WSDL
     * - documentation: LACS. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pad__adr_lacs = null;
    /**
     * The pad__adr_time_zone
     * Meta information extracted from the WSDL
     * - documentation: TimeZone. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pad__adr_time_zone = null;
    /**
     * The pad__adr_urbanization
     * Meta information extracted from the WSDL
     * - documentation: Urbanization. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 75
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pad__adr_urbanization = null;
    /**
     * The pad__adr_bar_code
     * Meta information extracted from the WSDL
     * - documentation: BarCode. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pad__adr_bar_code = null;
    /**
     * The pad__adr_fips
     * Meta information extracted from the WSDL
     * - documentation: County FIPS Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 5
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pad__adr_fips = null;
    /**
     * The pad__adr_no_validation_flag
     * Meta information extracted from the WSDL
     * - documentation: Do Not Validate. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pad__adr_no_validation_flag = null;
    /**
     * The pad__adr_attn
     * Meta information extracted from the WSDL
     * - documentation: Attention. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 75
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pad__adr_attn = null;
    /**
     * The pad__adr_record_type_code
     * Meta information extracted from the WSDL
     * - documentation: Record Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pad__adr_record_type_code = null;
    /**
     * The pad__adr_geography
     * Meta information extracted from the WSDL
     * - documentation: geography datatype. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $pad__adr_geography = null;
    /**
     * Constructor method for Chapter_Prim._Contact_Address_DataObjectType
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_key()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_cst_key_owner()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_line1()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_line2()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_line3()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_city()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_state()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_post_code()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_city_state_code()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_country()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_intl_province()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_county()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_cong_dist()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_state_house()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_state_senate()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_latitude()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_longitude()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_mailing_label()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_mailing_label_html()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_add_date()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_add_user()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_change_date()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_change_user()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_delete_flag()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_key_ext()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_bad_address_flag()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_adb_key()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_entity_key()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_metro_stat_area()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_carrier_route()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_delivery_point_code()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_lacs()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_time_zone()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_urbanization()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_bar_code()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_fips()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_no_validation_flag()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_attn()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_record_type_code()
     * @uses Chapter_Prim__Contact_Address_DataObjectType::setPad__adr_geography()
     * @param string $pad__adr_key
     * @param string $pad__adr_cst_key_owner
     * @param string $pad__adr_line1
     * @param string $pad__adr_line2
     * @param string $pad__adr_line3
     * @param string $pad__adr_city
     * @param string $pad__adr_state
     * @param string $pad__adr_post_code
     * @param string $pad__adr_city_state_code
     * @param string $pad__adr_country
     * @param string $pad__adr_intl_province
     * @param string $pad__adr_county
     * @param string $pad__adr_cong_dist
     * @param string $pad__adr_state_house
     * @param string $pad__adr_state_senate
     * @param float $pad__adr_latitude
     * @param float $pad__adr_longitude
     * @param string $pad__adr_mailing_label
     * @param string $pad__adr_mailing_label_html
     * @param string $pad__adr_add_date
     * @param string $pad__adr_add_user
     * @param string $pad__adr_change_date
     * @param string $pad__adr_change_user
     * @param string $pad__adr_delete_flag
     * @param string $pad__adr_key_ext
     * @param string $pad__adr_bad_address_flag
     * @param string $pad__adr_adb_key
     * @param string $pad__adr_entity_key
     * @param string $pad__adr_metro_stat_area
     * @param string $pad__adr_carrier_route
     * @param string $pad__adr_delivery_point_code
     * @param string $pad__adr_lacs
     * @param string $pad__adr_time_zone
     * @param string $pad__adr_urbanization
     * @param string $pad__adr_bar_code
     * @param string $pad__adr_fips
     * @param string $pad__adr_no_validation_flag
     * @param string $pad__adr_attn
     * @param string $pad__adr_record_type_code
     * @param string $pad__adr_geography
     */
    public function __construct(?string $pad__adr_key = null, ?string $pad__adr_cst_key_owner = null, ?string $pad__adr_line1 = null, ?string $pad__adr_line2 = null, ?string $pad__adr_line3 = null, ?string $pad__adr_city = null, ?string $pad__adr_state = null, ?string $pad__adr_post_code = null, ?string $pad__adr_city_state_code = null, ?string $pad__adr_country = null, ?string $pad__adr_intl_province = null, ?string $pad__adr_county = null, ?string $pad__adr_cong_dist = null, ?string $pad__adr_state_house = null, ?string $pad__adr_state_senate = null, ?float $pad__adr_latitude = null, ?float $pad__adr_longitude = null, ?string $pad__adr_mailing_label = null, ?string $pad__adr_mailing_label_html = null, ?string $pad__adr_add_date = null, ?string $pad__adr_add_user = null, ?string $pad__adr_change_date = null, ?string $pad__adr_change_user = null, ?string $pad__adr_delete_flag = null, ?string $pad__adr_key_ext = null, ?string $pad__adr_bad_address_flag = null, ?string $pad__adr_adb_key = null, ?string $pad__adr_entity_key = null, ?string $pad__adr_metro_stat_area = null, ?string $pad__adr_carrier_route = null, ?string $pad__adr_delivery_point_code = null, ?string $pad__adr_lacs = null, ?string $pad__adr_time_zone = null, ?string $pad__adr_urbanization = null, ?string $pad__adr_bar_code = null, ?string $pad__adr_fips = null, ?string $pad__adr_no_validation_flag = null, ?string $pad__adr_attn = null, ?string $pad__adr_record_type_code = null, ?string $pad__adr_geography = null)
    {
        $this
            ->setPad__adr_key($pad__adr_key)
            ->setPad__adr_cst_key_owner($pad__adr_cst_key_owner)
            ->setPad__adr_line1($pad__adr_line1)
            ->setPad__adr_line2($pad__adr_line2)
            ->setPad__adr_line3($pad__adr_line3)
            ->setPad__adr_city($pad__adr_city)
            ->setPad__adr_state($pad__adr_state)
            ->setPad__adr_post_code($pad__adr_post_code)
            ->setPad__adr_city_state_code($pad__adr_city_state_code)
            ->setPad__adr_country($pad__adr_country)
            ->setPad__adr_intl_province($pad__adr_intl_province)
            ->setPad__adr_county($pad__adr_county)
            ->setPad__adr_cong_dist($pad__adr_cong_dist)
            ->setPad__adr_state_house($pad__adr_state_house)
            ->setPad__adr_state_senate($pad__adr_state_senate)
            ->setPad__adr_latitude($pad__adr_latitude)
            ->setPad__adr_longitude($pad__adr_longitude)
            ->setPad__adr_mailing_label($pad__adr_mailing_label)
            ->setPad__adr_mailing_label_html($pad__adr_mailing_label_html)
            ->setPad__adr_add_date($pad__adr_add_date)
            ->setPad__adr_add_user($pad__adr_add_user)
            ->setPad__adr_change_date($pad__adr_change_date)
            ->setPad__adr_change_user($pad__adr_change_user)
            ->setPad__adr_delete_flag($pad__adr_delete_flag)
            ->setPad__adr_key_ext($pad__adr_key_ext)
            ->setPad__adr_bad_address_flag($pad__adr_bad_address_flag)
            ->setPad__adr_adb_key($pad__adr_adb_key)
            ->setPad__adr_entity_key($pad__adr_entity_key)
            ->setPad__adr_metro_stat_area($pad__adr_metro_stat_area)
            ->setPad__adr_carrier_route($pad__adr_carrier_route)
            ->setPad__adr_delivery_point_code($pad__adr_delivery_point_code)
            ->setPad__adr_lacs($pad__adr_lacs)
            ->setPad__adr_time_zone($pad__adr_time_zone)
            ->setPad__adr_urbanization($pad__adr_urbanization)
            ->setPad__adr_bar_code($pad__adr_bar_code)
            ->setPad__adr_fips($pad__adr_fips)
            ->setPad__adr_no_validation_flag($pad__adr_no_validation_flag)
            ->setPad__adr_attn($pad__adr_attn)
            ->setPad__adr_record_type_code($pad__adr_record_type_code)
            ->setPad__adr_geography($pad__adr_geography);
    }
    /**
     * Get pad__adr_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPad__adr_key(): ?string
    {
        return $this->pad__adr_key ?? null;
    }
    /**
     * Set pad__adr_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pad__adr_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_key(?string $pad__adr_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pad__adr_key) && !is_string($pad__adr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pad__adr_key, true), gettype($pad__adr_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pad__adr_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pad__adr_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pad__adr_key, true)), __LINE__);
        }
        if (is_null($pad__adr_key) || (is_array($pad__adr_key) && empty($pad__adr_key))) {
            unset($this->pad__adr_key);
        } else {
            $this->pad__adr_key = $pad__adr_key;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_cst_key_owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPad__adr_cst_key_owner(): ?string
    {
        return $this->pad__adr_cst_key_owner ?? null;
    }
    /**
     * Set pad__adr_cst_key_owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pad__adr_cst_key_owner
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_cst_key_owner(?string $pad__adr_cst_key_owner = null): self
    {
        // validation for constraint: string
        if (!is_null($pad__adr_cst_key_owner) && !is_string($pad__adr_cst_key_owner)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pad__adr_cst_key_owner, true), gettype($pad__adr_cst_key_owner)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pad__adr_cst_key_owner) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pad__adr_cst_key_owner)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pad__adr_cst_key_owner, true)), __LINE__);
        }
        if (is_null($pad__adr_cst_key_owner) || (is_array($pad__adr_cst_key_owner) && empty($pad__adr_cst_key_owner))) {
            unset($this->pad__adr_cst_key_owner);
        } else {
            $this->pad__adr_cst_key_owner = $pad__adr_cst_key_owner;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_line1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPad__adr_line1(): ?string
    {
        return $this->pad__adr_line1 ?? null;
    }
    /**
     * Set pad__adr_line1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pad__adr_line1
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_line1(?string $pad__adr_line1 = null): self
    {
        // validation for constraint: string
        if (!is_null($pad__adr_line1) && !is_string($pad__adr_line1)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pad__adr_line1, true), gettype($pad__adr_line1)), __LINE__);
        }
        // validation for constraint: maxLength(75)
        if (!is_null($pad__adr_line1) && mb_strlen((string) $pad__adr_line1) > 75) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 75', mb_strlen((string) $pad__adr_line1)), __LINE__);
        }
        if (is_null($pad__adr_line1) || (is_array($pad__adr_line1) && empty($pad__adr_line1))) {
            unset($this->pad__adr_line1);
        } else {
            $this->pad__adr_line1 = $pad__adr_line1;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_line2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPad__adr_line2(): ?string
    {
        return $this->pad__adr_line2 ?? null;
    }
    /**
     * Set pad__adr_line2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pad__adr_line2
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_line2(?string $pad__adr_line2 = null): self
    {
        // validation for constraint: string
        if (!is_null($pad__adr_line2) && !is_string($pad__adr_line2)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pad__adr_line2, true), gettype($pad__adr_line2)), __LINE__);
        }
        // validation for constraint: maxLength(75)
        if (!is_null($pad__adr_line2) && mb_strlen((string) $pad__adr_line2) > 75) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 75', mb_strlen((string) $pad__adr_line2)), __LINE__);
        }
        if (is_null($pad__adr_line2) || (is_array($pad__adr_line2) && empty($pad__adr_line2))) {
            unset($this->pad__adr_line2);
        } else {
            $this->pad__adr_line2 = $pad__adr_line2;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_line3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPad__adr_line3(): ?string
    {
        return $this->pad__adr_line3 ?? null;
    }
    /**
     * Set pad__adr_line3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pad__adr_line3
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_line3(?string $pad__adr_line3 = null): self
    {
        // validation for constraint: string
        if (!is_null($pad__adr_line3) && !is_string($pad__adr_line3)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pad__adr_line3, true), gettype($pad__adr_line3)), __LINE__);
        }
        // validation for constraint: maxLength(75)
        if (!is_null($pad__adr_line3) && mb_strlen((string) $pad__adr_line3) > 75) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 75', mb_strlen((string) $pad__adr_line3)), __LINE__);
        }
        if (is_null($pad__adr_line3) || (is_array($pad__adr_line3) && empty($pad__adr_line3))) {
            unset($this->pad__adr_line3);
        } else {
            $this->pad__adr_line3 = $pad__adr_line3;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_city value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPad__adr_city(): ?string
    {
        return $this->pad__adr_city ?? null;
    }
    /**
     * Set pad__adr_city value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pad__adr_city
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_city(?string $pad__adr_city = null): self
    {
        // validation for constraint: string
        if (!is_null($pad__adr_city) && !is_string($pad__adr_city)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pad__adr_city, true), gettype($pad__adr_city)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($pad__adr_city) && mb_strlen((string) $pad__adr_city) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $pad__adr_city)), __LINE__);
        }
        if (is_null($pad__adr_city) || (is_array($pad__adr_city) && empty($pad__adr_city))) {
            unset($this->pad__adr_city);
        } else {
            $this->pad__adr_city = $pad__adr_city;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_state value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPad__adr_state(): ?string
    {
        return $this->pad__adr_state ?? null;
    }
    /**
     * Set pad__adr_state value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pad__adr_state
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_state(?string $pad__adr_state = null): self
    {
        // validation for constraint: string
        if (!is_null($pad__adr_state) && !is_string($pad__adr_state)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pad__adr_state, true), gettype($pad__adr_state)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($pad__adr_state) && mb_strlen((string) $pad__adr_state) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $pad__adr_state)), __LINE__);
        }
        if (is_null($pad__adr_state) || (is_array($pad__adr_state) && empty($pad__adr_state))) {
            unset($this->pad__adr_state);
        } else {
            $this->pad__adr_state = $pad__adr_state;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_post_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPad__adr_post_code(): ?string
    {
        return $this->pad__adr_post_code ?? null;
    }
    /**
     * Set pad__adr_post_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pad__adr_post_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_post_code(?string $pad__adr_post_code = null): self
    {
        // validation for constraint: string
        if (!is_null($pad__adr_post_code) && !is_string($pad__adr_post_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pad__adr_post_code, true), gettype($pad__adr_post_code)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($pad__adr_post_code) && mb_strlen((string) $pad__adr_post_code) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $pad__adr_post_code)), __LINE__);
        }
        if (is_null($pad__adr_post_code) || (is_array($pad__adr_post_code) && empty($pad__adr_post_code))) {
            unset($this->pad__adr_post_code);
        } else {
            $this->pad__adr_post_code = $pad__adr_post_code;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_city_state_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPad__adr_city_state_code(): ?string
    {
        return $this->pad__adr_city_state_code ?? null;
    }
    /**
     * Set pad__adr_city_state_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pad__adr_city_state_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_city_state_code(?string $pad__adr_city_state_code = null): self
    {
        // validation for constraint: string
        if (!is_null($pad__adr_city_state_code) && !is_string($pad__adr_city_state_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pad__adr_city_state_code, true), gettype($pad__adr_city_state_code)), __LINE__);
        }
        // validation for constraint: maxLength(104)
        if (!is_null($pad__adr_city_state_code) && mb_strlen((string) $pad__adr_city_state_code) > 104) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 104', mb_strlen((string) $pad__adr_city_state_code)), __LINE__);
        }
        if (is_null($pad__adr_city_state_code) || (is_array($pad__adr_city_state_code) && empty($pad__adr_city_state_code))) {
            unset($this->pad__adr_city_state_code);
        } else {
            $this->pad__adr_city_state_code = $pad__adr_city_state_code;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_country value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPad__adr_country(): ?string
    {
        return $this->pad__adr_country ?? null;
    }
    /**
     * Set pad__adr_country value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pad__adr_country
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_country(?string $pad__adr_country = null): self
    {
        // validation for constraint: string
        if (!is_null($pad__adr_country) && !is_string($pad__adr_country)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pad__adr_country, true), gettype($pad__adr_country)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($pad__adr_country) && mb_strlen((string) $pad__adr_country) > 60) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen((string) $pad__adr_country)), __LINE__);
        }
        if (is_null($pad__adr_country) || (is_array($pad__adr_country) && empty($pad__adr_country))) {
            unset($this->pad__adr_country);
        } else {
            $this->pad__adr_country = $pad__adr_country;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_intl_province value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPad__adr_intl_province(): ?string
    {
        return $this->pad__adr_intl_province ?? null;
    }
    /**
     * Set pad__adr_intl_province value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pad__adr_intl_province
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_intl_province(?string $pad__adr_intl_province = null): self
    {
        // validation for constraint: string
        if (!is_null($pad__adr_intl_province) && !is_string($pad__adr_intl_province)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pad__adr_intl_province, true), gettype($pad__adr_intl_province)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($pad__adr_intl_province) && mb_strlen((string) $pad__adr_intl_province) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $pad__adr_intl_province)), __LINE__);
        }
        if (is_null($pad__adr_intl_province) || (is_array($pad__adr_intl_province) && empty($pad__adr_intl_province))) {
            unset($this->pad__adr_intl_province);
        } else {
            $this->pad__adr_intl_province = $pad__adr_intl_province;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_county value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPad__adr_county(): ?string
    {
        return $this->pad__adr_county ?? null;
    }
    /**
     * Set pad__adr_county value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pad__adr_county
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_county(?string $pad__adr_county = null): self
    {
        // validation for constraint: string
        if (!is_null($pad__adr_county) && !is_string($pad__adr_county)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pad__adr_county, true), gettype($pad__adr_county)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($pad__adr_county) && mb_strlen((string) $pad__adr_county) > 40) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen((string) $pad__adr_county)), __LINE__);
        }
        if (is_null($pad__adr_county) || (is_array($pad__adr_county) && empty($pad__adr_county))) {
            unset($this->pad__adr_county);
        } else {
            $this->pad__adr_county = $pad__adr_county;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_cong_dist value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPad__adr_cong_dist(): ?string
    {
        return $this->pad__adr_cong_dist ?? null;
    }
    /**
     * Set pad__adr_cong_dist value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pad__adr_cong_dist
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_cong_dist(?string $pad__adr_cong_dist = null): self
    {
        // validation for constraint: string
        if (!is_null($pad__adr_cong_dist) && !is_string($pad__adr_cong_dist)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pad__adr_cong_dist, true), gettype($pad__adr_cong_dist)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($pad__adr_cong_dist) && mb_strlen((string) $pad__adr_cong_dist) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen((string) $pad__adr_cong_dist)), __LINE__);
        }
        if (is_null($pad__adr_cong_dist) || (is_array($pad__adr_cong_dist) && empty($pad__adr_cong_dist))) {
            unset($this->pad__adr_cong_dist);
        } else {
            $this->pad__adr_cong_dist = $pad__adr_cong_dist;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_state_house value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPad__adr_state_house(): ?string
    {
        return $this->pad__adr_state_house ?? null;
    }
    /**
     * Set pad__adr_state_house value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pad__adr_state_house
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_state_house(?string $pad__adr_state_house = null): self
    {
        // validation for constraint: string
        if (!is_null($pad__adr_state_house) && !is_string($pad__adr_state_house)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pad__adr_state_house, true), gettype($pad__adr_state_house)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($pad__adr_state_house) && mb_strlen((string) $pad__adr_state_house) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen((string) $pad__adr_state_house)), __LINE__);
        }
        if (is_null($pad__adr_state_house) || (is_array($pad__adr_state_house) && empty($pad__adr_state_house))) {
            unset($this->pad__adr_state_house);
        } else {
            $this->pad__adr_state_house = $pad__adr_state_house;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_state_senate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPad__adr_state_senate(): ?string
    {
        return $this->pad__adr_state_senate ?? null;
    }
    /**
     * Set pad__adr_state_senate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pad__adr_state_senate
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_state_senate(?string $pad__adr_state_senate = null): self
    {
        // validation for constraint: string
        if (!is_null($pad__adr_state_senate) && !is_string($pad__adr_state_senate)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pad__adr_state_senate, true), gettype($pad__adr_state_senate)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($pad__adr_state_senate) && mb_strlen((string) $pad__adr_state_senate) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen((string) $pad__adr_state_senate)), __LINE__);
        }
        if (is_null($pad__adr_state_senate) || (is_array($pad__adr_state_senate) && empty($pad__adr_state_senate))) {
            unset($this->pad__adr_state_senate);
        } else {
            $this->pad__adr_state_senate = $pad__adr_state_senate;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_latitude value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPad__adr_latitude(): ?float
    {
        return $this->pad__adr_latitude ?? null;
    }
    /**
     * Set pad__adr_latitude value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pad__adr_latitude
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_latitude(?float $pad__adr_latitude = null): self
    {
        // validation for constraint: float
        if (!is_null($pad__adr_latitude) && !(is_float($pad__adr_latitude) || is_numeric($pad__adr_latitude))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pad__adr_latitude, true), gettype($pad__adr_latitude)), __LINE__);
        }
        if (is_null($pad__adr_latitude) || (is_array($pad__adr_latitude) && empty($pad__adr_latitude))) {
            unset($this->pad__adr_latitude);
        } else {
            $this->pad__adr_latitude = $pad__adr_latitude;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_longitude value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPad__adr_longitude(): ?float
    {
        return $this->pad__adr_longitude ?? null;
    }
    /**
     * Set pad__adr_longitude value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pad__adr_longitude
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_longitude(?float $pad__adr_longitude = null): self
    {
        // validation for constraint: float
        if (!is_null($pad__adr_longitude) && !(is_float($pad__adr_longitude) || is_numeric($pad__adr_longitude))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pad__adr_longitude, true), gettype($pad__adr_longitude)), __LINE__);
        }
        if (is_null($pad__adr_longitude) || (is_array($pad__adr_longitude) && empty($pad__adr_longitude))) {
            unset($this->pad__adr_longitude);
        } else {
            $this->pad__adr_longitude = $pad__adr_longitude;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_mailing_label value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPad__adr_mailing_label(): ?string
    {
        return $this->pad__adr_mailing_label ?? null;
    }
    /**
     * Set pad__adr_mailing_label value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pad__adr_mailing_label
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_mailing_label(?string $pad__adr_mailing_label = null): self
    {
        // validation for constraint: string
        if (!is_null($pad__adr_mailing_label) && !is_string($pad__adr_mailing_label)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pad__adr_mailing_label, true), gettype($pad__adr_mailing_label)), __LINE__);
        }
        // validation for constraint: maxLength(450)
        if (!is_null($pad__adr_mailing_label) && mb_strlen((string) $pad__adr_mailing_label) > 450) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 450', mb_strlen((string) $pad__adr_mailing_label)), __LINE__);
        }
        if (is_null($pad__adr_mailing_label) || (is_array($pad__adr_mailing_label) && empty($pad__adr_mailing_label))) {
            unset($this->pad__adr_mailing_label);
        } else {
            $this->pad__adr_mailing_label = $pad__adr_mailing_label;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_mailing_label_html value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPad__adr_mailing_label_html(): ?string
    {
        return $this->pad__adr_mailing_label_html ?? null;
    }
    /**
     * Set pad__adr_mailing_label_html value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pad__adr_mailing_label_html
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_mailing_label_html(?string $pad__adr_mailing_label_html = null): self
    {
        // validation for constraint: string
        if (!is_null($pad__adr_mailing_label_html) && !is_string($pad__adr_mailing_label_html)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pad__adr_mailing_label_html, true), gettype($pad__adr_mailing_label_html)), __LINE__);
        }
        // validation for constraint: maxLength(450)
        if (!is_null($pad__adr_mailing_label_html) && mb_strlen((string) $pad__adr_mailing_label_html) > 450) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 450', mb_strlen((string) $pad__adr_mailing_label_html)), __LINE__);
        }
        if (is_null($pad__adr_mailing_label_html) || (is_array($pad__adr_mailing_label_html) && empty($pad__adr_mailing_label_html))) {
            unset($this->pad__adr_mailing_label_html);
        } else {
            $this->pad__adr_mailing_label_html = $pad__adr_mailing_label_html;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPad__adr_add_date(): ?string
    {
        return $this->pad__adr_add_date ?? null;
    }
    /**
     * Set pad__adr_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pad__adr_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_add_date(?string $pad__adr_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($pad__adr_add_date) && !is_string($pad__adr_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pad__adr_add_date, true), gettype($pad__adr_add_date)), __LINE__);
        }
        if (is_null($pad__adr_add_date) || (is_array($pad__adr_add_date) && empty($pad__adr_add_date))) {
            unset($this->pad__adr_add_date);
        } else {
            $this->pad__adr_add_date = $pad__adr_add_date;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPad__adr_add_user(): ?string
    {
        return $this->pad__adr_add_user ?? null;
    }
    /**
     * Set pad__adr_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pad__adr_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_add_user(?string $pad__adr_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($pad__adr_add_user) && !is_string($pad__adr_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pad__adr_add_user, true), gettype($pad__adr_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($pad__adr_add_user) && mb_strlen((string) $pad__adr_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $pad__adr_add_user)), __LINE__);
        }
        if (is_null($pad__adr_add_user) || (is_array($pad__adr_add_user) && empty($pad__adr_add_user))) {
            unset($this->pad__adr_add_user);
        } else {
            $this->pad__adr_add_user = $pad__adr_add_user;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPad__adr_change_date(): ?string
    {
        return $this->pad__adr_change_date ?? null;
    }
    /**
     * Set pad__adr_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pad__adr_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_change_date(?string $pad__adr_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($pad__adr_change_date) && !is_string($pad__adr_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pad__adr_change_date, true), gettype($pad__adr_change_date)), __LINE__);
        }
        if (is_null($pad__adr_change_date) || (is_array($pad__adr_change_date) && empty($pad__adr_change_date))) {
            unset($this->pad__adr_change_date);
        } else {
            $this->pad__adr_change_date = $pad__adr_change_date;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPad__adr_change_user(): ?string
    {
        return $this->pad__adr_change_user ?? null;
    }
    /**
     * Set pad__adr_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pad__adr_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_change_user(?string $pad__adr_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($pad__adr_change_user) && !is_string($pad__adr_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pad__adr_change_user, true), gettype($pad__adr_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($pad__adr_change_user) && mb_strlen((string) $pad__adr_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $pad__adr_change_user)), __LINE__);
        }
        if (is_null($pad__adr_change_user) || (is_array($pad__adr_change_user) && empty($pad__adr_change_user))) {
            unset($this->pad__adr_change_user);
        } else {
            $this->pad__adr_change_user = $pad__adr_change_user;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPad__adr_delete_flag(): ?string
    {
        return $this->pad__adr_delete_flag ?? null;
    }
    /**
     * Set pad__adr_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pad__adr_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_delete_flag(?string $pad__adr_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pad__adr_delete_flag) && !is_string($pad__adr_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pad__adr_delete_flag, true), gettype($pad__adr_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pad__adr_delete_flag) && $pad__adr_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pad__adr_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pad__adr_delete_flag) && $pad__adr_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pad__adr_delete_flag, true)), __LINE__);
        }
        if (is_null($pad__adr_delete_flag) || (is_array($pad__adr_delete_flag) && empty($pad__adr_delete_flag))) {
            unset($this->pad__adr_delete_flag);
        } else {
            $this->pad__adr_delete_flag = $pad__adr_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPad__adr_key_ext(): ?string
    {
        return $this->pad__adr_key_ext ?? null;
    }
    /**
     * Set pad__adr_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pad__adr_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_key_ext(?string $pad__adr_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($pad__adr_key_ext) && !is_string($pad__adr_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pad__adr_key_ext, true), gettype($pad__adr_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pad__adr_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pad__adr_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pad__adr_key_ext, true)), __LINE__);
        }
        if (is_null($pad__adr_key_ext) || (is_array($pad__adr_key_ext) && empty($pad__adr_key_ext))) {
            unset($this->pad__adr_key_ext);
        } else {
            $this->pad__adr_key_ext = $pad__adr_key_ext;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_bad_address_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPad__adr_bad_address_flag(): ?string
    {
        return $this->pad__adr_bad_address_flag ?? null;
    }
    /**
     * Set pad__adr_bad_address_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pad__adr_bad_address_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_bad_address_flag(?string $pad__adr_bad_address_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pad__adr_bad_address_flag) && !is_string($pad__adr_bad_address_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pad__adr_bad_address_flag, true), gettype($pad__adr_bad_address_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pad__adr_bad_address_flag) && $pad__adr_bad_address_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pad__adr_bad_address_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pad__adr_bad_address_flag) && $pad__adr_bad_address_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pad__adr_bad_address_flag, true)), __LINE__);
        }
        if (is_null($pad__adr_bad_address_flag) || (is_array($pad__adr_bad_address_flag) && empty($pad__adr_bad_address_flag))) {
            unset($this->pad__adr_bad_address_flag);
        } else {
            $this->pad__adr_bad_address_flag = $pad__adr_bad_address_flag;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_adb_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPad__adr_adb_key(): ?string
    {
        return $this->pad__adr_adb_key ?? null;
    }
    /**
     * Set pad__adr_adb_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pad__adr_adb_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_adb_key(?string $pad__adr_adb_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pad__adr_adb_key) && !is_string($pad__adr_adb_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pad__adr_adb_key, true), gettype($pad__adr_adb_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pad__adr_adb_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pad__adr_adb_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pad__adr_adb_key, true)), __LINE__);
        }
        if (is_null($pad__adr_adb_key) || (is_array($pad__adr_adb_key) && empty($pad__adr_adb_key))) {
            unset($this->pad__adr_adb_key);
        } else {
            $this->pad__adr_adb_key = $pad__adr_adb_key;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPad__adr_entity_key(): ?string
    {
        return $this->pad__adr_entity_key ?? null;
    }
    /**
     * Set pad__adr_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pad__adr_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_entity_key(?string $pad__adr_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($pad__adr_entity_key) && !is_string($pad__adr_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pad__adr_entity_key, true), gettype($pad__adr_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($pad__adr_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $pad__adr_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($pad__adr_entity_key, true)), __LINE__);
        }
        if (is_null($pad__adr_entity_key) || (is_array($pad__adr_entity_key) && empty($pad__adr_entity_key))) {
            unset($this->pad__adr_entity_key);
        } else {
            $this->pad__adr_entity_key = $pad__adr_entity_key;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_metro_stat_area value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPad__adr_metro_stat_area(): ?string
    {
        return $this->pad__adr_metro_stat_area ?? null;
    }
    /**
     * Set pad__adr_metro_stat_area value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pad__adr_metro_stat_area
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_metro_stat_area(?string $pad__adr_metro_stat_area = null): self
    {
        // validation for constraint: string
        if (!is_null($pad__adr_metro_stat_area) && !is_string($pad__adr_metro_stat_area)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pad__adr_metro_stat_area, true), gettype($pad__adr_metro_stat_area)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($pad__adr_metro_stat_area) && mb_strlen((string) $pad__adr_metro_stat_area) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $pad__adr_metro_stat_area)), __LINE__);
        }
        if (is_null($pad__adr_metro_stat_area) || (is_array($pad__adr_metro_stat_area) && empty($pad__adr_metro_stat_area))) {
            unset($this->pad__adr_metro_stat_area);
        } else {
            $this->pad__adr_metro_stat_area = $pad__adr_metro_stat_area;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_carrier_route value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPad__adr_carrier_route(): ?string
    {
        return $this->pad__adr_carrier_route ?? null;
    }
    /**
     * Set pad__adr_carrier_route value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pad__adr_carrier_route
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_carrier_route(?string $pad__adr_carrier_route = null): self
    {
        // validation for constraint: string
        if (!is_null($pad__adr_carrier_route) && !is_string($pad__adr_carrier_route)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pad__adr_carrier_route, true), gettype($pad__adr_carrier_route)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($pad__adr_carrier_route) && mb_strlen((string) $pad__adr_carrier_route) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $pad__adr_carrier_route)), __LINE__);
        }
        if (is_null($pad__adr_carrier_route) || (is_array($pad__adr_carrier_route) && empty($pad__adr_carrier_route))) {
            unset($this->pad__adr_carrier_route);
        } else {
            $this->pad__adr_carrier_route = $pad__adr_carrier_route;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_delivery_point_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPad__adr_delivery_point_code(): ?string
    {
        return $this->pad__adr_delivery_point_code ?? null;
    }
    /**
     * Set pad__adr_delivery_point_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pad__adr_delivery_point_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_delivery_point_code(?string $pad__adr_delivery_point_code = null): self
    {
        // validation for constraint: string
        if (!is_null($pad__adr_delivery_point_code) && !is_string($pad__adr_delivery_point_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pad__adr_delivery_point_code, true), gettype($pad__adr_delivery_point_code)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($pad__adr_delivery_point_code) && mb_strlen((string) $pad__adr_delivery_point_code) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $pad__adr_delivery_point_code)), __LINE__);
        }
        if (is_null($pad__adr_delivery_point_code) || (is_array($pad__adr_delivery_point_code) && empty($pad__adr_delivery_point_code))) {
            unset($this->pad__adr_delivery_point_code);
        } else {
            $this->pad__adr_delivery_point_code = $pad__adr_delivery_point_code;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_lacs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPad__adr_lacs(): ?string
    {
        return $this->pad__adr_lacs ?? null;
    }
    /**
     * Set pad__adr_lacs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pad__adr_lacs
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_lacs(?string $pad__adr_lacs = null): self
    {
        // validation for constraint: string
        if (!is_null($pad__adr_lacs) && !is_string($pad__adr_lacs)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pad__adr_lacs, true), gettype($pad__adr_lacs)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($pad__adr_lacs) && mb_strlen((string) $pad__adr_lacs) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen((string) $pad__adr_lacs)), __LINE__);
        }
        if (is_null($pad__adr_lacs) || (is_array($pad__adr_lacs) && empty($pad__adr_lacs))) {
            unset($this->pad__adr_lacs);
        } else {
            $this->pad__adr_lacs = $pad__adr_lacs;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_time_zone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPad__adr_time_zone(): ?string
    {
        return $this->pad__adr_time_zone ?? null;
    }
    /**
     * Set pad__adr_time_zone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pad__adr_time_zone
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_time_zone(?string $pad__adr_time_zone = null): self
    {
        // validation for constraint: string
        if (!is_null($pad__adr_time_zone) && !is_string($pad__adr_time_zone)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pad__adr_time_zone, true), gettype($pad__adr_time_zone)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($pad__adr_time_zone) && mb_strlen((string) $pad__adr_time_zone) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $pad__adr_time_zone)), __LINE__);
        }
        if (is_null($pad__adr_time_zone) || (is_array($pad__adr_time_zone) && empty($pad__adr_time_zone))) {
            unset($this->pad__adr_time_zone);
        } else {
            $this->pad__adr_time_zone = $pad__adr_time_zone;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_urbanization value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPad__adr_urbanization(): ?string
    {
        return $this->pad__adr_urbanization ?? null;
    }
    /**
     * Set pad__adr_urbanization value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pad__adr_urbanization
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_urbanization(?string $pad__adr_urbanization = null): self
    {
        // validation for constraint: string
        if (!is_null($pad__adr_urbanization) && !is_string($pad__adr_urbanization)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pad__adr_urbanization, true), gettype($pad__adr_urbanization)), __LINE__);
        }
        // validation for constraint: maxLength(75)
        if (!is_null($pad__adr_urbanization) && mb_strlen((string) $pad__adr_urbanization) > 75) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 75', mb_strlen((string) $pad__adr_urbanization)), __LINE__);
        }
        if (is_null($pad__adr_urbanization) || (is_array($pad__adr_urbanization) && empty($pad__adr_urbanization))) {
            unset($this->pad__adr_urbanization);
        } else {
            $this->pad__adr_urbanization = $pad__adr_urbanization;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_bar_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPad__adr_bar_code(): ?string
    {
        return $this->pad__adr_bar_code ?? null;
    }
    /**
     * Set pad__adr_bar_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pad__adr_bar_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_bar_code(?string $pad__adr_bar_code = null): self
    {
        // validation for constraint: string
        if (!is_null($pad__adr_bar_code) && !is_string($pad__adr_bar_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pad__adr_bar_code, true), gettype($pad__adr_bar_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($pad__adr_bar_code) && mb_strlen((string) $pad__adr_bar_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $pad__adr_bar_code)), __LINE__);
        }
        if (is_null($pad__adr_bar_code) || (is_array($pad__adr_bar_code) && empty($pad__adr_bar_code))) {
            unset($this->pad__adr_bar_code);
        } else {
            $this->pad__adr_bar_code = $pad__adr_bar_code;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_fips value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPad__adr_fips(): ?string
    {
        return $this->pad__adr_fips ?? null;
    }
    /**
     * Set pad__adr_fips value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pad__adr_fips
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_fips(?string $pad__adr_fips = null): self
    {
        // validation for constraint: string
        if (!is_null($pad__adr_fips) && !is_string($pad__adr_fips)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pad__adr_fips, true), gettype($pad__adr_fips)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($pad__adr_fips) && mb_strlen((string) $pad__adr_fips) > 5) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen((string) $pad__adr_fips)), __LINE__);
        }
        if (is_null($pad__adr_fips) || (is_array($pad__adr_fips) && empty($pad__adr_fips))) {
            unset($this->pad__adr_fips);
        } else {
            $this->pad__adr_fips = $pad__adr_fips;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_no_validation_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPad__adr_no_validation_flag(): ?string
    {
        return $this->pad__adr_no_validation_flag ?? null;
    }
    /**
     * Set pad__adr_no_validation_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pad__adr_no_validation_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_no_validation_flag(?string $pad__adr_no_validation_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($pad__adr_no_validation_flag) && !is_string($pad__adr_no_validation_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pad__adr_no_validation_flag, true), gettype($pad__adr_no_validation_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($pad__adr_no_validation_flag) && $pad__adr_no_validation_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($pad__adr_no_validation_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pad__adr_no_validation_flag) && $pad__adr_no_validation_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pad__adr_no_validation_flag, true)), __LINE__);
        }
        if (is_null($pad__adr_no_validation_flag) || (is_array($pad__adr_no_validation_flag) && empty($pad__adr_no_validation_flag))) {
            unset($this->pad__adr_no_validation_flag);
        } else {
            $this->pad__adr_no_validation_flag = $pad__adr_no_validation_flag;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_attn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPad__adr_attn(): ?string
    {
        return $this->pad__adr_attn ?? null;
    }
    /**
     * Set pad__adr_attn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pad__adr_attn
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_attn(?string $pad__adr_attn = null): self
    {
        // validation for constraint: string
        if (!is_null($pad__adr_attn) && !is_string($pad__adr_attn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pad__adr_attn, true), gettype($pad__adr_attn)), __LINE__);
        }
        // validation for constraint: maxLength(75)
        if (!is_null($pad__adr_attn) && mb_strlen((string) $pad__adr_attn) > 75) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 75', mb_strlen((string) $pad__adr_attn)), __LINE__);
        }
        if (is_null($pad__adr_attn) || (is_array($pad__adr_attn) && empty($pad__adr_attn))) {
            unset($this->pad__adr_attn);
        } else {
            $this->pad__adr_attn = $pad__adr_attn;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_record_type_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPad__adr_record_type_code(): ?string
    {
        return $this->pad__adr_record_type_code ?? null;
    }
    /**
     * Set pad__adr_record_type_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pad__adr_record_type_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_record_type_code(?string $pad__adr_record_type_code = null): self
    {
        // validation for constraint: string
        if (!is_null($pad__adr_record_type_code) && !is_string($pad__adr_record_type_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pad__adr_record_type_code, true), gettype($pad__adr_record_type_code)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($pad__adr_record_type_code) && mb_strlen((string) $pad__adr_record_type_code) > 4) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen((string) $pad__adr_record_type_code)), __LINE__);
        }
        if (is_null($pad__adr_record_type_code) || (is_array($pad__adr_record_type_code) && empty($pad__adr_record_type_code))) {
            unset($this->pad__adr_record_type_code);
        } else {
            $this->pad__adr_record_type_code = $pad__adr_record_type_code;
        }
        
        return $this;
    }
    /**
     * Get pad__adr_geography value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPad__adr_geography(): ?string
    {
        return $this->pad__adr_geography ?? null;
    }
    /**
     * Set pad__adr_geography value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pad__adr_geography
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Prim__Contact_Address_DataObjectType
     */
    public function setPad__adr_geography(?string $pad__adr_geography = null): self
    {
        // validation for constraint: string
        if (!is_null($pad__adr_geography) && !is_string($pad__adr_geography)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pad__adr_geography, true), gettype($pad__adr_geography)), __LINE__);
        }
        if (is_null($pad__adr_geography) || (is_array($pad__adr_geography) && empty($pad__adr_geography))) {
            unset($this->pad__adr_geography);
        } else {
            $this->pad__adr_geography = $pad__adr_geography;
        }
        
        return $this;
    }
}
