<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Chapter_Primary_Contact_XRef_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Chapter_Primary_Contact_XRef_DataObjectType extends AbstractStructBase
{
    /**
     * The cxc_cst_key_1
     * Meta information extracted from the WSDL
     * - documentation: Relating Customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cxc_cst_key_1 = null;
    /**
     * The cxc_cst_key_2
     * Meta information extracted from the WSDL
     * - documentation: Related Customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cxc_cst_key_2 = null;
    /**
     * The cxc_rlt_code
     * Meta information extracted from the WSDL
     * - documentation: Relationship Type. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cxc_rlt_code = null;
    /**
     * The cxc_start_date
     * Meta information extracted from the WSDL
     * - documentation: Relationship Start Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cxc_start_date = null;
    /**
     * The cxc_end_date
     * Meta information extracted from the WSDL
     * - documentation: Relationship End Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cxc_end_date = null;
    /**
     * The cxc_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cxc_add_date = null;
    /**
     * The cxc_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cxc_add_user = null;
    /**
     * The cxc_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cxc_change_date = null;
    /**
     * The cxc_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cxc_change_user = null;
    /**
     * The cxc_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cxc_delete_flag = null;
    /**
     * The cxc_key
     * Meta information extracted from the WSDL
     * - documentation: Primary Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cxc_key = null;
    /**
     * The cxc_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cxc_key_ext = null;
    /**
     * The cxc_rlt_code2
     * Meta information extracted from the WSDL
     * - documentation: Relationship Type 2. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cxc_rlt_code2 = null;
    /**
     * The cxc_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cxc_entity_key = null;
    /**
     * Constructor method for Chapter_Primary_Contact_XRef_DataObjectType
     * @uses Chapter_Primary_Contact_XRef_DataObjectType::setCxc_cst_key_1()
     * @uses Chapter_Primary_Contact_XRef_DataObjectType::setCxc_cst_key_2()
     * @uses Chapter_Primary_Contact_XRef_DataObjectType::setCxc_rlt_code()
     * @uses Chapter_Primary_Contact_XRef_DataObjectType::setCxc_start_date()
     * @uses Chapter_Primary_Contact_XRef_DataObjectType::setCxc_end_date()
     * @uses Chapter_Primary_Contact_XRef_DataObjectType::setCxc_add_date()
     * @uses Chapter_Primary_Contact_XRef_DataObjectType::setCxc_add_user()
     * @uses Chapter_Primary_Contact_XRef_DataObjectType::setCxc_change_date()
     * @uses Chapter_Primary_Contact_XRef_DataObjectType::setCxc_change_user()
     * @uses Chapter_Primary_Contact_XRef_DataObjectType::setCxc_delete_flag()
     * @uses Chapter_Primary_Contact_XRef_DataObjectType::setCxc_key()
     * @uses Chapter_Primary_Contact_XRef_DataObjectType::setCxc_key_ext()
     * @uses Chapter_Primary_Contact_XRef_DataObjectType::setCxc_rlt_code2()
     * @uses Chapter_Primary_Contact_XRef_DataObjectType::setCxc_entity_key()
     * @param string $cxc_cst_key_1
     * @param string $cxc_cst_key_2
     * @param string $cxc_rlt_code
     * @param string $cxc_start_date
     * @param string $cxc_end_date
     * @param string $cxc_add_date
     * @param string $cxc_add_user
     * @param string $cxc_change_date
     * @param string $cxc_change_user
     * @param string $cxc_delete_flag
     * @param string $cxc_key
     * @param string $cxc_key_ext
     * @param string $cxc_rlt_code2
     * @param string $cxc_entity_key
     */
    public function __construct(?string $cxc_cst_key_1 = null, ?string $cxc_cst_key_2 = null, ?string $cxc_rlt_code = null, ?string $cxc_start_date = null, ?string $cxc_end_date = null, ?string $cxc_add_date = null, ?string $cxc_add_user = null, ?string $cxc_change_date = null, ?string $cxc_change_user = null, ?string $cxc_delete_flag = null, ?string $cxc_key = null, ?string $cxc_key_ext = null, ?string $cxc_rlt_code2 = null, ?string $cxc_entity_key = null)
    {
        $this
            ->setCxc_cst_key_1($cxc_cst_key_1)
            ->setCxc_cst_key_2($cxc_cst_key_2)
            ->setCxc_rlt_code($cxc_rlt_code)
            ->setCxc_start_date($cxc_start_date)
            ->setCxc_end_date($cxc_end_date)
            ->setCxc_add_date($cxc_add_date)
            ->setCxc_add_user($cxc_add_user)
            ->setCxc_change_date($cxc_change_date)
            ->setCxc_change_user($cxc_change_user)
            ->setCxc_delete_flag($cxc_delete_flag)
            ->setCxc_key($cxc_key)
            ->setCxc_key_ext($cxc_key_ext)
            ->setCxc_rlt_code2($cxc_rlt_code2)
            ->setCxc_entity_key($cxc_entity_key);
    }
    /**
     * Get cxc_cst_key value
     * @return cxc_cst_key
     */
    public function getCxc_cst_key_1(): ?string
    {
        return $this->cxc_cst_key_1 ?? null;
    }
    /**
     * Set cxc_cst_key value
     * @param cxc_cst_key $cxc_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Primary_Contact_XRef_DataObjectType
     */
    public function setCxc_cst_key_1(?string $cxc_cst_key_1 = null): self
    {
        // validation for constraint: string
        if (!is_null($cxc_cst_key_1) && !is_string($cxc_cst_key_1)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxc_cst_key_1, true), gettype($cxc_cst_key_1)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cxc_cst_key_1) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cxc_cst_key_1)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cxc_cst_key_1, true)), __LINE__);
        }
        if (is_null($cxc_cst_key_1) || (is_array($cxc_cst_key_1) && empty($cxc_cst_key_1))) {
            unset($this->cxc_cst_key_1);
        } else {
            $this->cxc_cst_key_1 = $cxc_cst_key_1;
        }
        
        return $this;
    }
    /**
     * Get cxc_cst_key value
     * @return cxc_cst_key
     */
    public function getCxc_cst_key_2(): ?string
    {
        return $this->cxc_cst_key_2 ?? null;
    }
    /**
     * Set cxc_cst_key value
     * @param cxc_cst_key $cxc_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Primary_Contact_XRef_DataObjectType
     */
    public function setCxc_cst_key_2(?string $cxc_cst_key_2 = null): self
    {
        // validation for constraint: string
        if (!is_null($cxc_cst_key_2) && !is_string($cxc_cst_key_2)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxc_cst_key_2, true), gettype($cxc_cst_key_2)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cxc_cst_key_2) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cxc_cst_key_2)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cxc_cst_key_2, true)), __LINE__);
        }
        if (is_null($cxc_cst_key_2) || (is_array($cxc_cst_key_2) && empty($cxc_cst_key_2))) {
            unset($this->cxc_cst_key_2);
        } else {
            $this->cxc_cst_key_2 = $cxc_cst_key_2;
        }
        
        return $this;
    }
    /**
     * Get cxc_rlt_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxc_rlt_code(): ?string
    {
        return $this->cxc_rlt_code ?? null;
    }
    /**
     * Set cxc_rlt_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxc_rlt_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Primary_Contact_XRef_DataObjectType
     */
    public function setCxc_rlt_code(?string $cxc_rlt_code = null): self
    {
        // validation for constraint: string
        if (!is_null($cxc_rlt_code) && !is_string($cxc_rlt_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxc_rlt_code, true), gettype($cxc_rlt_code)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($cxc_rlt_code) && mb_strlen((string) $cxc_rlt_code) > 80) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen((string) $cxc_rlt_code)), __LINE__);
        }
        if (is_null($cxc_rlt_code) || (is_array($cxc_rlt_code) && empty($cxc_rlt_code))) {
            unset($this->cxc_rlt_code);
        } else {
            $this->cxc_rlt_code = $cxc_rlt_code;
        }
        
        return $this;
    }
    /**
     * Get cxc_start_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxc_start_date(): ?string
    {
        return $this->cxc_start_date ?? null;
    }
    /**
     * Set cxc_start_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxc_start_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Primary_Contact_XRef_DataObjectType
     */
    public function setCxc_start_date(?string $cxc_start_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cxc_start_date) && !is_string($cxc_start_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxc_start_date, true), gettype($cxc_start_date)), __LINE__);
        }
        if (is_null($cxc_start_date) || (is_array($cxc_start_date) && empty($cxc_start_date))) {
            unset($this->cxc_start_date);
        } else {
            $this->cxc_start_date = $cxc_start_date;
        }
        
        return $this;
    }
    /**
     * Get cxc_end_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxc_end_date(): ?string
    {
        return $this->cxc_end_date ?? null;
    }
    /**
     * Set cxc_end_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxc_end_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Primary_Contact_XRef_DataObjectType
     */
    public function setCxc_end_date(?string $cxc_end_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cxc_end_date) && !is_string($cxc_end_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxc_end_date, true), gettype($cxc_end_date)), __LINE__);
        }
        if (is_null($cxc_end_date) || (is_array($cxc_end_date) && empty($cxc_end_date))) {
            unset($this->cxc_end_date);
        } else {
            $this->cxc_end_date = $cxc_end_date;
        }
        
        return $this;
    }
    /**
     * Get cxc_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxc_add_date(): ?string
    {
        return $this->cxc_add_date ?? null;
    }
    /**
     * Set cxc_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxc_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Primary_Contact_XRef_DataObjectType
     */
    public function setCxc_add_date(?string $cxc_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cxc_add_date) && !is_string($cxc_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxc_add_date, true), gettype($cxc_add_date)), __LINE__);
        }
        if (is_null($cxc_add_date) || (is_array($cxc_add_date) && empty($cxc_add_date))) {
            unset($this->cxc_add_date);
        } else {
            $this->cxc_add_date = $cxc_add_date;
        }
        
        return $this;
    }
    /**
     * Get cxc_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxc_add_user(): ?string
    {
        return $this->cxc_add_user ?? null;
    }
    /**
     * Set cxc_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxc_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Primary_Contact_XRef_DataObjectType
     */
    public function setCxc_add_user(?string $cxc_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cxc_add_user) && !is_string($cxc_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxc_add_user, true), gettype($cxc_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cxc_add_user) && mb_strlen((string) $cxc_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cxc_add_user)), __LINE__);
        }
        if (is_null($cxc_add_user) || (is_array($cxc_add_user) && empty($cxc_add_user))) {
            unset($this->cxc_add_user);
        } else {
            $this->cxc_add_user = $cxc_add_user;
        }
        
        return $this;
    }
    /**
     * Get cxc_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxc_change_date(): ?string
    {
        return $this->cxc_change_date ?? null;
    }
    /**
     * Set cxc_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxc_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Primary_Contact_XRef_DataObjectType
     */
    public function setCxc_change_date(?string $cxc_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cxc_change_date) && !is_string($cxc_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxc_change_date, true), gettype($cxc_change_date)), __LINE__);
        }
        if (is_null($cxc_change_date) || (is_array($cxc_change_date) && empty($cxc_change_date))) {
            unset($this->cxc_change_date);
        } else {
            $this->cxc_change_date = $cxc_change_date;
        }
        
        return $this;
    }
    /**
     * Get cxc_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxc_change_user(): ?string
    {
        return $this->cxc_change_user ?? null;
    }
    /**
     * Set cxc_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxc_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Primary_Contact_XRef_DataObjectType
     */
    public function setCxc_change_user(?string $cxc_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cxc_change_user) && !is_string($cxc_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxc_change_user, true), gettype($cxc_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cxc_change_user) && mb_strlen((string) $cxc_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cxc_change_user)), __LINE__);
        }
        if (is_null($cxc_change_user) || (is_array($cxc_change_user) && empty($cxc_change_user))) {
            unset($this->cxc_change_user);
        } else {
            $this->cxc_change_user = $cxc_change_user;
        }
        
        return $this;
    }
    /**
     * Get cxc_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxc_delete_flag(): ?string
    {
        return $this->cxc_delete_flag ?? null;
    }
    /**
     * Set cxc_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxc_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Primary_Contact_XRef_DataObjectType
     */
    public function setCxc_delete_flag(?string $cxc_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cxc_delete_flag) && !is_string($cxc_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxc_delete_flag, true), gettype($cxc_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cxc_delete_flag) && $cxc_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cxc_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cxc_delete_flag) && $cxc_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cxc_delete_flag, true)), __LINE__);
        }
        if (is_null($cxc_delete_flag) || (is_array($cxc_delete_flag) && empty($cxc_delete_flag))) {
            unset($this->cxc_delete_flag);
        } else {
            $this->cxc_delete_flag = $cxc_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get cxc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxc_key(): ?string
    {
        return $this->cxc_key ?? null;
    }
    /**
     * Set cxc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Primary_Contact_XRef_DataObjectType
     */
    public function setCxc_key(?string $cxc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cxc_key) && !is_string($cxc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxc_key, true), gettype($cxc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cxc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cxc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cxc_key, true)), __LINE__);
        }
        if (is_null($cxc_key) || (is_array($cxc_key) && empty($cxc_key))) {
            unset($this->cxc_key);
        } else {
            $this->cxc_key = $cxc_key;
        }
        
        return $this;
    }
    /**
     * Get cxc_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxc_key_ext(): ?string
    {
        return $this->cxc_key_ext ?? null;
    }
    /**
     * Set cxc_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxc_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Primary_Contact_XRef_DataObjectType
     */
    public function setCxc_key_ext(?string $cxc_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($cxc_key_ext) && !is_string($cxc_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxc_key_ext, true), gettype($cxc_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cxc_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cxc_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cxc_key_ext, true)), __LINE__);
        }
        if (is_null($cxc_key_ext) || (is_array($cxc_key_ext) && empty($cxc_key_ext))) {
            unset($this->cxc_key_ext);
        } else {
            $this->cxc_key_ext = $cxc_key_ext;
        }
        
        return $this;
    }
    /**
     * Get cxc_rlt_code2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxc_rlt_code2(): ?string
    {
        return $this->cxc_rlt_code2 ?? null;
    }
    /**
     * Set cxc_rlt_code2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxc_rlt_code2
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Primary_Contact_XRef_DataObjectType
     */
    public function setCxc_rlt_code2(?string $cxc_rlt_code2 = null): self
    {
        // validation for constraint: string
        if (!is_null($cxc_rlt_code2) && !is_string($cxc_rlt_code2)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxc_rlt_code2, true), gettype($cxc_rlt_code2)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($cxc_rlt_code2) && mb_strlen((string) $cxc_rlt_code2) > 80) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen((string) $cxc_rlt_code2)), __LINE__);
        }
        if (is_null($cxc_rlt_code2) || (is_array($cxc_rlt_code2) && empty($cxc_rlt_code2))) {
            unset($this->cxc_rlt_code2);
        } else {
            $this->cxc_rlt_code2 = $cxc_rlt_code2;
        }
        
        return $this;
    }
    /**
     * Get cxc_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCxc_entity_key(): ?string
    {
        return $this->cxc_entity_key ?? null;
    }
    /**
     * Set cxc_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cxc_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Chapter_Primary_Contact_XRef_DataObjectType
     */
    public function setCxc_entity_key(?string $cxc_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cxc_entity_key) && !is_string($cxc_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cxc_entity_key, true), gettype($cxc_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cxc_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cxc_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cxc_entity_key, true)), __LINE__);
        }
        if (is_null($cxc_entity_key) || (is_array($cxc_entity_key) && empty($cxc_entity_key))) {
            unset($this->cxc_entity_key);
        } else {
            $this->cxc_entity_key = $cxc_entity_key;
        }
        
        return $this;
    }
}
