<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Column StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Column extends AbstractStructBase
{
    /**
     * The mdc_name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $mdc_name = null;
    /**
     * The mdc_description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $mdc_description = null;
    /**
     * The mdc_data_type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $mdc_data_type = null;
    /**
     * The mdc_ext
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $mdc_ext = null;
    /**
     * The mdc_nullable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $mdc_nullable = null;
    /**
     * The mdc_table_name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $mdc_table_name = null;
    /**
     * The mdc_width_max
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string|null
     */
    protected ?string $mdc_width_max = null;
    /**
     * Constructor method for Column
     * @uses Column::setMdc_name()
     * @uses Column::setMdc_description()
     * @uses Column::setMdc_data_type()
     * @uses Column::setMdc_ext()
     * @uses Column::setMdc_nullable()
     * @uses Column::setMdc_table_name()
     * @uses Column::setMdc_width_max()
     * @param string $mdc_name
     * @param string $mdc_description
     * @param string $mdc_data_type
     * @param string $mdc_ext
     * @param string $mdc_nullable
     * @param string $mdc_table_name
     * @param string $mdc_width_max
     */
    public function __construct(?string $mdc_name = null, ?string $mdc_description = null, ?string $mdc_data_type = null, ?string $mdc_ext = null, ?string $mdc_nullable = null, ?string $mdc_table_name = null, ?string $mdc_width_max = null)
    {
        $this
            ->setMdc_name($mdc_name)
            ->setMdc_description($mdc_description)
            ->setMdc_data_type($mdc_data_type)
            ->setMdc_ext($mdc_ext)
            ->setMdc_nullable($mdc_nullable)
            ->setMdc_table_name($mdc_table_name)
            ->setMdc_width_max($mdc_width_max);
    }
    /**
     * Get mdc_name value
     * @return string|null
     */
    public function getMdc_name(): ?string
    {
        return $this->mdc_name;
    }
    /**
     * Set mdc_name value
     * @param string $mdc_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\Column
     */
    public function setMdc_name(?string $mdc_name = null): self
    {
        // validation for constraint: string
        if (!is_null($mdc_name) && !is_string($mdc_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mdc_name, true), gettype($mdc_name)), __LINE__);
        }
        $this->mdc_name = $mdc_name;
        
        return $this;
    }
    /**
     * Get mdc_description value
     * @return string|null
     */
    public function getMdc_description(): ?string
    {
        return $this->mdc_description;
    }
    /**
     * Set mdc_description value
     * @param string $mdc_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\Column
     */
    public function setMdc_description(?string $mdc_description = null): self
    {
        // validation for constraint: string
        if (!is_null($mdc_description) && !is_string($mdc_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mdc_description, true), gettype($mdc_description)), __LINE__);
        }
        $this->mdc_description = $mdc_description;
        
        return $this;
    }
    /**
     * Get mdc_data_type value
     * @return string|null
     */
    public function getMdc_data_type(): ?string
    {
        return $this->mdc_data_type;
    }
    /**
     * Set mdc_data_type value
     * @param string $mdc_data_type
     * @return \Drupal\netforum\xWeb\Generated\StructType\Column
     */
    public function setMdc_data_type(?string $mdc_data_type = null): self
    {
        // validation for constraint: string
        if (!is_null($mdc_data_type) && !is_string($mdc_data_type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mdc_data_type, true), gettype($mdc_data_type)), __LINE__);
        }
        $this->mdc_data_type = $mdc_data_type;
        
        return $this;
    }
    /**
     * Get mdc_ext value
     * @return string|null
     */
    public function getMdc_ext(): ?string
    {
        return $this->mdc_ext;
    }
    /**
     * Set mdc_ext value
     * @param string $mdc_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Column
     */
    public function setMdc_ext(?string $mdc_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($mdc_ext) && !is_string($mdc_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mdc_ext, true), gettype($mdc_ext)), __LINE__);
        }
        $this->mdc_ext = $mdc_ext;
        
        return $this;
    }
    /**
     * Get mdc_nullable value
     * @return string|null
     */
    public function getMdc_nullable(): ?string
    {
        return $this->mdc_nullable;
    }
    /**
     * Set mdc_nullable value
     * @param string $mdc_nullable
     * @return \Drupal\netforum\xWeb\Generated\StructType\Column
     */
    public function setMdc_nullable(?string $mdc_nullable = null): self
    {
        // validation for constraint: string
        if (!is_null($mdc_nullable) && !is_string($mdc_nullable)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mdc_nullable, true), gettype($mdc_nullable)), __LINE__);
        }
        $this->mdc_nullable = $mdc_nullable;
        
        return $this;
    }
    /**
     * Get mdc_table_name value
     * @return string|null
     */
    public function getMdc_table_name(): ?string
    {
        return $this->mdc_table_name;
    }
    /**
     * Set mdc_table_name value
     * @param string $mdc_table_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\Column
     */
    public function setMdc_table_name(?string $mdc_table_name = null): self
    {
        // validation for constraint: string
        if (!is_null($mdc_table_name) && !is_string($mdc_table_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mdc_table_name, true), gettype($mdc_table_name)), __LINE__);
        }
        $this->mdc_table_name = $mdc_table_name;
        
        return $this;
    }
    /**
     * Get mdc_width_max value
     * @return string|null
     */
    public function getMdc_width_max(): ?string
    {
        return $this->mdc_width_max;
    }
    /**
     * Set mdc_width_max value
     * @param string $mdc_width_max
     * @return \Drupal\netforum\xWeb\Generated\StructType\Column
     */
    public function setMdc_width_max(?string $mdc_width_max = null): self
    {
        // validation for constraint: string
        if (!is_null($mdc_width_max) && !is_string($mdc_width_max)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mdc_width_max, true), gettype($mdc_width_max)), __LINE__);
        }
        $this->mdc_width_max = $mdc_width_max;
        
        return $this;
    }
}
