<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommitteeNominations_Committee_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class CommitteeNominations_Committee_DataObjectType extends AbstractStructBase
{
    /**
     * The cmt_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cmt_key = null;
    /**
     * The cmt_asn_code
     * Meta information extracted from the WSDL
     * - documentation: Association. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmt_asn_code = null;
    /**
     * The cmt_code
     * Meta information extracted from the WSDL
     * - documentation: Committee Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmt_code = null;
    /**
     * The cmt_ctp_code
     * Meta information extracted from the WSDL
     * - documentation: Type Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmt_ctp_code = null;
    /**
     * The cmt_name
     * Meta information extracted from the WSDL
     * - documentation: Committee Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmt_name = null;
    /**
     * The cmt_begin_date
     * Meta information extracted from the WSDL
     * - documentation: Begin Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmt_begin_date = null;
    /**
     * The cmt_end_date
     * Meta information extracted from the WSDL
     * - documentation: End Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmt_end_date = null;
    /**
     * The cmt_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmt_add_date = null;
    /**
     * The cmt_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmt_add_user = null;
    /**
     * The cmt_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmt_change_date = null;
    /**
     * The cmt_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmt_change_user = null;
    /**
     * The cmt_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmt_delete_flag = null;
    /**
     * The cmt_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cmt_key_ext = null;
    /**
     * The cmt_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cmt_entity_key = null;
    /**
     * The cmt_parent_key
     * Meta information extracted from the WSDL
     * - documentation: Parent Committee. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cmt_parent_key = null;
    /**
     * The cmt_description
     * Meta information extracted from the WSDL
     * - documentation: Description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmt_description = null;
    /**
     * The cmt_html_description
     * Meta information extracted from the WSDL
     * - documentation: html description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmt_html_description = null;
    /**
     * The cmt_region
     * Meta information extracted from the WSDL
     * - documentation: Region. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmt_region = null;
    /**
     * The cmt_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cmt_cst_key = null;
    /**
     * Constructor method for CommitteeNominations_Committee_DataObjectType
     * @uses CommitteeNominations_Committee_DataObjectType::setCmt_key()
     * @uses CommitteeNominations_Committee_DataObjectType::setCmt_asn_code()
     * @uses CommitteeNominations_Committee_DataObjectType::setCmt_code()
     * @uses CommitteeNominations_Committee_DataObjectType::setCmt_ctp_code()
     * @uses CommitteeNominations_Committee_DataObjectType::setCmt_name()
     * @uses CommitteeNominations_Committee_DataObjectType::setCmt_begin_date()
     * @uses CommitteeNominations_Committee_DataObjectType::setCmt_end_date()
     * @uses CommitteeNominations_Committee_DataObjectType::setCmt_add_date()
     * @uses CommitteeNominations_Committee_DataObjectType::setCmt_add_user()
     * @uses CommitteeNominations_Committee_DataObjectType::setCmt_change_date()
     * @uses CommitteeNominations_Committee_DataObjectType::setCmt_change_user()
     * @uses CommitteeNominations_Committee_DataObjectType::setCmt_delete_flag()
     * @uses CommitteeNominations_Committee_DataObjectType::setCmt_key_ext()
     * @uses CommitteeNominations_Committee_DataObjectType::setCmt_entity_key()
     * @uses CommitteeNominations_Committee_DataObjectType::setCmt_parent_key()
     * @uses CommitteeNominations_Committee_DataObjectType::setCmt_description()
     * @uses CommitteeNominations_Committee_DataObjectType::setCmt_html_description()
     * @uses CommitteeNominations_Committee_DataObjectType::setCmt_region()
     * @uses CommitteeNominations_Committee_DataObjectType::setCmt_cst_key()
     * @param string $cmt_key
     * @param string $cmt_asn_code
     * @param string $cmt_code
     * @param string $cmt_ctp_code
     * @param string $cmt_name
     * @param string $cmt_begin_date
     * @param string $cmt_end_date
     * @param string $cmt_add_date
     * @param string $cmt_add_user
     * @param string $cmt_change_date
     * @param string $cmt_change_user
     * @param string $cmt_delete_flag
     * @param string $cmt_key_ext
     * @param string $cmt_entity_key
     * @param string $cmt_parent_key
     * @param string $cmt_description
     * @param string $cmt_html_description
     * @param string $cmt_region
     * @param string $cmt_cst_key
     */
    public function __construct(?string $cmt_key = null, ?string $cmt_asn_code = null, ?string $cmt_code = null, ?string $cmt_ctp_code = null, ?string $cmt_name = null, ?string $cmt_begin_date = null, ?string $cmt_end_date = null, ?string $cmt_add_date = null, ?string $cmt_add_user = null, ?string $cmt_change_date = null, ?string $cmt_change_user = null, ?string $cmt_delete_flag = null, ?string $cmt_key_ext = null, ?string $cmt_entity_key = null, ?string $cmt_parent_key = null, ?string $cmt_description = null, ?string $cmt_html_description = null, ?string $cmt_region = null, ?string $cmt_cst_key = null)
    {
        $this
            ->setCmt_key($cmt_key)
            ->setCmt_asn_code($cmt_asn_code)
            ->setCmt_code($cmt_code)
            ->setCmt_ctp_code($cmt_ctp_code)
            ->setCmt_name($cmt_name)
            ->setCmt_begin_date($cmt_begin_date)
            ->setCmt_end_date($cmt_end_date)
            ->setCmt_add_date($cmt_add_date)
            ->setCmt_add_user($cmt_add_user)
            ->setCmt_change_date($cmt_change_date)
            ->setCmt_change_user($cmt_change_user)
            ->setCmt_delete_flag($cmt_delete_flag)
            ->setCmt_key_ext($cmt_key_ext)
            ->setCmt_entity_key($cmt_entity_key)
            ->setCmt_parent_key($cmt_parent_key)
            ->setCmt_description($cmt_description)
            ->setCmt_html_description($cmt_html_description)
            ->setCmt_region($cmt_region)
            ->setCmt_cst_key($cmt_cst_key);
    }
    /**
     * Get cmt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmt_key(): ?string
    {
        return $this->cmt_key ?? null;
    }
    /**
     * Set cmt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_DataObjectType
     */
    public function setCmt_key(?string $cmt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cmt_key) && !is_string($cmt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmt_key, true), gettype($cmt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cmt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cmt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cmt_key, true)), __LINE__);
        }
        if (is_null($cmt_key) || (is_array($cmt_key) && empty($cmt_key))) {
            unset($this->cmt_key);
        } else {
            $this->cmt_key = $cmt_key;
        }
        
        return $this;
    }
    /**
     * Get cmt_asn_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmt_asn_code(): ?string
    {
        return $this->cmt_asn_code ?? null;
    }
    /**
     * Set cmt_asn_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmt_asn_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_DataObjectType
     */
    public function setCmt_asn_code(?string $cmt_asn_code = null): self
    {
        // validation for constraint: string
        if (!is_null($cmt_asn_code) && !is_string($cmt_asn_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmt_asn_code, true), gettype($cmt_asn_code)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($cmt_asn_code) && mb_strlen((string) $cmt_asn_code) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $cmt_asn_code)), __LINE__);
        }
        if (is_null($cmt_asn_code) || (is_array($cmt_asn_code) && empty($cmt_asn_code))) {
            unset($this->cmt_asn_code);
        } else {
            $this->cmt_asn_code = $cmt_asn_code;
        }
        
        return $this;
    }
    /**
     * Get cmt_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmt_code(): ?string
    {
        return $this->cmt_code ?? null;
    }
    /**
     * Set cmt_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmt_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_DataObjectType
     */
    public function setCmt_code(?string $cmt_code = null): self
    {
        // validation for constraint: string
        if (!is_null($cmt_code) && !is_string($cmt_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmt_code, true), gettype($cmt_code)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($cmt_code) && mb_strlen((string) $cmt_code) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $cmt_code)), __LINE__);
        }
        if (is_null($cmt_code) || (is_array($cmt_code) && empty($cmt_code))) {
            unset($this->cmt_code);
        } else {
            $this->cmt_code = $cmt_code;
        }
        
        return $this;
    }
    /**
     * Get cmt_ctp_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmt_ctp_code(): ?string
    {
        return $this->cmt_ctp_code ?? null;
    }
    /**
     * Set cmt_ctp_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmt_ctp_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_DataObjectType
     */
    public function setCmt_ctp_code(?string $cmt_ctp_code = null): self
    {
        // validation for constraint: string
        if (!is_null($cmt_ctp_code) && !is_string($cmt_ctp_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmt_ctp_code, true), gettype($cmt_ctp_code)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($cmt_ctp_code) && mb_strlen((string) $cmt_ctp_code) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $cmt_ctp_code)), __LINE__);
        }
        if (is_null($cmt_ctp_code) || (is_array($cmt_ctp_code) && empty($cmt_ctp_code))) {
            unset($this->cmt_ctp_code);
        } else {
            $this->cmt_ctp_code = $cmt_ctp_code;
        }
        
        return $this;
    }
    /**
     * Get cmt_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmt_name(): ?string
    {
        return $this->cmt_name ?? null;
    }
    /**
     * Set cmt_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmt_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_DataObjectType
     */
    public function setCmt_name(?string $cmt_name = null): self
    {
        // validation for constraint: string
        if (!is_null($cmt_name) && !is_string($cmt_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmt_name, true), gettype($cmt_name)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($cmt_name) && mb_strlen((string) $cmt_name) > 80) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen((string) $cmt_name)), __LINE__);
        }
        if (is_null($cmt_name) || (is_array($cmt_name) && empty($cmt_name))) {
            unset($this->cmt_name);
        } else {
            $this->cmt_name = $cmt_name;
        }
        
        return $this;
    }
    /**
     * Get cmt_begin_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmt_begin_date(): ?string
    {
        return $this->cmt_begin_date ?? null;
    }
    /**
     * Set cmt_begin_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmt_begin_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_DataObjectType
     */
    public function setCmt_begin_date(?string $cmt_begin_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cmt_begin_date) && !is_string($cmt_begin_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmt_begin_date, true), gettype($cmt_begin_date)), __LINE__);
        }
        if (is_null($cmt_begin_date) || (is_array($cmt_begin_date) && empty($cmt_begin_date))) {
            unset($this->cmt_begin_date);
        } else {
            $this->cmt_begin_date = $cmt_begin_date;
        }
        
        return $this;
    }
    /**
     * Get cmt_end_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmt_end_date(): ?string
    {
        return $this->cmt_end_date ?? null;
    }
    /**
     * Set cmt_end_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmt_end_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_DataObjectType
     */
    public function setCmt_end_date(?string $cmt_end_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cmt_end_date) && !is_string($cmt_end_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmt_end_date, true), gettype($cmt_end_date)), __LINE__);
        }
        if (is_null($cmt_end_date) || (is_array($cmt_end_date) && empty($cmt_end_date))) {
            unset($this->cmt_end_date);
        } else {
            $this->cmt_end_date = $cmt_end_date;
        }
        
        return $this;
    }
    /**
     * Get cmt_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmt_add_date(): ?string
    {
        return $this->cmt_add_date ?? null;
    }
    /**
     * Set cmt_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmt_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_DataObjectType
     */
    public function setCmt_add_date(?string $cmt_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cmt_add_date) && !is_string($cmt_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmt_add_date, true), gettype($cmt_add_date)), __LINE__);
        }
        if (is_null($cmt_add_date) || (is_array($cmt_add_date) && empty($cmt_add_date))) {
            unset($this->cmt_add_date);
        } else {
            $this->cmt_add_date = $cmt_add_date;
        }
        
        return $this;
    }
    /**
     * Get cmt_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmt_add_user(): ?string
    {
        return $this->cmt_add_user ?? null;
    }
    /**
     * Set cmt_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmt_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_DataObjectType
     */
    public function setCmt_add_user(?string $cmt_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cmt_add_user) && !is_string($cmt_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmt_add_user, true), gettype($cmt_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cmt_add_user) && mb_strlen((string) $cmt_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cmt_add_user)), __LINE__);
        }
        if (is_null($cmt_add_user) || (is_array($cmt_add_user) && empty($cmt_add_user))) {
            unset($this->cmt_add_user);
        } else {
            $this->cmt_add_user = $cmt_add_user;
        }
        
        return $this;
    }
    /**
     * Get cmt_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmt_change_date(): ?string
    {
        return $this->cmt_change_date ?? null;
    }
    /**
     * Set cmt_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmt_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_DataObjectType
     */
    public function setCmt_change_date(?string $cmt_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cmt_change_date) && !is_string($cmt_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmt_change_date, true), gettype($cmt_change_date)), __LINE__);
        }
        if (is_null($cmt_change_date) || (is_array($cmt_change_date) && empty($cmt_change_date))) {
            unset($this->cmt_change_date);
        } else {
            $this->cmt_change_date = $cmt_change_date;
        }
        
        return $this;
    }
    /**
     * Get cmt_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmt_change_user(): ?string
    {
        return $this->cmt_change_user ?? null;
    }
    /**
     * Set cmt_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmt_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_DataObjectType
     */
    public function setCmt_change_user(?string $cmt_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cmt_change_user) && !is_string($cmt_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmt_change_user, true), gettype($cmt_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cmt_change_user) && mb_strlen((string) $cmt_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cmt_change_user)), __LINE__);
        }
        if (is_null($cmt_change_user) || (is_array($cmt_change_user) && empty($cmt_change_user))) {
            unset($this->cmt_change_user);
        } else {
            $this->cmt_change_user = $cmt_change_user;
        }
        
        return $this;
    }
    /**
     * Get cmt_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmt_delete_flag(): ?string
    {
        return $this->cmt_delete_flag ?? null;
    }
    /**
     * Set cmt_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmt_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_DataObjectType
     */
    public function setCmt_delete_flag(?string $cmt_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cmt_delete_flag) && !is_string($cmt_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmt_delete_flag, true), gettype($cmt_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cmt_delete_flag) && $cmt_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cmt_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cmt_delete_flag) && $cmt_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cmt_delete_flag, true)), __LINE__);
        }
        if (is_null($cmt_delete_flag) || (is_array($cmt_delete_flag) && empty($cmt_delete_flag))) {
            unset($this->cmt_delete_flag);
        } else {
            $this->cmt_delete_flag = $cmt_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get cmt_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmt_key_ext(): ?string
    {
        return $this->cmt_key_ext ?? null;
    }
    /**
     * Set cmt_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmt_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_DataObjectType
     */
    public function setCmt_key_ext(?string $cmt_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($cmt_key_ext) && !is_string($cmt_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmt_key_ext, true), gettype($cmt_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cmt_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cmt_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cmt_key_ext, true)), __LINE__);
        }
        if (is_null($cmt_key_ext) || (is_array($cmt_key_ext) && empty($cmt_key_ext))) {
            unset($this->cmt_key_ext);
        } else {
            $this->cmt_key_ext = $cmt_key_ext;
        }
        
        return $this;
    }
    /**
     * Get cmt_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmt_entity_key(): ?string
    {
        return $this->cmt_entity_key ?? null;
    }
    /**
     * Set cmt_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmt_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_DataObjectType
     */
    public function setCmt_entity_key(?string $cmt_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cmt_entity_key) && !is_string($cmt_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmt_entity_key, true), gettype($cmt_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cmt_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cmt_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cmt_entity_key, true)), __LINE__);
        }
        if (is_null($cmt_entity_key) || (is_array($cmt_entity_key) && empty($cmt_entity_key))) {
            unset($this->cmt_entity_key);
        } else {
            $this->cmt_entity_key = $cmt_entity_key;
        }
        
        return $this;
    }
    /**
     * Get cmt_parent_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmt_parent_key(): ?string
    {
        return $this->cmt_parent_key ?? null;
    }
    /**
     * Set cmt_parent_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmt_parent_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_DataObjectType
     */
    public function setCmt_parent_key(?string $cmt_parent_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cmt_parent_key) && !is_string($cmt_parent_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmt_parent_key, true), gettype($cmt_parent_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cmt_parent_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cmt_parent_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cmt_parent_key, true)), __LINE__);
        }
        if (is_null($cmt_parent_key) || (is_array($cmt_parent_key) && empty($cmt_parent_key))) {
            unset($this->cmt_parent_key);
        } else {
            $this->cmt_parent_key = $cmt_parent_key;
        }
        
        return $this;
    }
    /**
     * Get cmt_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmt_description(): ?string
    {
        return $this->cmt_description ?? null;
    }
    /**
     * Set cmt_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmt_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_DataObjectType
     */
    public function setCmt_description(?string $cmt_description = null): self
    {
        // validation for constraint: string
        if (!is_null($cmt_description) && !is_string($cmt_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmt_description, true), gettype($cmt_description)), __LINE__);
        }
        if (is_null($cmt_description) || (is_array($cmt_description) && empty($cmt_description))) {
            unset($this->cmt_description);
        } else {
            $this->cmt_description = $cmt_description;
        }
        
        return $this;
    }
    /**
     * Get cmt_html_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmt_html_description(): ?string
    {
        return $this->cmt_html_description ?? null;
    }
    /**
     * Set cmt_html_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmt_html_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_DataObjectType
     */
    public function setCmt_html_description(?string $cmt_html_description = null): self
    {
        // validation for constraint: string
        if (!is_null($cmt_html_description) && !is_string($cmt_html_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmt_html_description, true), gettype($cmt_html_description)), __LINE__);
        }
        if (is_null($cmt_html_description) || (is_array($cmt_html_description) && empty($cmt_html_description))) {
            unset($this->cmt_html_description);
        } else {
            $this->cmt_html_description = $cmt_html_description;
        }
        
        return $this;
    }
    /**
     * Get cmt_region value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmt_region(): ?string
    {
        return $this->cmt_region ?? null;
    }
    /**
     * Set cmt_region value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmt_region
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_DataObjectType
     */
    public function setCmt_region(?string $cmt_region = null): self
    {
        // validation for constraint: string
        if (!is_null($cmt_region) && !is_string($cmt_region)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmt_region, true), gettype($cmt_region)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($cmt_region) && mb_strlen((string) $cmt_region) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $cmt_region)), __LINE__);
        }
        if (is_null($cmt_region) || (is_array($cmt_region) && empty($cmt_region))) {
            unset($this->cmt_region);
        } else {
            $this->cmt_region = $cmt_region;
        }
        
        return $this;
    }
    /**
     * Get cmt_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmt_cst_key(): ?string
    {
        return $this->cmt_cst_key ?? null;
    }
    /**
     * Set cmt_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmt_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_DataObjectType
     */
    public function setCmt_cst_key(?string $cmt_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cmt_cst_key) && !is_string($cmt_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmt_cst_key, true), gettype($cmt_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cmt_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cmt_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cmt_cst_key, true)), __LINE__);
        }
        if (is_null($cmt_cst_key) || (is_array($cmt_cst_key) && empty($cmt_cst_key))) {
            unset($this->cmt_cst_key);
        } else {
            $this->cmt_cst_key = $cmt_cst_key;
        }
        
        return $this;
    }
}
