<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * CommitteeNominations_Committee_Position_Codes_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class CommitteeNominations_Committee_Position_Codes_DataObjectType extends AbstractStructBase
{
    /**
     * The cpo_code
     * Meta information extracted from the WSDL
     * - documentation: Position Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cpo_code = null;
    /**
     * The cpo_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cpo_add_user = null;
    /**
     * The cpo_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cpo_add_date = null;
    /**
     * The cpo_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cpo_change_user = null;
    /**
     * The cpo_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cpo_change_date = null;
    /**
     * The cpo_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cpo_delete_flag = null;
    /**
     * The cpo_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cpo_key = null;
    /**
     * The cpo_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cpo_key_ext = null;
    /**
     * The cpo_chapter_flag
     * Meta information extracted from the WSDL
     * - documentation: Chapter Position.This element has a default value of '0'. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cpo_chapter_flag = null;
    /**
     * The cpo_description
     * Meta information extracted from the WSDL
     * - documentation: Description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cpo_description = null;
    /**
     * The cpo_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cpo_entity_key = null;
    /**
     * Constructor method for
     * CommitteeNominations_Committee_Position_Codes_DataObjectType
     * @uses CommitteeNominations_Committee_Position_Codes_DataObjectType::setCpo_code()
     * @uses CommitteeNominations_Committee_Position_Codes_DataObjectType::setCpo_add_user()
     * @uses CommitteeNominations_Committee_Position_Codes_DataObjectType::setCpo_add_date()
     * @uses CommitteeNominations_Committee_Position_Codes_DataObjectType::setCpo_change_user()
     * @uses CommitteeNominations_Committee_Position_Codes_DataObjectType::setCpo_change_date()
     * @uses CommitteeNominations_Committee_Position_Codes_DataObjectType::setCpo_delete_flag()
     * @uses CommitteeNominations_Committee_Position_Codes_DataObjectType::setCpo_key()
     * @uses CommitteeNominations_Committee_Position_Codes_DataObjectType::setCpo_key_ext()
     * @uses CommitteeNominations_Committee_Position_Codes_DataObjectType::setCpo_chapter_flag()
     * @uses CommitteeNominations_Committee_Position_Codes_DataObjectType::setCpo_description()
     * @uses CommitteeNominations_Committee_Position_Codes_DataObjectType::setCpo_entity_key()
     * @param string $cpo_code
     * @param string $cpo_add_user
     * @param string $cpo_add_date
     * @param string $cpo_change_user
     * @param string $cpo_change_date
     * @param string $cpo_delete_flag
     * @param string $cpo_key
     * @param string $cpo_key_ext
     * @param string $cpo_chapter_flag
     * @param string $cpo_description
     * @param string $cpo_entity_key
     */
    public function __construct(?string $cpo_code = null, ?string $cpo_add_user = null, ?string $cpo_add_date = null, ?string $cpo_change_user = null, ?string $cpo_change_date = null, ?string $cpo_delete_flag = null, ?string $cpo_key = null, ?string $cpo_key_ext = null, ?string $cpo_chapter_flag = null, ?string $cpo_description = null, ?string $cpo_entity_key = null)
    {
        $this
            ->setCpo_code($cpo_code)
            ->setCpo_add_user($cpo_add_user)
            ->setCpo_add_date($cpo_add_date)
            ->setCpo_change_user($cpo_change_user)
            ->setCpo_change_date($cpo_change_date)
            ->setCpo_delete_flag($cpo_delete_flag)
            ->setCpo_key($cpo_key)
            ->setCpo_key_ext($cpo_key_ext)
            ->setCpo_chapter_flag($cpo_chapter_flag)
            ->setCpo_description($cpo_description)
            ->setCpo_entity_key($cpo_entity_key);
    }
    /**
     * Get cpo_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpo_code(): ?string
    {
        return $this->cpo_code ?? null;
    }
    /**
     * Set cpo_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpo_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_Codes_DataObjectType
     */
    public function setCpo_code(?string $cpo_code = null): self
    {
        // validation for constraint: string
        if (!is_null($cpo_code) && !is_string($cpo_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpo_code, true), gettype($cpo_code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($cpo_code) && mb_strlen((string) $cpo_code) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $cpo_code)), __LINE__);
        }
        if (is_null($cpo_code) || (is_array($cpo_code) && empty($cpo_code))) {
            unset($this->cpo_code);
        } else {
            $this->cpo_code = $cpo_code;
        }
        
        return $this;
    }
    /**
     * Get cpo_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpo_add_user(): ?string
    {
        return $this->cpo_add_user ?? null;
    }
    /**
     * Set cpo_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpo_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_Codes_DataObjectType
     */
    public function setCpo_add_user(?string $cpo_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cpo_add_user) && !is_string($cpo_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpo_add_user, true), gettype($cpo_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cpo_add_user) && mb_strlen((string) $cpo_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cpo_add_user)), __LINE__);
        }
        if (is_null($cpo_add_user) || (is_array($cpo_add_user) && empty($cpo_add_user))) {
            unset($this->cpo_add_user);
        } else {
            $this->cpo_add_user = $cpo_add_user;
        }
        
        return $this;
    }
    /**
     * Get cpo_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpo_add_date(): ?string
    {
        return $this->cpo_add_date ?? null;
    }
    /**
     * Set cpo_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpo_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_Codes_DataObjectType
     */
    public function setCpo_add_date(?string $cpo_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cpo_add_date) && !is_string($cpo_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpo_add_date, true), gettype($cpo_add_date)), __LINE__);
        }
        if (is_null($cpo_add_date) || (is_array($cpo_add_date) && empty($cpo_add_date))) {
            unset($this->cpo_add_date);
        } else {
            $this->cpo_add_date = $cpo_add_date;
        }
        
        return $this;
    }
    /**
     * Get cpo_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpo_change_user(): ?string
    {
        return $this->cpo_change_user ?? null;
    }
    /**
     * Set cpo_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpo_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_Codes_DataObjectType
     */
    public function setCpo_change_user(?string $cpo_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cpo_change_user) && !is_string($cpo_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpo_change_user, true), gettype($cpo_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cpo_change_user) && mb_strlen((string) $cpo_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cpo_change_user)), __LINE__);
        }
        if (is_null($cpo_change_user) || (is_array($cpo_change_user) && empty($cpo_change_user))) {
            unset($this->cpo_change_user);
        } else {
            $this->cpo_change_user = $cpo_change_user;
        }
        
        return $this;
    }
    /**
     * Get cpo_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpo_change_date(): ?string
    {
        return $this->cpo_change_date ?? null;
    }
    /**
     * Set cpo_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpo_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_Codes_DataObjectType
     */
    public function setCpo_change_date(?string $cpo_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cpo_change_date) && !is_string($cpo_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpo_change_date, true), gettype($cpo_change_date)), __LINE__);
        }
        if (is_null($cpo_change_date) || (is_array($cpo_change_date) && empty($cpo_change_date))) {
            unset($this->cpo_change_date);
        } else {
            $this->cpo_change_date = $cpo_change_date;
        }
        
        return $this;
    }
    /**
     * Get cpo_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpo_delete_flag(): ?string
    {
        return $this->cpo_delete_flag ?? null;
    }
    /**
     * Set cpo_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpo_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_Codes_DataObjectType
     */
    public function setCpo_delete_flag(?string $cpo_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cpo_delete_flag) && !is_string($cpo_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpo_delete_flag, true), gettype($cpo_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cpo_delete_flag) && $cpo_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cpo_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cpo_delete_flag) && $cpo_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cpo_delete_flag, true)), __LINE__);
        }
        if (is_null($cpo_delete_flag) || (is_array($cpo_delete_flag) && empty($cpo_delete_flag))) {
            unset($this->cpo_delete_flag);
        } else {
            $this->cpo_delete_flag = $cpo_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get cpo_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpo_key(): ?string
    {
        return $this->cpo_key ?? null;
    }
    /**
     * Set cpo_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpo_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_Codes_DataObjectType
     */
    public function setCpo_key(?string $cpo_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cpo_key) && !is_string($cpo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpo_key, true), gettype($cpo_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cpo_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cpo_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cpo_key, true)), __LINE__);
        }
        if (is_null($cpo_key) || (is_array($cpo_key) && empty($cpo_key))) {
            unset($this->cpo_key);
        } else {
            $this->cpo_key = $cpo_key;
        }
        
        return $this;
    }
    /**
     * Get cpo_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpo_key_ext(): ?string
    {
        return $this->cpo_key_ext ?? null;
    }
    /**
     * Set cpo_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpo_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_Codes_DataObjectType
     */
    public function setCpo_key_ext(?string $cpo_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($cpo_key_ext) && !is_string($cpo_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpo_key_ext, true), gettype($cpo_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cpo_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cpo_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cpo_key_ext, true)), __LINE__);
        }
        if (is_null($cpo_key_ext) || (is_array($cpo_key_ext) && empty($cpo_key_ext))) {
            unset($this->cpo_key_ext);
        } else {
            $this->cpo_key_ext = $cpo_key_ext;
        }
        
        return $this;
    }
    /**
     * Get cpo_chapter_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpo_chapter_flag(): ?string
    {
        return $this->cpo_chapter_flag ?? null;
    }
    /**
     * Set cpo_chapter_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpo_chapter_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_Codes_DataObjectType
     */
    public function setCpo_chapter_flag(?string $cpo_chapter_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cpo_chapter_flag) && !is_string($cpo_chapter_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpo_chapter_flag, true), gettype($cpo_chapter_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cpo_chapter_flag) && $cpo_chapter_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cpo_chapter_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cpo_chapter_flag) && $cpo_chapter_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cpo_chapter_flag, true)), __LINE__);
        }
        if (is_null($cpo_chapter_flag) || (is_array($cpo_chapter_flag) && empty($cpo_chapter_flag))) {
            unset($this->cpo_chapter_flag);
        } else {
            $this->cpo_chapter_flag = $cpo_chapter_flag;
        }
        
        return $this;
    }
    /**
     * Get cpo_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpo_description(): ?string
    {
        return $this->cpo_description ?? null;
    }
    /**
     * Set cpo_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpo_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_Codes_DataObjectType
     */
    public function setCpo_description(?string $cpo_description = null): self
    {
        // validation for constraint: string
        if (!is_null($cpo_description) && !is_string($cpo_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpo_description, true), gettype($cpo_description)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($cpo_description) && mb_strlen((string) $cpo_description) > 80) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen((string) $cpo_description)), __LINE__);
        }
        if (is_null($cpo_description) || (is_array($cpo_description) && empty($cpo_description))) {
            unset($this->cpo_description);
        } else {
            $this->cpo_description = $cpo_description;
        }
        
        return $this;
    }
    /**
     * Get cpo_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpo_entity_key(): ?string
    {
        return $this->cpo_entity_key ?? null;
    }
    /**
     * Set cpo_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpo_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Committee_Position_Codes_DataObjectType
     */
    public function setCpo_entity_key(?string $cpo_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cpo_entity_key) && !is_string($cpo_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpo_entity_key, true), gettype($cpo_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cpo_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cpo_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cpo_entity_key, true)), __LINE__);
        }
        if (is_null($cpo_entity_key) || (is_array($cpo_entity_key) && empty($cpo_entity_key))) {
            unset($this->cpo_entity_key);
        } else {
            $this->cpo_entity_key = $cpo_entity_key;
        }
        
        return $this;
    }
}
