<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommitteeNominations_Nominations_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class CommitteeNominations_Nominations_DataObjectType extends AbstractStructBase
{
    /**
     * The nom_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nom_key = null;
    /**
     * The nom_cmt_key
     * Meta information extracted from the WSDL
     * - documentation: Committee. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nom_cmt_key = null;
    /**
     * The nom_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Nominee. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nom_cst_key = null;
    /**
     * The nom_cst_key_by
     * Meta information extracted from the WSDL
     * - documentation: Nominated By. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nom_cst_key_by = null;
    /**
     * The nom_nms_key
     * Meta information extracted from the WSDL
     * - documentation: Status. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nom_nms_key = null;
    /**
     * The nom_status_chg_date
     * Meta information extracted from the WSDL
     * - documentation: Status Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nom_status_chg_date = null;
    /**
     * The nom_date
     * Meta information extracted from the WSDL
     * - documentation: Nomination Date. This field has this Input Mask: 99/99/9999 . | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nom_date = null;
    /**
     * The nom_notes
     * Meta information extracted from the WSDL
     * - documentation: Notes. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 300
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nom_notes = null;
    /**
     * The nom_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nom_add_user = null;
    /**
     * The nom_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nom_add_date = null;
    /**
     * The nom_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nom_change_user = null;
    /**
     * The nom_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nom_change_date = null;
    /**
     * The nom_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nom_delete_flag = null;
    /**
     * The nom_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nom_key_ext = null;
    /**
     * The nom_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nom_entity_key = null;
    /**
     * The nom_start_date
     * Meta information extracted from the WSDL
     * - documentation: Start Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nom_start_date = null;
    /**
     * The nom_end_date
     * Meta information extracted from the WSDL
     * - documentation: End Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nom_end_date = null;
    /**
     * The nom_cxa_key
     * Meta information extracted from the WSDL
     * - documentation: Address. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nom_cxa_key = null;
    /**
     * The nom_cph_key
     * Meta information extracted from the WSDL
     * - documentation: Phone. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nom_cph_key = null;
    /**
     * The nom_cfx_key
     * Meta information extracted from the WSDL
     * - documentation: Fax. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nom_cfx_key = null;
    /**
     * The nom_url_key
     * Meta information extracted from the WSDL
     * - documentation: Url. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nom_url_key = null;
    /**
     * The nom_pref_comm_meth
     * Meta information extracted from the WSDL
     * - documentation: Preferred Communication Method. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nom_pref_comm_meth = null;
    /**
     * The nom_cop_key
     * Meta information extracted from the WSDL
     * - documentation: Position. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nom_cop_key = null;
    /**
     * The nom_eml_key
     * Meta information extracted from the WSDL
     * - documentation: email. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $nom_eml_key = null;
    /**
     * The nom_accepted_flag
     * Meta information extracted from the WSDL
     * - documentation: Accepted?.This element has a default value of '0'. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nom_accepted_flag = null;
    /**
     * The nom_rejected_flag
     * Meta information extracted from the WSDL
     * - documentation: Rejected?. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $nom_rejected_flag = null;
    /**
     * Constructor method for CommitteeNominations_Nominations_DataObjectType
     * @uses CommitteeNominations_Nominations_DataObjectType::setNom_key()
     * @uses CommitteeNominations_Nominations_DataObjectType::setNom_cmt_key()
     * @uses CommitteeNominations_Nominations_DataObjectType::setNom_cst_key()
     * @uses CommitteeNominations_Nominations_DataObjectType::setNom_cst_key_by()
     * @uses CommitteeNominations_Nominations_DataObjectType::setNom_nms_key()
     * @uses CommitteeNominations_Nominations_DataObjectType::setNom_status_chg_date()
     * @uses CommitteeNominations_Nominations_DataObjectType::setNom_date()
     * @uses CommitteeNominations_Nominations_DataObjectType::setNom_notes()
     * @uses CommitteeNominations_Nominations_DataObjectType::setNom_add_user()
     * @uses CommitteeNominations_Nominations_DataObjectType::setNom_add_date()
     * @uses CommitteeNominations_Nominations_DataObjectType::setNom_change_user()
     * @uses CommitteeNominations_Nominations_DataObjectType::setNom_change_date()
     * @uses CommitteeNominations_Nominations_DataObjectType::setNom_delete_flag()
     * @uses CommitteeNominations_Nominations_DataObjectType::setNom_key_ext()
     * @uses CommitteeNominations_Nominations_DataObjectType::setNom_entity_key()
     * @uses CommitteeNominations_Nominations_DataObjectType::setNom_start_date()
     * @uses CommitteeNominations_Nominations_DataObjectType::setNom_end_date()
     * @uses CommitteeNominations_Nominations_DataObjectType::setNom_cxa_key()
     * @uses CommitteeNominations_Nominations_DataObjectType::setNom_cph_key()
     * @uses CommitteeNominations_Nominations_DataObjectType::setNom_cfx_key()
     * @uses CommitteeNominations_Nominations_DataObjectType::setNom_url_key()
     * @uses CommitteeNominations_Nominations_DataObjectType::setNom_pref_comm_meth()
     * @uses CommitteeNominations_Nominations_DataObjectType::setNom_cop_key()
     * @uses CommitteeNominations_Nominations_DataObjectType::setNom_eml_key()
     * @uses CommitteeNominations_Nominations_DataObjectType::setNom_accepted_flag()
     * @uses CommitteeNominations_Nominations_DataObjectType::setNom_rejected_flag()
     * @param string $nom_key
     * @param string $nom_cmt_key
     * @param string $nom_cst_key
     * @param string $nom_cst_key_by
     * @param string $nom_nms_key
     * @param string $nom_status_chg_date
     * @param string $nom_date
     * @param string $nom_notes
     * @param string $nom_add_user
     * @param string $nom_add_date
     * @param string $nom_change_user
     * @param string $nom_change_date
     * @param string $nom_delete_flag
     * @param string $nom_key_ext
     * @param string $nom_entity_key
     * @param string $nom_start_date
     * @param string $nom_end_date
     * @param string $nom_cxa_key
     * @param string $nom_cph_key
     * @param string $nom_cfx_key
     * @param string $nom_url_key
     * @param string $nom_pref_comm_meth
     * @param string $nom_cop_key
     * @param string $nom_eml_key
     * @param string $nom_accepted_flag
     * @param string $nom_rejected_flag
     */
    public function __construct(?string $nom_key = null, ?string $nom_cmt_key = null, ?string $nom_cst_key = null, ?string $nom_cst_key_by = null, ?string $nom_nms_key = null, ?string $nom_status_chg_date = null, ?string $nom_date = null, ?string $nom_notes = null, ?string $nom_add_user = null, ?string $nom_add_date = null, ?string $nom_change_user = null, ?string $nom_change_date = null, ?string $nom_delete_flag = null, ?string $nom_key_ext = null, ?string $nom_entity_key = null, ?string $nom_start_date = null, ?string $nom_end_date = null, ?string $nom_cxa_key = null, ?string $nom_cph_key = null, ?string $nom_cfx_key = null, ?string $nom_url_key = null, ?string $nom_pref_comm_meth = null, ?string $nom_cop_key = null, ?string $nom_eml_key = null, ?string $nom_accepted_flag = null, ?string $nom_rejected_flag = null)
    {
        $this
            ->setNom_key($nom_key)
            ->setNom_cmt_key($nom_cmt_key)
            ->setNom_cst_key($nom_cst_key)
            ->setNom_cst_key_by($nom_cst_key_by)
            ->setNom_nms_key($nom_nms_key)
            ->setNom_status_chg_date($nom_status_chg_date)
            ->setNom_date($nom_date)
            ->setNom_notes($nom_notes)
            ->setNom_add_user($nom_add_user)
            ->setNom_add_date($nom_add_date)
            ->setNom_change_user($nom_change_user)
            ->setNom_change_date($nom_change_date)
            ->setNom_delete_flag($nom_delete_flag)
            ->setNom_key_ext($nom_key_ext)
            ->setNom_entity_key($nom_entity_key)
            ->setNom_start_date($nom_start_date)
            ->setNom_end_date($nom_end_date)
            ->setNom_cxa_key($nom_cxa_key)
            ->setNom_cph_key($nom_cph_key)
            ->setNom_cfx_key($nom_cfx_key)
            ->setNom_url_key($nom_url_key)
            ->setNom_pref_comm_meth($nom_pref_comm_meth)
            ->setNom_cop_key($nom_cop_key)
            ->setNom_eml_key($nom_eml_key)
            ->setNom_accepted_flag($nom_accepted_flag)
            ->setNom_rejected_flag($nom_rejected_flag);
    }
    /**
     * Get nom_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNom_key(): ?string
    {
        return $this->nom_key ?? null;
    }
    /**
     * Set nom_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nom_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominations_DataObjectType
     */
    public function setNom_key(?string $nom_key = null): self
    {
        // validation for constraint: string
        if (!is_null($nom_key) && !is_string($nom_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nom_key, true), gettype($nom_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nom_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nom_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nom_key, true)), __LINE__);
        }
        if (is_null($nom_key) || (is_array($nom_key) && empty($nom_key))) {
            unset($this->nom_key);
        } else {
            $this->nom_key = $nom_key;
        }
        
        return $this;
    }
    /**
     * Get nom_cmt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNom_cmt_key(): ?string
    {
        return $this->nom_cmt_key ?? null;
    }
    /**
     * Set nom_cmt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nom_cmt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominations_DataObjectType
     */
    public function setNom_cmt_key(?string $nom_cmt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($nom_cmt_key) && !is_string($nom_cmt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nom_cmt_key, true), gettype($nom_cmt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nom_cmt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nom_cmt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nom_cmt_key, true)), __LINE__);
        }
        if (is_null($nom_cmt_key) || (is_array($nom_cmt_key) && empty($nom_cmt_key))) {
            unset($this->nom_cmt_key);
        } else {
            $this->nom_cmt_key = $nom_cmt_key;
        }
        
        return $this;
    }
    /**
     * Get nom_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNom_cst_key(): ?string
    {
        return $this->nom_cst_key ?? null;
    }
    /**
     * Set nom_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nom_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominations_DataObjectType
     */
    public function setNom_cst_key(?string $nom_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($nom_cst_key) && !is_string($nom_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nom_cst_key, true), gettype($nom_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nom_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nom_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nom_cst_key, true)), __LINE__);
        }
        if (is_null($nom_cst_key) || (is_array($nom_cst_key) && empty($nom_cst_key))) {
            unset($this->nom_cst_key);
        } else {
            $this->nom_cst_key = $nom_cst_key;
        }
        
        return $this;
    }
    /**
     * Get nom_cst_key_by value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNom_cst_key_by(): ?string
    {
        return $this->nom_cst_key_by ?? null;
    }
    /**
     * Set nom_cst_key_by value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nom_cst_key_by
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominations_DataObjectType
     */
    public function setNom_cst_key_by(?string $nom_cst_key_by = null): self
    {
        // validation for constraint: string
        if (!is_null($nom_cst_key_by) && !is_string($nom_cst_key_by)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nom_cst_key_by, true), gettype($nom_cst_key_by)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nom_cst_key_by) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nom_cst_key_by)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nom_cst_key_by, true)), __LINE__);
        }
        if (is_null($nom_cst_key_by) || (is_array($nom_cst_key_by) && empty($nom_cst_key_by))) {
            unset($this->nom_cst_key_by);
        } else {
            $this->nom_cst_key_by = $nom_cst_key_by;
        }
        
        return $this;
    }
    /**
     * Get nom_nms_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNom_nms_key(): ?string
    {
        return $this->nom_nms_key ?? null;
    }
    /**
     * Set nom_nms_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nom_nms_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominations_DataObjectType
     */
    public function setNom_nms_key(?string $nom_nms_key = null): self
    {
        // validation for constraint: string
        if (!is_null($nom_nms_key) && !is_string($nom_nms_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nom_nms_key, true), gettype($nom_nms_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nom_nms_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nom_nms_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nom_nms_key, true)), __LINE__);
        }
        if (is_null($nom_nms_key) || (is_array($nom_nms_key) && empty($nom_nms_key))) {
            unset($this->nom_nms_key);
        } else {
            $this->nom_nms_key = $nom_nms_key;
        }
        
        return $this;
    }
    /**
     * Get nom_status_chg_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNom_status_chg_date(): ?string
    {
        return $this->nom_status_chg_date ?? null;
    }
    /**
     * Set nom_status_chg_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nom_status_chg_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominations_DataObjectType
     */
    public function setNom_status_chg_date(?string $nom_status_chg_date = null): self
    {
        // validation for constraint: string
        if (!is_null($nom_status_chg_date) && !is_string($nom_status_chg_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nom_status_chg_date, true), gettype($nom_status_chg_date)), __LINE__);
        }
        if (is_null($nom_status_chg_date) || (is_array($nom_status_chg_date) && empty($nom_status_chg_date))) {
            unset($this->nom_status_chg_date);
        } else {
            $this->nom_status_chg_date = $nom_status_chg_date;
        }
        
        return $this;
    }
    /**
     * Get nom_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNom_date(): ?string
    {
        return $this->nom_date ?? null;
    }
    /**
     * Set nom_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nom_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominations_DataObjectType
     */
    public function setNom_date(?string $nom_date = null): self
    {
        // validation for constraint: string
        if (!is_null($nom_date) && !is_string($nom_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nom_date, true), gettype($nom_date)), __LINE__);
        }
        if (is_null($nom_date) || (is_array($nom_date) && empty($nom_date))) {
            unset($this->nom_date);
        } else {
            $this->nom_date = $nom_date;
        }
        
        return $this;
    }
    /**
     * Get nom_notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNom_notes(): ?string
    {
        return $this->nom_notes ?? null;
    }
    /**
     * Set nom_notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nom_notes
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominations_DataObjectType
     */
    public function setNom_notes(?string $nom_notes = null): self
    {
        // validation for constraint: string
        if (!is_null($nom_notes) && !is_string($nom_notes)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nom_notes, true), gettype($nom_notes)), __LINE__);
        }
        // validation for constraint: maxLength(300)
        if (!is_null($nom_notes) && mb_strlen((string) $nom_notes) > 300) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 300', mb_strlen((string) $nom_notes)), __LINE__);
        }
        if (is_null($nom_notes) || (is_array($nom_notes) && empty($nom_notes))) {
            unset($this->nom_notes);
        } else {
            $this->nom_notes = $nom_notes;
        }
        
        return $this;
    }
    /**
     * Get nom_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNom_add_user(): ?string
    {
        return $this->nom_add_user ?? null;
    }
    /**
     * Set nom_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nom_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominations_DataObjectType
     */
    public function setNom_add_user(?string $nom_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($nom_add_user) && !is_string($nom_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nom_add_user, true), gettype($nom_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($nom_add_user) && mb_strlen((string) $nom_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $nom_add_user)), __LINE__);
        }
        if (is_null($nom_add_user) || (is_array($nom_add_user) && empty($nom_add_user))) {
            unset($this->nom_add_user);
        } else {
            $this->nom_add_user = $nom_add_user;
        }
        
        return $this;
    }
    /**
     * Get nom_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNom_add_date(): ?string
    {
        return $this->nom_add_date ?? null;
    }
    /**
     * Set nom_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nom_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominations_DataObjectType
     */
    public function setNom_add_date(?string $nom_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($nom_add_date) && !is_string($nom_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nom_add_date, true), gettype($nom_add_date)), __LINE__);
        }
        if (is_null($nom_add_date) || (is_array($nom_add_date) && empty($nom_add_date))) {
            unset($this->nom_add_date);
        } else {
            $this->nom_add_date = $nom_add_date;
        }
        
        return $this;
    }
    /**
     * Get nom_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNom_change_user(): ?string
    {
        return $this->nom_change_user ?? null;
    }
    /**
     * Set nom_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nom_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominations_DataObjectType
     */
    public function setNom_change_user(?string $nom_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($nom_change_user) && !is_string($nom_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nom_change_user, true), gettype($nom_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($nom_change_user) && mb_strlen((string) $nom_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $nom_change_user)), __LINE__);
        }
        if (is_null($nom_change_user) || (is_array($nom_change_user) && empty($nom_change_user))) {
            unset($this->nom_change_user);
        } else {
            $this->nom_change_user = $nom_change_user;
        }
        
        return $this;
    }
    /**
     * Get nom_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNom_change_date(): ?string
    {
        return $this->nom_change_date ?? null;
    }
    /**
     * Set nom_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nom_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominations_DataObjectType
     */
    public function setNom_change_date(?string $nom_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($nom_change_date) && !is_string($nom_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nom_change_date, true), gettype($nom_change_date)), __LINE__);
        }
        if (is_null($nom_change_date) || (is_array($nom_change_date) && empty($nom_change_date))) {
            unset($this->nom_change_date);
        } else {
            $this->nom_change_date = $nom_change_date;
        }
        
        return $this;
    }
    /**
     * Get nom_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNom_delete_flag(): ?string
    {
        return $this->nom_delete_flag ?? null;
    }
    /**
     * Set nom_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nom_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominations_DataObjectType
     */
    public function setNom_delete_flag(?string $nom_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($nom_delete_flag) && !is_string($nom_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nom_delete_flag, true), gettype($nom_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($nom_delete_flag) && $nom_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($nom_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($nom_delete_flag) && $nom_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($nom_delete_flag, true)), __LINE__);
        }
        if (is_null($nom_delete_flag) || (is_array($nom_delete_flag) && empty($nom_delete_flag))) {
            unset($this->nom_delete_flag);
        } else {
            $this->nom_delete_flag = $nom_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get nom_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNom_key_ext(): ?string
    {
        return $this->nom_key_ext ?? null;
    }
    /**
     * Set nom_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nom_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominations_DataObjectType
     */
    public function setNom_key_ext(?string $nom_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($nom_key_ext) && !is_string($nom_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nom_key_ext, true), gettype($nom_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nom_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nom_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nom_key_ext, true)), __LINE__);
        }
        if (is_null($nom_key_ext) || (is_array($nom_key_ext) && empty($nom_key_ext))) {
            unset($this->nom_key_ext);
        } else {
            $this->nom_key_ext = $nom_key_ext;
        }
        
        return $this;
    }
    /**
     * Get nom_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNom_entity_key(): ?string
    {
        return $this->nom_entity_key ?? null;
    }
    /**
     * Set nom_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nom_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominations_DataObjectType
     */
    public function setNom_entity_key(?string $nom_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($nom_entity_key) && !is_string($nom_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nom_entity_key, true), gettype($nom_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nom_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nom_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nom_entity_key, true)), __LINE__);
        }
        if (is_null($nom_entity_key) || (is_array($nom_entity_key) && empty($nom_entity_key))) {
            unset($this->nom_entity_key);
        } else {
            $this->nom_entity_key = $nom_entity_key;
        }
        
        return $this;
    }
    /**
     * Get nom_start_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNom_start_date(): ?string
    {
        return $this->nom_start_date ?? null;
    }
    /**
     * Set nom_start_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nom_start_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominations_DataObjectType
     */
    public function setNom_start_date(?string $nom_start_date = null): self
    {
        // validation for constraint: string
        if (!is_null($nom_start_date) && !is_string($nom_start_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nom_start_date, true), gettype($nom_start_date)), __LINE__);
        }
        if (is_null($nom_start_date) || (is_array($nom_start_date) && empty($nom_start_date))) {
            unset($this->nom_start_date);
        } else {
            $this->nom_start_date = $nom_start_date;
        }
        
        return $this;
    }
    /**
     * Get nom_end_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNom_end_date(): ?string
    {
        return $this->nom_end_date ?? null;
    }
    /**
     * Set nom_end_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nom_end_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominations_DataObjectType
     */
    public function setNom_end_date(?string $nom_end_date = null): self
    {
        // validation for constraint: string
        if (!is_null($nom_end_date) && !is_string($nom_end_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nom_end_date, true), gettype($nom_end_date)), __LINE__);
        }
        if (is_null($nom_end_date) || (is_array($nom_end_date) && empty($nom_end_date))) {
            unset($this->nom_end_date);
        } else {
            $this->nom_end_date = $nom_end_date;
        }
        
        return $this;
    }
    /**
     * Get nom_cxa_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNom_cxa_key(): ?string
    {
        return $this->nom_cxa_key ?? null;
    }
    /**
     * Set nom_cxa_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nom_cxa_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominations_DataObjectType
     */
    public function setNom_cxa_key(?string $nom_cxa_key = null): self
    {
        // validation for constraint: string
        if (!is_null($nom_cxa_key) && !is_string($nom_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nom_cxa_key, true), gettype($nom_cxa_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nom_cxa_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nom_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nom_cxa_key, true)), __LINE__);
        }
        if (is_null($nom_cxa_key) || (is_array($nom_cxa_key) && empty($nom_cxa_key))) {
            unset($this->nom_cxa_key);
        } else {
            $this->nom_cxa_key = $nom_cxa_key;
        }
        
        return $this;
    }
    /**
     * Get nom_cph_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNom_cph_key(): ?string
    {
        return $this->nom_cph_key ?? null;
    }
    /**
     * Set nom_cph_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nom_cph_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominations_DataObjectType
     */
    public function setNom_cph_key(?string $nom_cph_key = null): self
    {
        // validation for constraint: string
        if (!is_null($nom_cph_key) && !is_string($nom_cph_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nom_cph_key, true), gettype($nom_cph_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nom_cph_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nom_cph_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nom_cph_key, true)), __LINE__);
        }
        if (is_null($nom_cph_key) || (is_array($nom_cph_key) && empty($nom_cph_key))) {
            unset($this->nom_cph_key);
        } else {
            $this->nom_cph_key = $nom_cph_key;
        }
        
        return $this;
    }
    /**
     * Get nom_cfx_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNom_cfx_key(): ?string
    {
        return $this->nom_cfx_key ?? null;
    }
    /**
     * Set nom_cfx_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nom_cfx_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominations_DataObjectType
     */
    public function setNom_cfx_key(?string $nom_cfx_key = null): self
    {
        // validation for constraint: string
        if (!is_null($nom_cfx_key) && !is_string($nom_cfx_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nom_cfx_key, true), gettype($nom_cfx_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nom_cfx_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nom_cfx_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nom_cfx_key, true)), __LINE__);
        }
        if (is_null($nom_cfx_key) || (is_array($nom_cfx_key) && empty($nom_cfx_key))) {
            unset($this->nom_cfx_key);
        } else {
            $this->nom_cfx_key = $nom_cfx_key;
        }
        
        return $this;
    }
    /**
     * Get nom_url_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNom_url_key(): ?string
    {
        return $this->nom_url_key ?? null;
    }
    /**
     * Set nom_url_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nom_url_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominations_DataObjectType
     */
    public function setNom_url_key(?string $nom_url_key = null): self
    {
        // validation for constraint: string
        if (!is_null($nom_url_key) && !is_string($nom_url_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nom_url_key, true), gettype($nom_url_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nom_url_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nom_url_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nom_url_key, true)), __LINE__);
        }
        if (is_null($nom_url_key) || (is_array($nom_url_key) && empty($nom_url_key))) {
            unset($this->nom_url_key);
        } else {
            $this->nom_url_key = $nom_url_key;
        }
        
        return $this;
    }
    /**
     * Get nom_pref_comm_meth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNom_pref_comm_meth(): ?string
    {
        return $this->nom_pref_comm_meth ?? null;
    }
    /**
     * Set nom_pref_comm_meth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nom_pref_comm_meth
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominations_DataObjectType
     */
    public function setNom_pref_comm_meth(?string $nom_pref_comm_meth = null): self
    {
        // validation for constraint: string
        if (!is_null($nom_pref_comm_meth) && !is_string($nom_pref_comm_meth)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nom_pref_comm_meth, true), gettype($nom_pref_comm_meth)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($nom_pref_comm_meth) && mb_strlen((string) $nom_pref_comm_meth) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $nom_pref_comm_meth)), __LINE__);
        }
        if (is_null($nom_pref_comm_meth) || (is_array($nom_pref_comm_meth) && empty($nom_pref_comm_meth))) {
            unset($this->nom_pref_comm_meth);
        } else {
            $this->nom_pref_comm_meth = $nom_pref_comm_meth;
        }
        
        return $this;
    }
    /**
     * Get nom_cop_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNom_cop_key(): ?string
    {
        return $this->nom_cop_key ?? null;
    }
    /**
     * Set nom_cop_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nom_cop_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominations_DataObjectType
     */
    public function setNom_cop_key(?string $nom_cop_key = null): self
    {
        // validation for constraint: string
        if (!is_null($nom_cop_key) && !is_string($nom_cop_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nom_cop_key, true), gettype($nom_cop_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nom_cop_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nom_cop_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nom_cop_key, true)), __LINE__);
        }
        if (is_null($nom_cop_key) || (is_array($nom_cop_key) && empty($nom_cop_key))) {
            unset($this->nom_cop_key);
        } else {
            $this->nom_cop_key = $nom_cop_key;
        }
        
        return $this;
    }
    /**
     * Get nom_eml_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNom_eml_key(): ?string
    {
        return $this->nom_eml_key ?? null;
    }
    /**
     * Set nom_eml_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nom_eml_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominations_DataObjectType
     */
    public function setNom_eml_key(?string $nom_eml_key = null): self
    {
        // validation for constraint: string
        if (!is_null($nom_eml_key) && !is_string($nom_eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nom_eml_key, true), gettype($nom_eml_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($nom_eml_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $nom_eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($nom_eml_key, true)), __LINE__);
        }
        if (is_null($nom_eml_key) || (is_array($nom_eml_key) && empty($nom_eml_key))) {
            unset($this->nom_eml_key);
        } else {
            $this->nom_eml_key = $nom_eml_key;
        }
        
        return $this;
    }
    /**
     * Get nom_accepted_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNom_accepted_flag(): ?string
    {
        return $this->nom_accepted_flag ?? null;
    }
    /**
     * Set nom_accepted_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nom_accepted_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominations_DataObjectType
     */
    public function setNom_accepted_flag(?string $nom_accepted_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($nom_accepted_flag) && !is_string($nom_accepted_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nom_accepted_flag, true), gettype($nom_accepted_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($nom_accepted_flag) && $nom_accepted_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($nom_accepted_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($nom_accepted_flag) && $nom_accepted_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($nom_accepted_flag, true)), __LINE__);
        }
        if (is_null($nom_accepted_flag) || (is_array($nom_accepted_flag) && empty($nom_accepted_flag))) {
            unset($this->nom_accepted_flag);
        } else {
            $this->nom_accepted_flag = $nom_accepted_flag;
        }
        
        return $this;
    }
    /**
     * Get nom_rejected_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNom_rejected_flag(): ?string
    {
        return $this->nom_rejected_flag ?? null;
    }
    /**
     * Set nom_rejected_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nom_rejected_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\CommitteeNominations_Nominations_DataObjectType
     */
    public function setNom_rejected_flag(?string $nom_rejected_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($nom_rejected_flag) && !is_string($nom_rejected_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nom_rejected_flag, true), gettype($nom_rejected_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($nom_rejected_flag) && $nom_rejected_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($nom_rejected_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($nom_rejected_flag) && $nom_rejected_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($nom_rejected_flag, true)), __LINE__);
        }
        if (is_null($nom_rejected_flag) || (is_array($nom_rejected_flag) && empty($nom_rejected_flag))) {
            unset($this->nom_rejected_flag);
        } else {
            $this->nom_rejected_flag = $nom_rejected_flag;
        }
        
        return $this;
    }
}
