<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Committee_Committee_Participant_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Committee_Committee_Participant_DataObjectType extends AbstractStructBase
{
    /**
     * The cmc_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cmc_key = null;
    /**
     * The cmc_start_date
     * Meta information extracted from the WSDL
     * - documentation: Start Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmc_start_date = null;
    /**
     * The cmc_end_date
     * Meta information extracted from the WSDL
     * - documentation: End Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmc_end_date = null;
    /**
     * The cmc_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Member Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cmc_cst_key = null;
    /**
     * The cmc_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmc_add_date = null;
    /**
     * The cmc_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmc_add_user = null;
    /**
     * The cmc_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmc_change_date = null;
    /**
     * The cmc_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmc_change_user = null;
    /**
     * The cmc_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmc_delete_flag = null;
    /**
     * The cmc_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cmc_key_ext = null;
    /**
     * The cmc_status
     * Meta information extracted from the WSDL
     * - documentation: Status. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmc_status = null;
    /**
     * The cmc_cmt_key
     * Meta information extracted from the WSDL
     * - documentation: committee. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cmc_cmt_key = null;
    /**
     * The cmc_voting_flag
     * Meta information extracted from the WSDL
     * - documentation: Voting. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmc_voting_flag = null;
    /**
     * The cmc_cxa_key
     * Meta information extracted from the WSDL
     * - documentation: Address. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cmc_cxa_key = null;
    /**
     * The cmc_cph_key
     * Meta information extracted from the WSDL
     * - documentation: Phone. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cmc_cph_key = null;
    /**
     * The cmc_eml_key
     * Meta information extracted from the WSDL
     * - documentation: E-Mail. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cmc_eml_key = null;
    /**
     * The cmc_cfx_key
     * Meta information extracted from the WSDL
     * - documentation: Fax. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cmc_cfx_key = null;
    /**
     * The cmc_url_key
     * Meta information extracted from the WSDL
     * - documentation: URL. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cmc_url_key = null;
    /**
     * The cmc_pref_comm_meth
     * Meta information extracted from the WSDL
     * - documentation: Pref. Communication. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmc_pref_comm_meth = null;
    /**
     * The cmc_rank
     * Meta information extracted from the WSDL
     * - documentation: Rank. | Avectra netForum defined simpleType.
     * - base: s:integer
     * - maxInclusive: 2147483647
     * - maxOccurs: 1
     * - minInclusive: -2147483648
     * - minOccurs: 0
     * - nillable: true
     * @var int|null
     */
    protected ?int $cmc_rank = null;
    /**
     * The cmc_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cmc_entity_key = null;
    /**
     * The cmc_funded_flag
     * Meta information extracted from the WSDL
     * - documentation: Funded. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmc_funded_flag = null;
    /**
     * The cmc_status_date
     * Meta information extracted from the WSDL
     * - documentation: Status Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmc_status_date = null;
    /**
     * The cmc_cop_key
     * Meta information extracted from the WSDL
     * - documentation: Position. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cmc_cop_key = null;
    /**
     * The cmc_nom_key
     * Meta information extracted from the WSDL
     * - documentation: Nomination. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cmc_nom_key = null;
    /**
     * The cmc_renewable_flag
     * Meta information extracted from the WSDL
     * - documentation: Renewable. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmc_renewable_flag = null;
    /**
     * The cmc_csu_key
     * Meta information extracted from the WSDL
     * - documentation: Assignment Subject. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cmc_csu_key = null;
    /**
     * Constructor method for Committee_Committee_Participant_DataObjectType
     * @uses Committee_Committee_Participant_DataObjectType::setCmc_key()
     * @uses Committee_Committee_Participant_DataObjectType::setCmc_start_date()
     * @uses Committee_Committee_Participant_DataObjectType::setCmc_end_date()
     * @uses Committee_Committee_Participant_DataObjectType::setCmc_cst_key()
     * @uses Committee_Committee_Participant_DataObjectType::setCmc_add_date()
     * @uses Committee_Committee_Participant_DataObjectType::setCmc_add_user()
     * @uses Committee_Committee_Participant_DataObjectType::setCmc_change_date()
     * @uses Committee_Committee_Participant_DataObjectType::setCmc_change_user()
     * @uses Committee_Committee_Participant_DataObjectType::setCmc_delete_flag()
     * @uses Committee_Committee_Participant_DataObjectType::setCmc_key_ext()
     * @uses Committee_Committee_Participant_DataObjectType::setCmc_status()
     * @uses Committee_Committee_Participant_DataObjectType::setCmc_cmt_key()
     * @uses Committee_Committee_Participant_DataObjectType::setCmc_voting_flag()
     * @uses Committee_Committee_Participant_DataObjectType::setCmc_cxa_key()
     * @uses Committee_Committee_Participant_DataObjectType::setCmc_cph_key()
     * @uses Committee_Committee_Participant_DataObjectType::setCmc_eml_key()
     * @uses Committee_Committee_Participant_DataObjectType::setCmc_cfx_key()
     * @uses Committee_Committee_Participant_DataObjectType::setCmc_url_key()
     * @uses Committee_Committee_Participant_DataObjectType::setCmc_pref_comm_meth()
     * @uses Committee_Committee_Participant_DataObjectType::setCmc_rank()
     * @uses Committee_Committee_Participant_DataObjectType::setCmc_entity_key()
     * @uses Committee_Committee_Participant_DataObjectType::setCmc_funded_flag()
     * @uses Committee_Committee_Participant_DataObjectType::setCmc_status_date()
     * @uses Committee_Committee_Participant_DataObjectType::setCmc_cop_key()
     * @uses Committee_Committee_Participant_DataObjectType::setCmc_nom_key()
     * @uses Committee_Committee_Participant_DataObjectType::setCmc_renewable_flag()
     * @uses Committee_Committee_Participant_DataObjectType::setCmc_csu_key()
     * @param string $cmc_key
     * @param string $cmc_start_date
     * @param string $cmc_end_date
     * @param string $cmc_cst_key
     * @param string $cmc_add_date
     * @param string $cmc_add_user
     * @param string $cmc_change_date
     * @param string $cmc_change_user
     * @param string $cmc_delete_flag
     * @param string $cmc_key_ext
     * @param string $cmc_status
     * @param string $cmc_cmt_key
     * @param string $cmc_voting_flag
     * @param string $cmc_cxa_key
     * @param string $cmc_cph_key
     * @param string $cmc_eml_key
     * @param string $cmc_cfx_key
     * @param string $cmc_url_key
     * @param string $cmc_pref_comm_meth
     * @param int $cmc_rank
     * @param string $cmc_entity_key
     * @param string $cmc_funded_flag
     * @param string $cmc_status_date
     * @param string $cmc_cop_key
     * @param string $cmc_nom_key
     * @param string $cmc_renewable_flag
     * @param string $cmc_csu_key
     */
    public function __construct(?string $cmc_key = null, ?string $cmc_start_date = null, ?string $cmc_end_date = null, ?string $cmc_cst_key = null, ?string $cmc_add_date = null, ?string $cmc_add_user = null, ?string $cmc_change_date = null, ?string $cmc_change_user = null, ?string $cmc_delete_flag = null, ?string $cmc_key_ext = null, ?string $cmc_status = null, ?string $cmc_cmt_key = null, ?string $cmc_voting_flag = null, ?string $cmc_cxa_key = null, ?string $cmc_cph_key = null, ?string $cmc_eml_key = null, ?string $cmc_cfx_key = null, ?string $cmc_url_key = null, ?string $cmc_pref_comm_meth = null, ?int $cmc_rank = null, ?string $cmc_entity_key = null, ?string $cmc_funded_flag = null, ?string $cmc_status_date = null, ?string $cmc_cop_key = null, ?string $cmc_nom_key = null, ?string $cmc_renewable_flag = null, ?string $cmc_csu_key = null)
    {
        $this
            ->setCmc_key($cmc_key)
            ->setCmc_start_date($cmc_start_date)
            ->setCmc_end_date($cmc_end_date)
            ->setCmc_cst_key($cmc_cst_key)
            ->setCmc_add_date($cmc_add_date)
            ->setCmc_add_user($cmc_add_user)
            ->setCmc_change_date($cmc_change_date)
            ->setCmc_change_user($cmc_change_user)
            ->setCmc_delete_flag($cmc_delete_flag)
            ->setCmc_key_ext($cmc_key_ext)
            ->setCmc_status($cmc_status)
            ->setCmc_cmt_key($cmc_cmt_key)
            ->setCmc_voting_flag($cmc_voting_flag)
            ->setCmc_cxa_key($cmc_cxa_key)
            ->setCmc_cph_key($cmc_cph_key)
            ->setCmc_eml_key($cmc_eml_key)
            ->setCmc_cfx_key($cmc_cfx_key)
            ->setCmc_url_key($cmc_url_key)
            ->setCmc_pref_comm_meth($cmc_pref_comm_meth)
            ->setCmc_rank($cmc_rank)
            ->setCmc_entity_key($cmc_entity_key)
            ->setCmc_funded_flag($cmc_funded_flag)
            ->setCmc_status_date($cmc_status_date)
            ->setCmc_cop_key($cmc_cop_key)
            ->setCmc_nom_key($cmc_nom_key)
            ->setCmc_renewable_flag($cmc_renewable_flag)
            ->setCmc_csu_key($cmc_csu_key);
    }
    /**
     * Get cmc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmc_key(): ?string
    {
        return $this->cmc_key ?? null;
    }
    /**
     * Set cmc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_Participant_DataObjectType
     */
    public function setCmc_key(?string $cmc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cmc_key) && !is_string($cmc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmc_key, true), gettype($cmc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cmc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cmc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cmc_key, true)), __LINE__);
        }
        if (is_null($cmc_key) || (is_array($cmc_key) && empty($cmc_key))) {
            unset($this->cmc_key);
        } else {
            $this->cmc_key = $cmc_key;
        }
        
        return $this;
    }
    /**
     * Get cmc_start_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmc_start_date(): ?string
    {
        return $this->cmc_start_date ?? null;
    }
    /**
     * Set cmc_start_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmc_start_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_Participant_DataObjectType
     */
    public function setCmc_start_date(?string $cmc_start_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cmc_start_date) && !is_string($cmc_start_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmc_start_date, true), gettype($cmc_start_date)), __LINE__);
        }
        if (is_null($cmc_start_date) || (is_array($cmc_start_date) && empty($cmc_start_date))) {
            unset($this->cmc_start_date);
        } else {
            $this->cmc_start_date = $cmc_start_date;
        }
        
        return $this;
    }
    /**
     * Get cmc_end_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmc_end_date(): ?string
    {
        return $this->cmc_end_date ?? null;
    }
    /**
     * Set cmc_end_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmc_end_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_Participant_DataObjectType
     */
    public function setCmc_end_date(?string $cmc_end_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cmc_end_date) && !is_string($cmc_end_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmc_end_date, true), gettype($cmc_end_date)), __LINE__);
        }
        if (is_null($cmc_end_date) || (is_array($cmc_end_date) && empty($cmc_end_date))) {
            unset($this->cmc_end_date);
        } else {
            $this->cmc_end_date = $cmc_end_date;
        }
        
        return $this;
    }
    /**
     * Get cmc_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmc_cst_key(): ?string
    {
        return $this->cmc_cst_key ?? null;
    }
    /**
     * Set cmc_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmc_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_Participant_DataObjectType
     */
    public function setCmc_cst_key(?string $cmc_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cmc_cst_key) && !is_string($cmc_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmc_cst_key, true), gettype($cmc_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cmc_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cmc_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cmc_cst_key, true)), __LINE__);
        }
        if (is_null($cmc_cst_key) || (is_array($cmc_cst_key) && empty($cmc_cst_key))) {
            unset($this->cmc_cst_key);
        } else {
            $this->cmc_cst_key = $cmc_cst_key;
        }
        
        return $this;
    }
    /**
     * Get cmc_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmc_add_date(): ?string
    {
        return $this->cmc_add_date ?? null;
    }
    /**
     * Set cmc_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmc_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_Participant_DataObjectType
     */
    public function setCmc_add_date(?string $cmc_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cmc_add_date) && !is_string($cmc_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmc_add_date, true), gettype($cmc_add_date)), __LINE__);
        }
        if (is_null($cmc_add_date) || (is_array($cmc_add_date) && empty($cmc_add_date))) {
            unset($this->cmc_add_date);
        } else {
            $this->cmc_add_date = $cmc_add_date;
        }
        
        return $this;
    }
    /**
     * Get cmc_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmc_add_user(): ?string
    {
        return $this->cmc_add_user ?? null;
    }
    /**
     * Set cmc_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmc_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_Participant_DataObjectType
     */
    public function setCmc_add_user(?string $cmc_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cmc_add_user) && !is_string($cmc_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmc_add_user, true), gettype($cmc_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cmc_add_user) && mb_strlen((string) $cmc_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cmc_add_user)), __LINE__);
        }
        if (is_null($cmc_add_user) || (is_array($cmc_add_user) && empty($cmc_add_user))) {
            unset($this->cmc_add_user);
        } else {
            $this->cmc_add_user = $cmc_add_user;
        }
        
        return $this;
    }
    /**
     * Get cmc_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmc_change_date(): ?string
    {
        return $this->cmc_change_date ?? null;
    }
    /**
     * Set cmc_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmc_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_Participant_DataObjectType
     */
    public function setCmc_change_date(?string $cmc_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cmc_change_date) && !is_string($cmc_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmc_change_date, true), gettype($cmc_change_date)), __LINE__);
        }
        if (is_null($cmc_change_date) || (is_array($cmc_change_date) && empty($cmc_change_date))) {
            unset($this->cmc_change_date);
        } else {
            $this->cmc_change_date = $cmc_change_date;
        }
        
        return $this;
    }
    /**
     * Get cmc_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmc_change_user(): ?string
    {
        return $this->cmc_change_user ?? null;
    }
    /**
     * Set cmc_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmc_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_Participant_DataObjectType
     */
    public function setCmc_change_user(?string $cmc_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cmc_change_user) && !is_string($cmc_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmc_change_user, true), gettype($cmc_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cmc_change_user) && mb_strlen((string) $cmc_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cmc_change_user)), __LINE__);
        }
        if (is_null($cmc_change_user) || (is_array($cmc_change_user) && empty($cmc_change_user))) {
            unset($this->cmc_change_user);
        } else {
            $this->cmc_change_user = $cmc_change_user;
        }
        
        return $this;
    }
    /**
     * Get cmc_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmc_delete_flag(): ?string
    {
        return $this->cmc_delete_flag ?? null;
    }
    /**
     * Set cmc_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmc_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_Participant_DataObjectType
     */
    public function setCmc_delete_flag(?string $cmc_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cmc_delete_flag) && !is_string($cmc_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmc_delete_flag, true), gettype($cmc_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cmc_delete_flag) && $cmc_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cmc_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cmc_delete_flag) && $cmc_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cmc_delete_flag, true)), __LINE__);
        }
        if (is_null($cmc_delete_flag) || (is_array($cmc_delete_flag) && empty($cmc_delete_flag))) {
            unset($this->cmc_delete_flag);
        } else {
            $this->cmc_delete_flag = $cmc_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get cmc_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmc_key_ext(): ?string
    {
        return $this->cmc_key_ext ?? null;
    }
    /**
     * Set cmc_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmc_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_Participant_DataObjectType
     */
    public function setCmc_key_ext(?string $cmc_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($cmc_key_ext) && !is_string($cmc_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmc_key_ext, true), gettype($cmc_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cmc_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cmc_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cmc_key_ext, true)), __LINE__);
        }
        if (is_null($cmc_key_ext) || (is_array($cmc_key_ext) && empty($cmc_key_ext))) {
            unset($this->cmc_key_ext);
        } else {
            $this->cmc_key_ext = $cmc_key_ext;
        }
        
        return $this;
    }
    /**
     * Get cmc_status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmc_status(): ?string
    {
        return $this->cmc_status ?? null;
    }
    /**
     * Set cmc_status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmc_status
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_Participant_DataObjectType
     */
    public function setCmc_status(?string $cmc_status = null): self
    {
        // validation for constraint: string
        if (!is_null($cmc_status) && !is_string($cmc_status)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmc_status, true), gettype($cmc_status)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($cmc_status) && mb_strlen((string) $cmc_status) > 20) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen((string) $cmc_status)), __LINE__);
        }
        if (is_null($cmc_status) || (is_array($cmc_status) && empty($cmc_status))) {
            unset($this->cmc_status);
        } else {
            $this->cmc_status = $cmc_status;
        }
        
        return $this;
    }
    /**
     * Get cmc_cmt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmc_cmt_key(): ?string
    {
        return $this->cmc_cmt_key ?? null;
    }
    /**
     * Set cmc_cmt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmc_cmt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_Participant_DataObjectType
     */
    public function setCmc_cmt_key(?string $cmc_cmt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cmc_cmt_key) && !is_string($cmc_cmt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmc_cmt_key, true), gettype($cmc_cmt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cmc_cmt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cmc_cmt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cmc_cmt_key, true)), __LINE__);
        }
        if (is_null($cmc_cmt_key) || (is_array($cmc_cmt_key) && empty($cmc_cmt_key))) {
            unset($this->cmc_cmt_key);
        } else {
            $this->cmc_cmt_key = $cmc_cmt_key;
        }
        
        return $this;
    }
    /**
     * Get cmc_voting_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmc_voting_flag(): ?string
    {
        return $this->cmc_voting_flag ?? null;
    }
    /**
     * Set cmc_voting_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmc_voting_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_Participant_DataObjectType
     */
    public function setCmc_voting_flag(?string $cmc_voting_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cmc_voting_flag) && !is_string($cmc_voting_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmc_voting_flag, true), gettype($cmc_voting_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cmc_voting_flag) && $cmc_voting_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cmc_voting_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cmc_voting_flag) && $cmc_voting_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cmc_voting_flag, true)), __LINE__);
        }
        if (is_null($cmc_voting_flag) || (is_array($cmc_voting_flag) && empty($cmc_voting_flag))) {
            unset($this->cmc_voting_flag);
        } else {
            $this->cmc_voting_flag = $cmc_voting_flag;
        }
        
        return $this;
    }
    /**
     * Get cmc_cxa_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmc_cxa_key(): ?string
    {
        return $this->cmc_cxa_key ?? null;
    }
    /**
     * Set cmc_cxa_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmc_cxa_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_Participant_DataObjectType
     */
    public function setCmc_cxa_key(?string $cmc_cxa_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cmc_cxa_key) && !is_string($cmc_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmc_cxa_key, true), gettype($cmc_cxa_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cmc_cxa_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cmc_cxa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cmc_cxa_key, true)), __LINE__);
        }
        if (is_null($cmc_cxa_key) || (is_array($cmc_cxa_key) && empty($cmc_cxa_key))) {
            unset($this->cmc_cxa_key);
        } else {
            $this->cmc_cxa_key = $cmc_cxa_key;
        }
        
        return $this;
    }
    /**
     * Get cmc_cph_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmc_cph_key(): ?string
    {
        return $this->cmc_cph_key ?? null;
    }
    /**
     * Set cmc_cph_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmc_cph_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_Participant_DataObjectType
     */
    public function setCmc_cph_key(?string $cmc_cph_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cmc_cph_key) && !is_string($cmc_cph_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmc_cph_key, true), gettype($cmc_cph_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cmc_cph_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cmc_cph_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cmc_cph_key, true)), __LINE__);
        }
        if (is_null($cmc_cph_key) || (is_array($cmc_cph_key) && empty($cmc_cph_key))) {
            unset($this->cmc_cph_key);
        } else {
            $this->cmc_cph_key = $cmc_cph_key;
        }
        
        return $this;
    }
    /**
     * Get cmc_eml_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmc_eml_key(): ?string
    {
        return $this->cmc_eml_key ?? null;
    }
    /**
     * Set cmc_eml_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmc_eml_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_Participant_DataObjectType
     */
    public function setCmc_eml_key(?string $cmc_eml_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cmc_eml_key) && !is_string($cmc_eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmc_eml_key, true), gettype($cmc_eml_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cmc_eml_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cmc_eml_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cmc_eml_key, true)), __LINE__);
        }
        if (is_null($cmc_eml_key) || (is_array($cmc_eml_key) && empty($cmc_eml_key))) {
            unset($this->cmc_eml_key);
        } else {
            $this->cmc_eml_key = $cmc_eml_key;
        }
        
        return $this;
    }
    /**
     * Get cmc_cfx_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmc_cfx_key(): ?string
    {
        return $this->cmc_cfx_key ?? null;
    }
    /**
     * Set cmc_cfx_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmc_cfx_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_Participant_DataObjectType
     */
    public function setCmc_cfx_key(?string $cmc_cfx_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cmc_cfx_key) && !is_string($cmc_cfx_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmc_cfx_key, true), gettype($cmc_cfx_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cmc_cfx_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cmc_cfx_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cmc_cfx_key, true)), __LINE__);
        }
        if (is_null($cmc_cfx_key) || (is_array($cmc_cfx_key) && empty($cmc_cfx_key))) {
            unset($this->cmc_cfx_key);
        } else {
            $this->cmc_cfx_key = $cmc_cfx_key;
        }
        
        return $this;
    }
    /**
     * Get cmc_url_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmc_url_key(): ?string
    {
        return $this->cmc_url_key ?? null;
    }
    /**
     * Set cmc_url_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmc_url_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_Participant_DataObjectType
     */
    public function setCmc_url_key(?string $cmc_url_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cmc_url_key) && !is_string($cmc_url_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmc_url_key, true), gettype($cmc_url_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cmc_url_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cmc_url_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cmc_url_key, true)), __LINE__);
        }
        if (is_null($cmc_url_key) || (is_array($cmc_url_key) && empty($cmc_url_key))) {
            unset($this->cmc_url_key);
        } else {
            $this->cmc_url_key = $cmc_url_key;
        }
        
        return $this;
    }
    /**
     * Get cmc_pref_comm_meth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmc_pref_comm_meth(): ?string
    {
        return $this->cmc_pref_comm_meth ?? null;
    }
    /**
     * Set cmc_pref_comm_meth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmc_pref_comm_meth
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_Participant_DataObjectType
     */
    public function setCmc_pref_comm_meth(?string $cmc_pref_comm_meth = null): self
    {
        // validation for constraint: string
        if (!is_null($cmc_pref_comm_meth) && !is_string($cmc_pref_comm_meth)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmc_pref_comm_meth, true), gettype($cmc_pref_comm_meth)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($cmc_pref_comm_meth) && mb_strlen((string) $cmc_pref_comm_meth) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $cmc_pref_comm_meth)), __LINE__);
        }
        if (is_null($cmc_pref_comm_meth) || (is_array($cmc_pref_comm_meth) && empty($cmc_pref_comm_meth))) {
            unset($this->cmc_pref_comm_meth);
        } else {
            $this->cmc_pref_comm_meth = $cmc_pref_comm_meth;
        }
        
        return $this;
    }
    /**
     * Get cmc_rank value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCmc_rank(): ?int
    {
        return $this->cmc_rank ?? null;
    }
    /**
     * Set cmc_rank value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cmc_rank
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_Participant_DataObjectType
     */
    public function setCmc_rank(?int $cmc_rank = null): self
    {
        // validation for constraint: int
        if (!is_null($cmc_rank) && !(is_int($cmc_rank) || ctype_digit($cmc_rank))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cmc_rank, true), gettype($cmc_rank)), __LINE__);
        }
        // validation for constraint: maxInclusive(2147483647)
        if (!is_null($cmc_rank) && $cmc_rank > 2147483647) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2147483647', var_export($cmc_rank, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-2147483648)
        if (!is_null($cmc_rank) && $cmc_rank < -2147483648) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -2147483648', var_export($cmc_rank, true)), __LINE__);
        }
        if (is_null($cmc_rank) || (is_array($cmc_rank) && empty($cmc_rank))) {
            unset($this->cmc_rank);
        } else {
            $this->cmc_rank = $cmc_rank;
        }
        
        return $this;
    }
    /**
     * Get cmc_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmc_entity_key(): ?string
    {
        return $this->cmc_entity_key ?? null;
    }
    /**
     * Set cmc_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmc_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_Participant_DataObjectType
     */
    public function setCmc_entity_key(?string $cmc_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cmc_entity_key) && !is_string($cmc_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmc_entity_key, true), gettype($cmc_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cmc_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cmc_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cmc_entity_key, true)), __LINE__);
        }
        if (is_null($cmc_entity_key) || (is_array($cmc_entity_key) && empty($cmc_entity_key))) {
            unset($this->cmc_entity_key);
        } else {
            $this->cmc_entity_key = $cmc_entity_key;
        }
        
        return $this;
    }
    /**
     * Get cmc_funded_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmc_funded_flag(): ?string
    {
        return $this->cmc_funded_flag ?? null;
    }
    /**
     * Set cmc_funded_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmc_funded_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_Participant_DataObjectType
     */
    public function setCmc_funded_flag(?string $cmc_funded_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cmc_funded_flag) && !is_string($cmc_funded_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmc_funded_flag, true), gettype($cmc_funded_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cmc_funded_flag) && $cmc_funded_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cmc_funded_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cmc_funded_flag) && $cmc_funded_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cmc_funded_flag, true)), __LINE__);
        }
        if (is_null($cmc_funded_flag) || (is_array($cmc_funded_flag) && empty($cmc_funded_flag))) {
            unset($this->cmc_funded_flag);
        } else {
            $this->cmc_funded_flag = $cmc_funded_flag;
        }
        
        return $this;
    }
    /**
     * Get cmc_status_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmc_status_date(): ?string
    {
        return $this->cmc_status_date ?? null;
    }
    /**
     * Set cmc_status_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmc_status_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_Participant_DataObjectType
     */
    public function setCmc_status_date(?string $cmc_status_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cmc_status_date) && !is_string($cmc_status_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmc_status_date, true), gettype($cmc_status_date)), __LINE__);
        }
        if (is_null($cmc_status_date) || (is_array($cmc_status_date) && empty($cmc_status_date))) {
            unset($this->cmc_status_date);
        } else {
            $this->cmc_status_date = $cmc_status_date;
        }
        
        return $this;
    }
    /**
     * Get cmc_cop_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmc_cop_key(): ?string
    {
        return $this->cmc_cop_key ?? null;
    }
    /**
     * Set cmc_cop_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmc_cop_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_Participant_DataObjectType
     */
    public function setCmc_cop_key(?string $cmc_cop_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cmc_cop_key) && !is_string($cmc_cop_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmc_cop_key, true), gettype($cmc_cop_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cmc_cop_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cmc_cop_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cmc_cop_key, true)), __LINE__);
        }
        if (is_null($cmc_cop_key) || (is_array($cmc_cop_key) && empty($cmc_cop_key))) {
            unset($this->cmc_cop_key);
        } else {
            $this->cmc_cop_key = $cmc_cop_key;
        }
        
        return $this;
    }
    /**
     * Get cmc_nom_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmc_nom_key(): ?string
    {
        return $this->cmc_nom_key ?? null;
    }
    /**
     * Set cmc_nom_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmc_nom_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_Participant_DataObjectType
     */
    public function setCmc_nom_key(?string $cmc_nom_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cmc_nom_key) && !is_string($cmc_nom_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmc_nom_key, true), gettype($cmc_nom_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cmc_nom_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cmc_nom_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cmc_nom_key, true)), __LINE__);
        }
        if (is_null($cmc_nom_key) || (is_array($cmc_nom_key) && empty($cmc_nom_key))) {
            unset($this->cmc_nom_key);
        } else {
            $this->cmc_nom_key = $cmc_nom_key;
        }
        
        return $this;
    }
    /**
     * Get cmc_renewable_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmc_renewable_flag(): ?string
    {
        return $this->cmc_renewable_flag ?? null;
    }
    /**
     * Set cmc_renewable_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmc_renewable_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_Participant_DataObjectType
     */
    public function setCmc_renewable_flag(?string $cmc_renewable_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cmc_renewable_flag) && !is_string($cmc_renewable_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmc_renewable_flag, true), gettype($cmc_renewable_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cmc_renewable_flag) && $cmc_renewable_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cmc_renewable_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cmc_renewable_flag) && $cmc_renewable_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cmc_renewable_flag, true)), __LINE__);
        }
        if (is_null($cmc_renewable_flag) || (is_array($cmc_renewable_flag) && empty($cmc_renewable_flag))) {
            unset($this->cmc_renewable_flag);
        } else {
            $this->cmc_renewable_flag = $cmc_renewable_flag;
        }
        
        return $this;
    }
    /**
     * Get cmc_csu_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmc_csu_key(): ?string
    {
        return $this->cmc_csu_key ?? null;
    }
    /**
     * Set cmc_csu_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmc_csu_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Committee_Participant_DataObjectType
     */
    public function setCmc_csu_key(?string $cmc_csu_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cmc_csu_key) && !is_string($cmc_csu_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmc_csu_key, true), gettype($cmc_csu_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cmc_csu_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cmc_csu_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cmc_csu_key, true)), __LINE__);
        }
        if (is_null($cmc_csu_key) || (is_array($cmc_csu_key) && empty($cmc_csu_key))) {
            unset($this->cmc_csu_key);
        } else {
            $this->cmc_csu_key = $cmc_csu_key;
        }
        
        return $this;
    }
}
