<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Committee_Parent_Committee_DataObjectType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class Committee_Parent_Committee_DataObjectType extends AbstractStructBase
{
    /**
     * The cmp__cmt_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cmp__cmt_key = null;
    /**
     * The cmp__cmt_asn_code
     * Meta information extracted from the WSDL
     * - documentation: Association. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmp__cmt_asn_code = null;
    /**
     * The cmp__cmt_code
     * Meta information extracted from the WSDL
     * - documentation: Committee Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmp__cmt_code = null;
    /**
     * The cmp__cmt_ctp_code
     * Meta information extracted from the WSDL
     * - documentation: Type Code. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmp__cmt_ctp_code = null;
    /**
     * The cmp__cmt_name
     * Meta information extracted from the WSDL
     * - documentation: Committee Name. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmp__cmt_name = null;
    /**
     * The cmp__cmt_begin_date
     * Meta information extracted from the WSDL
     * - documentation: Begin Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmp__cmt_begin_date = null;
    /**
     * The cmp__cmt_end_date
     * Meta information extracted from the WSDL
     * - documentation: End Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmp__cmt_end_date = null;
    /**
     * The cmp__cmt_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmp__cmt_add_date = null;
    /**
     * The cmp__cmt_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmp__cmt_add_user = null;
    /**
     * The cmp__cmt_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. This field has this Input Mask: 99/99/9999. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmp__cmt_change_date = null;
    /**
     * The cmp__cmt_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmp__cmt_change_user = null;
    /**
     * The cmp__cmt_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmp__cmt_delete_flag = null;
    /**
     * The cmp__cmt_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cmp__cmt_key_ext = null;
    /**
     * The cmp__cmt_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cmp__cmt_entity_key = null;
    /**
     * The cmp__cmt_parent_key
     * Meta information extracted from the WSDL
     * - documentation: Parent Committee. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cmp__cmt_parent_key = null;
    /**
     * The cmp__cmt_description
     * Meta information extracted from the WSDL
     * - documentation: Description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmp__cmt_description = null;
    /**
     * The cmp__cmt_html_description
     * Meta information extracted from the WSDL
     * - documentation: html description. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmp__cmt_html_description = null;
    /**
     * The cmp__cmt_region
     * Meta information extracted from the WSDL
     * - documentation: Region. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $cmp__cmt_region = null;
    /**
     * The cmp__cmt_cst_key
     * Meta information extracted from the WSDL
     * - documentation: Customer Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $cmp__cmt_cst_key = null;
    /**
     * Constructor method for Committee_Parent_Committee_DataObjectType
     * @uses Committee_Parent_Committee_DataObjectType::setCmp__cmt_key()
     * @uses Committee_Parent_Committee_DataObjectType::setCmp__cmt_asn_code()
     * @uses Committee_Parent_Committee_DataObjectType::setCmp__cmt_code()
     * @uses Committee_Parent_Committee_DataObjectType::setCmp__cmt_ctp_code()
     * @uses Committee_Parent_Committee_DataObjectType::setCmp__cmt_name()
     * @uses Committee_Parent_Committee_DataObjectType::setCmp__cmt_begin_date()
     * @uses Committee_Parent_Committee_DataObjectType::setCmp__cmt_end_date()
     * @uses Committee_Parent_Committee_DataObjectType::setCmp__cmt_add_date()
     * @uses Committee_Parent_Committee_DataObjectType::setCmp__cmt_add_user()
     * @uses Committee_Parent_Committee_DataObjectType::setCmp__cmt_change_date()
     * @uses Committee_Parent_Committee_DataObjectType::setCmp__cmt_change_user()
     * @uses Committee_Parent_Committee_DataObjectType::setCmp__cmt_delete_flag()
     * @uses Committee_Parent_Committee_DataObjectType::setCmp__cmt_key_ext()
     * @uses Committee_Parent_Committee_DataObjectType::setCmp__cmt_entity_key()
     * @uses Committee_Parent_Committee_DataObjectType::setCmp__cmt_parent_key()
     * @uses Committee_Parent_Committee_DataObjectType::setCmp__cmt_description()
     * @uses Committee_Parent_Committee_DataObjectType::setCmp__cmt_html_description()
     * @uses Committee_Parent_Committee_DataObjectType::setCmp__cmt_region()
     * @uses Committee_Parent_Committee_DataObjectType::setCmp__cmt_cst_key()
     * @param string $cmp__cmt_key
     * @param string $cmp__cmt_asn_code
     * @param string $cmp__cmt_code
     * @param string $cmp__cmt_ctp_code
     * @param string $cmp__cmt_name
     * @param string $cmp__cmt_begin_date
     * @param string $cmp__cmt_end_date
     * @param string $cmp__cmt_add_date
     * @param string $cmp__cmt_add_user
     * @param string $cmp__cmt_change_date
     * @param string $cmp__cmt_change_user
     * @param string $cmp__cmt_delete_flag
     * @param string $cmp__cmt_key_ext
     * @param string $cmp__cmt_entity_key
     * @param string $cmp__cmt_parent_key
     * @param string $cmp__cmt_description
     * @param string $cmp__cmt_html_description
     * @param string $cmp__cmt_region
     * @param string $cmp__cmt_cst_key
     */
    public function __construct(?string $cmp__cmt_key = null, ?string $cmp__cmt_asn_code = null, ?string $cmp__cmt_code = null, ?string $cmp__cmt_ctp_code = null, ?string $cmp__cmt_name = null, ?string $cmp__cmt_begin_date = null, ?string $cmp__cmt_end_date = null, ?string $cmp__cmt_add_date = null, ?string $cmp__cmt_add_user = null, ?string $cmp__cmt_change_date = null, ?string $cmp__cmt_change_user = null, ?string $cmp__cmt_delete_flag = null, ?string $cmp__cmt_key_ext = null, ?string $cmp__cmt_entity_key = null, ?string $cmp__cmt_parent_key = null, ?string $cmp__cmt_description = null, ?string $cmp__cmt_html_description = null, ?string $cmp__cmt_region = null, ?string $cmp__cmt_cst_key = null)
    {
        $this
            ->setCmp__cmt_key($cmp__cmt_key)
            ->setCmp__cmt_asn_code($cmp__cmt_asn_code)
            ->setCmp__cmt_code($cmp__cmt_code)
            ->setCmp__cmt_ctp_code($cmp__cmt_ctp_code)
            ->setCmp__cmt_name($cmp__cmt_name)
            ->setCmp__cmt_begin_date($cmp__cmt_begin_date)
            ->setCmp__cmt_end_date($cmp__cmt_end_date)
            ->setCmp__cmt_add_date($cmp__cmt_add_date)
            ->setCmp__cmt_add_user($cmp__cmt_add_user)
            ->setCmp__cmt_change_date($cmp__cmt_change_date)
            ->setCmp__cmt_change_user($cmp__cmt_change_user)
            ->setCmp__cmt_delete_flag($cmp__cmt_delete_flag)
            ->setCmp__cmt_key_ext($cmp__cmt_key_ext)
            ->setCmp__cmt_entity_key($cmp__cmt_entity_key)
            ->setCmp__cmt_parent_key($cmp__cmt_parent_key)
            ->setCmp__cmt_description($cmp__cmt_description)
            ->setCmp__cmt_html_description($cmp__cmt_html_description)
            ->setCmp__cmt_region($cmp__cmt_region)
            ->setCmp__cmt_cst_key($cmp__cmt_cst_key);
    }
    /**
     * Get cmp__cmt_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmp__cmt_key(): ?string
    {
        return $this->cmp__cmt_key ?? null;
    }
    /**
     * Set cmp__cmt_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmp__cmt_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Parent_Committee_DataObjectType
     */
    public function setCmp__cmt_key(?string $cmp__cmt_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cmp__cmt_key) && !is_string($cmp__cmt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmp__cmt_key, true), gettype($cmp__cmt_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cmp__cmt_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cmp__cmt_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cmp__cmt_key, true)), __LINE__);
        }
        if (is_null($cmp__cmt_key) || (is_array($cmp__cmt_key) && empty($cmp__cmt_key))) {
            unset($this->cmp__cmt_key);
        } else {
            $this->cmp__cmt_key = $cmp__cmt_key;
        }
        
        return $this;
    }
    /**
     * Get cmp__cmt_asn_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmp__cmt_asn_code(): ?string
    {
        return $this->cmp__cmt_asn_code ?? null;
    }
    /**
     * Set cmp__cmt_asn_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmp__cmt_asn_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Parent_Committee_DataObjectType
     */
    public function setCmp__cmt_asn_code(?string $cmp__cmt_asn_code = null): self
    {
        // validation for constraint: string
        if (!is_null($cmp__cmt_asn_code) && !is_string($cmp__cmt_asn_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmp__cmt_asn_code, true), gettype($cmp__cmt_asn_code)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($cmp__cmt_asn_code) && mb_strlen((string) $cmp__cmt_asn_code) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $cmp__cmt_asn_code)), __LINE__);
        }
        if (is_null($cmp__cmt_asn_code) || (is_array($cmp__cmt_asn_code) && empty($cmp__cmt_asn_code))) {
            unset($this->cmp__cmt_asn_code);
        } else {
            $this->cmp__cmt_asn_code = $cmp__cmt_asn_code;
        }
        
        return $this;
    }
    /**
     * Get cmp__cmt_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmp__cmt_code(): ?string
    {
        return $this->cmp__cmt_code ?? null;
    }
    /**
     * Set cmp__cmt_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmp__cmt_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Parent_Committee_DataObjectType
     */
    public function setCmp__cmt_code(?string $cmp__cmt_code = null): self
    {
        // validation for constraint: string
        if (!is_null($cmp__cmt_code) && !is_string($cmp__cmt_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmp__cmt_code, true), gettype($cmp__cmt_code)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($cmp__cmt_code) && mb_strlen((string) $cmp__cmt_code) > 10) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen((string) $cmp__cmt_code)), __LINE__);
        }
        if (is_null($cmp__cmt_code) || (is_array($cmp__cmt_code) && empty($cmp__cmt_code))) {
            unset($this->cmp__cmt_code);
        } else {
            $this->cmp__cmt_code = $cmp__cmt_code;
        }
        
        return $this;
    }
    /**
     * Get cmp__cmt_ctp_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmp__cmt_ctp_code(): ?string
    {
        return $this->cmp__cmt_ctp_code ?? null;
    }
    /**
     * Set cmp__cmt_ctp_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmp__cmt_ctp_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Parent_Committee_DataObjectType
     */
    public function setCmp__cmt_ctp_code(?string $cmp__cmt_ctp_code = null): self
    {
        // validation for constraint: string
        if (!is_null($cmp__cmt_ctp_code) && !is_string($cmp__cmt_ctp_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmp__cmt_ctp_code, true), gettype($cmp__cmt_ctp_code)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($cmp__cmt_ctp_code) && mb_strlen((string) $cmp__cmt_ctp_code) > 30) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen((string) $cmp__cmt_ctp_code)), __LINE__);
        }
        if (is_null($cmp__cmt_ctp_code) || (is_array($cmp__cmt_ctp_code) && empty($cmp__cmt_ctp_code))) {
            unset($this->cmp__cmt_ctp_code);
        } else {
            $this->cmp__cmt_ctp_code = $cmp__cmt_ctp_code;
        }
        
        return $this;
    }
    /**
     * Get cmp__cmt_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmp__cmt_name(): ?string
    {
        return $this->cmp__cmt_name ?? null;
    }
    /**
     * Set cmp__cmt_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmp__cmt_name
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Parent_Committee_DataObjectType
     */
    public function setCmp__cmt_name(?string $cmp__cmt_name = null): self
    {
        // validation for constraint: string
        if (!is_null($cmp__cmt_name) && !is_string($cmp__cmt_name)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmp__cmt_name, true), gettype($cmp__cmt_name)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($cmp__cmt_name) && mb_strlen((string) $cmp__cmt_name) > 80) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen((string) $cmp__cmt_name)), __LINE__);
        }
        if (is_null($cmp__cmt_name) || (is_array($cmp__cmt_name) && empty($cmp__cmt_name))) {
            unset($this->cmp__cmt_name);
        } else {
            $this->cmp__cmt_name = $cmp__cmt_name;
        }
        
        return $this;
    }
    /**
     * Get cmp__cmt_begin_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmp__cmt_begin_date(): ?string
    {
        return $this->cmp__cmt_begin_date ?? null;
    }
    /**
     * Set cmp__cmt_begin_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmp__cmt_begin_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Parent_Committee_DataObjectType
     */
    public function setCmp__cmt_begin_date(?string $cmp__cmt_begin_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cmp__cmt_begin_date) && !is_string($cmp__cmt_begin_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmp__cmt_begin_date, true), gettype($cmp__cmt_begin_date)), __LINE__);
        }
        if (is_null($cmp__cmt_begin_date) || (is_array($cmp__cmt_begin_date) && empty($cmp__cmt_begin_date))) {
            unset($this->cmp__cmt_begin_date);
        } else {
            $this->cmp__cmt_begin_date = $cmp__cmt_begin_date;
        }
        
        return $this;
    }
    /**
     * Get cmp__cmt_end_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmp__cmt_end_date(): ?string
    {
        return $this->cmp__cmt_end_date ?? null;
    }
    /**
     * Set cmp__cmt_end_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmp__cmt_end_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Parent_Committee_DataObjectType
     */
    public function setCmp__cmt_end_date(?string $cmp__cmt_end_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cmp__cmt_end_date) && !is_string($cmp__cmt_end_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmp__cmt_end_date, true), gettype($cmp__cmt_end_date)), __LINE__);
        }
        if (is_null($cmp__cmt_end_date) || (is_array($cmp__cmt_end_date) && empty($cmp__cmt_end_date))) {
            unset($this->cmp__cmt_end_date);
        } else {
            $this->cmp__cmt_end_date = $cmp__cmt_end_date;
        }
        
        return $this;
    }
    /**
     * Get cmp__cmt_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmp__cmt_add_date(): ?string
    {
        return $this->cmp__cmt_add_date ?? null;
    }
    /**
     * Set cmp__cmt_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmp__cmt_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Parent_Committee_DataObjectType
     */
    public function setCmp__cmt_add_date(?string $cmp__cmt_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cmp__cmt_add_date) && !is_string($cmp__cmt_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmp__cmt_add_date, true), gettype($cmp__cmt_add_date)), __LINE__);
        }
        if (is_null($cmp__cmt_add_date) || (is_array($cmp__cmt_add_date) && empty($cmp__cmt_add_date))) {
            unset($this->cmp__cmt_add_date);
        } else {
            $this->cmp__cmt_add_date = $cmp__cmt_add_date;
        }
        
        return $this;
    }
    /**
     * Get cmp__cmt_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmp__cmt_add_user(): ?string
    {
        return $this->cmp__cmt_add_user ?? null;
    }
    /**
     * Set cmp__cmt_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmp__cmt_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Parent_Committee_DataObjectType
     */
    public function setCmp__cmt_add_user(?string $cmp__cmt_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cmp__cmt_add_user) && !is_string($cmp__cmt_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmp__cmt_add_user, true), gettype($cmp__cmt_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cmp__cmt_add_user) && mb_strlen((string) $cmp__cmt_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cmp__cmt_add_user)), __LINE__);
        }
        if (is_null($cmp__cmt_add_user) || (is_array($cmp__cmt_add_user) && empty($cmp__cmt_add_user))) {
            unset($this->cmp__cmt_add_user);
        } else {
            $this->cmp__cmt_add_user = $cmp__cmt_add_user;
        }
        
        return $this;
    }
    /**
     * Get cmp__cmt_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmp__cmt_change_date(): ?string
    {
        return $this->cmp__cmt_change_date ?? null;
    }
    /**
     * Set cmp__cmt_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmp__cmt_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Parent_Committee_DataObjectType
     */
    public function setCmp__cmt_change_date(?string $cmp__cmt_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($cmp__cmt_change_date) && !is_string($cmp__cmt_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmp__cmt_change_date, true), gettype($cmp__cmt_change_date)), __LINE__);
        }
        if (is_null($cmp__cmt_change_date) || (is_array($cmp__cmt_change_date) && empty($cmp__cmt_change_date))) {
            unset($this->cmp__cmt_change_date);
        } else {
            $this->cmp__cmt_change_date = $cmp__cmt_change_date;
        }
        
        return $this;
    }
    /**
     * Get cmp__cmt_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmp__cmt_change_user(): ?string
    {
        return $this->cmp__cmt_change_user ?? null;
    }
    /**
     * Set cmp__cmt_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmp__cmt_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Parent_Committee_DataObjectType
     */
    public function setCmp__cmt_change_user(?string $cmp__cmt_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($cmp__cmt_change_user) && !is_string($cmp__cmt_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmp__cmt_change_user, true), gettype($cmp__cmt_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cmp__cmt_change_user) && mb_strlen((string) $cmp__cmt_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $cmp__cmt_change_user)), __LINE__);
        }
        if (is_null($cmp__cmt_change_user) || (is_array($cmp__cmt_change_user) && empty($cmp__cmt_change_user))) {
            unset($this->cmp__cmt_change_user);
        } else {
            $this->cmp__cmt_change_user = $cmp__cmt_change_user;
        }
        
        return $this;
    }
    /**
     * Get cmp__cmt_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmp__cmt_delete_flag(): ?string
    {
        return $this->cmp__cmt_delete_flag ?? null;
    }
    /**
     * Set cmp__cmt_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmp__cmt_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Parent_Committee_DataObjectType
     */
    public function setCmp__cmt_delete_flag(?string $cmp__cmt_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($cmp__cmt_delete_flag) && !is_string($cmp__cmt_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmp__cmt_delete_flag, true), gettype($cmp__cmt_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($cmp__cmt_delete_flag) && $cmp__cmt_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($cmp__cmt_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cmp__cmt_delete_flag) && $cmp__cmt_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cmp__cmt_delete_flag, true)), __LINE__);
        }
        if (is_null($cmp__cmt_delete_flag) || (is_array($cmp__cmt_delete_flag) && empty($cmp__cmt_delete_flag))) {
            unset($this->cmp__cmt_delete_flag);
        } else {
            $this->cmp__cmt_delete_flag = $cmp__cmt_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get cmp__cmt_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmp__cmt_key_ext(): ?string
    {
        return $this->cmp__cmt_key_ext ?? null;
    }
    /**
     * Set cmp__cmt_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmp__cmt_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Parent_Committee_DataObjectType
     */
    public function setCmp__cmt_key_ext(?string $cmp__cmt_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($cmp__cmt_key_ext) && !is_string($cmp__cmt_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmp__cmt_key_ext, true), gettype($cmp__cmt_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cmp__cmt_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cmp__cmt_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cmp__cmt_key_ext, true)), __LINE__);
        }
        if (is_null($cmp__cmt_key_ext) || (is_array($cmp__cmt_key_ext) && empty($cmp__cmt_key_ext))) {
            unset($this->cmp__cmt_key_ext);
        } else {
            $this->cmp__cmt_key_ext = $cmp__cmt_key_ext;
        }
        
        return $this;
    }
    /**
     * Get cmp__cmt_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmp__cmt_entity_key(): ?string
    {
        return $this->cmp__cmt_entity_key ?? null;
    }
    /**
     * Set cmp__cmt_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmp__cmt_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Parent_Committee_DataObjectType
     */
    public function setCmp__cmt_entity_key(?string $cmp__cmt_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cmp__cmt_entity_key) && !is_string($cmp__cmt_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmp__cmt_entity_key, true), gettype($cmp__cmt_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cmp__cmt_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cmp__cmt_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cmp__cmt_entity_key, true)), __LINE__);
        }
        if (is_null($cmp__cmt_entity_key) || (is_array($cmp__cmt_entity_key) && empty($cmp__cmt_entity_key))) {
            unset($this->cmp__cmt_entity_key);
        } else {
            $this->cmp__cmt_entity_key = $cmp__cmt_entity_key;
        }
        
        return $this;
    }
    /**
     * Get cmp__cmt_parent_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmp__cmt_parent_key(): ?string
    {
        return $this->cmp__cmt_parent_key ?? null;
    }
    /**
     * Set cmp__cmt_parent_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmp__cmt_parent_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Parent_Committee_DataObjectType
     */
    public function setCmp__cmt_parent_key(?string $cmp__cmt_parent_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cmp__cmt_parent_key) && !is_string($cmp__cmt_parent_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmp__cmt_parent_key, true), gettype($cmp__cmt_parent_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cmp__cmt_parent_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cmp__cmt_parent_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cmp__cmt_parent_key, true)), __LINE__);
        }
        if (is_null($cmp__cmt_parent_key) || (is_array($cmp__cmt_parent_key) && empty($cmp__cmt_parent_key))) {
            unset($this->cmp__cmt_parent_key);
        } else {
            $this->cmp__cmt_parent_key = $cmp__cmt_parent_key;
        }
        
        return $this;
    }
    /**
     * Get cmp__cmt_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmp__cmt_description(): ?string
    {
        return $this->cmp__cmt_description ?? null;
    }
    /**
     * Set cmp__cmt_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmp__cmt_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Parent_Committee_DataObjectType
     */
    public function setCmp__cmt_description(?string $cmp__cmt_description = null): self
    {
        // validation for constraint: string
        if (!is_null($cmp__cmt_description) && !is_string($cmp__cmt_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmp__cmt_description, true), gettype($cmp__cmt_description)), __LINE__);
        }
        if (is_null($cmp__cmt_description) || (is_array($cmp__cmt_description) && empty($cmp__cmt_description))) {
            unset($this->cmp__cmt_description);
        } else {
            $this->cmp__cmt_description = $cmp__cmt_description;
        }
        
        return $this;
    }
    /**
     * Get cmp__cmt_html_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmp__cmt_html_description(): ?string
    {
        return $this->cmp__cmt_html_description ?? null;
    }
    /**
     * Set cmp__cmt_html_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmp__cmt_html_description
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Parent_Committee_DataObjectType
     */
    public function setCmp__cmt_html_description(?string $cmp__cmt_html_description = null): self
    {
        // validation for constraint: string
        if (!is_null($cmp__cmt_html_description) && !is_string($cmp__cmt_html_description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmp__cmt_html_description, true), gettype($cmp__cmt_html_description)), __LINE__);
        }
        if (is_null($cmp__cmt_html_description) || (is_array($cmp__cmt_html_description) && empty($cmp__cmt_html_description))) {
            unset($this->cmp__cmt_html_description);
        } else {
            $this->cmp__cmt_html_description = $cmp__cmt_html_description;
        }
        
        return $this;
    }
    /**
     * Get cmp__cmt_region value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmp__cmt_region(): ?string
    {
        return $this->cmp__cmt_region ?? null;
    }
    /**
     * Set cmp__cmt_region value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmp__cmt_region
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Parent_Committee_DataObjectType
     */
    public function setCmp__cmt_region(?string $cmp__cmt_region = null): self
    {
        // validation for constraint: string
        if (!is_null($cmp__cmt_region) && !is_string($cmp__cmt_region)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmp__cmt_region, true), gettype($cmp__cmt_region)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($cmp__cmt_region) && mb_strlen((string) $cmp__cmt_region) > 50) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen((string) $cmp__cmt_region)), __LINE__);
        }
        if (is_null($cmp__cmt_region) || (is_array($cmp__cmt_region) && empty($cmp__cmt_region))) {
            unset($this->cmp__cmt_region);
        } else {
            $this->cmp__cmt_region = $cmp__cmt_region;
        }
        
        return $this;
    }
    /**
     * Get cmp__cmt_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCmp__cmt_cst_key(): ?string
    {
        return $this->cmp__cmt_cst_key ?? null;
    }
    /**
     * Set cmp__cmt_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cmp__cmt_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\Committee_Parent_Committee_DataObjectType
     */
    public function setCmp__cmt_cst_key(?string $cmp__cmt_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($cmp__cmt_cst_key) && !is_string($cmp__cmt_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmp__cmt_cst_key, true), gettype($cmp__cmt_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($cmp__cmt_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $cmp__cmt_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($cmp__cmt_cst_key, true)), __LINE__);
        }
        if (is_null($cmp__cmt_cst_key) || (is_array($cmp__cmt_cst_key) && empty($cmp__cmt_cst_key))) {
            unset($this->cmp__cmt_cst_key);
        } else {
            $this->cmp__cmt_cst_key = $cmp__cmt_cst_key;
        }
        
        return $this;
    }
}
