<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactRequestType StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class ContactRequestType extends AbstractStructBase
{
    /**
     * The Contact_Request
     * @var \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Contact_Request_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Contact_Request_DataObjectType $Contact_Request = null;
    /**
     * The Customer
     * @var \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_DataObjectType $Customer = null;
    /**
     * The Individual
     * @var \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Individual_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Individual_DataObjectType $Individual = null;
    /**
     * The Comments
     * @var \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Comments_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Comments_DataObjectType $Comments = null;
    /**
     * The Document
     * @var \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Document_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Document_DataObjectType $Document = null;
    /**
     * The Primary_Address_XRef
     * @var \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Primary_Address_XRef_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Primary_Address_XRef_DataObjectType $Primary_Address_XRef = null;
    /**
     * The Primary_Address
     * @var \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Primary_Address_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Primary_Address_DataObjectType $Primary_Address = null;
    /**
     * The Assignment_Customer
     * @var \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_Customer_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_Customer_DataObjectType $Assignment_Customer = null;
    /**
     * The Customer_Alias
     * @var \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Alias_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Alias_DataObjectType $Customer_Alias = null;
    /**
     * The Customer_Activity
     * @var \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Activity_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Activity_DataObjectType $Customer_Activity = null;
    /**
     * The Assignment
     * @var \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_DataObjectType $Assignment = null;
    /**
     * The Org_Customer
     * @var \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Org_Customer_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Org_Customer_DataObjectType $Org_Customer = null;
    /**
     * The Org_Request
     * @var \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Org_Request_DataObjectType|null
     */
    protected ?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Org_Request_DataObjectType $Org_Request = null;
    /**
     * The CurrentKey
     * Meta information extracted from the WSDL
     * - documentation: Contact Request.The current key is the record key for the object. This field must be set whenever updating an existing database record. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $CurrentKey = null;
    /**
     * Constructor method for ContactRequestType
     * @uses ContactRequestType::setContact_Request()
     * @uses ContactRequestType::setCustomer()
     * @uses ContactRequestType::setIndividual()
     * @uses ContactRequestType::setComments()
     * @uses ContactRequestType::setDocument()
     * @uses ContactRequestType::setPrimary_Address_XRef()
     * @uses ContactRequestType::setPrimary_Address()
     * @uses ContactRequestType::setAssignment_Customer()
     * @uses ContactRequestType::setCustomer_Alias()
     * @uses ContactRequestType::setCustomer_Activity()
     * @uses ContactRequestType::setAssignment()
     * @uses ContactRequestType::setOrg_Customer()
     * @uses ContactRequestType::setOrg_Request()
     * @uses ContactRequestType::setCurrentKey()
     * @param \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Contact_Request_DataObjectType $contact_Request
     * @param \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_DataObjectType $customer
     * @param \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Individual_DataObjectType $individual
     * @param \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Comments_DataObjectType $comments
     * @param \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Document_DataObjectType $document
     * @param \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Primary_Address_XRef_DataObjectType $primary_Address_XRef
     * @param \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Primary_Address_DataObjectType $primary_Address
     * @param \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_Customer_DataObjectType $assignment_Customer
     * @param \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Alias_DataObjectType $customer_Alias
     * @param \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Activity_DataObjectType $customer_Activity
     * @param \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_DataObjectType $assignment
     * @param \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Org_Customer_DataObjectType $org_Customer
     * @param \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Org_Request_DataObjectType $org_Request
     * @param string $currentKey
     */
    public function __construct(?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Contact_Request_DataObjectType $contact_Request = null, ?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_DataObjectType $customer = null, ?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Individual_DataObjectType $individual = null, ?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Comments_DataObjectType $comments = null, ?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Document_DataObjectType $document = null, ?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Primary_Address_XRef_DataObjectType $primary_Address_XRef = null, ?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Primary_Address_DataObjectType $primary_Address = null, ?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_Customer_DataObjectType $assignment_Customer = null, ?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Alias_DataObjectType $customer_Alias = null, ?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Activity_DataObjectType $customer_Activity = null, ?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_DataObjectType $assignment = null, ?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Org_Customer_DataObjectType $org_Customer = null, ?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Org_Request_DataObjectType $org_Request = null, ?string $currentKey = null)
    {
        $this
            ->setContact_Request($contact_Request)
            ->setCustomer($customer)
            ->setIndividual($individual)
            ->setComments($comments)
            ->setDocument($document)
            ->setPrimary_Address_XRef($primary_Address_XRef)
            ->setPrimary_Address($primary_Address)
            ->setAssignment_Customer($assignment_Customer)
            ->setCustomer_Alias($customer_Alias)
            ->setCustomer_Activity($customer_Activity)
            ->setAssignment($assignment)
            ->setOrg_Customer($org_Customer)
            ->setOrg_Request($org_Request)
            ->setCurrentKey($currentKey);
    }
    /**
     * Get Contact_Request value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Contact_Request_DataObjectType|null
     */
    public function getContact_Request(): ?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Contact_Request_DataObjectType
    {
        return $this->Contact_Request;
    }
    /**
     * Set Contact_Request value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Contact_Request_DataObjectType $contact_Request
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequestType
     */
    public function setContact_Request(?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Contact_Request_DataObjectType $contact_Request = null): self
    {
        $this->Contact_Request = $contact_Request;
        
        return $this;
    }
    /**
     * Get Customer value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_DataObjectType|null
     */
    public function getCustomer(): ?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_DataObjectType
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_DataObjectType $customer
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequestType
     */
    public function setCustomer(?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_DataObjectType $customer = null): self
    {
        $this->Customer = $customer;
        
        return $this;
    }
    /**
     * Get Individual value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Individual_DataObjectType|null
     */
    public function getIndividual(): ?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Individual_DataObjectType
    {
        return $this->Individual;
    }
    /**
     * Set Individual value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Individual_DataObjectType $individual
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequestType
     */
    public function setIndividual(?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Individual_DataObjectType $individual = null): self
    {
        $this->Individual = $individual;
        
        return $this;
    }
    /**
     * Get Comments value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Comments_DataObjectType|null
     */
    public function getComments(): ?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Comments_DataObjectType
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Comments_DataObjectType $comments
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequestType
     */
    public function setComments(?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Comments_DataObjectType $comments = null): self
    {
        $this->Comments = $comments;
        
        return $this;
    }
    /**
     * Get Document value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Document_DataObjectType|null
     */
    public function getDocument(): ?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Document_DataObjectType
    {
        return $this->Document;
    }
    /**
     * Set Document value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Document_DataObjectType $document
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequestType
     */
    public function setDocument(?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Document_DataObjectType $document = null): self
    {
        $this->Document = $document;
        
        return $this;
    }
    /**
     * Get Primary_Address_XRef value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Primary_Address_XRef_DataObjectType|null
     */
    public function getPrimary_Address_XRef(): ?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Primary_Address_XRef_DataObjectType
    {
        return $this->Primary_Address_XRef;
    }
    /**
     * Set Primary_Address_XRef value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Primary_Address_XRef_DataObjectType $primary_Address_XRef
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequestType
     */
    public function setPrimary_Address_XRef(?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Primary_Address_XRef_DataObjectType $primary_Address_XRef = null): self
    {
        $this->Primary_Address_XRef = $primary_Address_XRef;
        
        return $this;
    }
    /**
     * Get Primary_Address value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Primary_Address_DataObjectType|null
     */
    public function getPrimary_Address(): ?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Primary_Address_DataObjectType
    {
        return $this->Primary_Address;
    }
    /**
     * Set Primary_Address value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Primary_Address_DataObjectType $primary_Address
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequestType
     */
    public function setPrimary_Address(?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Primary_Address_DataObjectType $primary_Address = null): self
    {
        $this->Primary_Address = $primary_Address;
        
        return $this;
    }
    /**
     * Get Assignment_Customer value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_Customer_DataObjectType|null
     */
    public function getAssignment_Customer(): ?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_Customer_DataObjectType
    {
        return $this->Assignment_Customer;
    }
    /**
     * Set Assignment_Customer value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_Customer_DataObjectType $assignment_Customer
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequestType
     */
    public function setAssignment_Customer(?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_Customer_DataObjectType $assignment_Customer = null): self
    {
        $this->Assignment_Customer = $assignment_Customer;
        
        return $this;
    }
    /**
     * Get Customer_Alias value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Alias_DataObjectType|null
     */
    public function getCustomer_Alias(): ?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Alias_DataObjectType
    {
        return $this->Customer_Alias;
    }
    /**
     * Set Customer_Alias value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Alias_DataObjectType $customer_Alias
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequestType
     */
    public function setCustomer_Alias(?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Alias_DataObjectType $customer_Alias = null): self
    {
        $this->Customer_Alias = $customer_Alias;
        
        return $this;
    }
    /**
     * Get Customer_Activity value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Activity_DataObjectType|null
     */
    public function getCustomer_Activity(): ?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Activity_DataObjectType
    {
        return $this->Customer_Activity;
    }
    /**
     * Set Customer_Activity value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Activity_DataObjectType $customer_Activity
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequestType
     */
    public function setCustomer_Activity(?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Customer_Activity_DataObjectType $customer_Activity = null): self
    {
        $this->Customer_Activity = $customer_Activity;
        
        return $this;
    }
    /**
     * Get Assignment value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_DataObjectType|null
     */
    public function getAssignment(): ?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_DataObjectType
    {
        return $this->Assignment;
    }
    /**
     * Set Assignment value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_DataObjectType $assignment
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequestType
     */
    public function setAssignment(?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_DataObjectType $assignment = null): self
    {
        $this->Assignment = $assignment;
        
        return $this;
    }
    /**
     * Get Org_Customer value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Org_Customer_DataObjectType|null
     */
    public function getOrg_Customer(): ?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Org_Customer_DataObjectType
    {
        return $this->Org_Customer;
    }
    /**
     * Set Org_Customer value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Org_Customer_DataObjectType $org_Customer
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequestType
     */
    public function setOrg_Customer(?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Org_Customer_DataObjectType $org_Customer = null): self
    {
        $this->Org_Customer = $org_Customer;
        
        return $this;
    }
    /**
     * Get Org_Request value
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Org_Request_DataObjectType|null
     */
    public function getOrg_Request(): ?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Org_Request_DataObjectType
    {
        return $this->Org_Request;
    }
    /**
     * Set Org_Request value
     * @param \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Org_Request_DataObjectType $org_Request
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequestType
     */
    public function setOrg_Request(?\Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Org_Request_DataObjectType $org_Request = null): self
    {
        $this->Org_Request = $org_Request;
        
        return $this;
    }
    /**
     * Get CurrentKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentKey(): ?string
    {
        return $this->CurrentKey ?? null;
    }
    /**
     * Set CurrentKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentKey
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequestType
     */
    public function setCurrentKey(?string $currentKey = null): self
    {
        // validation for constraint: string
        if (!is_null($currentKey) && !is_string($currentKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentKey, true), gettype($currentKey)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($currentKey) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $currentKey)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($currentKey, true)), __LINE__);
        }
        if (is_null($currentKey) || (is_array($currentKey) && empty($currentKey))) {
            unset($this->CurrentKey);
        } else {
            $this->CurrentKey = $currentKey;
        }
        
        return $this;
    }
}
