<?php

declare(strict_types=1);

namespace Drupal\netforum\xWeb\Generated\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactRequest_Assignment_Customer_DataObjectType
 * StructType
 * @subpackage Structs
 * @author Drupal NetForum xWeb PHP SDK Generator
 * @version 1.0.0
 * @license GPL-2.0-or-later https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @see https://www.drupal.org/project/netforum
 * @generatedDate 2025-08-05
 * @generatedRelease Official
 * @generatedNetForumVersion 37
 */
#[\AllowDynamicProperties]
class ContactRequest_Assignment_Customer_DataObjectType extends AbstractStructBase
{
    /**
     * The asc_key
     * Meta information extracted from the WSDL
     * - documentation: Unique Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $asc_key = null;
    /**
     * The asc_coa_key
     * Meta information extracted from the WSDL
     * - documentation: assignment. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $asc_coa_key = null;
    /**
     * The asc_cst_key
     * Meta information extracted from the WSDL
     * - documentation: customer. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $asc_cst_key = null;
    /**
     * The asc_crs_code
     * Meta information extracted from the WSDL
     * - documentation: status. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $asc_crs_code = null;
    /**
     * The asc_add_user
     * Meta information extracted from the WSDL
     * - documentation: Add User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $asc_add_user = null;
    /**
     * The asc_add_date
     * Meta information extracted from the WSDL
     * - documentation: Add Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $asc_add_date = null;
    /**
     * The asc_change_user
     * Meta information extracted from the WSDL
     * - documentation: Change User. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $asc_change_user = null;
    /**
     * The asc_change_date
     * Meta information extracted from the WSDL
     * - documentation: Change Date. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $asc_change_date = null;
    /**
     * The asc_delete_flag
     * Meta information extracted from the WSDL
     * - documentation: Delete Flag. | Avectra netForum defined simpleType.
     * - base: s:unsignedByte
     * - maxInclusive: 255
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var string|null
     */
    protected ?string $asc_delete_flag = null;
    /**
     * The asc_key_ext
     * Meta information extracted from the WSDL
     * - documentation: Extender Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $asc_key_ext = null;
    /**
     * The asc_entity_key
     * Meta information extracted from the WSDL
     * - documentation: Entity Key. | Avectra netForum defined simpleType.
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?
     * @var string|null
     */
    protected ?string $asc_entity_key = null;
    /**
     * Constructor method for ContactRequest_Assignment_Customer_DataObjectType
     * @uses ContactRequest_Assignment_Customer_DataObjectType::setAsc_key()
     * @uses ContactRequest_Assignment_Customer_DataObjectType::setAsc_coa_key()
     * @uses ContactRequest_Assignment_Customer_DataObjectType::setAsc_cst_key()
     * @uses ContactRequest_Assignment_Customer_DataObjectType::setAsc_crs_code()
     * @uses ContactRequest_Assignment_Customer_DataObjectType::setAsc_add_user()
     * @uses ContactRequest_Assignment_Customer_DataObjectType::setAsc_add_date()
     * @uses ContactRequest_Assignment_Customer_DataObjectType::setAsc_change_user()
     * @uses ContactRequest_Assignment_Customer_DataObjectType::setAsc_change_date()
     * @uses ContactRequest_Assignment_Customer_DataObjectType::setAsc_delete_flag()
     * @uses ContactRequest_Assignment_Customer_DataObjectType::setAsc_key_ext()
     * @uses ContactRequest_Assignment_Customer_DataObjectType::setAsc_entity_key()
     * @param string $asc_key
     * @param string $asc_coa_key
     * @param string $asc_cst_key
     * @param string $asc_crs_code
     * @param string $asc_add_user
     * @param string $asc_add_date
     * @param string $asc_change_user
     * @param string $asc_change_date
     * @param string $asc_delete_flag
     * @param string $asc_key_ext
     * @param string $asc_entity_key
     */
    public function __construct(?string $asc_key = null, ?string $asc_coa_key = null, ?string $asc_cst_key = null, ?string $asc_crs_code = null, ?string $asc_add_user = null, ?string $asc_add_date = null, ?string $asc_change_user = null, ?string $asc_change_date = null, ?string $asc_delete_flag = null, ?string $asc_key_ext = null, ?string $asc_entity_key = null)
    {
        $this
            ->setAsc_key($asc_key)
            ->setAsc_coa_key($asc_coa_key)
            ->setAsc_cst_key($asc_cst_key)
            ->setAsc_crs_code($asc_crs_code)
            ->setAsc_add_user($asc_add_user)
            ->setAsc_add_date($asc_add_date)
            ->setAsc_change_user($asc_change_user)
            ->setAsc_change_date($asc_change_date)
            ->setAsc_delete_flag($asc_delete_flag)
            ->setAsc_key_ext($asc_key_ext)
            ->setAsc_entity_key($asc_entity_key);
    }
    /**
     * Get asc_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsc_key(): ?string
    {
        return $this->asc_key ?? null;
    }
    /**
     * Set asc_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asc_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_Customer_DataObjectType
     */
    public function setAsc_key(?string $asc_key = null): self
    {
        // validation for constraint: string
        if (!is_null($asc_key) && !is_string($asc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asc_key, true), gettype($asc_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($asc_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $asc_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($asc_key, true)), __LINE__);
        }
        if (is_null($asc_key) || (is_array($asc_key) && empty($asc_key))) {
            unset($this->asc_key);
        } else {
            $this->asc_key = $asc_key;
        }
        
        return $this;
    }
    /**
     * Get asc_coa_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsc_coa_key(): ?string
    {
        return $this->asc_coa_key ?? null;
    }
    /**
     * Set asc_coa_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asc_coa_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_Customer_DataObjectType
     */
    public function setAsc_coa_key(?string $asc_coa_key = null): self
    {
        // validation for constraint: string
        if (!is_null($asc_coa_key) && !is_string($asc_coa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asc_coa_key, true), gettype($asc_coa_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($asc_coa_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $asc_coa_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($asc_coa_key, true)), __LINE__);
        }
        if (is_null($asc_coa_key) || (is_array($asc_coa_key) && empty($asc_coa_key))) {
            unset($this->asc_coa_key);
        } else {
            $this->asc_coa_key = $asc_coa_key;
        }
        
        return $this;
    }
    /**
     * Get asc_cst_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsc_cst_key(): ?string
    {
        return $this->asc_cst_key ?? null;
    }
    /**
     * Set asc_cst_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asc_cst_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_Customer_DataObjectType
     */
    public function setAsc_cst_key(?string $asc_cst_key = null): self
    {
        // validation for constraint: string
        if (!is_null($asc_cst_key) && !is_string($asc_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asc_cst_key, true), gettype($asc_cst_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($asc_cst_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $asc_cst_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($asc_cst_key, true)), __LINE__);
        }
        if (is_null($asc_cst_key) || (is_array($asc_cst_key) && empty($asc_cst_key))) {
            unset($this->asc_cst_key);
        } else {
            $this->asc_cst_key = $asc_cst_key;
        }
        
        return $this;
    }
    /**
     * Get asc_crs_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsc_crs_code(): ?string
    {
        return $this->asc_crs_code ?? null;
    }
    /**
     * Set asc_crs_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asc_crs_code
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_Customer_DataObjectType
     */
    public function setAsc_crs_code(?string $asc_crs_code = null): self
    {
        // validation for constraint: string
        if (!is_null($asc_crs_code) && !is_string($asc_crs_code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asc_crs_code, true), gettype($asc_crs_code)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($asc_crs_code) && mb_strlen((string) $asc_crs_code) > 12) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen((string) $asc_crs_code)), __LINE__);
        }
        if (is_null($asc_crs_code) || (is_array($asc_crs_code) && empty($asc_crs_code))) {
            unset($this->asc_crs_code);
        } else {
            $this->asc_crs_code = $asc_crs_code;
        }
        
        return $this;
    }
    /**
     * Get asc_add_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsc_add_user(): ?string
    {
        return $this->asc_add_user ?? null;
    }
    /**
     * Set asc_add_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asc_add_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_Customer_DataObjectType
     */
    public function setAsc_add_user(?string $asc_add_user = null): self
    {
        // validation for constraint: string
        if (!is_null($asc_add_user) && !is_string($asc_add_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asc_add_user, true), gettype($asc_add_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($asc_add_user) && mb_strlen((string) $asc_add_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $asc_add_user)), __LINE__);
        }
        if (is_null($asc_add_user) || (is_array($asc_add_user) && empty($asc_add_user))) {
            unset($this->asc_add_user);
        } else {
            $this->asc_add_user = $asc_add_user;
        }
        
        return $this;
    }
    /**
     * Get asc_add_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsc_add_date(): ?string
    {
        return $this->asc_add_date ?? null;
    }
    /**
     * Set asc_add_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asc_add_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_Customer_DataObjectType
     */
    public function setAsc_add_date(?string $asc_add_date = null): self
    {
        // validation for constraint: string
        if (!is_null($asc_add_date) && !is_string($asc_add_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asc_add_date, true), gettype($asc_add_date)), __LINE__);
        }
        if (is_null($asc_add_date) || (is_array($asc_add_date) && empty($asc_add_date))) {
            unset($this->asc_add_date);
        } else {
            $this->asc_add_date = $asc_add_date;
        }
        
        return $this;
    }
    /**
     * Get asc_change_user value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsc_change_user(): ?string
    {
        return $this->asc_change_user ?? null;
    }
    /**
     * Set asc_change_user value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asc_change_user
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_Customer_DataObjectType
     */
    public function setAsc_change_user(?string $asc_change_user = null): self
    {
        // validation for constraint: string
        if (!is_null($asc_change_user) && !is_string($asc_change_user)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asc_change_user, true), gettype($asc_change_user)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($asc_change_user) && mb_strlen((string) $asc_change_user) > 64) {
            throw new InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen((string) $asc_change_user)), __LINE__);
        }
        if (is_null($asc_change_user) || (is_array($asc_change_user) && empty($asc_change_user))) {
            unset($this->asc_change_user);
        } else {
            $this->asc_change_user = $asc_change_user;
        }
        
        return $this;
    }
    /**
     * Get asc_change_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsc_change_date(): ?string
    {
        return $this->asc_change_date ?? null;
    }
    /**
     * Set asc_change_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asc_change_date
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_Customer_DataObjectType
     */
    public function setAsc_change_date(?string $asc_change_date = null): self
    {
        // validation for constraint: string
        if (!is_null($asc_change_date) && !is_string($asc_change_date)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asc_change_date, true), gettype($asc_change_date)), __LINE__);
        }
        if (is_null($asc_change_date) || (is_array($asc_change_date) && empty($asc_change_date))) {
            unset($this->asc_change_date);
        } else {
            $this->asc_change_date = $asc_change_date;
        }
        
        return $this;
    }
    /**
     * Get asc_delete_flag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsc_delete_flag(): ?string
    {
        return $this->asc_delete_flag ?? null;
    }
    /**
     * Set asc_delete_flag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asc_delete_flag
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_Customer_DataObjectType
     */
    public function setAsc_delete_flag(?string $asc_delete_flag = null): self
    {
        // validation for constraint: string
        if (!is_null($asc_delete_flag) && !is_string($asc_delete_flag)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asc_delete_flag, true), gettype($asc_delete_flag)), __LINE__);
        }
        // validation for constraint: maxInclusive(255)
        if (!is_null($asc_delete_flag) && $asc_delete_flag > 255) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 255', var_export($asc_delete_flag, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($asc_delete_flag) && $asc_delete_flag < 0) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($asc_delete_flag, true)), __LINE__);
        }
        if (is_null($asc_delete_flag) || (is_array($asc_delete_flag) && empty($asc_delete_flag))) {
            unset($this->asc_delete_flag);
        } else {
            $this->asc_delete_flag = $asc_delete_flag;
        }
        
        return $this;
    }
    /**
     * Get asc_key_ext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsc_key_ext(): ?string
    {
        return $this->asc_key_ext ?? null;
    }
    /**
     * Set asc_key_ext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asc_key_ext
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_Customer_DataObjectType
     */
    public function setAsc_key_ext(?string $asc_key_ext = null): self
    {
        // validation for constraint: string
        if (!is_null($asc_key_ext) && !is_string($asc_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asc_key_ext, true), gettype($asc_key_ext)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($asc_key_ext) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $asc_key_ext)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($asc_key_ext, true)), __LINE__);
        }
        if (is_null($asc_key_ext) || (is_array($asc_key_ext) && empty($asc_key_ext))) {
            unset($this->asc_key_ext);
        } else {
            $this->asc_key_ext = $asc_key_ext;
        }
        
        return $this;
    }
    /**
     * Get asc_entity_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsc_entity_key(): ?string
    {
        return $this->asc_entity_key ?? null;
    }
    /**
     * Set asc_entity_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asc_entity_key
     * @return \Drupal\netforum\xWeb\Generated\StructType\ContactRequest_Assignment_Customer_DataObjectType
     */
    public function setAsc_entity_key(?string $asc_entity_key = null): self
    {
        // validation for constraint: string
        if (!is_null($asc_entity_key) && !is_string($asc_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asc_entity_key, true), gettype($asc_entity_key)), __LINE__);
        }
        // validation for constraint: pattern([{]?[0-9a-fA-F]{8}[\-]?([0-9a-fA-F]{4}[\-]?){3}[0-9a-fA-F]{12}[}]?)
        if (!is_null($asc_entity_key) && !preg_match('/[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', (string) $asc_entity_key)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[{]?[0-9a-fA-F]{8}[\\-]?([0-9a-fA-F]{4}[\\-]?){3}[0-9a-fA-F]{12}[}]?/', var_export($asc_entity_key, true)), __LINE__);
        }
        if (is_null($asc_entity_key) || (is_array($asc_entity_key) && empty($asc_entity_key))) {
            unset($this->asc_entity_key);
        } else {
            $this->asc_entity_key = $asc_entity_key;
        }
        
        return $this;
    }
}
